# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CommuneCadastre
                                 A QGIS plugin
 Permet d'identifier une commune ou une parcelle cadastrale sur la carte
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-07-04
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Augustin Roche
        email                : augustin.roche@enertrag.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 """


import json
from qgis.PyQt.QtCore import Qt, QUrl, QUrlQuery, QModelIndex, pyqtSignal
from qgis.PyQt.QtGui import QStandardItemModel, QStandardItem
from qgis.PyQt.QtWidgets import QCompleter, QLineEdit
from qgis.core import QgsNetworkContentFetcher
from .utils import geoJson2geom


class CommuneSelector(QLineEdit):
    COMMUNES_API_URL = "https://geo.api.gouv.fr/communes"

    communeChanged = pyqtSignal()

    def __init__(self, parent):
        super().__init__(parent)
        self.suggestions = QStandardItemModel(self)
        self.results = []
        self.completer = QCompleter(self)
        self.completer.setModel(self.suggestions)
        self.completer.setCompletionMode(QCompleter.UnfilteredPopupCompletion)
        self.completer.setCaseSensitivity(Qt.CaseInsensitive)
        self.setCompleter(self.completer)
        self.communesFetcher = QgsNetworkContentFetcher()
        self.communesFetcher.finished.connect(self.commune_results)
        self.textEdited.connect(self.on_textChange)
        self.selected = None
        self.completer.activated[QModelIndex].connect(self.on_activated)

    def on_textChange(self):
        prompt = self.text()
        self.communesFetcher.cancel()
        params = QUrlQuery()
        params.addQueryItem('nom', prompt)
        params.addQueryItem('limit', '50')
        params.addQueryItem('geometry', 'contour')
        params.addQueryItem('format', 'geojson')
        # NB: recupérer le nom du dept ? (fields=departement)
        url = QUrl(self.COMMUNES_API_URL)
        url.setQuery(params)
        self.communesFetcher.fetchContent(url)

    def commune_results(self):
        """ Commune search results fetched """
        content = self.communesFetcher.contentAsString()
        try:
            self.results = json.loads(content)['features']
        except (json.decoder.JSONDecodeError, KeyError):
            self.results = []
        self.suggestions.clear()
        for li in self.results:
            props = li['properties']
            text = f"{props['nom']} ({props['codeDepartement']})"
            self.suggestions.appendRow([QStandardItem(text)])

    def on_activated(self, index):
        row = index.row()
        self.selected = self.results[row]
        self.communeChanged.emit()

    def get_insee(self):
        if self.selected is not None:
            return self.selected['properties']['code']
        
    def get_geom(self):
        if self.selected is not None:
            return geoJson2geom(self.selected['geometry'])
        