# -*- coding: utf-8 -*-
"""
/***************************************************************************
 co2flux
                                 A QGIS plugin
 This Plugin evalute the carbon flux
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-07-31
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Sandro Faria
        email                : sandro.faria@ifsudestemg.edu.br
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import *
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QFileDialog, QProgressBar
from qgis.core import *
from qgis.gui import QgsDoubleSpinBox
from qgis.core import QgsProject, Qgis, QgsRasterLayer
import processing,tempfile
from qgis.utils import iface
import os
from qgis.analysis import QgsRasterCalculatorEntry, QgsRasterCalculator
from qgis.core import QgsRasterLayer
from qgis.core import QgsProject
from qgis.analysis import QgsRasterCalculatorEntry, QgsRasterCalculator

from qgis.analysis import QgsRasterCalculator, QgsRasterCalculatorEntry

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog

import os.path
import time
from .co2_flux_dialog import co2fluxDialog

class co2flux:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'co2flux_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)
        
        self.dlg = co2fluxDialog()
        
        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&CO2 FLUX')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        ##self.first_start = None
        # create instance of dialog class
        self.toolbar = self.iface.addToolBar(u'&CO2 FLUX')
        self.toolbar.setObjectName(u'&CO2 FLUX')
        # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('co2flux', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):


        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/co2_flux/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'CO2 Flux'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&CO2 FLUX'),
                action)
            self.iface.removeToolBarIcon(action)

    """ my code from here"""

    def update_rasters_boxes(self):

        self.clear_boxes(
                self.dlg.cmb_blue,
                self.dlg.cmb_green,
                self.dlg.cmb_red,
                self.dlg.cmb_nir,
            )
        
        layers = list()
        
        layers.append("Chose your Raster Layer")
        
        layers = layers + [lay.name() for lay in self.iface.mapCanvas().layers()] #vector with all layers + "Chose your Raster Layer"
        #(self.iface.mapCanvas().layers())  =>> show active layers

        self.add_layers_to_raster_boxes(
            layers,
            self.dlg.cmb_blue,
            self.dlg.cmb_green,
            self.dlg.cmb_red,
            self.dlg.cmb_nir,
         )

    def add_layers_to_raster_boxes(self, layers, *boxes):
        for box in boxes:
            box.addItems(layers)

    def clear_boxes(self, *boxes):
        for box in boxes:
            box.clear()
  
  #######################################################################################################
    def getBlue(self):
        layer = None
        layername = self.dlg.cmb_blue.currentText()
        for lyr in QgsProject.instance().mapLayers().values():
            if lyr.name() == layername:
                layer = lyr
                
                break
        return layer
        
    def getGreen(self):
        layer = None
        layername = self.dlg.cmb_green.currentText()
        for lyr in QgsProject.instance().mapLayers().values():
            if lyr.name() == layername:
                layer = lyr
                break
        return layer

    def getRed(self):
        layer = None
        layername = self.dlg.cmb_red.currentText()
        for lyr in QgsProject.instance().mapLayers().values():
            if lyr.name() == layername:
                layer = lyr
                break
        return layer

    def getNir(self):
        layer = None
        layername = self.dlg.cmb_nir.currentText()
        for lyr in QgsProject.instance().mapLayers().values():
            if lyr.name() == layername:
                layer = lyr
                break
        return layer
 ###################################################################################################       
 # output folder choose
    def saveRaster(self):
        filename = QFileDialog.getExistingDirectory(self.dlg, "Select folder")
        if filename:  # Verifica se um diretório foi selecionado
            self.dlg.lineEdit_output_folder.setText(filename)
        
 ######################################################################################################         
    def calc_ndvi(self):
        band2 = self.getBlue()
        band3 = self.getGreen()
        band4 = self.getRed()
        band5 = self.getNir()
        
        #outputs
        
        output_ndvi = os.path.join(self.dlg.lineEdit_output_folder.text(),"ndvi.tif")
        output_pri = os.path.join(self.dlg.lineEdit_output_folder.text(),"pri.tif")
        output_spri = os.path.join(self.dlg.lineEdit_output_folder.text(),"spri.tif")
        output_co2flux = os.path.join(self.dlg.lineEdit_output_folder.text(),"CO2Flux.tif")
        
        entries = []
        #blue band 2
        blue = QgsRasterCalculatorEntry()
        blue.ref = 'blue'
        blue.raster = band2
        blue.bandNumber = 1
        entries.append(blue)
        #green band 3
        green = QgsRasterCalculatorEntry()
        green.ref = 'green'
        green.raster = band3
        green.bandNumber = 1
        entries.append(green)
        #red band 4
        red = QgsRasterCalculatorEntry()
        red.ref = 'red'
        red.raster = band4
        red.bandNumber = 1
        entries.append(red)
        #nir band 5
        nir = QgsRasterCalculatorEntry()
        nir.ref = 'nir'
        nir.raster = band5
        nir.bandNumber = 1
        entries.append(nir)
        
        calc_NDVI = QgsRasterCalculator( '("nir" -  "red") / ("nir" + "red")', \
        output_ndvi, 'GTiff', band2.extent(), band2.width(), band2.height(), entries )
        calc_NDVI.processCalculation()
        self.iface.messageBar().pushMessage("NDVI Output Created Successfully", level=Qgis.Success, duration=3)

        calc_PRI = QgsRasterCalculator( '("green" -  "blue") / ("green" + "blue")', \
        output_pri, 'GTiff', band2.extent(), band2.width(), band2.height(), entries )
        calc_PRI.processCalculation()
        self.iface.messageBar().pushMessage("PRI Output Created Successfully", level=Qgis.Success, duration=3)
        calc_PRI.processCalculation()
        
        layer_Pri = QgsRasterLayer(output_pri)
        pri = QgsRasterCalculatorEntry()
        pri.ref = 'pri'
        pri.raster = layer_Pri
        pri.bandNumber = 1
        entries.append(pri)

        calc_sPRI = QgsRasterCalculator( '("pri" + 1) / 2', \
        output_spri, 'GTiff', band2.extent(), band2.width(), band2.height(), entries )
        calc_sPRI.processCalculation()
        self.iface.messageBar().pushMessage("sPRI Output Created Successfully", level=Qgis.Success, duration=3)
        
        layer_sPri = QgsRasterLayer(output_spri)
        spri = QgsRasterCalculatorEntry()
        spri.ref = 'spri'
        spri.raster = layer_sPri
        spri.bandNumber = 1
        entries.append(spri)
        
        layer_ndvi = QgsRasterLayer(output_ndvi)
        ndvi = QgsRasterCalculatorEntry()
        ndvi.ref = 'ndvi'
        ndvi.raster = layer_ndvi
        ndvi.bandNumber = 1
        entries.append(ndvi)
        
        calc_CO2Flux = QgsRasterCalculator( '"spri" * "ndvi"', \
        output_co2flux, 'GTiff', band2.extent(), band2.width(), band2.height(), entries )
        calc_CO2Flux.processCalculation()
        self.iface.messageBar().pushMessage("CO2 Flux Output Created Successfully", level=Qgis.Success, duration=3)
           
#######################################################################################################
    def run(self):
        """Run method that performs all the real work"""

        self.update_rasters_boxes()
        
        self.dlg.lineEdit_output_folder.clear()

        self.dlg.pushButton_choosefolder.clicked.connect(self.saveRaster)
        # show the dialog
        self.dlg.show()

        self.getBlue()
        
        
        
        
        # Run the dialog event loop
        result = self.dlg.exec_()
       
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            self.calc_ndvi()
            
            
            pass
