"""
/***************************************************************************
                                 A QGIS plugin
 CLUZ for QGIS
                             -------------------
        begin                : 2022-26-08
        copyright            : (C) 2022 by Bob Smith, DICE
        email                : r.j.smith@kent.ac.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import qgis
from qgis.core import QgsVectorLayer, QgsExpression, QgsFeatureRequest
from qgis.utils import iface

from .cluz_messages import successMessage, zonesCheckChangeEarmarkedToAvailablePU, warningMessage
from .cluz_display import updatePULayerToShowChangesByShiftingExtent

from .zcluz_dialog3 import recalcUpdateZonesTargetTableDetails
from .zcluz_make_file_dicts import updateZonesTargetCSVFromTargetDict


def returnZonesMainTargetsMetTuple(setupObject):
    numTargets = 0
    numTargetsMet = 0
    targetDict = setupObject.targetDict
    for aFeat in targetDict:
        targetList = targetDict[aFeat]
        targetAmount = targetList[3]
        conAmount = 0
        for zonePosition in range(1, len(setupObject.zonesDict)):
            conListPos = 6 + (2 * len(setupObject.zonesDict)) + zonePosition
            conAmount += targetList[conListPos]
        if targetAmount > 0:
            numTargets += 1
            if conAmount >= targetAmount:
                numTargetsMet += 1

    return numTargetsMet, numTargets


def returnZonesTargetsMetTuple(setupObject, selectedZoneID):
    numZoneTargets = 0
    numZonesTargetsMet = 0
    targetDict = setupObject.targetDict
    zoneIDAdditionalListPosValue = list(setupObject.zonesDict).index(selectedZoneID) + 1
    for aFeat in targetDict:
        targetList = targetDict[aFeat]
        targetListPos = 6 + (1 * len(setupObject.zonesDict)) + zoneIDAdditionalListPosValue
        targetAmount = targetList[targetListPos]
        conListPos = 6 + (2 * len(setupObject.zonesDict)) + zoneIDAdditionalListPosValue
        conAmount = targetList[conListPos]
        if targetAmount > 0:
            numZoneTargets += 1
            if conAmount >= targetAmount:
                numZonesTargetsMet += 1

    return numZonesTargetsMet, numZoneTargets


def returnSelectedZoneIDFromChangeStatusPanel(ZonesChangeStatusDialog):
    zoneString = str(ZonesChangeStatusDialog.zonesNameComboBox.currentText())
    zoneID = int(zoneString.split(' - ')[0][5:])

    return zoneID


def returnBeforeAfterPUZonesStatusDicts(setupObject, changeStatusType, changeLockedPUsBool, selectedZoneID):
    puLayer = QgsVectorLayer(setupObject.puPath, 'Planning units', 'ogr')
    qgis.utils.iface.setActiveLayer(puLayer)
    puLayer = qgis.utils.iface.activeLayer()
    puLayer.startEditing()
    beforePUZonesStatusDict = makeBeforePUZonesStatusDict(setupObject)
    afterPUZonesStatusDict = makeAfterPUZonesStatusDict(beforePUZonesStatusDict, selectedZoneID, changeStatusType, changeLockedPUsBool)

    return beforePUZonesStatusDict, afterPUZonesStatusDict


def makeBeforePUZonesStatusDict(setupObject):
    beforePUZonesStatusDict = dict()

    puLayer = QgsVectorLayer(setupObject.puPath, 'Planning units', 'ogr')
    qgis.utils.iface.setActiveLayer(puLayer)
    puLayer = qgis.utils.iface.activeLayer()
    provider = puLayer.dataProvider()
    idFieldOrder = provider.fieldNameIndex('Unit_ID')

    selectedPUs = puLayer.selectedFeatures()
    puLayer.startEditing()

    for aPU in selectedPUs:
        puZoneStatusDict = dict()
        puID = aPU.attributes()[idFieldOrder]
        for zoneID in list(setupObject.zonesDict):
            statusFieldName = 'Z' + str(zoneID) + '_Status'
            zoneStatusFieldOrder = provider.fieldNameIndex(statusFieldName)
            zoneStatus = aPU.attributes()[zoneStatusFieldOrder]
            puZoneStatusDict[zoneID] = zoneStatus
        beforePUZonesStatusDict[puID] = puZoneStatusDict

    return beforePUZonesStatusDict


def makeAfterPUZonesStatusDict(beforePUZonesStatusDict, selectedZoneID, changeStatusType, changeExcLockPUsBool):
    afterPUZonesStatusDict = dict()
    for puID in beforePUZonesStatusDict:
        beforePUIDZoneStatusDict = beforePUZonesStatusDict[puID]
        otherZonesStatusList = makeOtherZonesStatusList(beforePUIDZoneStatusDict, selectedZoneID)
        origZoneStatusType = beforePUIDZoneStatusDict[selectedZoneID]
        changeStatusPUsBool = checkChangeStatusPUsBool(origZoneStatusType, changeStatusType, otherZonesStatusList)

        if changeExcLockPUsBool is False and changeStatusPUsBool is False:
            pass
        else:
            afterPUIDZoneStatusDict = dict()
            afterPUIDZoneStatusDict[selectedZoneID] = changeStatusType
            for zoneID in beforePUIDZoneStatusDict:
                if zoneID != selectedZoneID:
                    origOtherZoneStatusType = beforePUIDZoneStatusDict[zoneID]
                    newOtherZoneStatusType = returnOtherZoneStatusType(changeStatusType, origOtherZoneStatusType)
                    afterPUIDZoneStatusDict[zoneID] = newOtherZoneStatusType
            afterPUZonesStatusDict[puID] = afterPUIDZoneStatusDict

    return afterPUZonesStatusDict


def checkChangeStatusPUsBool(origZoneStatusType, changeStatusType, otherZonesStatusList):
    changeStatusPUsBool = True
    if origZoneStatusType == changeStatusType:
        changeStatusPUsBool = False
    if origZoneStatusType == 'Excluded' or origZoneStatusType == 'Locked':
        changeStatusPUsBool = False
    if changeStatusType == 'Earmarked' and 'Locked' in otherZonesStatusList:
        changeStatusPUsBool = False

    return changeStatusPUsBool


def returnOtherZoneStatusType(changeStatusType, origOtherZoneStatusType):
    changeZoneStatusTypeDict = dict()
    changeZoneStatusTypeDict[('Unassigned', 'Unassigned')] = 'Unassigned'
    changeZoneStatusTypeDict[('Unassigned', 'Earmarked')] = 'Earmarked'
    changeZoneStatusTypeDict[('Unassigned', 'Excluded')] = 'Excluded'
    changeZoneStatusTypeDict[('Unassigned', 'Locked')] = 'Unassigned'
    changeZoneStatusTypeDict[('Earmarked', 'Unassigned')] = 'Unassigned'
    changeZoneStatusTypeDict[('Earmarked', 'Earmarked')] = 'Unassigned'
    changeZoneStatusTypeDict[('Earmarked', 'Excluded')] = 'Excluded'
    changeZoneStatusTypeDict[('Earmarked', 'Locked')] = 'Unassigned'
    changeZoneStatusTypeDict[('Excluded', 'Unassigned')] = 'Unassigned'
    changeZoneStatusTypeDict[('Excluded', 'Earmarked')] = 'Earmarked'
    changeZoneStatusTypeDict[('Excluded', 'Excluded')] = 'Excluded'
    changeZoneStatusTypeDict[('Excluded', 'Locked')] = 'Locked'
    changeZoneStatusTypeDict[('Locked', 'Unassigned')] = 'Unassigned'
    changeZoneStatusTypeDict[('Locked', 'Earmarked')] = 'Unassigned'
    changeZoneStatusTypeDict[('Locked', 'Excluded')] = 'Excluded'
    changeZoneStatusTypeDict[('Locked', 'Locked')] = 'Unassigned'
    newOtherZoneStatusType = changeZoneStatusTypeDict[(changeStatusType, origOtherZoneStatusType)]

    return newOtherZoneStatusType


def makeOtherZonesStatusList(beforeChangePUZonesStatusDict, selectedZoneID):
    otherZonesStatusList = list()
    for zoneID in beforeChangePUZonesStatusDict:
        if zoneID != selectedZoneID:
            otherZonesStatusList.append(beforeChangePUZonesStatusDict[zoneID])

    return otherZonesStatusList


def makeZonesSelectedStatusBalanceDict(beforePUZonesStatusDict, afterPUZonesStatusDict):
    zonesSelectedStatusBalanceDict = dict()
    for puID in afterPUZonesStatusDict:
        try:
            puIDZoneStatusBalanceDict = zonesSelectedStatusBalanceDict[puID]
        except KeyError:
            puIDZoneStatusBalanceDict = dict()
        beforePUStatusDict = beforePUZonesStatusDict[puID]
        afterPUStatusDict = afterPUZonesStatusDict[puID]
        for zoneID in afterPUStatusDict:
            beforeStatus = beforePUStatusDict[zoneID]
            afterStatus = afterPUStatusDict[zoneID]
            puIDZoneStatusBalanceDict[zoneID] = returnStatusBalanceValue(beforeStatus, afterStatus)
        zonesSelectedStatusBalanceDict[puID] = puIDZoneStatusBalanceDict

    return zonesSelectedStatusBalanceDict


def returnStatusBalanceValue(beforeStatus, afterStatus):
    recodeDict = {'Unassigned': False, 'Earmarked': True, 'Excluded': False, 'Locked': True}
    beforeBool = recodeDict[beforeStatus]
    afterBool = recodeDict[afterStatus]

    balanceValue = 0
    if beforeBool and afterBool is False:
        balanceValue = -1
    elif beforeBool is False and afterBool:
        balanceValue = 1

    return balanceValue


def changeZonesStatusPuLayer(setupObject, afterPUZonesStatusDict):
    puLayer = QgsVectorLayer(setupObject.puPath, 'Planning units', 'ogr')
    qgis.utils.iface.setActiveLayer(puLayer)
    puLayer = qgis.utils.iface.activeLayer()
    provider = puLayer.dataProvider()
    idFieldOrder = provider.fieldNameIndex('Unit_ID')
    selectedPUList = list()

    selectedPUs = puLayer.selectedFeatures()
    puLayer.startEditing()

    for aPU in selectedPUs:
        puRow = aPU.id()
        selectedPUList.append(puRow)
        puID = aPU.attributes()[idFieldOrder]
        try:
            afterPUIDZonesStatusDict = afterPUZonesStatusDict[puID]
            for zoneID in afterPUIDZonesStatusDict:
                zoneStatusFieldName = 'Z' + str(zoneID) + '_Status'
                zoneStatusFieldOrder = provider.fieldNameIndex(zoneStatusFieldName)
                finalChangeStatusType = afterPUIDZonesStatusDict[zoneID]
                puLayer.changeAttributeValue(puRow, zoneStatusFieldOrder, finalChangeStatusType)
        except KeyError:
            pass

    setupObject.selectedPUList = selectedPUList
    puLayer.commitChanges()
    puLayer.removeSelection()
    updatePULayerToShowChangesByShiftingExtent()


def calcZonesChangeAbundDict(setupObject, zonesSelectedStatusBalanceDict):
    zonesChangeAbundDict = dict()
    for puID in zonesSelectedStatusBalanceDict:
        puIDZonesStatusBalanceDict = zonesSelectedStatusBalanceDict[puID]
        for zoneID in puIDZonesStatusBalanceDict:
            try:
                zoneIDChangeAbundDict = zonesChangeAbundDict[zoneID]
            except KeyError:
                zoneIDChangeAbundDict = dict()
            try:
                puAbundDict = setupObject.abundPUKeyDict[puID]
            except KeyError:
                puAbundDict = dict()  # just to leave things blank
            for featID in puAbundDict:
                abundValue = puAbundDict[featID]
                try:
                    runningChange = zoneIDChangeAbundDict[featID]
                except KeyError:
                    runningChange = 0
                featZoneProp = setupObject.zonesPropDict['Z' + str(zoneID) + '_Prop'][featID]
                changeAmount = abundValue * puIDZonesStatusBalanceDict[zoneID] * featZoneProp
                runningChange += changeAmount
                zoneIDChangeAbundDict[featID] = runningChange
            zonesChangeAbundDict[zoneID] = zoneIDChangeAbundDict

    return zonesChangeAbundDict


def updateZonesTargetDictWithChanges(setupObject, zonesChangeAbundDict):
    targetDict = setupObject.targetDict
    for zoneID in zonesChangeAbundDict:
        aZoneChangeAbundDict = zonesChangeAbundDict[zoneID]
        for featID in aZoneChangeAbundDict:
            changeAmount = zonesChangeAbundDict[zoneID][featID]
            targetList = setupObject.targetDict[featID]

            zoneIDAdditionalListPosValue = list(setupObject.zonesDict).index(zoneID) + 1
            targetListPos = 6 + (2 * len(setupObject.zonesDict)) + zoneIDAdditionalListPosValue
            zoneConAmount = targetList[targetListPos]
            newZoneAmount = zoneConAmount + changeAmount
            targetList[targetListPos] = newZoneAmount

            targetDict[featID] = targetList

    return targetDict


def zonesSelectUndoPlanningUnits(setupObject):
    puLayer = QgsVectorLayer(setupObject.puPath, 'Planning units', 'ogr')
    qgis.utils.iface.setActiveLayer(puLayer)
    puLayer = qgis.utils.iface.activeLayer()
    puLayer.selectByIds(setupObject.selectedPUList)


# # ####################################################################

def zonesChangeBestToEarmarkedPUs(setupObject):
    puLayer = QgsVectorLayer(setupObject.puPath, 'Planning units', 'ogr')
    puProvider = puLayer.dataProvider()
    statusFieldOrderDict = makeStatusFieldOrderDict(setupObject, puProvider)
    bestFieldOrder = puProvider.fieldNameIndex('Best')

    if bestFieldOrder == -1:
        warningMessage('Incorrect format', 'The planning unit layer has no field named Best (which is produced by running Marxan with Zones). This process will terminate.')
    else:
        zonesChangeZonesStatusFromBestField(setupObject, puLayer, statusFieldOrderDict, bestFieldOrder)
        recalcUpdateZonesTargetTableDetails(setupObject)
        updateZonesTargetCSVFromTargetDict(setupObject, setupObject.targetDict)
        successMessage('Process completed', 'Planning units that were selected in the Best portfolio for each zone now have Earmarked status and the target table has been updated accordingly.')
    updatePULayerToShowChangesByShiftingExtent()


def makeStatusFieldOrderDict(setupObject, puProvider):
    statusFieldOrderDict = dict()
    for zoneID in setupObject.zonesDict:
        statusFieldOrderDict[zoneID] = puProvider.fieldNameIndex('Z' + str(zoneID) + '_Status')

    return statusFieldOrderDict


def zonesChangeZonesStatusFromBestField(setupObject, puLayer, statusFieldOrderDict, bestFieldOrder):
    puLayer.startEditing()
    puFeatures = puLayer.getFeatures()
    for puFeature in puFeatures:
        puRow = puFeature.id()
        puBestZoneValue = puFeature.attributes()[bestFieldOrder]
        for zoneID in setupObject.zonesDict:
            puZoneStatus = puFeature.attributes()[statusFieldOrderDict[zoneID]]
            if puZoneStatus == 'Unassigned' and puBestZoneValue == zoneID:
                puLayer.changeAttributeValue(puRow, statusFieldOrderDict[zoneID], 'Earmarked')
            if puZoneStatus == 'Earmarked' and puBestZoneValue != zoneID:
                puLayer.changeAttributeValue(puRow, statusFieldOrderDict[zoneID], 'Unassigned')

    puLayer.commitChanges()


def zonesChangeEarmarkedToAvailablePUs(setupObject):
    puLayer = QgsVectorLayer(setupObject.puPath, "Planning units", "ogr")
    puProvider = puLayer.dataProvider()
    statusFieldOrderDict = makeStatusFieldOrderDict(setupObject, puProvider)
    changeBool = zonesCheckChangeEarmarkedToAvailablePU()

    if changeBool:
        zonesUpdatedZonesFieldsFromEarmarkedToUnassigned(setupObject, puLayer, statusFieldOrderDict)
        recalcUpdateZonesTargetTableDetails(setupObject)
        updateZonesTargetCSVFromTargetDict(setupObject, setupObject.targetDict)
        successMessage('Process completed', 'Planning units with Earmarked status in each zone have been changed to Unassigned status and the target table has been updated accordingly.')
    updatePULayerToShowChangesByShiftingExtent()


def zonesUpdatedZonesFieldsFromEarmarkedToUnassigned(setupObject, puLayer, statusFieldOrderDict):
    puLayer.startEditing()
    puFeatures = puLayer.getFeatures()
    for puFeature in puFeatures:
        puRow = puFeature.id()
        for zoneID in setupObject.zonesDict:
            puZoneStatus = puFeature.attributes()[statusFieldOrderDict[zoneID]]
            if puZoneStatus == 'Earmarked':
                puLayer.changeAttributeValue(puRow, statusFieldOrderDict[zoneID], 'Unassigned')

    puLayer.commitChanges()
