"""
/***************************************************************************
                                 A QGIS plugin
 CLUZ for QGIS
                             -------------------
        begin                : 2022-26-08
        copyright            : (C) 2022 by Bob Smith, DICE
        email                : r.j.smith@kent.ac.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from qgis.core import QgsVectorLayer, NULL

from csv import reader

from .cluz_messages import clearProgressBar, makeProgressBar


def checkZonesFieldsTargetCsvFile(setupObject):
    targetCSVFilePath = setupObject.targetPath

    with open(targetCSVFilePath, 'rt') as f:
        countReader = reader(f)
        rowTotalCount = len(list(countReader))

    progressBar = makeProgressBar('Processing target file')
    rowCount = 1

    with open(targetCSVFilePath, 'rt') as f:
        targetReader = reader(f)
        origHeaderList = next(targetReader)
        headerList = list()  # convert to lowercase so it doesn't matter whether the headers or lowercase, uppercase or a mix
        for aHeader in origHeaderList:
            headerList.append(aHeader.lower())

        targetErrorSet = set()
        for aRow in targetReader:
            progressBar.setValue((rowCount/rowTotalCount)*100)
            rowCount += 1
            for zoneID in setupObject.zonesDict:
                propZoneNameString = 'z' + str(zoneID) + '_prop'
                targetZoneNameString = 'z' + str(zoneID) + '_target'
                earlockZoneNameString = 'z' + str(zoneID) + '_ear+lock'

                propZoneString = aRow[headerList.index(propZoneNameString)]
                targetZoneString = aRow[headerList.index(targetZoneNameString)]
                earlockZoneString = aRow[headerList.index(earlockZoneNameString)]

                targetErrorSet = checkZonePropString(propZoneString, targetErrorSet)
                targetErrorSet = checkZoneFeatTargetString(targetZoneString, targetErrorSet)
                targetErrorSet = checkZoneFeatEarLockString(earlockZoneString, targetErrorSet)

    clearProgressBar()

    return targetErrorSet


def checkZonePropString(propZoneString, errorSet):
    if propZoneString == '':
        errorSet.add('featZonePropBlank')
    else:
        try:
            float(propZoneString)
            if float(propZoneString) < 0:
                errorSet.add('featZonePropNotFloat')
        except ValueError:
            errorSet.add('featZonePropNotFloat')

    return errorSet


def checkZoneFeatTargetString(targetZoneString, errorSet):
    if targetZoneString == '':
        errorSet.add('featZoneTargetBlank')
    else:
        try:
            float(targetZoneString)
            if float(targetZoneString) < 0:
                errorSet.add('featZoneTargetNotFloat')
        except ValueError:
            errorSet.add('featZoneTargetNotFloat')

    return errorSet


def checkZoneFeatEarLockString(earlockZoneString, errorSet):
    if earlockZoneString == '':
        errorSet.add('featZoneEarLockBlank')
    else:
        try:
            float(earlockZoneString)
            if float(earlockZoneString) < 0:
                errorSet.add('featZoneEarLockNotFloat')
        except ValueError:
            errorSet.add('featZoneEarLockNotFloat')

    return errorSet


def zonesCheckPuShapeFilePUStatusValue(shapeErrorSet, puAttributes, unitStatusField):
    puStatus = puAttributes[unitStatusField]
    if puStatus not in ['Unassigned', 'Earmarked', 'Excluded', 'Locked']:
        shapeErrorSet.add('puZonesStatusWrong')

    return shapeErrorSet


def checkZonesFieldStatusListForConflicts(shapeErrorSet, zonesFieldStatusList):
    if zonesFieldStatusList.count('Locked') > 1:
        shapeErrorSet.add('puZonesStatusConflict')

    return shapeErrorSet


def zonesCheckPuShapeFilePUCostValue(shapeErrorSet, puAttributes, puCostField):
    puCost = puAttributes[puCostField]
    if puCost == NULL:
        shapeErrorSet.add('puCostBlank')
    else:
        try:
            float(puCost)
            if float(puCost) < 0:
                shapeErrorSet.add('puCostNotFloat')
        except ValueError:
            shapeErrorSet.add('puCostNotFloat')

    return shapeErrorSet
