"""
/***************************************************************************
                                 A QGIS plugin
 CLUZ for QGIS
                             -------------------
        begin                : 2022-26-08
        copyright            : (C) 2022 by Bob Smith, DICE
        email                : r.j.smith@kent.ac.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from qgis.PyQt.QtCore import QVariant
from qgis.core import QgsFields, QgsVectorLayer, QgsVectorLayer, QgsVectorFileWriter, QgsWkbTypes, QgsFeature, QgsField, QgsSpatialIndex

from os import sep
from csv import writer

from processing.core.Processing import Processing
Processing.initialize()


# Transform to Marxan with Zones ###################################################

def createZonesPULayer(setupObject, zonesTransformObject):
    puLayer = QgsVectorLayer(setupObject.puPath, 'Planning units', 'ogr')
    puIDField = puLayer.fields().indexFromName('Unit_ID')
    puAreaField = puLayer.fields().indexFromName('Area')

    zonesPULayerPathName = zonesTransformObject.transformFolderPath + sep + zonesTransformObject.puLayerName + '.shp'
    newFields = QgsFields()
    newFields.append(QgsField('Unit_ID', QVariant.Int))
    newFields.append(QgsField('Area', QVariant.Double, 'double', 12, setupObject.decimalPlaces))
    for zoneID in range(1, zonesTransformObject.zoneNum + 1):
        newFields.append(QgsField('Z' + str(zoneID) + '_Cost', QVariant.Double, 'double', 12, setupObject.decimalPlaces))
        newFields.append(QgsField('Z' + str(zoneID) + '_Status', QVariant.String))

    shapefileWriter = QgsVectorFileWriter(zonesPULayerPathName, 'System', newFields, QgsWkbTypes.MultiPolygon, puLayer.dataProvider().crs(), 'ESRI Shapefile')
    puFeatures = puLayer.getFeatures()
    # Make distribution shapefile copying PU polygons and ID field
    for puFeature in puFeatures:
        puGeom = puFeature.geometry()
        puAttributes = puFeature.attributes()
        puID = puAttributes[puIDField]
        puArea = puAttributes[puAreaField]
        puZoneDataList = [0, 'Unassigned'] * zonesTransformObject.zoneNum
        featAttribList = [puID, puArea] + puZoneDataList

        distFeat = QgsFeature()
        distFeat.setGeometry(puGeom)
        distFeat.setAttributes(featAttribList)
        shapefileWriter.addFeature(distFeat)

    del shapefileWriter


def convertOld2NewTargetDict(setupObject, zoneNum):
    zoneTargetDict = dict()
    for featID in setupObject.targetDict:
        oldFeatList = setupObject.targetDict[featID]
        newFeatListStep = oldFeatList[0:2] + ([0.0] * zoneNum) + [oldFeatList[2]] + ([0.0] * zoneNum) + [oldFeatList[3]] + ([0.0] * zoneNum) + oldFeatList[4:7]
        zoneTargetDict[featID] = newFeatListStep

    return zoneTargetDict


def createZoneTargetCSVFile(zoneTargetDict, zonesTransformObject):
    transformTargetCSVFilePath = zonesTransformObject.transformFolderPath + sep + zonesTransformObject.zonesTargetCSVFileName + '.csv'
    featIDList = list(zoneTargetDict.keys())
    zoneTargetCSVFileHeaderList = createZoneTargetCSVFileHeaderList(zonesTransformObject.zoneNum)

    with open(transformTargetCSVFilePath, 'w', newline='') as out_file:
        targetWriter = writer(out_file)
        targetWriter.writerow(zoneTargetCSVFileHeaderList)
        for featID in featIDList:
            textList = [featID] + zoneTargetDict[featID]
            targetWriter.writerow(textList)


def createZoneTargetCSVFileHeaderList(zoneNum):
    zoneTargetCSVFileHeaderList = ['Id', 'Name', 'Type']
    for zoneID in range(1, zoneNum + 1):
        zoneTargetCSVFileHeaderList.append('Z' + str(zoneID) + '_Prop')
    zoneTargetCSVFileHeaderList = zoneTargetCSVFileHeaderList + ['Spf']
    for zoneID in range(1, zoneNum + 1):
        zoneTargetCSVFileHeaderList.append('Z' + str(zoneID) + '_Target')
    zoneTargetCSVFileHeaderList = zoneTargetCSVFileHeaderList + ['Target']
    for zoneID in range(1, zoneNum + 1):
        zoneTargetCSVFileHeaderList.append('Z' + str(zoneID) + '_Ear+Lock')
    zoneTargetCSVFileHeaderList = zoneTargetCSVFileHeaderList + ['Ear+Lock', 'Total', 'PC_Target']

    return zoneTargetCSVFileHeaderList


def createZoneZonesCSVFile(zonesTransformObject):
    transformZonesCSVFilePath = zonesTransformObject.transformFolderPath + sep + zonesTransformObject.zonesZonesCSVFileName + '.csv'

    with open(transformZonesCSVFilePath, 'w', newline='') as out_file:
        targetWriter = writer(out_file)
        targetWriter.writerow(['Id', 'Name'])
        for zoneID in range(1, zonesTransformObject.zoneNum + 1):
            textList = [str(zoneID), 'Blank']
            targetWriter.writerow(textList)


# Import Vec data #########################################################################

def updateZonesPropDictForAddedFeatures(setupObject, addFeatIDList):
    for featID in addFeatIDList:
        for zoneID in setupObject.zonesDict:
            setupObject.zonesPropDict[zoneID][featID] = 1

    return setupObject.zonesPropDict
