"""
/***************************************************************************
                                 A QGIS plugin
 CLUZ for QGIS
                             -------------------
        begin                : 2022-26-08
        copyright            : (C) 2022 by Bob Smith, DICE
        email                : r.j.smith@kent.ac.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from qgis.PyQt.QtWidgets import QTableWidgetItem
from qgis.PyQt.QtCore import Qt
from qgis.core import QgsVectorLayer

from csv import reader
from os import path, sep
from subprocess import Popen
from itertools import combinations

from .cluz_dialog5_code import checkImportBestFieldName, checkImportSummedFieldName
from .cluz_functions5 import checkNumRunsParaDict, checkInitialPropValueParaDict, checkMissingPropValueParaDict
from .cluz_functions5 import checkNumIterParaDict, checkPermissionToUseMarxanFolderParaDict, checkBlmValueParaDict, makeMarxanBatFile, waitingForMarxan
from .zcluz_functions5 import makeZonesMarxanInputFile, returnZonesOutputName, checkIfAddZoneTargetDatNeededBool

from .cluz_messages import warningMessage


def setZonesDialogParameters(ZonesMarxanDialog, setupObject):
    ZonesMarxanDialog.iterLineEdit.setText(str(setupObject.numIter))
    ZonesMarxanDialog.runLineEdit.setText(str(setupObject.numRuns))
    zonesOutputName = returnZonesOutputName(setupObject)
    ZonesMarxanDialog.outputLineEdit.setText(zonesOutputName)
    ZonesMarxanDialog.boundLineEdit.setText(str(setupObject.blmValue))

    if setupObject.boundFlag:
        ZonesMarxanDialog.boundCheckBox.setChecked(True)
        ZonesMarxanDialog.boundLineEdit.setVisible(True)
    else:
        ZonesMarxanDialog.boundLineEdit.setVisible(False)

    if setupObject.extraOutputsFlag:
        ZonesMarxanDialog.extraCheckBox.setChecked(True)

    produceBLMTableWidgetContent(ZonesMarxanDialog, setupObject)
    if setupObject.zonesBoundFlag:
        ZonesMarxanDialog.boundZoneCheckBox.setChecked(True)
        ZonesMarxanDialog.blmTableWidget.setVisible(True)
    else:
        ZonesMarxanDialog.boundZoneCheckBox.setChecked(False)
        ZonesMarxanDialog.blmTableWidget.setVisible(False)

    ZonesMarxanDialog.missingLineEdit.setText(str(setupObject.targetProp))
    ZonesMarxanDialog.propLineEdit.setText(str(setupObject.startProp))


def produceBLMTableWidgetContent(ZonesMarxanDialog, setupObject):
    blmZonesCombinationList = returnBLMZonesCombinationList(setupObject)
    ZonesMarxanDialog.blmTableWidget.insertColumn(0)
    ZonesMarxanDialog.blmTableWidget.insertColumn(1)
    for aRow in range(0, len(blmZonesCombinationList)):
        blmCombinationText = 'Zone ' + str(blmZonesCombinationList[aRow][0]) + ' vs Zone ' + str(blmZonesCombinationList[aRow][1])
        try:
            blmValue = setupObject.zonesBLMDict[blmCombinationText]
        except KeyError:
            blmValue = 1
        except TypeError:
            blmValue = 1
        ZonesMarxanDialog.blmTableWidget.insertRow(aRow)
        labelItem = QTableWidgetItem(blmCombinationText)
        labelItem.setFlags(Qt.ItemIsEditable)
        ZonesMarxanDialog.blmTableWidget.setItem(aRow, 0, labelItem)
        ZonesMarxanDialog.blmTableWidget.setItem(aRow, 1, QTableWidgetItem(str(blmValue)))

        ZonesMarxanDialog.blmTableWidget.horizontalHeader().hide()
        ZonesMarxanDialog.blmTableWidget.horizontalHeader().setStretchLastSection(True)
        ZonesMarxanDialog.blmTableWidget.verticalHeader().hide()


def returnBLMZonesCombinationList(setupObject):
    blmZonesCombinationList = list()
    zonesIDTextBlock = ''
    for zoneID in list(setupObject.zonesDict):
        zonesIDTextBlock += str(zoneID)
    for aZoneTextBlock in combinations(zonesIDTextBlock, 2):
        blmZonesCombinationList.append((aZoneTextBlock[0], aZoneTextBlock[1]))

    return blmZonesCombinationList


def makeZonesMarxanRawParameterDict(ZonesMarxanDialog, setupObject):
    numIterString = ZonesMarxanDialog.iterLineEdit.text()
    numRunString = ZonesMarxanDialog.runLineEdit.text()
    outputName = str(ZonesMarxanDialog.outputLineEdit.text())
    setupObject.outputName = outputName
    if ZonesMarxanDialog.boundCheckBox.isChecked():
        blmValueString = ZonesMarxanDialog.boundLineEdit.text()
    else:
        blmValueString = '0'
    missingPropString = ZonesMarxanDialog.missingLineEdit.text()
    initialPropString = ZonesMarxanDialog.propLineEdit.text()
    extraOutputsBool = ZonesMarxanDialog.extraCheckBox.isChecked()

    marxanRawParameterDict = dict()
    marxanRawParameterDict['numIterString'] = numIterString
    marxanRawParameterDict['numRunString'] = numRunString
    marxanRawParameterDict['blmValueString'] = blmValueString
    marxanRawParameterDict['missingPropString'] = missingPropString
    marxanRawParameterDict['initialPropString'] = initialPropString
    marxanRawParameterDict['extraOutputsBool'] = extraOutputsBool
    marxanRawParameterDict['outputName'] = outputName
    marxanRawParameterDict['marxanPath'] = setupObject.marxanPath

    return marxanRawParameterDict


def makeZonesMarxanParameterDict(setupObject, zonesMarxanRawParameterDict):
    zonesMarxanParameterDict = dict()
    zonesMarxanParameterDict['numIter'] = int(zonesMarxanRawParameterDict['numIterString'])
    zonesMarxanParameterDict['numRun'] = int(zonesMarxanRawParameterDict['numRunString'])
    zonesMarxanParameterDict['blmValue'] = float(zonesMarxanRawParameterDict['blmValueString'])
    zonesMarxanParameterDict['missingProp'] = float(zonesMarxanRawParameterDict['missingPropString'])
    zonesMarxanParameterDict['initialProp'] = float(zonesMarxanRawParameterDict['initialPropString'])

    zonesMarxanParameterDict['extraOutputsBool'] = zonesMarxanRawParameterDict['extraOutputsBool']
    zonesMarxanParameterDict['outputName'] = zonesMarxanRawParameterDict['outputName']
    zonesMarxanParameterDict['extraOutputsBool'] = zonesMarxanRawParameterDict['extraOutputsBool']

    marxanPath = setupObject.marxanPath
    marxanFolderName = path.dirname(marxanPath)
    marxanSetupPath = str(marxanFolderName) + sep + 'input.dat'
    zonesMarxanParameterDict["marxanPath"] = marxanPath
    zonesMarxanParameterDict["marxanSetupPath"] = marxanSetupPath

    return zonesMarxanParameterDict


def returnZonesMarxanInputValuesOKBool(marxanParameterDict):
    marxanInputValuesOKBool = checkNumIterParaDict(marxanParameterDict['numIterString'])
    marxanInputValuesOKBool = checkNumRunsParaDict(marxanParameterDict['numRunString'], marxanInputValuesOKBool)
    marxanInputValuesOKBool = checkBlmValueParaDict(marxanParameterDict['blmValueString'], marxanInputValuesOKBool)
    marxanInputValuesOKBool = checkMissingPropValueParaDict(marxanParameterDict['missingPropString'], marxanInputValuesOKBool)
    marxanInputValuesOKBool = checkInitialPropValueParaDict(marxanParameterDict['initialPropString'], marxanInputValuesOKBool)
    marxanInputValuesOKBool = checkPermissionToUseMarxanFolderParaDict(marxanParameterDict, marxanInputValuesOKBool)

    return marxanInputValuesOKBool


def checkZonesMarxanFilesExistBool(setupObject):
    marxanFilesExistBool = True
    puDatPath = setupObject.inputPath + sep + 'pu.dat'
    specDatPath = setupObject.inputPath + sep + 'feat.dat'
    puvspr2DatPath = setupObject.inputPath + sep + 'puvspr2.dat'

    if path.exists(puDatPath) is False:
        warningMessage('Missing Marxan file', 'There is no pu.dat file in the specified Marxan input folder. Please create the file using the Create Marxan input files function')
        marxanFilesExistBool = False
    if path.exists(specDatPath) is False:
        warningMessage('Missing Marxan file', 'There is no feat.dat file in the specified Marxan input folder. Please create the file using the Create Marxan input files function')
        marxanFilesExistBool = False
    if path.exists(puvspr2DatPath) is False:
        warningMessage('Missing Marxan file', 'There is no puvspr2.dat file in the specified Marxan input folder. Please create one')
        marxanFilesExistBool = False

    return marxanFilesExistBool


def launchZonesMarxanAnalysis(setupObject, zonesMarxanParameterDict):
    addZoneTargetDatBool = checkIfAddZoneTargetDatNeededBool(setupObject)
    makeZonesMarxanInputFile(setupObject, zonesMarxanParameterDict, addZoneTargetDatBool)
    zonesMarxanBatFileName = makeMarxanBatFile(setupObject)
    Popen([zonesMarxanBatFileName])
    waitingForMarxan(setupObject, zonesMarxanParameterDict['outputName'])
    bestOutputFile = setupObject.outputPath + sep + zonesMarxanParameterDict['outputName'] + '_best.csv'
    summedOutputFile = setupObject.outputPath + sep + zonesMarxanParameterDict['outputName'] + '_ssoln.csv'

    return bestOutputFile, summedOutputFile


# Load previous results ########################################################

def zonesReturnInitialLoadFieldNames(setupObject):
    puLayer = QgsVectorLayer(setupObject.puPath, 'Planning units', 'ogr')
    fieldNameList = [field.name() for field in puLayer.fields()]
    zonesBestName = 'IMP_BEST'
    bestSuffix = ''
    if zonesBestName in fieldNameList:
        bestSuffix = 1
        while (zonesBestName + str(bestSuffix)) in fieldNameList:
            bestSuffix += 1
    finalBestName = zonesBestName + str(bestSuffix)

    zonesSummedName = 'I'
    summedSuffixNumber = 1
    prefixSuffixNameList = list()
    for aName in fieldNameList:
        prefixSuffixNameList.append([aName[0:4], aName[-2:]])
    nameLoopBool = True

    while nameLoopBool:
        prefixSuffixNameCount = 0
        for prefixSuffixNameElement in prefixSuffixNameList:
            if prefixSuffixNameElement[0] == zonesSummedName + str(summedSuffixNumber) + '_Z' and prefixSuffixNameElement[1] == 'SF':
                prefixSuffixNameCount += 1
        if prefixSuffixNameCount == 0:
            nameLoopBool = False
        else:
            summedSuffixNumber += 1

    finalSummedName = zonesSummedName + str(summedSuffixNumber)

    return finalBestName, finalSummedName


def zonesCheckLoadBestMarxanResultFile(ZonesLoadDialog, setupObject):
    zonesBestFieldName = ZonesLoadDialog.zonesBestNameLineEdit.text()
    if ZonesLoadDialog.zonesBestCheckBox.isChecked():
        loadBestPath = ZonesLoadDialog.zonesBestLineEdit.text()
    else:
        loadBestPath = 'blank'
    zonesCheckBool = checkImportBestFieldName(setupObject, zonesBestFieldName)
    if zonesCheckBool:
        ZonesLoadDialog.close()
        if loadBestPath != 'blank':
            if path.isfile(loadBestPath):
                with open(loadBestPath, 'rt') as f:
                    zonesBestReader = reader(f)
                    bestHeader = next(zonesBestReader, None)  # skip the headers
                if bestHeader != setupObject.zonesBestHeadingFieldNames:
                    zonesCheckBool = False
                    warningMessage('Invalid file', 'The specified Marxan with Zones best output file is incorrectly formatted. It must contain only two fields named planning_unit and zone.')
            else:
                zonesCheckBool = False
                warningMessage('Incorrect pathname', 'The specified pathname for the Marxan with Zones best output is invalid. Please choose another one.')

    return zonesCheckBool


def zonesCheckLoadSummedMarxanResultFile(LoadDialog, setupObject):
    summedFieldName = LoadDialog.zonesSummedNameLineEdit.text()
    if LoadDialog.zonesSummedCheckBox.isChecked():
        loadSummedPath = LoadDialog.zonesSummedLineEdit.text()
    else:
        loadSummedPath = 'blank'
    zonesCheckBool = checkImportSummedFieldName(setupObject, summedFieldName)
    if zonesCheckBool:
        LoadDialog.close()
        if loadSummedPath != 'blank':
            if path.isfile(loadSummedPath):
                with open(loadSummedPath, 'rt') as f:
                    summedReader = reader(f)
                    summedHeaderList = next(summedReader, None)  # skip the headers
                if summedHeaderList.count('planning unit') + summedHeaderList.count('number') != 2:
                    zonesCheckBool = False
                    warningMessage('Invalid file', 'The specified Marxan with Zones summed output file is incorrectly formatted. It must include two fields named planning unit and number')
            else:
                zonesCheckBool = False
                warningMessage('Incorrect pathname', 'The specified pathname for the Marxan with Zones summed output is invalid. Please choose another one')

    return zonesCheckBool
