"""
/***************************************************************************
                                 A QGIS plugin
 CLUZ for QGIS
                             -------------------
        begin                : 2022-26-08
        copyright            : (C) 2022 by Bob Smith, DICE
        email                : r.j.smith@kent.ac.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from qgis.PyQt.QtWidgets import QDialog, QFileDialog, QLabel, QTableWidgetItem

from cluz_form_zones_inputs import Ui_zonesInputsDialog
from cluz_form_zones_marxan import Ui_zonesMarxanDialog
from cluz_form_zones_load import Ui_zonesLoadDialog

from .cluz_setup import updateClzSetupFile
from .zcluz_display import displayZonesSFLayer, removePreviousZonesMarxanLayers, reloadZonesPULayer, displayZonesBestOutput
from .zcluz_functions5 import createZonesFeatDatFile, createZonesTargetDatFile, createZonesPropDatFile, createZonesBLMFile
from .zcluz_functions5 import createZonesPuDatFile, createZonesPUStatusDict, createPuLockDatFile, createPuZoneDatFile
from .zcluz_functions5 import createCostsDatFile, createZonesDatFile, createZonecostDatFile
from .cluz_functions5 import createBoundDatFile
from .zcluz_functions5 import zonesMarxanUpdateSetupObject, addBestZonesMarxanOutputToPUShapefile, addSummedZonesMarxanOutputToPUShapefile, zonesLoadBestMarxanOutputToPUShapefile, zonesLoadSummedMarxanOutputToPUShapefile
from .zcluz_dialog5_code import makeZonesMarxanRawParameterDict, returnZonesMarxanInputValuesOKBool, checkZonesMarxanFilesExistBool, launchZonesMarxanAnalysis, setZonesDialogParameters, makeZonesMarxanParameterDict
from .zcluz_dialog5_code import zonesReturnInitialLoadFieldNames, zonesCheckLoadBestMarxanResultFile, zonesCheckLoadSummedMarxanResultFile


from .cluz_messages import successMessage


class zonesInputsDialog(QDialog, Ui_zonesInputsDialog):
    def __init__(self, iface, setupObject):
        QDialog.__init__(self)
        self.iface = iface
        self.setupUi(self)
        self.boundextBox.setEnabled(False)
        self.okButton.clicked.connect(lambda: self.setCreateZonesMarxanInputFiles(setupObject))

    def setCreateZonesMarxanInputFiles(self, setupObject):
        messageStringList = list()
        if self.targetBox.isChecked():
            createZonesFeatDatFile(setupObject)
            messageStringList.append('feat.dat')
            createZonesTargetDatFile(setupObject)
            messageStringList.append('zonetarget.dat')
            createZonesPropDatFile(setupObject)
            messageStringList.append('zonecontrib.dat')

        if self.puBox.isChecked():
            createZonesPuDatFile(setupObject)
            messageStringList.append('pu.dat')
            zonesPUStatusDict = createZonesPUStatusDict(setupObject)
            createPuLockDatFile(setupObject, zonesPUStatusDict)
            messageStringList.append('pulock.dat')
            createPuZoneDatFile(setupObject, zonesPUStatusDict)
            messageStringList.append('puzone.dat')

        if self.zonesBox.isChecked():
            createZonesDatFile(setupObject)
            messageStringList.append('zones.dat')
            createCostsDatFile(setupObject)
            messageStringList.append('costs.dat')
            createZonecostDatFile(setupObject)
            messageStringList.append('zonecost.dat')

        if self.boundBox.isChecked():
            if self.boundextBox.isChecked() and self.boundextBox.isEnabled():
                extEdgeBool = True
            else:
                extEdgeBool = False
            createBoundDatFile(setupObject, extEdgeBool)
            messageStringList.append('bound.dat')

        if len(messageStringList) > 0:
            messageString = ''
            for aString in messageStringList:
                messageString += aString + ', '
            finalMessageString = messageString[:-2]
            successMessage('Marxan files:', 'the following files have been produced: ' + finalMessageString)

        self.close()


class zonesMarxanDialog(QDialog, Ui_zonesMarxanDialog):
    def __init__(self, iface, setupObject):
        QDialog.__init__(self)
        self.iface = iface
        self.setupUi(self)
        setZonesDialogParameters(self, setupObject)
        self.startButton.clicked.connect(lambda: self.runZonesMarxan(setupObject))

    def runZonesMarxan(self, setupObject):
        zonesMarxanRawParameterDict = makeZonesMarxanRawParameterDict(self, setupObject)
        zonesMarxanInputValuesOKBool = returnZonesMarxanInputValuesOKBool(zonesMarxanRawParameterDict)
        zonesMarxanFilesExistBool = checkZonesMarxanFilesExistBool(setupObject)
        if zonesMarxanInputValuesOKBool and zonesMarxanFilesExistBool:
            zonesMarxanParameterDict = makeZonesMarxanParameterDict(setupObject, zonesMarxanRawParameterDict)
            createZonesFeatDatFile(setupObject)
            if self.boundZoneCheckBox:
                setupObject = createZonesBLMFile(self, setupObject)

            setupObject = zonesMarxanUpdateSetupObject(self, setupObject, zonesMarxanParameterDict)
            updateClzSetupFile(setupObject, True)  # saveSuccessfulBool = True
            self.close()

            bestOutputFile, summedOutputFile = launchZonesMarxanAnalysis(setupObject, zonesMarxanParameterDict)

            addBestZonesMarxanOutputToPUShapefile(setupObject, bestOutputFile, 'Best')
            addSummedZonesMarxanOutputToPUShapefile(setupObject, summedOutputFile)

            reloadZonesPULayer(setupObject)
            removePreviousZonesMarxanLayers()
            displayZonesSFLayer(setupObject, zonesMarxanParameterDict['numRun'], zonesMarxanParameterDict['outputName'], 'Z', '_' + 'SFreq')
            displayZonesBestOutput(setupObject, 'Best (' + zonesMarxanParameterDict['outputName'] + ')', 'Best')

            setupObject.TargetsMetAction.setEnabled(True)


class zonesLoadDialog(QDialog, Ui_zonesLoadDialog):
    def __init__(self, iface, setupObject):
        QDialog.__init__(self)
        self.iface = iface
        self.setupUi(self)

        self.zonesBestLabel.setVisible(False)
        self.zonesBestLineEdit.setVisible(False)
        self.zonesBestNameLineEdit.setVisible(False)
        self.zonesBestButton.setVisible(False)
        self.zonesSummedLabel.setVisible(False)
        self.zonesSummedLineEdit.setVisible(False)
        self.zonesSummedNameLineEdit.setVisible(False)
        self.zonesSummedButton.setVisible(False)

        zonesImportBestName, zonesImportSummedName = zonesReturnInitialLoadFieldNames(setupObject)
        self.zonesBestNameLineEdit.setText(zonesImportBestName)
        self.zonesSummedNameLineEdit.setText(zonesImportSummedName)

        self.zonesBestButton.clicked.connect(self.zonesSetBestPath)
        self.zonesSummedButton.clicked.connect(self.zonesSetSummedPath)
        self.okButton.clicked.connect(lambda: self.zonesLoadPreviousMarxanResults(setupObject))

    def zonesSetBestPath(self):
        (zonesBestPathNameText, fileTypeDetailsText) = QFileDialog.getOpenFileName(self, 'Select Marxan with Zones best portfolio output', '*.csv')
        if zonesBestPathNameText is not None:
            self.zonesBestLineEdit.setText(zonesBestPathNameText)

    def zonesSetSummedPath(self):
        (summedPathNameText, fileTypeDetailsText) = QFileDialog.getOpenFileName(self, 'Select Marxan with Zones summed solution output', '*.csv')
        if summedPathNameText is not None:
            self.zonesSummedLineEdit.setText(summedPathNameText)

    def zonesLoadPreviousMarxanResults(self, setupObject):
        if self.zonesSummedCheckBox.isChecked() and zonesCheckLoadSummedMarxanResultFile(self, setupObject):  # add SF first so Best is then on top
            zonesLoadSFCsvFileName, zonesLoadSFNamePrefix, maxSFScore = zonesLoadSummedMarxanOutputToPUShapefile(self, setupObject)
            reloadZonesPULayer(setupObject)
            runNumber = maxSFScore
            displayZonesSFLayer(setupObject, runNumber, zonesLoadSFCsvFileName, zonesLoadSFNamePrefix + '_Z', '_SF')

        if self.zonesBestCheckBox.isChecked() and zonesCheckLoadBestMarxanResultFile(self, setupObject):
            zonesLoadBestCsvFileName, zonesLoadBestFieldName = zonesLoadBestMarxanOutputToPUShapefile(self, setupObject)
            displayZonesBestOutput(setupObject, 'Best (' + zonesLoadBestCsvFileName + ')', zonesLoadBestFieldName)
