"""
/***************************************************************************
                                 A QGIS plugin
 CLUZ for QGIS
                             -------------------
        begin                : 2022-26-08
        copyright            : (C) 2022 by Bob Smith, DICE
        email                : r.j.smith@kent.ac.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from qgis.PyQt.QtCore import Qt, QVariant
from qgis.PyQt.QtWidgets import QTableWidgetItem
from qgis.PyQt.QtGui import QColor

from qgis.core import QgsVectorLayer, QgsField
from qgis.utils import iface

from .cluz_make_file_dicts import returnRoundedValue
from .cluz_functions4 import returnStringShortfall


# Identify features in selected units #############################################################

def zonesReturnSelectedPUIDDict(setupObject):
    zonesSelectedPUIDDict = dict()

    puLayer = QgsVectorLayer(setupObject.puPath, 'Planning units', 'ogr')
    iface.setActiveLayer(puLayer)
    puLayer = iface.activeLayer()
    provider = puLayer.dataProvider()
    selectedPUs = puLayer.selectedFeatures()
    idFieldIndex = provider.fieldNameIndex('Unit_ID')

    for zoneID in setupObject.zonesDict:
        aZoneSelectedPUIDDict = dict()
        aZoneStatusFieldIndex = provider.fieldNameIndex('Z' + str(zoneID) + '_Status')
        for aPU in selectedPUs:
            puID = int(aPU.attributes()[idFieldIndex])
            puStatus = str(aPU.attributes()[aZoneStatusFieldIndex])
            aZoneSelectedPUIDDict[puID] = puStatus
        zonesSelectedPUIDDict[zoneID] = aZoneSelectedPUIDDict

    return zonesSelectedPUIDDict


def returnZonesSelectedPUDetailsDict(setupObject, zonesSelectedPUIDDict):
    zonesSelectedPUDetailsDict = dict()
    for zoneID in setupObject.zonesDict:
        aZoneSelectedPUDetailsDict = dict()
        aZoneSelectedPUIDDict = zonesSelectedPUIDDict[zoneID]
        for puID in aZoneSelectedPUIDDict:
            puStatus = aZoneSelectedPUIDDict[puID]
            try:
                puAbundDict = setupObject.abundPUKeyDict[puID]
            except KeyError:
                puAbundDict = dict()
            try:
                statusDetailsDict = aZoneSelectedPUDetailsDict[puStatus]
            except KeyError:
                statusDetailsDict = dict()

            for featID in puAbundDict:
                try:
                    featAmount = puAbundDict[featID]
                except KeyError:
                    featAmount = 0
                zoneFeatAmount = featAmount * setupObject.zonesPropDict['Z' + str(zoneID) + '_Prop'][featID]
                try:
                    featRunningAmount = statusDetailsDict[featID]
                except KeyError:
                    featRunningAmount = 0
                featRunningAmount += zoneFeatAmount
                statusDetailsDict[featID] = featRunningAmount
            aZoneSelectedPUDetailsDict[puStatus] = statusDetailsDict

        zonesSelectedPUDetailsDict[zoneID] = aZoneSelectedPUDetailsDict

    return zonesSelectedPUDetailsDict


def zonesAddSelectedIdentifyDataToTableWidget(ZonesIdentifySelectedDialog, setupObject, zonesSelectedPUDetailsDict):
    featIDList = list(setupObject.targetDict.keys())
    featIDList.sort()
    for rowNumber in range(0, len(featIDList)):
        featID = featIDList[rowNumber]
        ZonesIdentifySelectedDialog.zonesIdentifySelectedTableWidget.insertRow(rowNumber)
        featIDTableItem = QTableWidgetItem(str(featID))
        featNameTableItem = QTableWidgetItem(str(setupObject.targetDict[featID][0]))
        zonesIdentifySelectedTableWidgetItemList = [featIDTableItem, featNameTableItem]
        for zoneID in setupObject.zonesDict:
            zoneUnassignedDTableItem = QTableWidgetItem(zonesReturnStringAmountPerStatus(setupObject, zonesSelectedPUDetailsDict, zoneID, 'Unassigned', featID))
            earLockAmount = float(zonesReturnStringAmountPerStatus(setupObject, zonesSelectedPUDetailsDict, zoneID, 'Earmarked', featID)) + float(zonesReturnStringAmountPerStatus(setupObject, zonesSelectedPUDetailsDict, zoneID, 'Locked', featID))
            zoneEarLockIDTableItem = QTableWidgetItem(str(earLockAmount))
            zoneFeatTarget = returnRoundedValue(setupObject, setupObject.zonesTargetDict['Z' + str(zoneID) + '_Target'][featID])
            zoneFeatTargetTableItem = QTableWidgetItem(zoneFeatTarget)
            zonesIdentifySelectedTableWidgetItemList += [zoneUnassignedDTableItem, zoneEarLockIDTableItem, zoneFeatTargetTableItem]
        featTarget = returnRoundedValue(setupObject, setupObject.targetDict[featID][3])
        featTargetTableItem = QTableWidgetItem(featTarget)
        featShortfallTableItem = QTableWidgetItem(returnStringShortfall(setupObject, featID))
        zonesIdentifySelectedTableWidgetItemList += [featTargetTableItem, featShortfallTableItem]

        for colNumber in range(0, len(zonesIdentifySelectedTableWidgetItemList)):
            ZonesIdentifySelectedDialog.zonesIdentifySelectedTableWidget.setItem(rowNumber, colNumber, zonesIdentifySelectedTableWidgetItemList[colNumber])


def zonesReturnStringAmountPerStatus(setupObject, zonesSelectedPUDetailsDict, zoneID, statusValue, featID):
    decPrec = setupObject.decimalPlaces
    try:
        featAmount = zonesSelectedPUDetailsDict[zoneID][statusValue][featID]
        featAmountRound = round(float(featAmount), decPrec)
        featAmountString = format(featAmountRound, '.' + str(decPrec) + 'f')
    except KeyError:
        featAmountString = '0'

    return featAmountString


def zonesAddFormatting_HeadingsToTableWidget(ZonesIdentifySelectedDialog, setupObject):
    headerList = ['ID  ', 'Name  ']
    for zoneID in setupObject.zonesDict:
        headerList.append('Z' + str(zoneID) + ' Unassigned  ')
        headerList.append('Z' + str(zoneID) + ' Ear+Lock  ')
        headerList.append('Z' + str(zoneID) + ' Target  ')
    headerList.append('Target  ')
    headerList.append('Target shortfall  ')

    ZonesIdentifySelectedDialog.zonesIdentifySelectedTableWidget.setHorizontalHeaderLabels(headerList)
    ZonesIdentifySelectedDialog.zonesIdentifySelectedTableWidget.horizontalHeader().setStyleSheet(setupObject.TableHeadingStyle)
    ZonesIdentifySelectedDialog.zonesIdentifySelectedTableWidget.verticalHeader().hide()
    for aColValue in range(len(headerList)):
        ZonesIdentifySelectedDialog.zonesIdentifySelectedTableWidget.resizeColumnToContents(aColValue)


def zonesIdentifySelectedKeyPressEventCode(ZonesIdentifySelectedDialog, e):  # http://stackoverflow.com/questions/24971305/copy-pyqt-table-selection-including-column-and-row-headers
    if e.modifiers() & Qt.ControlModifier:
        selected = ZonesIdentifySelectedDialog.zonesIdentifySelectedTableWidget.selectedRanges()
        if e.key() == Qt.Key_C:  # copy
            s = ''
            for r in range(selected[0].topRow(), selected[0].bottomRow() + 1):
                for c in range(selected[0].leftColumn(), selected[0].rightColumn()+1):
                    try:
                        s += str(ZonesIdentifySelectedDialog.zonesIdentifySelectedTableWidget.item(r, c).text()) + '\t'
                    except AttributeError:
                        s += '\t'
                s = s[:-1] + '\n'  # eliminate last '\t'
            ZonesIdentifySelectedDialog.clip.setText(s)
