"""
/***************************************************************************
                                 A QGIS plugin
 CLUZ for QGIS
                             -------------------
        begin                : 2022-26-08
        copyright            : (C) 2022 by Bob Smith, DICE
        email                : r.j.smith@kent.ac.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""


from qgis.core import QgsVectorLayer
from qgis.PyQt.QtWidgets import QDialog, QFileDialog, QApplication

from cluz_form_zones_identify_selected import Ui_zonesIdentifySelectedDialog


from .zcluz_dialog4_code import zonesReturnSelectedPUIDDict, returnZonesSelectedPUDetailsDict, zonesAddSelectedIdentifyDataToTableWidget, zonesAddFormatting_HeadingsToTableWidget
from .zcluz_dialog4_code import zonesIdentifySelectedKeyPressEventCode


class zonesIdentifySelectedDialog(QDialog, Ui_zonesIdentifySelectedDialog):
    def __init__(self, iface, setupObject):
        QDialog.__init__(self)
        self.iface = iface
        self.setupUi(self)
        self.clip = QApplication.clipboard()
        selectedPUIDDict = zonesReturnSelectedPUIDDict(setupObject)
        selectedPUCount = len(selectedPUIDDict[list(selectedPUIDDict)[0]])
        zonesSelectedPUDetailsDict = returnZonesSelectedPUDetailsDict(setupObject, selectedPUIDDict)
        self.zonesShowSelectedIdentifyData(setupObject, zonesSelectedPUDetailsDict, selectedPUCount)

    def zonesShowSelectedIdentifyData(self, setupObject, zonesSelectedPUDetailsDict, selectedPUCount):
        if len(zonesSelectedPUDetailsDict) > 0:
            self.zonesIdentifySelectedTableWidget.clear()
            columnCountValue = 4 + (3 * len(setupObject.zonesDict))
            self.zonesIdentifySelectedTableWidget.setColumnCount(columnCountValue)
            zonesAddSelectedIdentifyDataToTableWidget(self, setupObject, zonesSelectedPUDetailsDict)
            zonesAddFormatting_HeadingsToTableWidget(self, setupObject)
            self.setWindowTitle('Details of ' + str(selectedPUCount) + ' planning units.')
        else:
            self.setWindowTitle('No planning units selected')

    def keyPressEvent(self, e):
        zonesIdentifySelectedKeyPressEventCode(self, e)
