"""
/***************************************************************************
                                 A QGIS plugin
 CLUZ for QGIS
                             -------------------
        begin                : 2022-26-08
        copyright            : (C) 2022 by Bob Smith, DICE
        email                : r.j.smith@kent.ac.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from qgis.core import QgsVectorLayer


# Update Zones target table ##########


def returnZonesEarLockTotDict(setupObject):
    zonesEarLock_Tot_Dict = dict()

    for zoneID in list(setupObject.zonesDict):
        puLayer = QgsVectorLayer(setupObject.puPath, 'Planning units', 'ogr')
        puFeatures = puLayer.getFeatures()
        puIDField = puLayer.fields().indexFromName('Unit_ID')
        statusFieldName = 'Z' + str(zoneID) + '_Status'
        puStatusField = puLayer.fields().indexFromName(statusFieldName)
        aZonesEarLock_Tot_Dict = dict()

        for puFeature in puFeatures:
            puAttributes = puFeature.attributes()
            puID = puAttributes[puIDField]
            puStatus = puAttributes[puStatusField]
            try:
                puAbundDict = setupObject.abundPUKeyDict[puID]
            except KeyError:
                puAbundDict = dict()
            for featID in puAbundDict:
                try:
                    earLockAmount, totAmount = aZonesEarLock_Tot_Dict[featID]
                except KeyError:
                    earLockAmount, totAmount = [0, 0]
                featAmount = puAbundDict[featID]
                featZoneProp = setupObject.zonesPropDict['Z' + str(zoneID) + '_Prop'][featID]
                adjFeatAmount = featAmount * featZoneProp
                newTotAmount = totAmount + featAmount
                if puStatus == 'Earmarked' or puStatus == 'Locked':
                    newEarLockAmount = earLockAmount + adjFeatAmount
                else:
                    newEarLockAmount = earLockAmount
                aZonesEarLock_Tot_Dict[featID] = [newEarLockAmount, newTotAmount]

        zonesEarLock_Tot_Dict[zoneID] = aZonesEarLock_Tot_Dict

    return zonesEarLock_Tot_Dict


def updateZonesEarLockTotFieldsTargetDict(setupObject, zonesEarLockTotDict):
    targetDict = setupObject.targetDict
    decPrec = setupObject.decimalPlaces
    for featID in targetDict:
        targetList = targetDict[featID]

        try:
            totValue = zonesEarLockTotDict[list(zonesEarLockTotDict)[1]][featID][1]  # This value is in every zone dict, so just chose the Z1 dict
        except KeyError:
            totValue = 0
        targetList[5] = totValue

        combEarLockValue = 0
        for zoneID in list(setupObject.zonesDict):
            zoneIDAdditionalListPosValue = list(setupObject.zonesDict).index(zoneID) + 1
            targetListPos = 6 + (2 * len(setupObject.zonesDict)) + zoneIDAdditionalListPosValue
            try:
                zoneEarLockValue = zonesEarLockTotDict[zoneID][featID][0]
            except KeyError:
                zoneEarLockValue = 0
            targetList[targetListPos] = zoneEarLockValue
            combEarLockValue += zoneEarLockValue
        targetList[4] = combEarLockValue

        featTarget = targetList[3]
        if featTarget > 0:
            pcTarget = targetDict[featID][4] / featTarget
            pcTarget *= 100
            pcTarget = round(float(pcTarget), decPrec)
            pcTarget = format(pcTarget, "." + str(decPrec) + "f")
        else:
            pcTarget = -1
        targetList[6] = pcTarget

        targetDict[featID] = targetList

    return targetDict
