"""
/***************************************************************************
                                 A QGIS plugin
 CLUZ for QGIS
                             -------------------
        begin                : 2022-26-08
        copyright            : (C) 2022 by Bob Smith, DICE
        email                : r.j.smith@kent.ac.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from qgis.PyQt.QtWidgets import QDialog, QFileDialog

from cluz_form_remove import Ui_removeDialog

from .cluz_make_file_dicts import makeAbundancePUKeyDict
from .zcluz_dialog3_code import returnZonesEarLockTotDict, updateZonesEarLockTotFieldsTargetDict
from .zcluz_make_file_dicts import updateZonesTargetCSVFromTargetDict
from .cluz_messages import successMessage


def recalcUpdateZonesTargetTableDetails(setupObject):
    setupObject.abundPUKeyDict = makeAbundancePUKeyDict(setupObject)
    newZonesEarLockTotDict = returnZonesEarLockTotDict(setupObject)
    targetDict = updateZonesEarLockTotFieldsTargetDict(setupObject, newZonesEarLockTotDict)

    setupObject.targetDict = targetDict
    updateZonesTargetCSVFromTargetDict(setupObject, targetDict)
    successMessage('Target table updated: ', 'process completed.')

