"""
/***************************************************************************
                                 A QGIS plugin
 CLUZ for QGIS
                             -------------------
        begin                : 2022-26-08
        copyright            : (C) 2022 by Bob Smith, DICE
        email                : r.j.smith@kent.ac.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from qgis.PyQt.QtWidgets import QDialog, QFileDialog

from os import listdir, path
import sys

from .zcluz_dialog2_code import updateMarxanWithZonesTransformObject, zonesTransformMakeInputFolder, zonesTransformMakeOutputFolder, zonesTransformCopyPuvSpr2File, zonesTransformTargetCSVFile, zonesTransformPULayer
from .zcluz_dialog2_code import zonesTransformZonesCSVFile, zonesTransformCreateClzSetupFile
from .cluz_messages import criticalMessage, successMessage


sys.path.append(path.dirname(path.abspath(__file__)) + "/forms")
from cluz_form_zones_transform import Ui_zonesTransformDialog


class marxanWithZonesTransformObject:
    def __init__(self):
        self.updated = False


class zonesTransformDialog(QDialog, Ui_zonesTransformDialog):
    def __init__(self, iface, setupObject):
        QDialog.__init__(self)
        self.iface = iface
        self.setupUi(self)

        self.zoneComboBox.addItems(['2', '3', '4', '5'])
        self.zoneComboBox.setCurrentIndex(1)
        self.setupPathLabel.setText('CLUZ setup file for files that will be transformed: ' + setupObject.setupPath)
        self.setupLineEdit.setText('zones_ex1')
        self.puLineEdit.setText('zones_puLayer')
        self.targetLineEdit.setText('zones_targets')
        self.zonesLineEdit.setText('zones_details')

        self.mwzInputButton.clicked.connect(self.setMarxanWithZonesPath)
        self.folderButton.clicked.connect(self.setTransformFolderPath)
        self.okButton.clicked.connect(lambda: self.createNewZonesCLUZFiles(setupObject))

        self.close()

    def setMarxanWithZonesPath(self):
        (marxanWithZonesPathNameRawText, fileTypeDetailsText) = QFileDialog.getOpenFileName(self, 'Select Marxan with Zones file', '*.exe')
        marxanWithZonesPathNameText = path.abspath(marxanWithZonesPathNameRawText)
        if marxanWithZonesPathNameText is not None:
            self.mwzInputLineEdit.setText(marxanWithZonesPathNameText)

    def setTransformFolderPath(self):
        transformPathNameRawText = QFileDialog.getExistingDirectory(self, 'Select empty folder where new files will be saved')
        transformPathNameText = path.abspath(transformPathNameRawText)
        if transformPathNameText is not None:
            if len(listdir(transformPathNameText)) == 0:
                self.folderLineEdit.setText(transformPathNameText)
            else:
                criticalMessage('Selected folder is not empty', ' You must specify a folder that does not contain any files or subfolders.')

    def createNewZonesCLUZFiles(self, setupObject):
        zonesTransformObject = marxanWithZonesTransformObject
        zonesTransformObject = updateMarxanWithZonesTransformObject(self, zonesTransformObject)
        if zonesTransformObject.updated:
            zonesTransformMakeInputFolder(zonesTransformObject)
            zonesTransformMakeOutputFolder(zonesTransformObject)
            zonesTransformCopyPuvSpr2File(setupObject, zonesTransformObject)

            zonesTransformPULayer(setupObject, zonesTransformObject)
            zonesTransformTargetCSVFile(setupObject, zonesTransformObject)
            zonesTransformZonesCSVFile(zonesTransformObject)

            zonesTransformCreateClzSetupFile(setupObject, zonesTransformObject)

        successMessage('Marxan with Zones transformation: ', 'process completed.')

        self.close()
