# -*- coding: utf-8 -*-

'''
/***************************************************************************
 Closest Points
                                 A QGIS plugin
 desciption of the plugin
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-10-27
        copyright            : (C) 2019 by Christoph Jung
        email                : jagodki.cj@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
'''

__author__ = 'Christoph Jung'
__date__ = '2019-10-27'
__copyright__ = '(C) 2019 by Christoph Jung'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'
from PyQt5.QtCore import QCoreApplication, QUrl, QVariant
from PyQt5.QtGui import QIcon
from qgis.core import (QgsProcessing,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterVectorLayer,
                       QgsProcessingParameterFeatureSink,
                       QgsWkbTypes,
                       QgsField,
                       QgsFields,
                       QgsFeature)
import processing
import time, os.path
from collections import Counter


class FindAllClosestPointsAlgorithm(QgsProcessingAlgorithm):
    '''
    This is an example algorithm that takes a vector layer and
    creates a new identical one.

    It is meant to be used as an example of how to create your own
    algorithms and explain methods and variables used to do it. An
    algorithm like this will be available in all elements, and there
    is not need for additional work.

    All Processing algorithms should extend the QgsProcessingAlgorithm
    class.
    '''

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.

    FROM_LAYER = 'FROM_LAYER'
    TO_LAYER = 'TO_LAYER'
    OUTPUT = 'OUTPUT'

    def initAlgorithm(self, config):
        '''
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        '''
        
        self.addParameter(
            QgsProcessingParameterVectorLayer(
                self.FROM_LAYER,
                self.tr('Layer to calculate closest points from'),
                [QgsProcessing.TypeVectorAnyGeometry]
            )
        )
        
        self.addParameter(
            QgsProcessingParameterVectorLayer(
                self.TO_LAYER,
                self.tr('Layer to calculate closest points to'),
                [QgsProcessing.TypeVectorAnyGeometry]
            )
        )
        
        self.addParameter(
            QgsProcessingParameterFeatureSink(
                self.OUTPUT,
                self.tr('Closest Points')
            )
        )

    def processAlgorithm(self, parameters, context, feedback):
        '''
        Here is where the processing itself takes place.
        '''
        start_time = time.time()
        
        #create the fields for the feature sink
        fields_array = [QgsField('id', QVariant.Int),
                  QgsField('from_fid', QVariant.Int),
                  QgsField('to_fid', QVariant.Int),
                  QgsField('distance', QVariant.Double)]
        
        fields = QgsFields()
        for field in fields_array:
            fields.append(field)
        
        #extract all parameters
        from_layer = self.parameterAsVectorLayer(
            parameters,
            self.FROM_LAYER,
            context
        )
        
        to_layer = self.parameterAsVectorLayer(
            parameters,
            self.TO_LAYER,
            context
        )
        
        (sink, dest_id) = self.parameterAsSink(
            parameters,
            self.OUTPUT,
            context,
            fields,
            QgsWkbTypes.Point,
            from_layer.crs()
        )
        
        #check the input
        if from_layer is None:
            raise QgsProcessingException(self.invalidSourceError(parameters, self.FROM_LAYER))
            
        if to_layer is None:
            raise QgsProcessingException(self.invalidSourceError(parameters, self.TO_LAYER))
        
        feedback.pushInfo('CRS of the first layer is {}'.format(from_layer.sourceCrs().authid()))
        feedback.pushInfo('CRS of the second layer is {}'.format(to_layer.sourceCrs().authid()))
        
        if from_layer.sourceCrs().authid() != to_layer.sourceCrs().authid():
            raise QgsProcessingException(self.invalidSourceError(parameters, self.FROM_LAYER, self.TO_LAYER))
        
        #init the progressbar
        max_count = len(Counter(from_layer.getFeatures()))
        feedback.setProgress(0)
        
        #init the id of the new layer
        new_id = 1
        
        #iterate over all features
        for index, from_feature in enumerate(from_layer.getFeatures()):
            
            #iterate over the features of the second layer
            for second_index, to_feature in enumerate(to_layer.getFeatures()):
                
                #calcuate the distance between the current features and store the result in the feature sink
                distance = from_feature.geometry().distance(to_feature.geometry())
                closest_point = to_feature.geometry().nearestPoint(from_feature.geometry())
                
                #add the new point to the sink
                if closest_point is not None:
                    new_feature = QgsFeature(fields)
                    new_feature.setGeometry(closest_point)
                    new_feature.setAttribute('id', new_id)
                    new_feature.setAttribute('from_fid', index)
                    new_feature.setAttribute('to_fid', second_index)
                    new_feature.setAttribute('distance', distance)
                    sink.addFeature(new_feature)
                
                new_id += 1
            
            #update progressbar
            feedback.setProgress(int((index / max_count) * 100))
        
        return {'OUTPUT': dest_id,
                'COMPUTATION_TIME': str(time.time() - start_time)}

    def name(self):
        '''
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        '''
        return 'find_all_closest_points'
    
    def helpUrl(self):
        '''
        Returns the URL for the help document, if a help document does exist.
        '''
        dir = os.path.dirname(__file__)
        file = os.path.abspath(os.path.join(dir, '..', 'help', 'help_closest_points.html'))
        if not os.path.exists(file):
            return ''
        return QUrl.fromLocalFile(file).toString(QUrl.FullyEncoded)

    def shortHelpString(self):
        '''Returns the text for the help widget, if a help document does exist.'''
        dir = os.path.dirname(__file__)
        file = os.path.abspath(os.path.join(dir, '..', 'help', 'help_closest_points.html'))
        if not os.path.exists(file):
            return ''
        with open(file) as helpf:
            help=helpf.read()
        return help
    
    def displayName(self):
        '''
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        '''
        return self.tr('Find all closest points for each feature')

    # def group(self):
        # '''
        # Returns the name of the group this algorithm belongs to. This string
        # should be localised.
        # '''
        # return self.tr(self.groupId())
    
    # def groupId(self):
        # '''
        # Returns the unique ID of the group this algorithm belongs to. This
        # string should be fixed for the algorithm, and must not be localised.
        # The group id should be unique within each provider. Group id should
        # contain lowercase alphanumeric characters only and no spaces or other
        # formatting characters.
        # '''
        # return 'Find closest points'
    
    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return FindAllClosestPointsAlgorithm()

    def icon(self):
        return QIcon(':/plugins/closest_points/icons/all_closest_points_icon.png')
