import os
from qgis.core import QgsApplication, QgsProcessingProvider
from qgis.PyQt.QtGui import QIcon

class ClockBoardZoneProvider(QgsProcessingProvider):
    """
    QGIS Processing Provider for Clock Board Zone (Multi-Center).
    """
    def __init__(self, iface=None):
        super().__init__()
        self.iface = iface

    def initGui(self):
        """
        Called by QGIS to initialize the plugin GUI; here we register the provider.
        """
        QgsApplication.processingRegistry().addProvider(self)

    def unload(self):
        """
        Called by QGIS when plugin is disabled; remove the provider.
        """
        QgsApplication.processingRegistry().removeProvider(self)

    def id(self):
        return 'clock_board_zone'

    def name(self):
        return self.tr('Clock Board Zone (Multi-Center)')

    def icon(self):
        icon_path = os.path.join(os.path.dirname(__file__), 'icon.png')
        return QIcon(icon_path)

    def loadAlgorithms(self):
        """Register available Processing algorithms."""
        from .algorithms.clock_board_zone_algorithm import ClockBoardZoneAlgorithm
        self.addAlgorithm(ClockBoardZoneAlgorithm())