# -*- coding: utf-8 -*-
"""
/***************************************************************************
 ClimaPlots 
                                 A QGIS plugin
This plugin calculates the Vegetation Index of a given area.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-10-24
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Caio Arantes
        email                : github.com/caioarantes
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
from qgis.gui import QgsMapToolEmitPoint
from qgis.gui import QgsVertexMarker

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .climaplots_dialog import ClimaPlotsDialog
import os.path

from .mouse_events import handleMouseDown, Delete_Marker, fun_fechou


class ClimaPlots:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.



        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'ClimaPlots_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&ClimaPlots')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None
        self.dlg = None  # Initialize dialog reference

        # refernce to map canvas
        self.canvas = self.iface.mapCanvas()
        # out click tool will emit a QgsPoint on every click
        self.clickTool = QgsMapToolEmitPoint(self.canvas)


    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('ClimaPlots', message)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar."""

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/climaplots/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'ClimaPlots'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True

                # will be set False in run()
        self.first_start = True
        self.Markers = []

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&ClimaPlots'),
                action)
            self.iface.removeToolBarIcon(action)
        
        # Close dialog if it exists
        if self.dlg:
            self.dlg.close()

    # In your main plugin class (climaplots.py)
    def run(self):
        """Run method that shows the modeless dialog"""
        
        # Create dialog only if it doesn't exist
        if not hasattr(self, 'dlg') or self.dlg is None:
            self.dlg = ClimaPlotsDialog(parent=None, iface=self.iface)
            # expose canvas and markers list to the dialog for cleanup
            try:
                self.dlg.canvas = self.canvas
                self.dlg.Markers = self.Markers
            except Exception:
                pass
        
        # Check if dialog exists but is minimized or hidden
        if self.dlg.isMinimized():
            # Restore from minimized state
            self.dlg.showNormal()
            self.dlg.raise_()
            self.dlg.activateWindow()
        elif not self.dlg.isVisible():
            # Show if hidden
            self.dlg.show()
            self.dlg.raise_()
            self.dlg.activateWindow()
        else:
            # Already visible, just bring to front
            self.dlg.raise_()
            self.dlg.activateWindow()

        # Run method that performs all the real work
        self.canvas.setMapTool(self.clickTool)
        # Conecta o evento do mouse à função importada
        self.clickTool.canvasClicked.connect(lambda point, button=None: handleMouseDown(self.canvas, self.dlg, self.Markers, point, button))
        self.dlg.LongEdit.clear()
        self.dlg.LatEdit.clear()
        # Ensure dialog-level cleanup also removes markers when rejected
        self.dlg.rejected.connect(lambda: fun_fechou(self.canvas, self.Markers))

        self.dlg.show()

        # Run the dialog event loop
        result = self.dlg.exec_()



    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&ClimaPlots'),
                action)
            self.iface.removeToolBarIcon(action)
        
        # Clean close of dialog
        if hasattr(self, 'dlg') and self.dlg:
            try:
                self.dlg.close()
            except RuntimeError:
                pass