# -*- coding: utf-8 -*-
"""
/***************************************************************************
 citygen
                                 A QGIS plugin
 A plugin to generate 3D models of urban areas
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-04-30
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Arthur Ruf Hosang da Costa (https://github.com/arthurRuf)
        email                : arthur.rhc@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""


import os
import processing
from qgis.core import QgsProcessingUtils, QgsRasterLayer, QgsProject

def configure(appResources, appContext):
    pass


def execute(appResources, appContext):

    appResources.bibliotecas.logger.update_progress(step_current=1, step_maximum=100)
    raw_folder = f"{appContext.execution.raw_temp_folder}/dsm"
    raw_file = f"{raw_folder}/dsm.zip"
    appResources.bibliotecas.file_management.create_dirs(raw_folder)

    appResources.bibliotecas.logger.plugin_log(f"raw_file: {raw_file}")

    appResources.bibliotecas.logger.update_progress(step_description="Downloading DSM...")
    appResources.bibliotecas.internet.download_file(
        'https://ttc-hosang.s3.amazonaws.com/test/sc_dsm.zip',
        raw_file)

    # NORMALIZING
    appResources.bibliotecas.logger.update_progress(step_description="Uncompressing...")
    appResources.bibliotecas.file_management.unzip_file(raw_file, f"{appContext.execution.raw_temp_folder}/dsm/")
    result = f"{appContext.execution.raw_temp_folder}/dsm/dsm.tif"

    appContext.update_layer(
        appContext,
        result,
        "dsm",
        "gdal",
        4674
    )

    appResources.bibliotecas.logger.update_progress(step_current=1, step_maximum=1)
    appResources.bibliotecas.logger.plugin_log("Done!")
