# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CIGeoERenameAttachmentAttribute
                                 A QGIS plugin
 Rename attachment attribute of selected field on all features
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-05-05
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Centro de Informação Geoespacial do Exército 
        email                : igeoe@igeoe.pt
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, Qt
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QToolBar, QMessageBox, QComboBox, QLineEdit, QPushButton, QLabel

#from qgis.gui import QgsMessageBar
from qgis.gui import *
from qgis.core import *

# Initialize Qt resources from file resources.py
from .resources import *

# Import the code for the DockWidget
from .CIGeoE_Rename_Attachment_Attribute_dockwidget import CIGeoERenameAttachmentAttributeDockWidget


import os.path
from pathlib import Path
import shutil


class CIGeoERenameAttachmentAttribute:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface

        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)

        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'CIGeoERenameAttachmentAttribute_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&CIGeoE Rename Attachment Attribute')

        # TODO: We are going to let the user set this up in a future iteration

        # Check for CIGeoE toolbar. If exists, add button there; if not exists, create one
        cigeoeToolBarExists = False
        for x in iface.mainWindow().findChildren(QToolBar): 
            if x.windowTitle() == 'CIGeoE':
                self.toolbar = x
                cigeoeToolBarExists = True
        if cigeoeToolBarExists==False:
            self.toolbar = self.iface.addToolBar(u'CIGeoE')
        
        self.toolbar.setObjectName(u'CIGeoERenameAttachmentAttribute')

        #print "** INITIALIZING CIGeoERenameAttachmentAttribute"

        self.pluginIsActive = False
        self.dockwidget = None
        self.attrList = []
        self.selectedAttr = ""

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('CIGeoERenameAttachmentAttribute', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action


    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/CIGeoE_Rename_Attachment_Attribute/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'CIGeoE Rename Attachment Attribute: Rename attachment attribute of selected field on all features'),
            callback=self.run,
            parent=self.iface.mainWindow())


    def onClosePlugin(self):
        """Cleanup necessary items here when plugin dockwidget is closed"""

        #print "** CLOSING CIGeoERenameAttachmentAttribute"

        # disconnects
        self.dockwidget.closingPlugin.disconnect(self.onClosePlugin)

        # remove this statement if dockwidget is to remain
        # for reuse if plugin is reopened
        # Commented next statement since it causes QGIS crashe
        # when closing the docked window:
        # self.dockwidget = None

        self.pluginIsActive = False
        self.dockwidget = None
        self.attrList = []
        self.selectedAttr = ""


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""

        #print "** UNLOAD CIGeoERenameAttachmentAttribute"

        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&CIGeoE Rename Attachment Attribute'),
                action)
            self.iface.removeToolBarIcon(action)
        # remove the toolbar
        del self.toolbar

    
    #*************************************************************

    def run(self):
        """Run method that loads and starts the plugin"""  

        layer = self.iface.activeLayer()
        if not layer:        
            QMessageBox.information(self.iface.mainWindow(), "Error", 'Layer is not loaded!')
            return 

        if not layer.isEditable():
            QMessageBox.information(self.iface.mainWindow(), "Error", 'Layer is not editable!')
            return

        if not self.pluginIsActive:
            self.pluginIsActive = True

            if self.dockwidget == None:
                # Create the dockwidget (after translation) and keep reference
                self.dockwidget = CIGeoERenameAttachmentAttributeDockWidget()
 
                self.dockwidget.label.setText(layer.name())
                self.loadAttrIntoComboBox()
                self.dockwidget.attrComboBox.currentIndexChanged.connect(self.newAttrSelected)
                self.dockwidget.valueTextLine.returnPressed.connect(self.newValueSelected)               
 
            # connect to provide cleanup on closing of dockwidget
            self.dockwidget.closingPlugin.connect(self.onClosePlugin)

            # show the dockwidget
            # TODO: fix to allow choice of dock location
            self.iface.addDockWidget(Qt.LeftDockWidgetArea, self.dockwidget)
            self.dockwidget.show()
 
        else:            
            self.iface.removeDockWidget(self.dockwidget)
            self.onClosePlugin()


    #*************************************************************

    def loadAttrIntoComboBox(self):
        selectedLayer = self.iface.activeLayer()

        self.attrList=[]
        prov = selectedLayer.dataProvider()
        fields = prov.fields()
        for field in fields:
            self.attrList.append(field.name())

        self.dockwidget.attrComboBox.addItems(self.attrList)


    def newAttrSelected(self):      
        self.selectedAttr = self.dockwidget.attrComboBox.currentText()
        return


    def newValueSelected(self):
        layer = self.iface.activeLayer()

        newValue = self.dockwidget.valueTextLine.text()
        if newValue == '':
            QMessageBox.information(self.iface.mainWindow(), "Error", "Insert <new value> in the text line.")
            return

        # identify the selected attribute index
        indAttr = 0
        for ind in range(len(self.attrList)):
            if self.attrList[ind] == self.selectedAttr:
                indAttr = ind


        # check the attributes in "newValueSeleted"       
        desc1 = ""          # diretoria/ficheiro
        desc2 = ""          # atributos
        ini = 0
        for ind in range(len(newValue)):
            if newValue[ind] == '$':
                if ini == 0:
                    ini = 1
            if ini == 0:
                desc1 = desc1+(newValue[ind])
            else:
                desc2 = desc2+(newValue[ind])


        if len(desc2) == 0:             
            QMessageBox.information(self.iface.mainWindow(), "Error", "The <new value> entered in the text line is invalid.")
            return

        base_path = self.iface.activeLayer().dataProvider().dataSourceUri() 
        layerPath,_ = os.path.split(base_path)
        
        if len(desc1) > 0:  
            flagPath = 0   
            absPath = ''
            relPath = ''
            desc1 = desc1.replace("\\", "/")  
            if desc1[1:3] == ':/': 
                absPath = desc1
                            
            elif desc1[0:2] =="//":      
                absPath = desc1
                flagPath = 1
                 
            elif desc1[0:2] == "./":
                desc1 = desc1[1:]
                relPath = desc1
                           
            elif desc1[0:1] == "/":        
                relPath = desc1            
                

            if absPath != '':
                tot = absPath.count('//')                
                if tot > 1: 
                    QMessageBox.information(self.iface.mainWindow(), "Error", "The <new value> entered in the text line is invalid.")
                    return  
                else:
                    if tot == 1:
                        if flagPath == 0:
                            QMessageBox.information(self.iface.mainWindow(), "Error", "The <new value> entered in the text line is invalid.")
                            return  

                iniPath = absPath.replace("/", "\\")                
                
            else:
                if relPath != '': 
                    tot = relPath.count('//')                
                    if tot > 0: 
                        QMessageBox.information(self.iface.mainWindow(), "Error", "The <new value> entered in the text line is invalid.")
                        return  

                    iniPath = layerPath+relPath                    
                    #iniPath = iniPath.replace("/", "\\")                    
                else:     
                    QMessageBox.information(self.iface.mainWindow(), "Error", "The <new value> entered in the text line is invalid.")
                    return

        else:
            iniPath = layerPath+"/"

        ini = 0
        desc = ""
        valueListIni =[]
        for ind in range(len(desc2)):
            if desc2[ind] == '$':
                if ini == 0:
                    ini = 1
                else:
                    if desc != "":    
                        valueListIni.append(desc)
                        desc =""
                        ini = 0
            else:        
                if ini == 1:
                    desc = desc + desc2[ind] 

        # check repeated attributes
        valueList =[]
        for name1 in valueListIni:
            if name1 != self.selectedAttr:
                if name1 not in valueList:                    
                    valueList.append(name1)
       
        if len(valueList) == 0:
            QMessageBox.information(self.iface.mainWindow(), "Error", "The <new value> entered in the text line is invalid.")
            return
        
        pathFile = Path(iniPath)                  
        if not pathFile.is_dir():
            pathFile.mkdir(parents=True, exist_ok=True)	
          
        # change attribute value in attribute selected 
        changeOK = ""

        features = layer.getFeatures()
        for feature in features: 
            attrs = feature.attributes()
            valueindAttr = attrs[indAttr] 

            if (type(valueindAttr).__name__) == 'str':

                fileName = valueindAttr 
                fileName = fileName.replace("\\", "/")
                if fileName is not None:                    
                    
                    if fileName[1:3] == ':/' or  fileName[0:2] =="//": 
                        fileName = fileName.replace("/", "\\")                        
                    else: 
                        if fileName[0:1] == '.':  
                            fileName = fileName[1:] 
                            fileName = layerPath+fileName 
                        else:
                            if fileName[0:1] == '/': 
                                fileName = layerPath+fileName
                            else:
                                fileName = layerPath+"/"+fileName 

                    pathFile = Path(fileName)                    
                    if pathFile.is_file():                        
                        valueAttrText = self.newValueAttrText(valueList, attrs)                  
    
                        newfileName = iniPath+valueAttrText+".jpg" 

                        pathFile = Path(newfileName)
                        if pathFile.is_file():
                            os.remove(pathFile)
 
                        shutil.copy(fileName, newfileName) 

                        if len(desc1) > 0 :
                            if desc1[1:3] == ':/' or fileName[0:2] =="//":
                                newfileNamex = absPath+valueAttrText+".jpg"
                            else:
                                newfileNamex = "."+relPath+valueAttrText+".jpg"
                        else:
                            newfileNamex = valueAttrText+".jpg"
                            
                        feature[self.selectedAttr] = newfileNamex
                        layer.updateFeature(feature) 
                        changeOK = "*"
                      

        self.dockwidget.attrComboBox.setEnabled(False)  
        self.dockwidget.valueTextLine.setEnabled(False) 

        if changeOK == "":
            QMessageBox.information(self.iface.mainWindow(), "Info", "No changes were made, check selected attribute values.")
        else:
            self.iface.messageBar().pushMessage("CIGeoE Rename Attachment Attribute", "Rename Attachment Attribute done" , level=Qgis.Info, duration=3)

        return


    def newValueAttrText(self, valueList, attrs): 
        valueAttrText = ""
        flag = 0
        for ind in range(len(valueList)):
            name1 = valueList[ind]
            if flag == 0:
                if name1 not in self.attrList:        
                    valueAttrText = valueAttrText + str(valueList[ind]) 
                else: 
                    for ind in range(len(self.attrList)):  
                        if name1 == self.attrList[ind]:  
                            valueAttrText = valueAttrText + str(attrs[ind])
                flag = 1
            else:
                if name1 not in self.attrList:
                    valueAttrText = valueAttrText+"_"+str(valueList[ind]) 
                else: 
                    for ind in range(len(self.attrList)):  
                        if name1 == self.attrList[ind]:  
                            valueAttrText = valueAttrText + "_"+ str(attrs[ind])   
        
        return valueAttrText




