# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CIGeoEMergeAreas
                                 A QGIS plugin
 Centro de Informação Geoespacial do Exército 
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-01-28
        git sha              : $Format:%H$
        copyright            : (C) 2019 by Centro de Informação Geoespacial do Exército 
        email                : igeoe@igeoe.pt
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtCore import QSettings, QTranslator, qVersion, QCoreApplication, Qt
from PyQt5.QtGui import QIcon
from PyQt5.QtWidgets import QAction, QToolBar, QMessageBox 
from qgis.gui import QgsMessageBar
from qgis.core import *

# Initialize Qt resources from file resources.py
from .resources import *

# Import the code for the DockWidget
from .CIGeoE_Merge_Areas_dockwidget import CIGeoEMergeAreasDockWidget
import os.path


class CIGeoEMergeAreas:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface

        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)

        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'CIGeoEMergeAreas_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&CIGeoE Merge Areas')

        # Check for CIGeoE toolbar. If exists, add button there; if not exists, create one
        cigeoeToolBarExists = False
        for x in iface.mainWindow().findChildren(QToolBar): 
            if x.windowTitle() == 'CIGeoE':
                self.toolbar = x
                cigeoeToolBarExists = True
        if cigeoeToolBarExists==False:
            self.toolbar = self.iface.addToolBar(u'CIGeoE')


        self.toolbar.setObjectName(u'CIGeoE Merge Areas')

       
        #print "** INITIALIZING CIGeoEMergeAreas"

        self.pluginIsActive = False
        self.dockwidget = None


    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('CIGeoEMergeAreas', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action


    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/CIGeoE_Merge_Areas/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'CIGeoE Merge Areas: Merges 2 polygons that overlap and have same attribute names and values.'),
            callback=self.run,
            parent=self.iface.mainWindow())

    #--------------------------------------------------------------------------

    def onClosePlugin(self):
        """Cleanup necessary items here when plugin dockwidget is closed"""

        #print "** CLOSING CIGeoEMergeAreas"

        # disconnects
        self.dockwidget.closingPlugin.disconnect(self.onClosePlugin)

        # remove this statement if dockwidget is to remain
        # for reuse if plugin is reopened
        # Commented next statement since it causes QGIS crashe
        # when closing the docked window:
        # self.dockwidget = None

        self.pluginIsActive = False


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""

        #print "** UNLOAD CIGeoEMergeAreas"

        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&CIGeoE Merge Areas'),
                action)
            self.iface.removeToolBarIcon(action)
        # remove the toolbar
        del self.toolbar

    #--------------------------------------------------------------------------

    def run(self):
        """Run method that loads and starts the plugin"""

        #if not self.pluginIsActive:
        #   self.pluginIsActive = True

        #    #print "** STARTING CIGeoEMergeAreas"

        #    # dockwidget may not exist if:
        #    #    first run of plugin
        #    #    removed on close (see self.onClosePlugin method)
        #    if self.dockwidget == None:
        #        # Create the dockwidget (after translation) and keep reference
        #        self.dockwidget = CIGeoEMergeAreasDockWidget()

        #    # connect to provide cleanup on closing of dockwidget
        #    self.dockwidget.closingPlugin.connect(self.onClosePlugin)

        #    # show the dockwidget
        #    # TODO: fix to allow choice of dock location
        #    self.iface.addDockWidget(Qt.LeftDockWidgetArea, self.dockwidget)
        #    self.dockwidget.show()


        self.mergeBtnHandler()

    def mergeBtnHandler(self):
        selectedLayer = self.iface.activeLayer()

        if not selectedLayer:
            QMessageBox.information(self.iface.mainWindow(), "Error", 'Layer is not loaded!')
            return 

        selected_features = selectedLayer.selectedFeatures()

        #wont advance if there's more or less than 2 selected features
        if(len(selected_features)!=2):
            QMessageBox.information(self.iface.mainWindow(), "Error", 'To merge areas, must exactly select 2 polygons that overlap.')
            return
        
        feat1=selected_features[0]
        feat2=selected_features[1]

        #wont advance if any of the two features is not a polygon
        #if feat1.geometry().type()!=QGis.Polygon or feat2.geometry().type()!=QGis.Polygon:             # pyqgis2
        if feat1.geometry().type()!=QgsWkbTypes.PolygonGeometry or feat2.geometry().type()!=QgsWkbTypes.PolygonGeometry:
            QMessageBox.information(self.iface.mainWindow(), "Error", 'To merge areas, both features must be of Polygon type.')
            return

        #populate fields list
        fields_list1=[]
        fields1 = feat1.fields()
        for field in fields1:
            fields_list1.append(field.name())

        fields_list2=[]
        fields2 = feat2.fields()
        for field in fields2:
            fields_list2.append(field.name())

        fields_list1=set(fields_list1)
        f1AttrQtt=len(fields_list1)
        fields_list2=set(fields_list2)
        f2AttrQtt=len(fields_list2)
        f12CommonAttr=len(list(fields_list1 & fields_list2))

        #wont advance if both features don't have same attributes
        if(f1AttrQtt!=f2AttrQtt or f1AttrQtt!=f12CommonAttr or f2AttrQtt!=f12CommonAttr):
            QMessageBox.information(self.iface.mainWindow(), "Error", "To merge areas, both features must have same attributes (feature 1: "+str(set(fields_list1))+", feature 2: "+str(set(fields_list2))+").")
            return

        hasSameAttrValues=True
        notMatchingFeature=""
        for field in fields_list1:
            if(feat1[field]!=feat2[field]):
                hasSameAttrValues=False
                notMatchingFeature="feature 1: '"+field+"="+str(feat1[field])+"', feature 2: '"+field+"="+str(feat2[field])+"'"
                break

        #wont advance if features have different values for same attributes
        if hasSameAttrValues==False:
            QMessageBox.information(self.iface.mainWindow(), "Error", "To merge areas, both features must have same values in their attributes ("+notMatchingFeature+").")
            return

        #wont advance if both features do not intersect each other
        if (feat1.geometry().intersects(feat2.geometry())==False):
            QMessageBox.information(self.iface.mainWindow(), "Error", "Selected features do not intersect each other.")
            return
        
        selectedLayer.startEditing()

        newFeature=QgsFeature()
        newFeature.setGeometry( feat1.geometry().combine( feat2.geometry() ) )
        newFeature.setFields(feat1.fields())
        for field in fields_list1:
            newFeature.setAttribute(field, feat1[field])

        #selectedLayer.addFeature(newFeature, True)         # pyqgis2
        selectedLayer.addFeature(newFeature)
        selectedLayer.deleteFeature(feat1.id())
        selectedLayer.deleteFeature(feat2.id())

        selectedLayer.triggerRepaint()
        
        #QgsMessageLog.logMessage("Features merged.", 'CIGeoE Merge Areas')
        self.iface.messageBar().pushMessage("CIGeoE Merge Areas", "Features merged." , level=Qgis.Info, duration=2)
