# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CIGeoECircumventPolygon
                                 A QGIS plugin
 Changes the line to circumvent a polygon between the intersection points
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-01-15
        git sha              : $Format:%H$
        copyright            : (C) 2019 by Centro de Informação Geoespacial do Exército
        email                : igeoe@igeoe.pt
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtCore import QSettings, QTranslator, qVersion, QCoreApplication
from PyQt5.QtGui import QIcon
from PyQt5.QtWidgets import QAction, QToolBar, QMessageBox

from qgis.gui import QgsMessageBar
from qgis.core import QgsMapLayer, QgsWkbTypes, QgsGeometry, QgsFeature, QgsProject, Qgis
#from qgis.core import *

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .CIGeoE_Circumvent_Polygon_dialog import CIGeoECircumventPolygonDialog
import os.path


class CIGeoECircumventPolygon:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'CIGeoECircumventPolygon_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&CIGeoE Circumvent Polygon')

        # Check for CIGeoE toolbar. If exists, add button there; if not exists, create one
        cigeoeToolBarExists = False
        for x in iface.mainWindow().findChildren(QToolBar): 
            if x.windowTitle() == 'CIGeoE':
                self.toolbar = x
                cigeoeToolBarExists = True

        if cigeoeToolBarExists==False:
            self.toolbar = self.iface.addToolBar(u'CIGeoE')         

        self.toolbar.setObjectName(u'CIGeoECircumventPolygon')


        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None


#************************************************

        self.selectedFeaturesMap={}
        self.iface.mapCanvas().selectionChanged.connect(self.mapSelectionChanged)


    def mapSelectionChanged(self, layer):
        if("0" not in self.selectedFeaturesMap):
            self.selectedFeaturesMap["0"]={"layer":layer, "features":layer.selectedFeatures()}
        elif("1" not in self.selectedFeaturesMap):
            self.selectedFeaturesMap["1"]={"layer":layer, "features":layer.selectedFeatures()}
        else:
            self.selectedFeaturesMap["0"]=self.selectedFeaturesMap["1"]
            self.selectedFeaturesMap["1"]={"layer":layer, "features":layer.selectedFeatures()}
        return 

 

#************************************************  

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('CIGeoECircumventPolygon', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """
        

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            #self.iface.addToolBarIcon(action)
            self.toolbar.addAction(action)               #++

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/CIGeoE_Circumvent_Polygon/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'CIGeoE Circumvent Polygon: Changes the line to circumvent a polygon between the intersection points'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&CIGeoE Circumvent Polygon'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        """Run method that performs all the real work"""

        selected_features=[]
        
        #check all selected features in all layers; only advance with exactly 2
        #layers = self.iface.legendInterface().layers()                                 # pyqgis2
        layers = [layer for layer in QgsProject.instance().mapLayers().values()]

        if not layers:
            QMessageBox.information(self.iface.mainWindow(), "Error", 'Layer is not loaded!')
            return 
        
        for layer in layers:
            if(layer.type() == QgsMapLayer.VectorLayer):
                for f in layer.selectedFeatures():
                    selected_features.append( f )
                    
               
        #wont advance if there's more or less than 2 selected features                     
        if(len(selected_features)!=2):
            QMessageBox.information(self.iface.mainWindow(), "Error", 'To execute the circumvent, you must select exactly 1 polygon and 1 line.')
            return

        #check which feature is the first or the second
        feat1full=None
        feat2full=None
        
        #if layers are different, first feature is of map "0" and second is of map "1"
        if self.selectedFeaturesMap["0"]["layer"] != self.selectedFeaturesMap["1"]["layer"]:
            feat1full={"layer" : self.selectedFeaturesMap["0"]["layer"], "feature" : self.selectedFeaturesMap["0"]["features"][0]}
            feat2full={"layer" : self.selectedFeaturesMap["1"]["layer"], "feature" : self.selectedFeaturesMap["1"]["features"][0]}
        else:
            #if is the same layer, an error is raised as there can only be polygons and lines in different layers
            QMessageBox.information(self.iface.mainWindow(), "Error", 'Both features belong to same layer (!!), the plugin cannot execute.')
            return
                        
        feat1=feat1full["feature"]
        feat2=feat2full["feature"]
        
                
        #won't advance if the selected features are both polygons or lines
        #if feat1.geometry().type()==QGis.Polygon:                              # pyqgis 2
            #if feat2.geometry().type()!=QGis.Line:                             # pyqgis 2
        if feat1.geometry().type()== QgsWkbTypes.PolygonGeometry:               
            if feat2.geometry().type()!= QgsWkbTypes.LineGeometry:
                QMessageBox.information(self.iface.mainWindow(), "Error", 'Both selected features are polygons.')
                return  

        #elif feat1.geometry().type()==QGis.Line:                               # pyqgis 2
            #if feat2.geometry().type()!=QGis.Polygon:                          # pyqgis 2
        elif feat1.geometry().type()== QgsWkbTypes.LineGeometry:
            if feat2.geometry().type()!= QgsWkbTypes.PolygonGeometry:
                QMessageBox.information(self.iface.mainWindow(), "Error", 'Both selected features are lines.')
                return
                
        #if first feature is polygon and second is line => ok ; otherwise we change the order
        #if feat2.geometry().type()== QGis.Polygon:                             # pyqgis 2
        if feat2.geometry().type()== QgsWkbTypes.PolygonGeometry:
            feat21full=feat2full
            feat2full=feat1full
            feat1full=feat21full
            feat1=feat1full["feature"]
            feat2=feat2full["feature"]


        #wont advance if both features do not intersect each other
        if (feat1.geometry().intersects(feat2.geometry())==False):
            QMessageBox.information(self.iface.mainWindow(), "Error", "Selected features do not intersect each other.")
            return
        
        #split polygon       
        success, splits, topTestPoints = feat1.geometry().splitGeometry(feat2.geometry().asPolyline(), True)
                          
        #wont advance if invalid split polygon
        if success != 0:
            QMessageBox.information(self.iface.mainWindow(), "Error", "Invalid split polygon.")
            return
       
        #removes the created polygons to the initial polygon    
        featsplit = feat1.geometry()

        for i in range(len(splits)):
            feat3 = featsplit.difference(splits[i]) 
            featsplit = feat3                         
       
        feat1full["layer"].startEditing()

        newFeature=QgsFeature()
        
        newFeature.setGeometry( QgsGeometry(feat3) )
                     

        newFeature.setFields(feat1.fields())
        for field in feat1.fields():
            newFeature.setAttribute(field.name(), feat1[field.name()])

            
        #feat1full["layer"].addFeature(newFeature, True)                    # pyqgis2
        feat1full["layer"].addFeature(newFeature)
        
        feat1full["layer"].deleteFeature(feat1.id()) 

        #feat1full["layer"].setSelectedFeatures( [newFeature.id()] )        # pyqgis2    
        feat1full["layer"].selectByIds( [newFeature.id()] )
        
        feat1full["layer"].triggerRepaint()
        
        
        del self.selectedFeaturesMap["0"]
        del self.selectedFeaturesMap["1"]
        
        #QgsMessageLog.logMessage("Polygon was adjusted to be circumvented by the line", 'CIGeoE Circumvent Polygon')  
        self.iface.messageBar().pushMessage("CIGeoE Circumvent Polygon", "Polygon was adjusted to be circumvented by the line." , level=Qgis.Info, duration=2)

