# -*- coding: utf-8 -*-

"""
/***************************************************************************
 ChangeNODATA
                                 A QGIS plugin
 This plugin allows you to quickly and efficiently change the NODATA value of rasters.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-09-16
        copyright            : (C) 2025 by Antonio Sobral Almeida
        email                : sobral.almeida@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Antonio Sobral Almeida'
__date__ = '2025-09-16'
__copyright__ = '(C) 2025 by Antonio Sobral Almeida'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'


from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterRasterLayer
from qgis.core import QgsProcessingParameterCrs
from qgis.core import QgsProcessingParameterNumber
from qgis.core import QgsProcessingParameterRasterDestination
from qgis.core import QgsProcessingOutputLayerDefinition
import processing


class ChangeNODATAAlgorithm(QgsProcessingAlgorithm):

    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterRasterLayer('input_raster', 'Input raster', defaultValue=None))
        self.addParameter(QgsProcessingParameterNumber('new_nodata_value', 'New NODATA value', type=QgsProcessingParameterNumber.Integer, defaultValue=-9999))
        self.addParameter(QgsProcessingParameterRasterDestination('New_nodata_raster', 'New_NODATA_raster', createByDefault=True, defaultValue=None))

    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(1, model_feedback)
        results = {}
        outputs = {}

        # Translate (convert format)
        alg_params = {
            'COPY_SUBDATASETS': False,
            'DATA_TYPE': 0,  # Use Input Layer Data Type
            'EXTRA': '',
            'INPUT': parameters['input_raster'],
            'NODATA': parameters['new_nodata_value'],
            'OPTIONS': None,
            'OUTPUT': parameters['New_nodata_raster']
        }
        parameters['New_nodata_raster'].destinationName = 'New NODATA raster'
        outputs['TranslateConvertFormat'] = processing.run('gdal:translate', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['New_nodata_raster'] = outputs['TranslateConvertFormat']['OUTPUT']
        return results

    def name(self):
        return 'ChangeNODATAPlugin'

    def displayName(self):
        return 'Change NODATA Plugin'

    def group(self):
        return 'Modify Rasters'

    def groupId(self):
        return

    def createInstance(self):
        return ChangeNODATAAlgorithm()
