# -*- coding: utf-8 -*-

"""
/***************************************************************************
 CGL_tools
                                 A QGIS plugin
 This plugin allows to download easily the Copernicus Global Land products (Land Cover, NDVI, FAPAR, ...).
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-01-02
        copyright            : (C) 2021 by Federico Gianoli
        email                : gianoli.federico@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Federico Gianoli'
__date__ = '2021-01-02'
__copyright__ = '(C) 2021 by Federico Gianoli'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (QgsProcessing,
                       QgsFeatureSink,
                       QgsProcessingException,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterFeatureSink,
                       QgsApplication)
from qgis import processing
import os
import sys
import urllib.request
from qgis.core import QgsProcessingParameterFile
from qgis.core import QgsProcessingParameterEnum
from qgis.core import QgsProcessingParameterString


class LandCoverDownload(QgsProcessingAlgorithm):


    def tr(self, string):
        """
        Returns a translatable string with the self.tr() function.
        """
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return LandCoverDownload()

    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'copernicuslandcover'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr('Copernicus Land Cover Downloader')

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr('Copernicus Products Downloader')

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'Copernicus Products Downloader'

    def shortHelpString(self):
        """
        Returns a localised short helper string for the algorithm. This string
        should provide a basic description about what the algorithm does and the
        parameters and outputs associated with it..
        """
        return self.tr("""This tool allows to download the Copernicus Land Cover. <br>"""
                       """<b>Product:</b> it is possible to select the Land Cover product to download. If the choosen product is 'None', al the products will be downloaded. <br>""" \
                       """<b>Year:</b> allows to select the year of reference for the Land Cover. If the choosen year is 'None', all the years will be downloaded. <br>""" \
                       """<b>Tile:</b> it is possible to select a specif Tile to download. <br>To choose the tile <a href="https://github.com/fgianoli/CopernicusGlobalLand/blob/master/img/tile.jpg?raw=true">Click here</a>, if the Tile is set to 'None', all the tiles will be downloaded""")


    def initAlgorithm(self, config=None):
        self.services = [None, 'Bare-CoverFraction-layer', 'BuiltUp-CoverFraction-layer', 'Crops-CoverFraction-layer',
                         'DataDensityIndicator', 'Discrete-Classification-map', 'Discrete-Classification-proba',
                         'Forest-Type-layer', 'Grass-CoverFraction-layer', 'MossLichen-CoverFraction-layer',
                         'PermanentWater-CoverFraction-layer', 'SeasonalWater-CoverFraction-layer',
                         'Shrub-CoverFraction-layer', 'Snow-CoverFraction-layer', 'Tree-CoverFraction-layer']
        self.yearlist = ['2015', '2016', '2017', '2018', '2019', None]

        self.addParameter(QgsProcessingParameterEnum('prodotto', 'Product', options=self.services, defaultValue=None))
        self.addParameter(QgsProcessingParameterEnum('anno', 'Year', options=self.yearlist, defaultValue=None))
        # self.addParameter(QgsProcessingParameterString('anno', 'Year', defaultValue=None)
        self.addParameter(QgsProcessingParameterString('nome_tile', 'Tile Name', defaultValue=None, optional=True))
        # self.addParameter(QgsProcessingParameterString('prodotto', 'prodotto', defaultValue='Bare-CoverFraction-layer'))
        self.addParameter(QgsProcessingParameterFile('Download directory', 'Download directory',
                                                     behavior=QgsProcessingParameterFile.Folder, optional=False,
                                                     defaultValue=None))

        self.plugin_dir = os.path.dirname(__file__)

    def search_Data(self, anno=None, nome_tile=None, prodotto=None):

        # list_file = 'C:\\Users\\giano\\AppData\\Roaming\\QGIS\\QGIS3\\profiles\\copernicus\\processing\\scripts\\list2.txt'
        # read list of files
        list_file=os.path.join(self.plugin_dir, 'list2.txt')
        f = open(list_file, 'r')
        #f = open(os.path.join(self.parent_module.plugin_dir,'list2.txt'), 'r')
        data = f.readlines()
        files = [f.rstrip() for f in data]
        f.close()

        base_URL = 'https://s3-eu-west-1.amazonaws.com/vito.landcover.global/v3.0.1/'

        urls = []

        for file in files:
            filename = file.split('/')[2]
            year = file.split('/')[0]
            tile = file.split('/')[1]
            if prodotto and prodotto in file:
                if anno and anno in file:
                    if nome_tile and nome_tile in file:
                        urls.append(base_URL + year + '/' + tile + '/' + filename)
                    if not nome_tile:
                        urls.append(base_URL + year + '/' + tile + '/' + filename)
                if not anno:
                    if nome_tile and nome_tile in file:
                        urls.append(base_URL + year + '/' + tile + '/' + filename)
                    if not nome_tile:
                        urls.append(base_URL + year + '/' + tile + '/' + filename)
            if not prodotto:
                if anno and anno in file:
                    if nome_tile and nome_tile in file:
                        urls.append(base_URL + year + '/' + tile + '/' + filename)
                    if not nome_tile:
                        urls.append(base_URL + year + '/' + tile + '/' + filename)
                if not anno:
                    if nome_tile and nome_tile in file:
                        urls.append(base_URL + year + '/' + tile + '/' + filename)
                    if not nome_tile:
                        urls.append(base_URL + year + '/' + tile + '/' + filename)

        # for u in urls:
        # print(u)

        return urls

    def processAlgorithm(self, parameters, context, feedback):
        anno = self.yearlist[parameters['anno']]
        # nome_tile = self.parameterAsString(parameters, 'nome_tile', context)
        nome_tile = parameters['nome_tile']
        prodotto = self.services[parameters['prodotto']]

        url_to_download_list = self.search_Data(anno=anno, nome_tile=nome_tile, prodotto=prodotto)

        for d in url_to_download_list:
            # output = self.parameterAsFile(parameters,'Download directory',context) + os.path.basename(d)
            output = parameters['Download directory'] + '/' + os.path.basename(d)
            alg_params = {
                "URL": d,
                "OUTPUT": output
            }
            output= processing.run('native:filedownloader', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
            feedback.pushInfo(os.path.basename(d))
            if feedback.isCanceled():
                feedback.pushInfo("Terminated by user")
                return {}

        return {}