# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CensusDownloaderDialog
                                 A QGIS plugin
 Downloads Census Data
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2024-08-06
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Amer Islam
        email                : aislam@ccrpc.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import pandas as pd
import geopandas as gpd
import requests
from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtWidgets import QMessageBox, QTableWidgetItem
from PyQt5.QtWidgets import QInputDialog, QTableWidget
from qgis.core import QgsVectorLayer, QgsProject

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'census_downloader_dialog_base.ui'))


class CensusDownloaderDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(CensusDownloaderDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        self.check_and_set_api_key()
        self.filter_comboboxes()
        self.progressBar.reset()
        self.cb_dataset.currentTextChanged.connect(self.filter_comboboxes)
        self.cb_dataset.currentTextChanged.connect(self.clear_variable)
        self.cb_dataset.currentTextChanged.connect(self.clear_variable_group)
        self.cb_table.currentTextChanged.connect(self.filter_comboboxes)
        self.cb_table.currentTextChanged.connect(self.clear_variable_group)
        self.cb_geography.currentTextChanged.connect(self.filter_comboboxes)
        self.cb_geography.currentTextChanged.connect(self.clear_variable)
        self.cb_predefined.currentTextChanged.connect(self.filter_comboboxes)
        self.cb_predefined.currentTextChanged.connect(self.clear_variable_group)
        self.cb_county.currentTextChanged.connect(self.filter_comboboxes)
        self.cb_county.currentTextChanged.connect(self.clear_variable)
        self.cb_year.currentTextChanged.connect(self.filter_comboboxes)
        self.cb_year.currentTextChanged.connect(self.clear_variable)
        self.cb_year.currentTextChanged.connect(self.clear_variable_group)
        self.pb_variables.clicked.connect(self.census_group_call)
        self.pb_selection.clicked.connect(self.add_to_variable_table)
        self.pb_remove.clicked.connect(self.remove_from_variable_table)
        self.pb_query.clicked.connect(self.execute_query)

    # Check if census api key is an environment variable, if it is prompt user to input it
    # otherwise set the existing api key to census_key
    def check_and_set_api_key(self):
        self.census_key_dir = os.path.dirname(__file__)
        locale_path = os.path.join(self.census_key_dir, '.env')
        if os.path.exists(locale_path) is False:
            title = "Enter Census Key"
            message = "Please enter your Census API Key:"
            key = QInputDialog.getText(None, title, message)
            with open(locale_path, 'w') as file:
                file.write(key[0])
        else:
            with open(locale_path, 'r') as file:
                return file.read()

    #This first filter method makes sure that the combo boxes have valid combinations
    def filter_comboboxes(self):

        allowed_tables = {
            "ACS5": ["Detailed Tables", "Subject Tables", "Data Profile"],
            "ACS1": ["Detailed Tables", "Subject Tables", "Data Profile"],
            "Decennial": ["Demographic and Housing Characteristics File", 'Demographic Profile']
        }

        allowed_geography = {
            ("ACS5", "Detailed Tables"): ['ZCTA','Census Tract','Subdivision (Township)','Urban Areas','Metropolitan Statistical Area','Designated & Incorporated Place','School District (elementary)','School District (secondary)', 'School District (unified)','Block Group'],
            ("ACS5", "Subject Tables"): ['ZCTA','Census Tract','Subdivision (Township)','Urban Areas','Metropolitan Statistical Area','Designated & Incorporated Place','School District (elementary)','School District (secondary)', 'School District (unified)'],
            ("ACS5", "Data Profile"): ['ZCTA','Census Tract','Subdivision (Township)','Urban Areas','Metropolitan Statistical Area','Designated & Incorporated Place','School District (elementary)','School District (secondary)', 'School District (unified)'],
            ("ACS1", "Detailed Tables"): ['Subdivision (Township)','Urban Areas','Metropolitan Statistical Area','Designated & Incorporated Place','School District (elementary)','School District (secondary)', 'School District (unified)'],
            ("ACS1", "Subject Tables"): ['Subdivision (Township)','Urban Areas','Metropolitan Statistical Area','Designated & Incorporated Place','School District (elementary)','School District (secondary)', 'School District (unified)'],
            ("ACS1", "Data Profile"): ['Subdivision (Township)','Urban Areas','Metropolitan Statistical Area','Designated & Incorporated Place','School District (elementary)','School District (secondary)', 'School District (unified)'],
            ("Decennial", "Demographic and Housing Characteristics File"): ['ZCTA','Census Tract','Subdivision (Township)','Urban Areas','Metropolitan Statistical Area','Designated & Incorporated Place','School District (elementary)','School District (secondary)', 'School District (unified)','Block Group'],
            ("Decennial", 'Demographic Profile'): ['ZCTA','Census Tract','Subdivision (Township)','Metropolitan Statistical Area','Designated & Incorporated Place','School District (elementary)','School District (secondary)', 'School District (unified)']
        }

        allowed_counties = {
            'Census Tract': [
                'Champaign, IL',
                'Clark, IL',
                'Coles, IL',
                'Cumberland, IL',
                'De Witt, IL',
                'Douglas, IL',
                'Edgar, IL',
                'Macon, IL',
                'Moultrie, IL',
                'Piatt, IL',
                'Shelby, IL',
                'Vermilion, IL',
                'Ford, IL',
                'Iroquois, IL'
            ],
            'Subdivision (Township)': [
                'Champaign, IL',
                'Clark, IL',
                'Coles, IL',
                'Cumberland, IL',
                'De Witt, IL',
                'Douglas, IL',
                'Edgar, IL',
                'Macon, IL',
                'Moultrie, IL',
                'Piatt, IL',
                'Shelby, IL',
                'Vermilion, IL',
                'Ford, IL',
                'Iroquois, IL'
            ],
            'Urban Areas': [
                'Champaign, IL',
                'Coles, IL',
                'De Witt, IL',
                'Douglas, IL',
                'Edgar, IL',
                'Macon, IL',
                'Moultrie, IL',
                'Piatt, IL',
                'Shelby, IL',
                'Vermilion, IL',
                'Ford, IL',
                'Iroquois, IL'
            ],
            'Metropolitan Statistical Area': ['Champaign, IL','Macon, IL'],
            'Designated & Incorporated Place': [
                'Champaign, IL',
                'Clark, IL',
                'Coles, IL',
                'Cumberland, IL',
                'De Witt, IL',
                'Douglas, IL',
                'Edgar, IL',
                'Macon, IL',
                'Moultrie, IL',
                'Piatt, IL',
                'Shelby, IL',
                'Vermilion, IL',
                'Ford, IL',
                'Iroquois, IL'
            ],
            'School District (elementary)':[
                'Champaign, IL',
                'De Witt, IL',
                'Vermilion, IL',
                'Iroquois, IL'
            ],
            'School District (secondary)':[
                'Champaign, IL',
                'De Witt, IL',
                'Vermilion, IL',
                'Iroquois, IL'
            ],
            'School District (unified)':[
                'Champaign, IL',
                'Clark, IL',
                'Coles, IL',
                'Cumberland, IL',
                'De Witt, IL',
                'Douglas, IL',
                'Edgar, IL',
                'Macon, IL',
                'Moultrie, IL',
                'Piatt, IL',
                'Shelby, IL',
                'Vermilion, IL',
                'Ford, IL',
                'Iroquois, IL'
            ],
            'ZCTA':[
                'Champaign, IL',
                'Clark, IL',
                'Coles, IL',
                'Cumberland, IL',
                'De Witt, IL',
                'Douglas, IL',
                'Edgar, IL',
                'Macon, IL',
                'Moultrie, IL',
                'Piatt, IL',
                'Shelby, IL',
                'Vermilion, IL',
                'Ford, IL',
                'Iroquois, IL'
            ],
            'Block Group':[
                'Champaign, IL',
                'Clark, IL',
                'Coles, IL',
                'Cumberland, IL',
                'De Witt, IL',
                'Douglas, IL',
                'Edgar, IL',
                'Macon, IL',
                'Moultrie, IL',
                'Piatt, IL',
                'Shelby, IL',
                'Vermilion, IL',
                'Ford, IL',
                'Iroquois, IL'
            ]
        }

        allowed_predefined = {
            ("ACS5", "Detailed Tables"): ["Sex By Age","Race","Hispanic or Latino Origin","Receipt of Food Stamps/SNAP in the Past 12 Months by Disability Status for Households","Poverty Status of Individuals in the Past 12 Months by Living Arrangement","Means of Transportation to Work","Travel Time to Work","Age by Language Spoken at Home by Ability to Speak English for the Population 5 Years and Over","Tenure by Vehicles Available", "Language Spoken at Home by Ability to Speak English for the Population 5 Years and Over"],
            ("ACS5", "Subject Tables"): ["Age and Sex","Household and Families"],
            ("ACS5", "Data Profile"): ["Selected Social Characteristics in the United States","Selected Economic Characteristics","Selected Housing Characteristics"],
            ('ACS1', "Detailed Tables"): ["Sex By Age","Race","Hispanic or Latino Origin","Receipt of Food Stamps/SNAP in the Past 12 Months by Disability Status for Households","Poverty Status of Individuals in the Past 12 Months by Living Arrangement","Means of Transportation to Work","Travel Time to Work","Age by Language Spoken at Home by Ability to Speak English for the Population 5 Years and Over","Tenure by Vehicles Available", "Language Spoken at Home by Ability to Speak English for the Population 5 Years and Over"],
            ('ACS1', "Subject Tables"): ["Age and Sex","Household and Families"],
            ('ACS1', "Data Profile"): ["Selected Social Characteristics in the United States","Selected Economic Characteristics","Selected Housing Characteristics"],
            ("Decennial", "Demographic and Housing Characteristics File"): ["Sex by Age for Selected Age Categories"],
            ("Decennial", 'Demographic Profile'): ["Profile of General Population and Housing Characteristics"]
        }
        #Then nested dictionary structure here is easier to read and the rest of the dictionaries should be changed to reflect this
        #Range is not inclusive of the last value so 2022 is the highest year being returned despite the upper end being 2023
        # Could clean up the dictionary by making the range int oa predefined list, but ti would make editing years harder from a glance
        allowed_years = {
            "ACS5": {
                "Detailed Tables": {
                    "ZCTA": list(map(str, range(2011, 2025))),
                    "Block Group": list(map(str, range(2013, 2025))),
                    "Census Tract": list(map(str, range(2009, 2025))),
                    "Subdivision (Township)": list(map(str, range(2009, 2025))),
                    'Urban Areas': list(map(str, range(2009, 2011))) + list(map(str, range(2012, 2025))),
                    'Metropolitan Statistical Area': list(map(str, range(2009, 2022))) + list(map(str, range(2023, 2025))),
                    'Designated & Incorporated Place': list(map(str, range(2009, 2025))),
                    'School District (elementary)': list(map(str, range(2009, 2025))),
                    'School District (secondary)': list(map(str, range(2009, 2025))),
                    'School District (unified)': list(map(str, range(2009, 2025))),
                },
                "Subject Tables": {
                    "ZCTA": list(map(str, range(2011, 2025))),
                    "Census Tract": list(map(str, range(2010, 2025))),
                    "Subdivision (Township)": list(map(str, range(2010, 2025))),
                    'Urban Areas': list(map(str, range(2009, 2011))) + list(map(str, range(2012, 2025))),
                    'Metropolitan Statistical Area': list(map(str, range(2010, 2022))) + list(map(str, range(2023, 2025))),
                    'Designated & Incorporated Place': list(map(str, range(2010, 2025))),
                    'School District (elementary)': list(map(str, range(2010, 2025))),
                    'School District (secondary)': list(map(str, range(2010, 2025))),
                    'School District (unified)': list(map(str, range(2010, 2025))),
                },
                "Data Profile": {
                    "ZCTA": list(map(str, range(2011, 2025))),
                    "Census Tract": list(map(str, range(2010, 2025))),
                    "Subdivision (Township)": list(map(str, range(2010, 2025))),
                    'Urban Areas': list(map(str, range(2010, 2011))) + list(map(str, range(2012, 2025))),
                    'Metropolitan Statistical Area': list(map(str, range(2010, 2022))) + list(map(str, range(2023, 2025))),
                    'Designated & Incorporated Place': list(map(str, range(2010, 2025))),
                    'School District (elementary)': list(map(str, range(2010, 2025))),
                    'School District (secondary)': list(map(str, range(2010, 2025))),
                    'School District (unified)': list(map(str, range(2010, 2025))),
                },
            },
            "ACS1":{
                "Detailed Tables": {
                    "Subdivision (Township)": list(map(str, range(2014, 2020))) + list(map(str, range(2021, 2025))),
                    'Urban Areas': list(map(str, range(2014, 2020))) + list(map(str, range(2021, 2025))),
                    'Metropolitan Statistical Area': list(map(str, range(2014, 2020))) + list(map(str, range(2021, 2022))) + list(map(str, range(2023, 2025))),
                    'Designated & Incorporated Place': list(map(str, range(2014, 2020))) + list(map(str, range(2021, 2025))),
                    'School District (elementary)': list(map(str, range(2014, 2020))) + list(map(str, range(2021, 2025))),
                    'School District (secondary)': list(map(str, range(2014, 2020))) + list(map(str, range(2021, 2025))),
                    'School District (unified)': list(map(str, range(2014, 2020))) + list(map(str, range(2021, 2025))),
                },
                "Subject Tables": {
                    "Subdivision (Township)": list(map(str, range(2014, 2020))) + list(map(str, range(2021, 2025))),
                    'Urban Areas': list(map(str, range(2014, 2020))) + list(map(str, range(2021, 2025))),
                    'Metropolitan Statistical Area': list(map(str, range(2014, 2020))) + list(map(str, range(2021, 2022))) + list(map(str, range(2023, 2025))),
                    'Designated & Incorporated Place': list(map(str, range(2014, 2020))) + list(map(str, range(2021, 2025))),
                    'School District (elementary)': list(map(str, range(2014, 2020))) + list(map(str, range(2021, 2025))),
                    'School District (secondary)': list(map(str, range(2014, 2020))) + list(map(str, range(2021, 2025))),
                    'School District (unified)': list(map(str, range(2014, 2020))) + list(map(str, range(2021, 2025))),
                },
                "Data Profile": {
                    "Subdivision (Township)": list(map(str, range(2014, 2020))) + list(map(str, range(2021, 2025))),
                    'Urban Areas': list(map(str, range(2014, 2020))) + list(map(str, range(2021, 2025))),
                    'Metropolitan Statistical Area': list(map(str, range(2014, 2020))) + list(map(str, range(2021, 2022))) + list(map(str, range(2023, 2025))),
                    'Designated & Incorporated Place': list(map(str, range(2014, 2020))) + list(map(str, range(2021, 2025))),
                    'School District (elementary)': list(map(str, range(2014, 2020))) + list(map(str, range(2021, 2025))),
                    'School District (secondary)': list(map(str, range(2014, 2020))) + list(map(str, range(2021, 2025))),
                    'School District (unified)': list(map(str, range(2014, 2020))) + list(map(str, range(2021, 2025))),
                },
            },
            "Decennial": {
                "Demographic and Housing Characteristics File": {
                    "ZCTA": "2020",
                    "Block Group": "2020",
                    "Census Tract": "2020",
                    "Subdivision (Township)": "2020",
                    'Urban Areas': "2020",
                    'Metropolitan Statistical Area': "2020",
                    'Designated & Incorporated Place': "2020",
                    'School District (elementary)': "2020",
                    'School District (secondary)': "2020",
                    'School District (unified)': "2020",
                },
                'Demographic Profile': {
                    "ZCTA": "2020",
                    "Census Tract": "2020",
                    "Subdivision (Township)": "2020",
                    'Metropolitan Statistical Area': "2020",
                    'Designated & Incorporated Place': "2020",
                    'School District (elementary)': "2020",
                    'School District (secondary)': "2020",
                    'School District (unified)': "2020",
                },
            }
        }

        #Below is a lot of forloops and if statements, These should be condensed into different methods but for the time being I'm leaving them as is
        selected_year = self.cb_year.currentText()
        selected_dataset = self.cb_dataset.currentText()
        selected_table = self.cb_table.currentText()
        selected_geography = self.cb_geography.currentText()
        selected_group = self.cb_predefined.currentText()
        selected_county = self.cb_county.currentText()

        #Disable options in the drop down that are not in the allowed dictionaries listed above.
        for i in range(self.cb_table.count()):
            table_name = self.cb_table.itemText(i)
            if table_name in allowed_tables[selected_dataset]:
                self.cb_table.model().item(i).setEnabled(True)
            else:
                self.cb_table.model().item(i).setEnabled(False)
        #The above loops disabled the drop downs but did not assign a new selection. This loop detects if the current table is valid. If it isn't then it loops through the dropdown entires
        #until it finds a valid one.
        if selected_table not in allowed_tables[selected_dataset]:
            for i in range(self.cb_table.count()):
                if self.cb_table.itemText(i) in allowed_tables[selected_dataset]:
                    self.cb_table.setCurrentIndex(i)
                    selected_table = self.cb_table.currentText() #make sure to update the current selection after changing it
        #Disable invalid options based on previous selections
        for i in range(self.cb_geography.count()):
            geography_name = self.cb_geography.itemText(i)
            if geography_name in allowed_geography[selected_dataset, selected_table]:
                self.cb_geography.model().item(i).setEnabled(True)
            else:
                self.cb_geography.model().item(i).setEnabled(False)
        #Update selection to a valid one
        if selected_geography not in allowed_geography[selected_dataset, selected_table]:
            for i in range(self.cb_geography.count()):
                if self.cb_geography.itemText(i) in allowed_geography[selected_dataset, selected_table]:
                    self.cb_geography.setCurrentIndex(i)
                    selected_geography = self.cb_geography.currentText()
        #Disable invalid options based on previous selections
        for i in range(self.cb_county.count()):
            county_name = self.cb_county.itemText(i)
            if county_name in allowed_counties[selected_geography]:
                self.cb_county.model().item(i).setEnabled(True)
            else:
                self.cb_county.model().item(i).setEnabled(False)
        #Update selection to a valid one
        if selected_county not in allowed_counties[selected_geography]:
            for i in range(self.cb_county.count()):
                if self.cb_county.itemText(i) in allowed_counties[selected_geography]:
                    self.cb_county.setCurrentIndex(i)
                    selected_county = self.cb_county.currentText()
        #Disable invalid options based on previous selections
        for i in range(self.cb_predefined.count()):
            group_name = self.cb_predefined.itemText(i)
            if group_name in allowed_predefined[selected_dataset, selected_table]:
                self.cb_predefined.model().item(i).setEnabled(True)
            else:
                self.cb_predefined.model().item(i).setEnabled(False)
        #Update selection to a valid one
        if selected_group not in allowed_predefined[selected_dataset, selected_table]:
            for i in range(self.cb_predefined.count()):
                if self.cb_predefined.itemText(i) in allowed_predefined[selected_dataset, selected_table]:
                    self.cb_predefined.setCurrentIndex(i)
                    selected_group = self.cb_predefined.currentText()
        #Disable invalid options based on previous selections
        for i in range(self.cb_year.count()):
            year = self.cb_year.itemText(i)
            if year in allowed_years[selected_dataset][selected_table][selected_geography]:
                self.cb_year.model().item(i).setEnabled(True)
            else:
                self.cb_year.model().item(i).setEnabled(False)
        #Update selection to a valid one
        if selected_year not in allowed_years[selected_dataset][selected_table][selected_geography]:
            for i in range(self.cb_year.count()):
                if self.cb_year.itemText(i) in allowed_years[selected_dataset][selected_table][selected_geography]:
                    self.cb_year.setCurrentIndex(i)
                    selected_year = self.cb_year.currentText()

    def write_df_to_qtable(self,df,table):
            headers = list(df)
            table.setRowCount(df.shape[0])
            table.setColumnCount(df.shape[1])
            table.setHorizontalHeaderLabels(headers)

            df_array = df.values
            for row in range(df.shape[0]):
                for col in range(df.shape[1]):
                    table.setItem(row, col, QTableWidgetItem(str(df_array[row,col])))

    def qtablewidget_to_dataframe(self, qtw):
        num_cols = qtw.columnCount()
        num_rows = qtw.rowCount()
        data = []
        for row in range(num_rows):
            row_data = []
            for col in range(num_cols):
                item = qtw.item(row, col)
                if item:
                    row_data.append(str(item.text()))
                else:
                    row_data.append('')
            data.append(row_data)

        df = pd.DataFrame(data, columns=['Variables','Labels','Table'])
        return df

    def census_group_call(self):
        selected_year = self.cb_year.currentText()
        selected_dataset = self.cb_dataset.currentText()
        selected_table = self.cb_table.currentText()
        selected_geography = self.cb_geography.currentText()
        selected_group = self.cb_predefined.currentText()
        selected_county = self.cb_county.currentText()
        census_key = self.check_and_set_api_key()

        dataset = {
            "ACS5": "acs/acs5",
            "ACS1": "acs/acs1",
            "Decennial": "dec",
        }

        table = {
            "Detailed Tables": "",
            "Subject Tables": "/subject",
            "Data Profile": "/profile",
            "Demographic and Housing Characteristics File": "/dhc",
            "Demographic Profile": "/dp",
        }

        predefined_groups = {
            "Sex By Age": "B01001",
            "Race": "B02001",
            "Hispanic or Latino Origin": "B03003",
            "Receipt of Food Stamps/SNAP in the Past 12 Months by Disability Status for Households": "B22010",
            "Poverty Status of Individuals in the Past 12 Months by Living Arrangement": "B17021",
            "Means of Transportation to Work": "B08301",
            "Travel Time to Work": "B08303",
            "Age by Language Spoken at Home by Ability to Speak English for the Population 5 Years and Over": "B16004",
            "Tenure by Vehicles Available": "B25044",
            "Age and Sex": "S0101",
            "Household and Families": "S1101",
            "Selected Social Characteristics in the United States": "DP02",
            "Selected Economic Characteristics": "DP03",
            "Selected Housing Characteristics": "DP04",
            "Sex by Age for Selected Age Categories": "P12",
            "Profile of General Population and Housing Characteristics": "DP1",
        }

        self.census_url = f'https://api.census.gov/data/{selected_year}/{dataset[selected_dataset]}{table[selected_table]}/variables.json'
        print(f"Census Variable Url: {self.census_url}")
        self.data = requests.get(self.census_url)
        self.data = self.data.json()

        keys = list(self.data['variables'].keys())
        labels = [item['label'] for item in self.data['variables'].values()]

        keys = [key for key, value in self.data['variables'].items() if value.get('group') == predefined_groups[selected_group]]
        labels = [value['label'] for key, value in self.data['variables'].items() if value.get('group') == predefined_groups[selected_group]]

        self.df = pd.DataFrame({'Variables': keys, 'Labels': labels, 'Table': selected_table})
        self.df = self.df.sort_values('Variables', ascending=True)


        self.write_df_to_qtable(self.df, self.tw_census_view)
        self.tw_census_view.setSelectionBehavior(QTableWidget.SelectRows)

    def execute_query(self):
        variable_df = self.qtablewidget_to_dataframe(self.tw_selected_variables)

        if self.cb_groupcall.isChecked() is False and self.tw_selected_variables.rowCount() == 0:
            QMessageBox.warning(self,"Group Call or Manual","Make sure either group call is selected or variables have been inputted into the Text Box")
        elif self.cb_mpa.isChecked() is True and self.cb_county.currentText() != 'Champaign, IL':
            QMessageBox.warning(self,"MPA","MPA can only be selected for Champaign County")
        elif variable_df['Labels'].duplicated().any():
            QMessageBox.warning(self,"DUPLICATE LABELS","Cannot Have Duplicate Label names")
        else:
            self.update_url()

    def update_url(self):
        census_key = self.check_and_set_api_key()
        selected_year = self.cb_year.currentText()
        selected_dataset = self.cb_dataset.currentText()
        selected_table = self.cb_table.currentText()
        selected_geography = self.cb_geography.currentText()
        selected_group = self.cb_predefined.currentText()
        selected_county = self.cb_county.currentText()

        tiger_dataset = {
            "2014": "ACS",
            "2015": "ACS",
            "2016": "ACS",
            "2017": "ACS",
            "2018": "ACS",
            "2019": "ACS",
            "2020": "CENSUS",
            "2021": "ACS",
            "2022": "ACS",
            "2023": "ACS",
        }
        county_code = {
            'Champaign, IL': '019',
            'Clark, IL': '023',
            'Coles, IL': '029',
            'Cumberland, IL': '035',
            'De Witt, IL': '039',
            'Douglas, IL': '041',
            'Edgar, IL': '045',
            'Macon, IL': '115',
            'Moultrie, IL': '139',
            'Piatt, IL': '147',
            'Shelby, IL': '173',
            'Vermilion, IL': '183',
            'Ford, IL': '053',
            'Iroquois, IL': '075'
        }

        bounding_area='-89.2347,+39.1056,-87.4688,+41.0453'

        centroid = {
            'Champaign, IL':'-88.1908,+40.1891',
            'Macon, IL':'-88.9530,+39.8355'
        }

        query = {
            '2014': {
                'Census Tract': f"ACS2014/MapServer/8/query?where=STATE='17'+AND+COUNTY='{county_code[selected_county]}'&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson",
                'Subdivision (Township)': f"ACS2014/MapServer/20/query?where=STATE='17'+AND+COUNTY='{county_code[selected_county]}'&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson",
                'Urban Areas' :{
                    'Areas': f'ACS2014/MapServer/62/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                    'Clusters': f'ACS2014/MapServer/64/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson'
                },
                'Metropolitan Statistical Area': f'ACS2014/MapServer/78/query?timeRelation=esriTimeRelationOverlaps&geometry={centroid[selected_county]}&geometryType=esriGeometryPoint&inSR=4326&spatialRel=esriSpatialRelIntersects&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'Designated & Incorporated Place' :{
                    'Designated': f'ACS2014/MapServer/28/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                    'Incorporated': f'ACS2014/MapServer/26/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson'
                },
                'School District (elementary)': f'ACS2014/MapServer/16/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'School District (secondary)': f'ACS2014/MapServer/14/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'School District (unified)': f'ACS2014/MapServer/12/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'ZCTA': f'ACS2014/MapServer/2/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'Block Group': f"ACS2014/MapServer/10/query?where=STATE='17'+AND+COUNTY='{county_code[selected_county]}'&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson",
            },
            '2015': {
                'Census Tract': f"ACS2015/MapServer/8/query?where=STATE='17'+AND+COUNTY='{county_code[selected_county]}'&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson",
                'Subdivision (Township)': f"ACS2015/MapServer/20/query?where=STATE='17'+AND+COUNTY='{county_code[selected_county]}'&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson",
                'Urban Areas' :{
                    'Areas': f'ACS2015/MapServer/62/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                    'Clusters': f'ACS2015/MapServer/64/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson'
                },
                'Metropolitan Statistical Area': f'ACS2015/MapServer/78/query?timeRelation=esriTimeRelationOverlaps&geometry={centroid[selected_county]}&geometryType=esriGeometryPoint&inSR=4326&spatialRel=esriSpatialRelIntersects&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'Designated & Incorporated Place' :{
                    'Designated': f'ACS2015/MapServer/28/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                    'Incorporated': f'ACS2015/MapServer/26/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson'
                },
                'School District (elementary)': f'ACS2015/MapServer/16/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'School District (secondary)': f'ACS2015/MapServer/14/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'School District (unified)': f'ACS2015/MapServer/12/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'ZCTA': f'ACS2015/MapServer/2/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'Block Group': f"ACS2015/MapServer/10/query?where=STATE='17'+AND+COUNTY='{county_code[selected_county]}'&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson",
            },
            '2016': {
                'Census Tract': f"ACS2016/MapServer/8/query?where=STATE='17'+AND+COUNTY='{county_code[selected_county]}'&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson",
                'Subdivision (Township)': f"ACS2016/MapServer/20/query?where=STATE='17'+AND+COUNTY='{county_code[selected_county]}'&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson",
                'Urban Areas' :{
                    'Areas': f'ACS2016/MapServer/62/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                    'Clusters': f'ACS2016/MapServer/64/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson'
                },
                'Metropolitan Statistical Area': f'ACS2016/MapServer/78/query?timeRelation=esriTimeRelationOverlaps&geometry={centroid[selected_county]}&geometryType=esriGeometryPoint&inSR=4326&spatialRel=esriSpatialRelIntersects&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'Designated & Incorporated Place' :{
                    'Designated': f'ACS2016/MapServer/28/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                    'Incorporated': f'ACS2016/MapServer/26/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson'
                },
                'School District (elementary)': f'ACS2016/MapServer/16/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'School District (secondary)': f'ACS2016/MapServer/14/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'School District (unified)': f'ACS2016/MapServer/12/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'ZCTA': f'ACS2016/MapServer/2/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'Block Group': f"ACS2016/MapServer/10/query?where=STATE='17'+AND+COUNTY='{county_code[selected_county]}'&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson",
            },
            '2017': {
                'Census Tract': f"ACS2017/MapServer/8/query?where=STATE='17'+AND+COUNTY='{county_code[selected_county]}'&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson",
                'Subdivision (Township)': f"ACS2017/MapServer/20/query?where=STATE='17'+AND+COUNTY='{county_code[selected_county]}'&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson",
                'Urban Areas' :{
                    'Areas': f'ACS2017/MapServer/62/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                    'Clusters': f'ACS2017/MapServer/64/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson'
                },
                'Metropolitan Statistical Area': f'ACS2017/MapServer/78/query?timeRelation=esriTimeRelationOverlaps&geometry={centroid[selected_county]}&geometryType=esriGeometryPoint&inSR=4326&spatialRel=esriSpatialRelIntersects&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'Designated & Incorporated Place' :{
                    'Designated': f'ACS2017/MapServer/28/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                    'Incorporated': f'ACS2017/MapServer/26/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson'
                },
                'School District (elementary)': f'ACS2017/MapServer/16/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'School District (secondary)': f'ACS2017/MapServer/14/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'School District (unified)': f'ACS2017/MapServer/12/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'ZCTA': f'ACS2017/MapServer/2/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'Block Group': f"ACS2017/MapServer/10/query?where=STATE='17'+AND+COUNTY='{county_code[selected_county]}'&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson",
            },
            '2018': {
                'Census Tract': f"ACS2018/MapServer/8/query?where=STATE='17'+AND+COUNTY='{county_code[selected_county]}'&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson",
                'Subdivision (Township)': f"ACS2018/MapServer/20/query?where=STATE='17'+AND+COUNTY='{county_code[selected_county]}'&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson",
                'Urban Areas' :{
                    'Areas': f'ACS2018/MapServer/62/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                    'Clusters': f'ACS2018/MapServer/64/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson'
                },
                'Metropolitan Statistical Area': f'ACS2018/MapServer/78/query?timeRelation=esriTimeRelationOverlaps&geometry={centroid[selected_county]}&geometryType=esriGeometryPoint&inSR=4326&spatialRel=esriSpatialRelIntersects&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'Designated & Incorporated Place' :{
                    'Designated': f'ACS2018/MapServer/28/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                    'Incorporated': f'ACS2018/MapServer/26/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson'
                },
                'School District (elementary)': f'ACS2018/MapServer/16/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'School District (secondary)': f'ACS2018/MapServer/14/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'School District (unified)': f'ACS2018/MapServer/12/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'ZCTA': f'ACS2018/MapServer/2/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'Block Group': f"ACS2018/MapServer/10/query?where=STATE='17'+AND+COUNTY='{county_code[selected_county]}'&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson",
            },
            '2019': {
                'Census Tract': f"ACS2019/MapServer/8/query?where=STATE='17'+AND+COUNTY='{county_code[selected_county]}'&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson",
                'Subdivision (Township)': f"ACS2019/MapServer/20/query?where=STATE='17'+AND+COUNTY='{county_code[selected_county]}'&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson",
                'Urban Areas' :{
                    'Areas': f'ACS2019/MapServer/62/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                    'Clusters': f'ACS2019/MapServer/64/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson'
                },
                'Metropolitan Statistical Area': f'ACS2019/MapServer/78/query?timeRelation=esriTimeRelationOverlaps&geometry={centroid[selected_county]}&geometryType=esriGeometryPoint&inSR=4326&spatialRel=esriSpatialRelIntersects&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'Designated & Incorporated Place' :{
                    'Designated': f'ACS2019/MapServer/28/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                    'Incorporated': f'ACS2019/MapServer/26/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson'
                },
                'School District (elementary)': f'ACS2019/MapServer/16/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'School District (secondary)': f'ACS2019/MapServer/14/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'School District (unified)': f'ACS2019/MapServer/12/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'ZCTA': f'ACS2019/MapServer/2/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'Block Group': f"ACS2019/MapServer/10/query?where=STATE='17'+AND+COUNTY='{county_code[selected_county]}'&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson",
            },
            '2020': {
                'Census Tract': f"Census2020/MapServer/6/query?where=STATE='17'+AND+COUNTY='{county_code[selected_county]}'&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson",
                'Subdivision (Township)': f"Census2020/MapServer/20/query?where=STATE='17'+AND+COUNTY='{county_code[selected_county]}'&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson",
                'Urban Areas': f'Census2020/MapServer/88/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'Metropolitan Statistical Area': f'Census2020/MapServer/76/query?timeRelation=esriTimeRelationOverlaps&geometry={centroid[selected_county]}&geometryType=esriGeometryPoint&inSR=4326&spatialRel=esriSpatialRelIntersects&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'Designated & Incorporated Place' :{
                    'Designated': f'Census2020/MapServer/28/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                    'Incorporated': f'Census2020/MapServer/26/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson'
                },
                'School District (elementary)': f'Census2020/MapServer/16/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'School District (secondary)': f'Census2020/MapServer/14/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'School District (unified)': f'Census2020/MapServer/12/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'ZCTA': f'Census2020/MapServer/84/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'Block Group': f"Census2020/MapServer/8/query?where=STATE='17'+AND+COUNTY='{county_code[selected_county]}'&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson",
            },
            '2021': {
                'Census Tract': f"ACS2021/MapServer/6/query?where=STATE='17'+AND+COUNTY='{county_code[selected_county]}'&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson",
                'Subdivision (Township)': f"ACS2021/MapServer/18/query?where=STATE='17'+AND+COUNTY='{county_code[selected_county]}'&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson",
                'Urban Areas': f'Census2020/MapServer/88/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'Metropolitan Statistical Area': f'ACS2021/MapServer/72/query?timeRelation=esriTimeRelationOverlaps&geometry={centroid[selected_county]}&geometryType=esriGeometryPoint&inSR=4326&spatialRel=esriSpatialRelIntersects&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'Designated & Incorporated Place' :{
                    'Designated': f'ACS2021/MapServer/26/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                    'Incorporated': f'ACS2021/MapServer/24/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson'
                },
                'School District (elementary)': f'ACS2021/MapServer/14/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'School District (secondary)': f'ACS2021/MapServer/12/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'School District (unified)': f'ACS2021/MapServer/10/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'ZCTA': f'ACS2021/MapServer/0/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'Block Group': f"ACS2021/MapServer/8/query?where=STATE='17'+AND+COUNTY='{county_code[selected_county]}'&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson",
            },
            '2022': {
                'Census Tract': f"ACS2022/MapServer/6/query?where=STATE='17'+AND+COUNTY='{county_code[selected_county]}'&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson",
                'Subdivision (Township)': f"ACS2022/MapServer/18/query?where=STATE='17'+AND+COUNTY='{county_code[selected_county]}'&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson",
                'Urban Areas': f'Census2020/MapServer/88/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'Designated & Incorporated Place' :{
                    'Designated': f'ACS2022/MapServer/26/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                    'Incorporated': f'ACS2022/MapServer/24/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson'
                },
                'School District (elementary)': f'ACS2022/MapServer/14/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'School District (secondary)': f'ACS2022/MapServer/12/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'School District (unified)': f'ACS2022/MapServer/10/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'ZCTA': f'ACS2022/MapServer/0/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'Block Group': f"ACS2022/MapServer/8/query?where=STATE='17'+AND+COUNTY='{county_code[selected_county]}'&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson",
            },
            '2023': {
                'Census Tract': f"ACS2023/MapServer/8/query?where=STATE='17'+AND+COUNTY='{county_code[selected_county]}'&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson",
                'Subdivision (Township)': f"ACS2023/MapServer/22/query?where=STATE='17'+AND+COUNTY='{county_code[selected_county]}'&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson",
                'Urban Areas': f'ACS2023/MapServer/88/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'Metropolitan Statistical Area': f'ACS2023/MapServer/93/query?timeRelation=esriTimeRelationOverlaps&geometry={centroid[selected_county]}&geometryType=esriGeometryPoint&inSR=4326&spatialRel=esriSpatialRelIntersects&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'Designated & Incorporated Place' :{
                    'Designated': f'ACS2023/MapServer/30/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                    'Incorporated': f'ACS2023/MapServer/28/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson'
                },
                'School District (elementary)': f'ACS2023/MapServer/18/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'School District (secondary)': f'ACS2023/MapServer/16/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'School District (unified)': f'ACS2023/MapServer/14/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'ZCTA': f'ACS2023/MapServer/2/query?timeRelation=esriTimeRelationOverlaps&geometry={bounding_area}&geometryType=esriGeometryEnvelope&inSR=4326&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson',
                'Block Group': f"ACS2023/MapServer/10/query?where=STATE='17'+AND+COUNTY='{county_code[selected_county]}'&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson",
            }
        }
        requires_clipping = ['Urban Areas','Metropolitan Statistical Area','Designated & Incorporated Place','School District (elementary)','School District (secondary)','School District (unified)','ZCTA']
        requires_codes = ['Urban Areas','Metropolitan Statistical Area','ZCTA']
        combination = {
            'Urban Areas': list(map(str, range(2014, 2020))),
            'Designated & Incorporated Place': list(map(str, range(2014, 2024)))
        }

        geometry = gpd.GeoDataFrame()
        self.progressBar.setValue(10)
        if selected_geography in combination and selected_year in combination[selected_geography]:
            self.progressBar.setValue(20)
            for value in (list(query[selected_year][selected_geography].values())):
                self.tiger_url = f"https://tigerweb.geo.census.gov/arcgis/rest/services/TIGERweb/tigerWMS_{value}"
                tiger_data = requests.get(self.tiger_url)
                print(f"Tiger URLs: {self.tiger_url}")
                if tiger_data.status_code == 200:
                    temp_gdf = gpd.read_file(self.tiger_url)
                    geometry = pd.concat([geometry, temp_gdf])
                else:
                    QMessageBox.warning(self,"TIGERWEB ERROR","Invalid Tiger URL or TIGER servers are currently busy")
            self.progressBar.setValue(30)
        else:
            self.progressBar.setValue(20)
            self.tiger_url = f"https://tigerweb.geo.census.gov/arcgis/rest/services/TIGERweb/tigerWMS_{query[selected_year][selected_geography]}"
            print(f"Tiger URL: {self.tiger_url}")
            tiger_data = requests.get(self.tiger_url)
            self.progressBar.setValue(30)
            if tiger_data.status_code == 200:
                geometry = gpd.read_file(self.tiger_url)
            else:
                QMessageBox.warning(self,"TIGERWEB ERROR","Invalid Tiger URL or TIGER servers are currently busy")


        geometry = geometry[['GEOID','geometry']]

        if selected_geography in requires_clipping:
            layer = {
                '2014': '84',
                '2015': '84',
                '2016': '84',
                '2017': '84',
                '2018': '84',
                '2019': '84',
                '2020': '82',
                '2021': '78',
                '2022': '78',
                '2023': '82',
            }
            if selected_year != '2020':
                county_url = f"https://tigerweb.geo.census.gov/arcgis/rest/services/TIGERweb/tigerWMS_ACS{selected_year}/MapServer/{layer[selected_year]}/query?where=STATE='17'+AND+COUNTY='{county_code[selected_county]}'&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson"
            else:
                county_url = f"https://tigerweb.geo.census.gov/arcgis/rest/services/TIGERweb/tigerWMS_Census{selected_year}/MapServer/{layer[selected_year]}/query?where=STATE='17'+AND+COUNTY='{county_code[selected_county]}'&outFields=GEOID&returnGeometry=true&outSR=3435&f=geojson"

            print("County URL:" + county_url)
            county_data = requests.get(county_url)
            if county_data.status_code == 200:
                county_geometry = gpd.read_file(county_url)
                # Filter merge to only include features that intersect with county_geometry
                geometry = geometry[geometry.intersects(county_geometry.unary_union)]
            else:
                QMessageBox.warning(self,"TIGERWEB ERROR","Invalid Tiger URL or TIGER servers are currently busy")

        self.progressBar.setValue(40)

        if self.cb_mpa.isChecked() is True:
            directory = os.path.dirname(os.path.abspath(__file__))
            mpa_path = os.path.join(directory, 'MPA.gpkg')
            mpa_boundary = gpd.read_file(mpa_path)
            mpa_boundary = mpa_boundary.to_crs(epsg = 3435)
            geometry = geometry.overlay(mpa_boundary)

        self.progressBar.setValue(50)

        codes=[]
        if selected_geography in requires_codes:
            codes = ','.join(str(x) for x in geometry['GEOID'])
        self.progressBar.setValue(60)
        print(codes)

        dataset = {
            "ACS5": "acs/acs5",
            "ACS1": "acs/acs1",
            "Decennial": "dec",
        }

        table = {
            "Detailed Tables": "",
            "Subject Tables": "/subject",
            "Data Profile": "/profile",
            "Demographic and Housing Characteristics File": "/dhc",
            "Demographic Profile": "/dp",
        }

        predefined_groups = {
            "Sex By Age": "B01001",
            "Race": "B02001",
            "Hispanic or Latino Origin": "B03003",
            "Receipt of Food Stamps/SNAP in the Past 12 Months by Disability Status for Households": "B22010",
            "Poverty Status of Individuals in the Past 12 Months by Living Arrangement": "B17021",
            "Means of Transportation to Work": "B08301",
            "Travel Time to Work": "B08303",
            "Age by Language Spoken at Home by Ability to Speak English for the Population 5 Years and Over": "B16004",
            "Tenure by Vehicles Available": "B25044",
            "Age and Sex": "S0101",
            "Household and Families": "S1101",
            "Selected Social Characteristics in the United States": "DP02",
            "Selected Economic Characteristics": "DP03",
            "Selected Housing Characteristics": "DP04",
            "Sex by Age for Selected Age Categories": "P12",
            "Profile of General Population and Housing Characteristics": "DP1",
        }

        geography_post_2020 = {
            'ACS5': {
                'Census Tract': f'tract:*&in=state:17&in=county:{county_code[selected_county]}',
                'Subdivision (Township)': f'county%20subdivision:*&in=state:17&in=county:{county_code[selected_county]}',
                'Urban Areas': f'urban%20area:{codes}', #Will have to get a list of urban area codes for given counties
                'Metropolitan Statistical Area': f'metropolitan%20statistical%20area/micropolitan%20statistical%20area:{codes}',
                'Designated & Incorporated Place': 'place:*&in=state:17', #Will need place codes for given counties
                'School District (elementary)': 'school%20district%20(elementary):*&in=state:17', #Needs codes for schools
                'School District (secondary)': 'school%20district%20(secondary):*&in=state:17', #Need codes for schools
                'School District (unified)': 'school%20district%20(unified):*&in=state:17', #Need codes for schools
                'ZCTA': f'zip%20code%20tabulation%20area:{codes}', #Need zipcodes for given counties
                'Block Group': f'block%20group:*&in=state:17%20county:{county_code[selected_county]}',
            },
            'ACS1': {
                'Subdivision (Township)': f'county%20subdivision:*&in=state:17&in=county:{county_code[selected_county]}',
                'Urban Areas': f'urban%20area:{codes}', #Need Urban Area codes for given counties
                'Metropolitan Statistical Area': f'metropolitan%20statistical%20area/micropolitan%20statistical%20area:{codes}',
                'Designated & Incorporated Place': 'place:*&in=state:17', #Need codes for places for given counties
                'School District (elementary)': 'school%20district%20(elementary):*&in=state:17', #Needs codes for schools
                'School District (secondary)': 'school%20district%20(secondary):*&in=state:17', #Needs codes for schools
                'School District (unified)': 'school%20district%20(unified):*&in=state:17', #Needs codes for schools
            },
            'Decennial': {
                'Census Tract': f'tract:*&in=state:17&in=county:{county_code[selected_county]}',
                'Subdivision (Township)': f'county%20subdivision:*&in=state:17&in=county:{county_code[selected_county]}',
                'Urban Areas': f'urban%20area:{codes}', #Later add a set of selected urban area code for the given counties
                'Metropolitan Statistical Area': f'metropolitan%20statistical%20area/micropolitan%20statistical%20area:{codes}',
                'Designated & Incorporated Place': f'place:*&in=state:17', #There is a more specific filter for dhp table but didn't want to complicate it right now
                'School District (elementary)': 'school%20district%20(elementary):*&in=state:17', #Later add a set of selected school codes to filter by county
                'School District (secondary)': 'school%20district%20(secondary):*&in=state:17', #Later add a set of selected school codes to filter by county
                'School District (unified)': 'school%20district%20(unified):*&in=state:17', #Later add a set of selected school codes to filter by county
                'ZCTA': f'zip%20code%20tabulation%20area:{codes}', #There is a more specific filter for dhp table but didn't want to complicate it right now, can be resolved by having predetermined codes
                'Block Group': f'block%20group:*&in=state:17%20county:{county_code[selected_county]}',
            }
        }

        geography_pre_2020 = {
            'ACS5': {
                'Census Tract': f'tract:*&in=state:17&in=county:{county_code[selected_county]}',
                'Subdivision (Township)': f'county%20subdivision:*&in=state:17&in=county:{county_code[selected_county]}',
                'Urban Areas': f'urban%20area:{codes}', #Will have to get a list of urban area codes for given counties
                'Metropolitan Statistical Area': f'metropolitan%20statistical%20area/micropolitan%20statistical%20area:{codes}',
                'Designated & Incorporated Place': 'place:*&in=state:17', #Will need place codes for given counties
                'School District (elementary)': 'school%20district%20(elementary):*&in=state:17', #Needs codes for schools
                'School District (secondary)': 'school%20district%20(secondary):*&in=state:17', #Need codes for schools
                'School District (unified)': 'school%20district%20(unified):*&in=state:17', #Need codes for schools
                'ZCTA': f'zip%20code%20tabulation%20area:{codes}&in=state:17', #Need zipcodes for given counties
                'Block Group': f'block%20group:*&in=state:17%20county:{county_code[selected_county]}',
            },
            'ACS1': {
                'Subdivision (Township)': f'county%20subdivision:*&in=state:17&in=county:{county_code[selected_county]}',
                'Urban Areas': f'urban%20area:{codes}', #Need Urban Area codes for given counties
                'Metropolitan Statistical Area': f'metropolitan%20statistical%20area/micropolitan%20statistical%20area:{codes}',
                'Designated & Incorporated Place': 'place:*&in=state:17', #Need codes for places for given counties
                'School District (elementary)': 'school%20district%20(elementary):*&in=state:17', #Needs codes for schools
                'School District (secondary)': 'school%20district%20(secondary):*&in=state:17', #Needs codes for schools
                'School District (unified)': 'school%20district%20(unified):*&in=state:17', #Needs codes for schools
            }
        }

        def create_variable_lists(df):
            variable_lists = {}

            for table_type, group in df.groupby('Table'):
                variable_lists[table_type] = group['Variables'].tolist()

            return variable_lists

        #Lists of which variables GEOID column is constructed from the last 4, 3 or last 2 columns in their dataframe
        GEOID_4 = ['Block Group']
        GEOID_3 = ["Census Tract",'Subdivision (Township)']
        GEOID_2 = ['Designated & Incorporated Place','School District (elementary)','School District (secondary)','School District (unified)']
        self.progressBar.setValue(70)
        if self.cb_groupcall.isChecked() is True:
            if int(selected_year) >=2020:
                self.census_url = f"https://api.census.gov/data/{selected_year}/{dataset[selected_dataset]}{table[selected_table]}?get=group({predefined_groups[selected_group]})&for={geography_post_2020[selected_dataset][selected_geography]}&key={census_key}"
            else:
                self.census_url = f"https://api.census.gov/data/{selected_year}/{dataset[selected_dataset]}{table[selected_table]}?get=group({predefined_groups[selected_group]})&for={geography_pre_2020[selected_dataset][selected_geography]}&key={census_key}"
            print(f"Census API URL: {self.census_url}")
            data = requests.get(self.census_url)
            if data.status_code == 200:
                data = data.json()
                group_df = pd.DataFrame(data[1:], columns=data[0])
                group_df['GEOID'] = group_df['GEO_ID'].str.split('US').str[1]
                df = group_df
            else:
                QMessageBox.warning(self,"CENSUS ERROR","Invalid Census URL or Census servers are currently busy")
            self.progressBar.setValue(80)
        else:
            variable_df = self.qtablewidget_to_dataframe(self.tw_selected_variables)
            variable_lists = create_variable_lists(variable_df)
            variable_labels = {row['Variables']: row['Labels'] for _, row in variable_df.iterrows()}
            all_dfs = pd.DataFrame()
            for key in variable_lists:
                if int(selected_year) >= 2020:
                    temp_url = f"https://api.census.gov/data/{selected_year}/{dataset[selected_dataset]}{table[key]}?get={','.join(map(str, variable_lists[key]))}&for={geography_post_2020[selected_dataset][selected_geography]}&key={census_key}"
                else:
                    temp_url = f"https://api.census.gov/data/{selected_year}/{dataset[selected_dataset]}{table[key]}?get={','.join(map(str, variable_lists[key]))}&for={geography_pre_2020[selected_dataset][selected_geography]}&key={census_key}"
                print(f"Census API URLs: {temp_url}")
                data = requests.get(temp_url)
                if data.status_code == 200:
                    data = data.json()
                    temp_df = pd.DataFrame(data[1:], columns=data[0])
                    if selected_geography in GEOID_4:
                        temp_df['GEOID'] = temp_df[temp_df.columns[-4]] + temp_df[temp_df.columns[-3]] + temp_df[temp_df.columns[-2]] + temp_df[temp_df.columns[-1]]
                    elif selected_geography in GEOID_3:
                        temp_df['GEOID'] = temp_df[temp_df.columns[-3]] + temp_df[temp_df.columns[-2]] + temp_df[temp_df.columns[-1]]
                    elif selected_geography in GEOID_2:
                        temp_df['GEOID'] = temp_df[temp_df.columns[-2]] + temp_df[temp_df.columns[-1]]
                    else:
                        temp_df['GEOID'] = temp_df[temp_df.columns[-1]]
                    if all_dfs.empty is True:
                        all_dfs = temp_df
                    else:
                        all_dfs = pd.merge(all_dfs, temp_df[['GEOID'] + variable_lists[key]], on='GEOID', how='left')
                else:
                    QMessageBox.warning(self,"CENSUS ERROR","Invalid Census URL or Census servers are currently busy")
            combined_df = all_dfs
            combined_df.rename(columns=variable_labels, inplace=True)
            df = combined_df
            self.progressBar.setValue(80)

        merge = geometry.merge(df, on = "GEOID")
        merge = merge.apply(pd.to_numeric, errors='ignore')

        if merge.empty:
            QMessageBox.warning(self,"EMPTY DATAFRAME","No data within the requested geography")

        self.progressBar.setValue(90)

        if self.cb_local.isChecked() is False:
            vl = QgsVectorLayer(merge.to_json(),f"{selected_dataset}_{selected_table}_{selected_geography}_{selected_county}_{selected_group}_{selected_year}","ogr")
            QgsProject.instance().addMapLayer(vl)
        else:
            save_directory = QtWidgets.QFileDialog.getSaveFileName(
                parent = None,
                caption = "Select Directory",
                directory = "file.gpkg",
                filter="GeoPackage Files (*.gpkg)"
            )
            merge.to_file(
                save_directory[0],
                driver="GPKG",
                layer="clipped_data"
            )

            uri = f"{save_directory[0]}|layername=clipped_data"
            layer_name = os.path.splitext(os.path.basename(save_directory[0]))[0]
            vl = QgsVectorLayer(uri,f"{layer_name}","ogr")
            if vl.isValid():
                QgsProject.instance().addMapLayer(vl)

        self.progressBar.setValue(100)
        self.progressBar.reset()

    def clear_variable_group(self):
        self.tw_census_view.clear()
        self.tw_census_view.setRowCount(0)
        self.tw_census_view.setColumnCount(0)

    def clear_variable(self):
        self.tw_selected_variables.clear()
        self.tw_selected_variables.setRowCount(0)
        self.tw_selected_variables.setColumnCount(0)

    def add_to_variable_table(self):
        self.tw_selected_variables.setSelectionBehavior(QTableWidget.SelectRows)
        self.tw_selected_variables.setSelectionMode(QTableWidget.ExtendedSelection)
        self.tw_selected_variables.setColumnCount(3)
        headers = ["Variables","Labels","Table"]
        self.tw_selected_variables.setHorizontalHeaderLabels(headers)

        if self.tw_census_view.rowCount() == 0:
            QMessageBox.information(self,"Populate Variables","You must run 'Submit' to pull an item from the table")
        else:
            selected_items = self.tw_census_view.selectedItems()
            selected_rows = set(item.row() for item in selected_items)

            if not selected_rows:
                QMessageBox.warning(self, "Error", "Please select at least one row")

            selected_data = []
            for row in range(self.tw_selected_variables.rowCount()):
                item = self.tw_selected_variables.item(row, 0)
                if item:
                    selected_data.append(item.text())

            row_data_list = []
            for row in selected_rows:
                row_data = []
                for col in range(min(self.tw_census_view.columnCount(), 3)):
                    item = self.tw_census_view.item(row, col)
                    if item:
                        row_data.append(item.text())
                    else:
                        row_data.append("")
                row_data_list.append(row_data)

            unique_rows_to_add = [
                row_data for row_data in row_data_list
                if row_data[0] not in selected_data
            ]

            current_row_count = self.tw_selected_variables.rowCount()
            for row_data in unique_rows_to_add:
                self.tw_selected_variables.insertRow(current_row_count)
                for col, data in enumerate(row_data[:3]):
                    self.tw_selected_variables.setItem(current_row_count, col, QTableWidgetItem(data))
                current_row_count += 1


    def remove_from_variable_table(self):
        selected_items = self.tw_selected_variables.selectedItems()
        selected_rows = set(item.row() for item in selected_items)

        for row in sorted(selected_rows, reverse=True):
            self.tw_selected_variables.removeRow(row)
