# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CduCreator
                                 A QGIS plugin
 This plugin creates CDU (Certificato di Destinazione Urbanistica)
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-07-18
        git sha              : $Format:%H$
        copyright            : (C) 2019 by Gter srl
        email                : assistenzagis@gter.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtCore import QSettings, QTranslator, qVersion, QCoreApplication, QDir, QSize, QDate, Qt, QByteArray
from PyQt5.QtGui import QIcon, QPainter, QImage, QTextDocument, QTextDocumentWriter, QPen, QColor
from PyQt5.QtWidgets import QAction, QFileDialog, QMessageBox, QProgressBar, QDialog, QCheckBox, QTabWidget
from PyQt5.QtPrintSupport import QPrinter
from PyQt5.QtXml import QDomDocument
from qgis.core import *
from qgis.core import QgsMapLayerProxyModel
from qgis.utils import *
import processing
# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .cdu_creator_dialog import CduCreatorDialog
import os.path
import os
from datetime import datetime
import webbrowser
import tempfile
import shutil
from shutil import copyfile
from PIL import Image

class CduCreator:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'CduCreator_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&CDU Creator')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        #self.first_start = None
        
        self.pluginIsActive = False
        
        #self.aoiIndex = -1
        self.foglioIndex = 0
        self.show_values = []
        self.sezioneIndex = 0
        self.filter_s = ''
        self.show_values_s = []
        self.particellaIndex = 0
        self.foglio_values = []
        self.sezione_values = []
        self.gruppoIndex = 0
        self.algoritmoIndex = 0
        self.out_tempdir_s = ''
        self.lyr = ''
        self.group_names = []
        self.algo_names = []
        self.cdu_path_folder = ''
        self.CduTitle = 'Certificato di Destinazione Urbanistica (CDU)'
        self.CduComune = ''
        self.input_logo_path = ''
        self.checkAreaBox = False
        self.checkAreaPercBox = False
        self.root = ''
        self.input_file_path = ''
        self.input_txt_path = ''
        self.cdu_file_name = ''
        self.protocollo = ''
        self.richiedente = ''
        self.data = QDate.currentDate()
        self.checkDataBox = False
        self.sez_list = []
        self.fog_list = []
        self.map_list = []
        self.catasto_alias = {}
        self.checkOdtBox = False
        self.checkMapBox = False 
        self.checkIntBox = False # inserimento IntcheckBox per filtro intersezioni < 1 m²   
        
    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('CduCreator', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/cdu_creator/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Create CDU'),
            callback=self.pressIcon,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True
        #print('sono in initgui')
        self.dlg = CduCreatorDialog()

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&CDU Creator'),
                action)
            self.iface.removeToolBarIcon(action)
            
    def pressIcon(self):
        print(self.pluginIsActive)
        if not self.pluginIsActive:
            #print(self.data)
            self.pluginIsActive = True
            self.dlg = CduCreatorDialog()
            
            self.param_txt = os.path.join(self.plugin_dir, 'input.txt')
            if os.path.isfile(self.param_txt) and os.path.getsize(self.param_txt) > 0:
                param_file = open(self.param_txt, "r")
                param = param_file.readlines()
                self.cdu_path_folder = param[0].strip()
                self.checkOdtBox = param[1].strip()
                self.checkMapBox = param[2].strip()
                self.CduTitle = param[3].strip()
                self.CduComune = param[4].strip()
                self.input_logo_path = param[5].strip()
                self.input_txt_path = param[6].strip()
                self.checkAreaBox = param[7].strip()
                self.checkAreaPercBox = param[8].strip()
                # self.checkIntBox = param[9].strip() if len(param) > 9 else 'False' per evitare errori se il file non contiene il nuovo parametro 
                self.checkIntBox = param[9].strip() if len(param) > 9 else 'False'  
                self.dlg.OutFolder.setText(self.cdu_path_folder)
                if self.checkOdtBox == 'True':
                    self.checkOdtBox = True
                    self.dlg.odtCheckBox.setChecked(True)
                else:
                    self.checkOdtBox = False
                    self.dlg.odtCheckBox.setChecked(False)
                if self.checkMapBox == 'True':
                    self.checkMapBox = True
                    self.dlg.mapCheckBox.setChecked(True)
                else:
                    self.checkMapBox = False
                    self.dlg.mapCheckBox.setChecked(False)
                self.dlg.titolo.setText(self.CduTitle)
                self.dlg.nomeComune.setText(self.CduComune)
                self.dlg.urlLogo.setText(self.input_logo_path)
                self.dlg.urlTxt.setText(self.input_txt_path)
                if self.checkAreaBox == 'True':
                    self.checkAreaBox = True
                    self.dlg.printAreaBox.setChecked(True)
                else:
                    self.checkAreaBox = False
                    self.dlg.printAreaBox.setChecked(False)
                if self.checkAreaPercBox == 'True':
                    self.checkAreaPercBox = True
                    self.dlg.printAreaPercBox.setChecked(True)
                # Imposta lo stato della variabile e della checkbox IntCheckBox in base al valore letto dal file di parametri
                # Serve per mantenere la selezione del filtro "intersezioni < 1 m²" tra una sessione e l'altra
                if self.checkIntBox == 'True':
                     self.checkIntBox = True 
                     self.dlg.IntcheckBox.setChecked(True)
                else:
                    self.checkIntBox = False
                    self.dlg.IntcheckBox.setChecked(False)
                                       
                param_file.close()
            else:
                param_file = open(self.param_txt, "w+")
                param_file.close()

            if QgsProject.instance().mapLayersByName('terreni_catastali'):
                self.lyr = QgsProject.instance().mapLayersByName('terreni_catastali')[0]
                        
                self.dlg.OutFolderButton.clicked.connect(self.exportCduButton)
                self.dlg.OutFolder.textChanged.connect(self.handleOutFolder)
                self.dlg.clearButton.clicked.connect(self.clearButton)
                self.dlg.clearSelButton.clicked.connect(self.clearSelButton)
                self.dlg.helpButton.clicked.connect(self.openHelpButton)
                self.dlg.foglioComboBox.currentIndexChanged.connect(self.foglioBox)
                self.dlg.foglioComboBox.view().setVerticalScrollBarPolicy(Qt.ScrollBarAlwaysOn)
                self.dlg.sezioneComboBox.currentIndexChanged.connect(self.sezioneBox)
                self.dlg.sezioneComboBox.view().setVerticalScrollBarPolicy(Qt.ScrollBarAlwaysOn)
                self.dlg.particellaComboBox.currentIndexChanged.connect(self.particellaBox)
                self.dlg.particellaComboBox.view().setVerticalScrollBarPolicy(Qt.ScrollBarAlwaysOn)
                self.dlg.fileImportButton.clicked.connect(self.importFile)
                self.dlg.gruppoComboBox.currentIndexChanged.connect(self.gruppoBox)
                self.dlg.algoComboBox.currentIndexChanged.connect(self.algoritmoBox)
                self.dlg.logoButton.clicked.connect(self.importLogo)
                self.dlg.urlLogo.textChanged.connect(self.handleLogo)
                self.dlg.txtButton.clicked.connect(self.importTxt)
                self.dlg.urlTxt.textChanged.connect(self.handleTxt)
                self.dlg.titolo.textChanged.connect(self.handleTitle)
                self.dlg.nomeComune.textChanged.connect(self.handleComune)
                #self.dlg.textParticelle.textChanged.connect(self.handleParticelleText)
                self.dlg.nameLineEdit.textChanged.connect(self.handleFileName)
                self.dlg.protocolloLineEdit.textChanged.connect(self.handleProtocollo)
                self.dlg.richiedenteEdit.textChanged.connect(self.handleRichiedente)
                self.dlg.DataCheckBox.stateChanged.connect(self.handleDataCheck)
                self.dlg.dateEdit.setDate(QDate.currentDate())
                #self.dlg.printAreaBox.setText("m<sup>2</sup>")
                #self.dlg.dateEdit.setDate(QDate(2019, 9, 13))
                self.dlg.dateEdit.dateChanged.connect(self.handleData)
                self.dlg.textParticelle.textChanged.connect(self.handleRemoveButton)
                self.dlg.printAreaBox.stateChanged.connect(self.handleAreaBox)
                self.dlg.printAreaPercBox.stateChanged.connect(self.handleAreaPercBox)
                self.dlg.IntcheckBox.stateChanged.connect(self.handleIntCheck)
                self.dlg.odtCheckBox.stateChanged.connect(self.handleOdtFile)
                self.dlg.mapCheckBox.stateChanged.connect(self.handleMapFile)
                self.dlg.addButton.clicked.connect(self.addMapButton)
                self.dlg.removeButton.clicked.connect(self.removeMapButton)
                self.dlg.reloadButton.clicked.connect(self.reloadMapButton)
                self.dlg.reloadButton.setToolTip('Aggiorna l\'elenco delle particelle selezionate indicando solo quelle effettivamente selezionate sul layer terreni_catastali') 
                self.dlg.pushButtonOk.clicked.connect(self.run)
                self.dlg.rejected.connect(self.closePlugin)
                
                self.prepRun()
                
                if self.lyr.selectedFeatureCount() > 0:
                    for sf in self.lyr.selectedFeatures():
                        sel_foglio = sf[self.fog_list[0].casefold()]
                        sel_particella = sf[self.map_list[0].casefold()]
                        if self.lyr.fields().lookupField("SEZIONE") != -1:
                            sel_sezione = sf[self.sez_list[0].casefold()]
                            if sel_sezione == 'NULL' or sel_sezione == '' or sel_sezione == '-' or sel_sezione == NULL:
                                self.dlg.textParticelle.append(self.tr('Fog = {}, Map = {} \n'.format(sel_foglio, sel_particella)))
                            else:
                                self.dlg.textParticelle.append(self.tr('Sez = {}, Fog = {}, Map = {} \n'.format(sel_sezione, sel_foglio, sel_particella)))
                        else:
                            self.dlg.textParticelle.append(self.tr('Fog = {}, Map = {} \n'.format(sel_foglio, sel_particella)))
                    #self.dlg.removeButton.setEnabled(True)
                    box = self.lyr.boundingBoxOfSelected()
                    map = iface.mapCanvas()
                    map.setExtent(box)
                    map.refresh()
                        
                    #self.dlg.textLog.append(self.tr('ATTENZIONE: è già presente una selezione nel layer terreni_catastali.\nUlteriori selezioni utilizzando i menù a tendina saranno aggiunte a quella esistente.'))
                    #QCoreApplication.processEvents()
                    
                self.dlg.show()
            else:
                self.iface.messageBar().pushMessage("ATTENZIONE", "Il layer terreni_catastali non è caricato nel progetto.", level=Qgis.Critical, duration=4)
                self.pluginIsActive = False
        else:
            self.dlg.show()
            self.dlg.activateWindow()
            
    def sezioneBox(self, idxs):
        #print('sezione')
        print(self.pluginIsActive)
        self.sezioneIndex = idxs
        self.check_f = 0
        self.check_m = 0
        self.check_s = 0
        self.catasto_alias = self.lyr.attributeAliases()
        if self.catasto_alias == {}:
            fi = 0
            for field in self.lyr.fields():
                self.lyr.setFieldAlias(fi, None)
                fi += 1
            self.catasto_alias = self.lyr.attributeAliases()
        for key_c, values_c in self.catasto_alias.items():
            if values_c.casefold() == 'SEZIONE'.casefold() or key_c.casefold() == 'SEZIONE'.casefold():
                self.sez_list.insert(0, key_c)
                self.check_s += 1
            if values_c.casefold() == 'FOGLIO'.casefold() or key_c.casefold() == 'FOGLIO'.casefold():
                self.fog_list.insert(0, key_c)
                self.check_f += 1
            if values_c.casefold() == 'MAPPALE'.casefold() or key_c.casefold() == 'MAPPALE'.casefold():
                self.map_list.insert(0, key_c)
                self.check_m += 1

        if self.check_s == 0:
            self.dlg.sezioneComboBox.setEnabled(False)
            self.dlg.textLog.append(self.tr('INFO: una colonna con nome o alias = sezione non è stata trovata, il menù a tendina Sezione è stato disabilitato.\n'))
            QCoreApplication.processEvents()
        if self.check_f == 0:
            self.dlg.textLog.append(self.tr('ERRORE: una colonna con nome o alias = foglio non è stata trovata\n'))
            return
        if self.check_m == 0:
            self.dlg.textLog.append(self.tr('ERRORE: una colonna con nome o alias = mappale non è stata trovata\n'))
            return

        #print(self.foglioIndex)
        if self.sezioneIndex == 0:
            #self.dlg.foglioComboBox.setEnabled(False)
            uniquevalues_s = []
            # #print(uniquevalues)
            uniqueprovider_s = self.lyr.dataProvider()
            #fields = uniqueprovider_s.fields()
            id_s = self.lyr.fields().lookupField('FOGLIO')
            uniquevalues_s = list(uniqueprovider_s.uniqueValues( id_s ))
            # #print(len(uniquevalues))
            # #print(uniquevalues)
            
            self.show_values_s = []
            for uvs in uniquevalues_s:
                #print (uv)
                if uvs != NULL and uvs != '':
                    str_value_s = str(uvs)
                    self.show_values_s.append(str_value_s)
            #print (self.show_values_s)
            
            self.show_values_s.sort()
            self.dlg.foglioComboBox.clear()
            self.dlg.foglioComboBox.addItem('') #--> aggiunge una riga vuota nell'elenco della combo
            self.dlg.foglioComboBox.addItems(svs for svs in self.show_values_s)    
        else:
            if self.lyr.fields().lookupField('SEZIONE') != -1:
            #self.dlg.foglioComboBox.setEnabled(True)
                self.show_values_s = []
                self.filter_s = self.dlg.sezioneComboBox.currentText()
                #print (self.filter_s)
                if self.filter_s == 'NULL':
                    print('is null')
                    values_s = [feat_s[self.fog_list[0].casefold()] for feat_s in self.lyr.getFeatures() if feat_s[self.sez_list[0].casefold()] == None]
                else:
                    print('is not null')
                    values_s = [feat_s[self.fog_list[0].casefold()] for feat_s in self.lyr.getFeatures() if feat_s[self.sez_list[0].casefold()] == self.filter_s]
                list_val_s = set(values_s)
                for uvs in list_val_s:
                    if uvs != '' and uvs != NULL:
                        self.show_values_s.append(uvs)
                #print(self.show_values_s)
                self.show_values_s.sort()
                self.dlg.foglioComboBox.clear()        
                self.dlg.foglioComboBox.addItem('') #--> aggiunge una riga vuota nell'elenco della combo
                self.dlg.foglioComboBox.addItems(sv for sv in self.show_values_s)
            else:
                uniquevalues_s = []
                # #print(uniquevalues)
                uniqueprovider_s = self.lyr.dataProvider()
                #fields = uniqueprovider_s.fields()
                id_s = self.lyr.fields().lookupField('FOGLIO')
                uniquevalues_s = list(uniqueprovider_s.uniqueValues( id_s ))
                self.show_values_s = []
                for uvs in uniquevalues_s:
                    #print (uv)
                    if uvs != NULL and uvs != '':
                        str_value_s = str(uvs)
                        self.show_values_s.append(str_value_s)
                
                self.show_values_s.sort()
                self.dlg.foglioComboBox.clear()
                self.dlg.foglioComboBox.addItem('') #--> aggiunge una riga vuota nell'elenco della combo
                self.dlg.foglioComboBox.addItems(svs for svs in self.show_values_s) 
            
    def foglioBox(self, idxf):
        #print('foglio')

        self.foglioIndex = idxf
        if self.foglioIndex == 0:
            self.dlg.particellaComboBox.setEnabled(False)
            uniquevalues = []
            # #print(uniquevalues)
            uniqueprovider = self.lyr.dataProvider()
            #fields = uniqueprovider.fields()
            id = self.lyr.fields().lookupField('FOGLIO')
            uniquevalues = list(uniqueprovider.uniqueValues( id ))
            # #print(len(uniquevalues))
            # #print(uniquevalues)
            
            self.show_values = []
            for uv in uniquevalues:
                #print (uv)
                if uv != NULL and uv != '':
                    str_value = str(uv)
                    self.show_values.append(str_value)
            #print (self.show_values)
            
            self.show_values.sort()
            self.dlg.particellaComboBox.clear()
            self.dlg.particellaComboBox.addItem('') #--> aggiunge una riga vuota nell'elenco della combo
            self.dlg.particellaComboBox.addItems(sv for sv in self.show_values)
        elif self.foglioIndex != 0 and self.sezioneIndex != 0:
            self.dlg.particellaComboBox.setEnabled(True)
            self.show_values = []
            filter = self.dlg.foglioComboBox.currentText()
            #print (self.filter_s)
            if self.filter_s == 'NULL':
                values = [feat[self.map_list[0].casefold()] for feat in self.lyr.getFeatures() if feat[self.fog_list[0].casefold()] == filter if feat[self.sez_list[0].casefold()] == None]
            else:
                values = [feat[self.map_list[0].casefold()] for feat in self.lyr.getFeatures() if feat[self.fog_list[0].casefold()] == filter if feat[self.sez_list[0].casefold()] == self.filter_s]
            list_val = set(values)
            for uv in list_val:
                if uv != '' and uv != NULL:
                    self.show_values.append(uv)
            
            self.show_values.sort()
            self.dlg.particellaComboBox.clear()        
            self.dlg.particellaComboBox.addItem('') #--> aggiunge una riga vuota nell'elenco della combo
            self.dlg.particellaComboBox.addItems(sv for sv in self.show_values)
            
        else:
            self.dlg.particellaComboBox.setEnabled(True)
            self.show_values = []
            filter = self.dlg.foglioComboBox.currentText()
            #print (filter)
            values = [feat[self.map_list[0].casefold()] for feat in self.lyr.getFeatures() if feat[self.fog_list[0].casefold()] == filter]
            list_val = set(values)
            for uv in list_val:
                if uv != '' and uv != NULL:
                    self.show_values.append(uv)
            #print(self.show_values)
            self.show_values.sort()
            self.dlg.particellaComboBox.clear()        
            self.dlg.particellaComboBox.addItem('') #--> aggiunge una riga vuota nell'elenco della combo
            self.dlg.particellaComboBox.addItems(sv for sv in self.show_values)
            
    def particellaBox(self, idxp):
        self.particellaIndex = idxp
        #print(self.particellaIndex)
        
    def popComboSezione(self):
        #print('pop sezione')
        uniqueprovider_sez = self.lyr.dataProvider()
        #fields_sez = uniqueprovider_sez.fields()
        unique_sezione = []
        id_sezione = self.lyr.fields().lookupField('SEZIONE')
        #print(id_sezione)
        if id_sezione != -1:
            unique_sezione = list(uniqueprovider_sez.uniqueValues( id_sezione ))

            self.sezione_values = []
            for uv_s in unique_sezione:
                #if uv_s != NULL:
                str_value_s = str(uv_s)
                self.sezione_values.append(str_value_s)
            #print(self.sezione_values)
            self.sezione_values.sort()
            self.dlg.sezioneComboBox.clear()
            self.dlg.sezioneComboBox.addItem('')
            self.dlg.sezioneComboBox.addItems(fvs for fvs in self.sezione_values)
        else:
            self.sezioneBox(self.sezioneIndex)
        
    def popComboFoglio(self):
        uniqueprovider = self.lyr.dataProvider()
        #fields = uniqueprovider.fields()
        unique_foglio = []
        id_foglio = self.lyr.fields().lookupField('FOGLIO') 
        unique_foglio = list(uniqueprovider.uniqueValues( id_foglio ))

        self.foglio_values = []
        for uv_f in unique_foglio:
            if uv_f != NULL:
                str_value_f = str(uv_f)
                self.foglio_values.append(str_value_f)
                
        self.foglio_values.sort()
        self.dlg.foglioComboBox.clear()
        self.dlg.foglioComboBox.addItem('')
        self.dlg.foglioComboBox.addItems(fv for fv in self.foglio_values)
            
    def unique(self, fi_ov): 
        # initialize a null list 
        unique_list = [] 
          
        # traverse for all elements 
        for x in fi_ov: 
            # check if exists in unique_list or not 
            if x not in unique_list: 
                unique_list.append(x) 
        # print list 
        return unique_list
        
    def addMapButton(self):
        self.dlg.removeButton.setEnabled(True)
        if self.foglioIndex != 0 and self.particellaIndex != 0:
            #print('sel_sezione = {}'.format(sel_sezione))
            sel_foglio = self.show_values_s[self.foglioIndex - 1]
            #print('sel_foglio è {}'.format(sel_foglio))
            sel_particella = self.show_values[self.particellaIndex - 1]
            #print(sel_particella)
            if self.sezioneIndex != 0:
                sel_sezione = self.sezione_values[self.sezioneIndex - 1]
                #print('sel_sezione è {}'.format(sel_sezione))
                if sel_sezione == 'NULL' or sel_sezione == '':
                    self.lyr.selectByExpression("{} is NULL AND {}='{}' AND {}='{}'".format(self.sez_list[0].casefold(), self.fog_list[0].casefold(), sel_foglio, self.map_list[0].casefold(), sel_particella), self.lyr.AddToSelection)
                else:
                    self.lyr.selectByExpression("{}='{}' AND {}='{}' AND {}='{}'".format(self.sez_list[0].casefold(), sel_sezione, self.fog_list[0].casefold(), sel_foglio, self.map_list[0].casefold(), sel_particella), self.lyr.AddToSelection)
                self.dlg.textParticelle.append(self.tr('Sez = {}, Fog = {}, Map = {} \n'.format(sel_sezione, sel_foglio, sel_particella)))
            else:
                #print('sono in sezione == 0')
                self.lyr.selectByExpression("{}='{}' AND {}='{}'".format(self.fog_list[0].casefold(), sel_foglio, self.map_list[0].casefold(), sel_particella), self.lyr.AddToSelection)
                selectedF = self.lyr.selectedFeatures()[0]
                if self.lyr.fields().lookupField("SEZIONE") != -1:
                    sel_sezione = selectedF[self.sez_list[0].casefold()]
                else:
                    sel_sezione = 'NULL'
                #sel_foglio = selectedF[self.fog_list[0].casefold()]
                #sel_particella = selectedF[self.map_list[0].casefold()]
                self.dlg.textParticelle.append(self.tr('Fog = {}, Map = {} \n'.format(sel_foglio, sel_particella)))
            box = self.lyr.boundingBoxOfSelected()
            map = iface.mapCanvas()
            map.setExtent(box)
            map.refresh()
                
        else:
            self.dlg.textLog.append(self.tr('ATTENZIONE: è necessario selezionare almeno un valore per il foglio e uno per il mappale.'))
            return
            
    def removeMapButton(self):
        if self.foglioIndex != 0 and self.particellaIndex != 0:
            #print('sel_sezione = {}'.format(sel_sezione))
            sel_foglio = self.show_values_s[self.foglioIndex - 1]
            #print('sel_foglio è {}'.format(sel_foglio))
            sel_particella = self.show_values[self.particellaIndex - 1]
            #print(sel_particella)
            if self.sezioneIndex != 0:
                sel_sezione = self.sezione_values[self.sezioneIndex - 1]
                #print('sel_sezione è {}'.format(sel_sezione))
                if sel_sezione == 'NULL' or sel_sezione == '':
                    self.lyr.selectByExpression("{} is NULL AND {}='{}' AND {}='{}'".format(self.sez_list[0].casefold(), self.fog_list[0].casefold(), sel_foglio, self.map_list[0].casefold(), sel_particella), self.lyr.RemoveFromSelection)
                else:
                    #print('sono qui')
                    self.lyr.selectByExpression("{}='{}' AND {}='{}' AND {}='{}'".format(self.sez_list[0].casefold(), sel_sezione, self.fog_list[0].casefold(), sel_foglio, self.map_list[0].casefold(), sel_particella), self.lyr.RemoveFromSelection)
                testo = self.tr('Sez = {}, Fog = {}, Map = {} '.format(sel_sezione, sel_foglio, sel_particella))
            else:
                #print('sono in sezione == 0')
                self.lyr.selectByExpression("{}='{}' AND {}='{}'".format(self.fog_list[0].casefold(), sel_foglio, self.map_list[0].casefold(), sel_particella), self.lyr.RemoveFromSelection)
                selectedF = self.lyr.selectedFeatures()[0]
                if self.lyr.fields().lookupField("SEZIONE") != -1:
                    sel_sezione = selectedF[self.sez_list[0].casefold()]
                else:
                    sel_sezione = 'NULL'
                #sel_foglio = selectedF[self.fog_list[0].casefold()]
                #sel_particella = selectedF[self.map_list[0].casefold()]
                testo = self.tr('Fog = {}, Map = {} '.format(sel_foglio, sel_particella))
            print(self.dlg.textParticelle.toPlainText())
            lines = self.dlg.textParticelle.toPlainText().split("\n")
            #print(lines)
            #print(testo)
            for i in lines:
                if i == testo:
                    lines.remove(i)
            self.dlg.textParticelle.clear()
            for k in lines:
                if k != '':
                    self.dlg.textParticelle.append(k + '\n')
 
            #print(lines)
            box = self.lyr.boundingBoxOfSelected()
            map = iface.mapCanvas()
            map.setExtent(box)
            map.refresh()
                    
        else:
            self.dlg.textLog.append(self.tr('ATTENZIONE: è necessario selezionare almeno un valore per il foglio e uno per il mappale.'))
            return
            
    def reloadMapButton(self):
        self.dlg.textParticelle.clear()
        if self.lyr.selectedFeatureCount() > 0:
            for sf in self.lyr.selectedFeatures():
                sel_foglio = sf[self.fog_list[0].casefold()]
                sel_particella = sf[self.map_list[0].casefold()]
                if self.lyr.fields().lookupField("SEZIONE") != -1:
                    sel_sezione = sf[self.sez_list[0].casefold()]
                    if sel_sezione == 'NULL' or sel_sezione == '' or sel_sezione == '-' or sel_sezione == NULL:
                        self.dlg.textParticelle.append(self.tr('Fog = {}, Map = {} \n'.format(sel_foglio, sel_particella)))
                    else:
                        self.dlg.textParticelle.append(self.tr('Sez = {}, Fog = {}, Map = {} \n'.format(sel_sezione, sel_foglio, sel_particella)))
                else:
                    self.dlg.textParticelle.append(self.tr('Fog = {}, Map = {} \n'.format(sel_foglio, sel_particella)))
        
            box = self.lyr.boundingBoxOfSelected()
            map = iface.mapCanvas()
            map.setExtent(box)
            map.refresh()

    def gruppoBox(self, idxg):
        #print('gruppo')
        self.gruppoIndex = idxg
        #print(self.gruppoIndex)
        
    def algoritmoBox(self, idxa):
        #print('gruppo')
        self.algoritmoIndex = idxa
        print(self.algoritmoIndex)
        
    def handleProtocollo(self, val):
        self.protocollo = val
        
    def handleRichiedente(self, val):
        self.richiedente = val
        
    def handleDataCheck(self):
        if self.dlg.DataCheckBox.isChecked() == True:
            self.checkDataBox = True
            self.dlg.label_11.setEnabled(True)
            self.dlg.dateEdit.setEnabled(True)
        else:
            self.checkDataBox = False
            self.dlg.label_11.setEnabled(False)
            self.dlg.dateEdit.setEnabled(False)
            
    def handleRemoveButton(self):
        if str(self.dlg.textParticelle.toPlainText()) != '':
            self.dlg.removeButton.setEnabled(True)
        else:
            self.dlg.removeButton.setEnabled(False)
        
    def handleData(self, val):
        self.data = val
        
    def exportCduButton(self):
        self.cdu_out_folder = QFileDialog.getExistingDirectory()
        self.cdu_path_folder = QDir.toNativeSeparators(self.cdu_out_folder)
        #print (self.cdu_out_folder)
        print (self.cdu_path_folder)
        cdu_txt_folder = self.dlg.OutFolder.setText(self.cdu_path_folder)
        
    def handleOutFolder(self, val):
        self.cdu_path_folder = val
        #print(self.cdu_path_folder)
        
    def handleFileName(self, val):
        self.cdu_file_name = val
        
    def handleOdtFile(self):
        if self.dlg.odtCheckBox.isChecked() == True:
            self.checkOdtBox = True
        else:
            self.checkOdtBox = False
            
    def handleMapFile(self):
        if self.dlg.mapCheckBox.isChecked() == True:
            self.checkMapBox = True
        else:
            self.checkMapBox = False
        
    def handleTitle(self, val):
        self.CduTitle = val
        print(self.CduTitle)
        
    def handleComune(self, val):
        self.CduComune = val
        print(self.CduComune)
        
    def importLogo(self):
        self.input_logo, _filter = QFileDialog.getOpenFileName(None, "Open ", '.', "(*.png *.jpg)")
        print (self.input_logo)
        self.input_logo_path = QDir.toNativeSeparators(self.input_logo)
        #print (self.input_logo)
        print (self.input_logo_path)
        input_logo_txt = self.dlg.urlLogo.setText(self.input_logo_path)
        
    def handleLogo(self, val):
        self.input_logo_path = val
        print(self.input_logo_path)
        
    def importFile(self):
        self.input_file, _filter = QFileDialog.getOpenFileName(None, "Open ", '.', "(*.txt *.csv)")
        self.input_file_path = QDir.toNativeSeparators(self.input_file)
        if os.path.isfile(self.input_file_path):
            #print('file exist')
            if os.path.splitext(self.input_file_path)[1] == '.csv':
                input_file_txt = open(self.input_file_path, "r")
                next(input_file_txt)
            elif os.path.splitext(self.input_file_path)[1] == '.txt':
                input_file_txt = open(self.input_file_path, "r")
            #print(file.read())
            for num, line in enumerate(input_file_txt, 1):
                if line.rstrip():
                    line_list = list(line.split(','))
                    #print(line_list)
                    if len(line_list) == 3:
                        if line_list[1] == '' or line_list[1] == ' ' or line_list[2] == '' or line_list[2] == ' ' or line_list[2] == '\n':
                            self.dlg.textParticelle.append(self.tr('Errore alla riga {}, è necessario specificare il numero di foglio e mappale. La riga sarà ignorata.\n'.format(num)))
                        elif line_list[0] == '' or line_list[0] == ' ':
                            self.lyr.selectByExpression("{}='{}' AND {}='{}'".format(self.fog_list[0].casefold(), line_list[1].strip(), self.map_list[0].casefold(), line_list[2].strip()), self.lyr.AddToSelection)
                            self.dlg.textParticelle.append(self.tr('Fog = {}, Map = {} \n'.format(line_list[1].strip(), line_list[2].strip())))
                        else:
                            self.lyr.selectByExpression("{}='{}' AND {}='{}' AND {}='{}'".format(self.sez_list[0].casefold(), line_list[0].strip(), self.fog_list[0].casefold(), line_list[1].strip(), self.map_list[0].casefold(), line_list[2].strip()), self.lyr.AddToSelection)
                            self.dlg.textParticelle.append(self.tr('Sez = {}, Fog = {}, Map = {} \n'.format(line_list[0].strip(), line_list[1].strip(), line_list[2].strip())))
                    elif len(line_list) < 2:
                        self.dlg.textParticelle.append(self.tr('Errore alla riga {}, è necessario specificare almeno il numero di foglio e mappale. La riga sarà ignorata.\n'.format(num)))
                    elif len(line_list) > 3:
                        if line_list[3] == '' or line_list[3] == ' ' or line_list[3] == '\n':
                            if line_list[1] == '' or line_list[1] == ' ' or line_list[2] == '' or line_list[2] == ' ':
                                self.dlg.textParticelle.append(self.tr('Errore alla riga {}, è necessario specificare il numero di foglio e mappale. La riga sarà ignorata.\n'.format(num)))
                            elif line_list[0] == '' or line_list[0] == ' ':
                                self.lyr.selectByExpression("{}='{}' AND {}='{}'".format(self.fog_list[0].casefold(), line_list[1].strip(), self.map_list[0].casefold(), line_list[2].strip()), self.lyr.AddToSelection)
                                self.dlg.textParticelle.append(self.tr('Fog = {}, Map = {} \n'.format(line_list[1].strip(), line_list[2].strip())))
                            else:
                                self.lyr.selectByExpression("{}='{}' AND {}='{}' AND {}='{}'".format(self.sez_list[0].casefold(), line_list[0].strip(), self.fog_list[0].casefold(), line_list[1].strip(), self.map_list[0].casefold(), line_list[2].strip()), self.lyr.AddToSelection)
                                self.dlg.textParticelle.append(self.tr('Sez = {}, Fog = {}, Map = {} \n'.format(line_list[0].strip(), line_list[1].strip(), line_list[2].strip())))
                        else:
                            self.dlg.textParticelle.append(self.tr('Errore alla riga {}, sono stati specificati troppi parametri. La riga sarà ignorata.\n'.format(num)))
                    else:
                        if line_list[0] == '' or line_list[0] == ' ' or line_list[1] == '' or line_list[1] == ' ':
                            self.dlg.textParticelle.append(self.tr('Errore alla riga {}, è necessario specificare il numero di foglio e mappale. La riga sarà ignorata.\n'.format(num)))
                        else:
                            self.lyr.selectByExpression("{}='{}' AND {}='{}'".format(self.fog_list[0].casefold(), line_list[0].strip(), self.map_list[0].casefold(), line_list[1].strip()), self.lyr.AddToSelection)
                            self.dlg.textParticelle.append(self.tr('Fog = {}, Map = {} \n'.format(line_list[0].strip(), line_list[1].strip())))
            input_file_txt.close()
            box = self.lyr.boundingBoxOfSelected()
            map = iface.mapCanvas()
            map.setExtent(box)
            map.refresh()

    def importTxt(self):
        self.input_txt, _filter = QFileDialog.getOpenFileName(None, "Open ", '.', "(*.txt)")
        self.input_txt_path = QDir.toNativeSeparators(self.input_txt)
        input_txt_txt = self.dlg.urlTxt.setText(self.input_txt_path)
        
    def handleTxt(self, val):
        self.input_txt_path = val
        print(self.input_txt_path)

    def handleAreaBox(self):
        if self.dlg.printAreaBox.isChecked() == True:
            self.checkAreaBox = True
        else:
            self.checkAreaBox = False
            
    def handleAreaPercBox(self):
        if self.dlg.printAreaPercBox.isChecked() == True:
            self.checkAreaPercBox = True
        else:
            self.checkAreaPercBox = False
    
    def handleIntCheck(self):
        if self.dlg.IntcheckBox.isChecked() == True:
            self.checkIntBox = True
        else:
            self.checkIntBox = False

    def clearButton(self):
        self.dlg.textLog.clear()
        
    def clearSelButton(self):
        self.lyr.removeSelection()
        self.dlg.textParticelle.clear()
        
    def openHelpButton(self):
        webbrowser.open('https://manuale-cdu-creator.readthedocs.io/it/latest/')
        
    def prepRun(self):
    
        self.popComboSezione()
        self.popComboFoglio()
        
        self.root = QgsProject.instance().layerTreeRoot()
        #print(root.children())
        child = self.root.children()
        self.group_names = []
        for ch in child:
            if isinstance(ch, QgsLayerTreeGroup):
                #print (type(ch))
                self.group_names.append(ch.name())
                
        self.dlg.gruppoComboBox.clear()
        self.dlg.gruppoComboBox.addItem('')
        self.dlg.gruppoComboBox.addItems(gro for gro in self.group_names)
        
        self.algo_names = ['QGIS - Ritaglia', 'GDAL - Ritaglia con maschera']
        self.dlg.algoComboBox.clear()
        #self.dlg.algoComboBox.addItem('')
        self.dlg.algoComboBox.addItems(alg for alg in self.algo_names)
        
        self.dlg.titolo.setText(self.CduTitle)
        
        
    def closePlugin(self):
        """Cleanup necessary items here when plugin dockwidget is closed"""

        print("** CLOSING Plugin")

        self.dlg.OutFolderButton.clicked.disconnect(self.exportCduButton)
        self.dlg.OutFolder.textChanged.disconnect(self.handleOutFolder)
        self.dlg.clearButton.clicked.disconnect(self.clearButton)
        self.dlg.clearSelButton.clicked.disconnect(self.clearSelButton)
        self.dlg.helpButton.clicked.disconnect(self.openHelpButton)
        self.dlg.foglioComboBox.currentIndexChanged.disconnect(self.foglioBox)
        self.dlg.sezioneComboBox.currentIndexChanged.disconnect(self.sezioneBox)
        self.dlg.particellaComboBox.currentIndexChanged.disconnect(self.particellaBox)
        self.dlg.fileImportButton.clicked.disconnect(self.importFile)
        self.dlg.gruppoComboBox.currentIndexChanged.disconnect(self.gruppoBox)
        self.dlg.algoComboBox.currentIndexChanged.disconnect(self.algoritmoBox)
        self.dlg.logoButton.clicked.disconnect(self.importLogo)
        self.dlg.urlLogo.textChanged.disconnect(self.handleLogo)
        self.dlg.txtButton.clicked.disconnect(self.importTxt)
        self.dlg.urlTxt.textChanged.disconnect(self.handleTxt)
        self.dlg.titolo.textChanged.disconnect(self.handleTitle)
        self.dlg.nomeComune.textChanged.disconnect(self.handleComune)
        #self.dlg.textParticelle.textChanged.disconnect(self.handleParticelleText)
        self.dlg.nameLineEdit.textChanged.disconnect(self.handleFileName)
        self.dlg.protocolloLineEdit.textChanged.disconnect(self.handleProtocollo)
        self.dlg.richiedenteEdit.textChanged.disconnect(self.handleRichiedente)
        self.dlg.DataCheckBox.stateChanged.disconnect(self.handleDataCheck)
        self.dlg.textParticelle.textChanged.disconnect(self.handleRemoveButton)
        self.dlg.dateEdit.dateChanged.connect(self.handleData)
        self.dlg.printAreaBox.stateChanged.disconnect(self.handleAreaBox)
        self.dlg.printAreaPercBox.stateChanged.disconnect(self.handleAreaPercBox)
        try:
            self.dlg.IntcheckBox.stateChanged.disconnect(self.handleIntCheck)
        except Exception:
            pass
        self.dlg.odtCheckBox.stateChanged.disconnect(self.handleOdtFile)
        self.dlg.mapCheckBox.stateChanged.disconnect(self.handleMapFile)
        self.dlg.addButton.clicked.disconnect(self.addMapButton)
        self.dlg.removeButton.clicked.disconnect(self.removeMapButton)
        self.dlg.reloadButton.clicked.disconnect(self.reloadMapButton)
        self.dlg.pushButtonOk.clicked.disconnect(self.run)
        self.dlg.rejected.disconnect(self.closePlugin)
        
        self.pluginIsActive = False
        #self.aoiIndex = -1
        self.foglioIndex = 0
        self.show_values = []
        self.sezioneIndex = 0
        self.filter_s = ''
        self.show_values_s = []
        self.particellaIndex = 0
        self.foglio_values = []
        self.sezione_values = []
        self.gruppoIndex = 0
        self.algoritmoIndex = 0
        self.out_tempdir_s = ''
        self.lyr = ''
        self.group_names = []
        self.algo_names = []
        self.cdu_path_folder = ''
        self.CduTitle = 'Certificato di Destinazione Urbanistica (CDU)'
        self.CduComune = ''
        self.input_logo_path = ''
        self.checkAreaBox = False
        self.checkAreaPercBox = False
        self.checkIntBox = False
        self.root = ''
        self.input_file_path = ''
        self.input_txt_path = ''
        self.cdu_file_name = ''
        self.protocollo = ''
        self.richiedente = ''
        self.data = QDate.currentDate()
        self.checkDataBox = False
        self.sez_list = []
        self.fog_list = []
        self.map_list = []
        self.catasto_alias = {}
        self.checkOdtBox = False
        self.checkMapBox = False 
        self.checkIntBox = False # modifica aggiunta sarah
        
        if self.out_tempdir_s != '':
            self.out_tempdir_s.cleanup()

        self.out_tempdir_s = None

        from qgis.utils import reloadPlugin
        reloadPlugin("CduCreator")
            

    def run(self):
        #print(show_values_s)
        #print(self.sezioneIndex)
        self.dlg.tabWidget.setCurrentIndex(2)
        
        if self.gruppoIndex == 0:
            self.dlg.textLog.append(self.tr('ATTENZIONE: nessun gruppo è stato selezionato, selezionare il gruppo contenete i dati urbanistici\n'))
            return
            
        if self.cdu_path_folder == '':
            self.dlg.textLog.append(self.tr('ERRORE: nessuna cartella di output è stata selezionata\n'))
            return
            
        if os.path.isdir(self.cdu_path_folder) == False:
            self.dlg.textLog.append(self.tr('ERRORE: la cartella {} non esiste\n'.format(self.cdu_path_folder)))
            return

            
        self.dlg.textLog.setText(self.tr('INIZIO PROCESSO...\nPotrebbe richiedere un po\' di tempo a seconda del numero di particelle selezionate. Attendere la fine del processo.\n'))
        QCoreApplication.processEvents()
        
        if self.dlg.algoComboBox.currentIndex() == 1:
            self.dlg.textLog.append(self.tr('ATTENZIONE: è stato scelto come algoritmo di intersezione "GDAL - Ritaglia con maschera".\nIl processo potrebbe richiedere un po\' più di tempo. Attendere la fine del processo.\n'))
            QCoreApplication.processEvents()
            
        param_file = open(self.param_txt, "w")
        param_file.write(self.cdu_path_folder + '\n')
        param_file.write(str(self.checkOdtBox) + '\n')
        param_file.write(str(self.checkMapBox) + '\n')
        param_file.write(self.CduTitle + '\n')
        param_file.write(self.CduComune + '\n')
        param_file.write(self.input_logo_path + '\n')
        param_file.write(self.input_txt_path + '\n')
        param_file.write(str(self.checkAreaBox) + '\n')
        param_file.write(str(self.checkAreaPercBox) + '\n')
        param_file.write(str(self.checkIntBox) + '\n')
        param_file.close()

        result = True
        # See if OK was pressed
        if result:
            # ensure previous tempdir is removed, then create a fresh one
            if self.out_tempdir_s:
                try:
                    self.out_tempdir_s.cleanup()
                except Exception:
                    pass
            self.out_tempdir_s = tempfile.TemporaryDirectory()
            out_tempdir = self.out_tempdir_s
                        
            selectedGroupIndex = self.dlg.gruppoComboBox.currentIndex()
            #print (selectedGroupIndex)
            selectedGroup = self.group_names[selectedGroupIndex - 1]
            #print (selectedGroup)
            
            selectedAlgoIndex = self.dlg.algoComboBox.currentIndex()
            #print (selectedAlgoIndex)
            selectedAlgo = self.algo_names[selectedAlgoIndex]
            #print (selectedAlgo)
            
            if self.lyr.selectedFeatureCount() > 0:
                selectedF = self.lyr.selectedFeatures()
                self.dlg.textLog.append(self.tr('Sono state selezionate {} particelle.\n'.format(self.lyr.selectedFeatureCount())))
                QCoreApplication.processEvents()
            else:
                self.dlg.textLog.append(self.tr('ATTENZIONE: nessuna particella è stata selezionata, selezionare almeno un mappale\n'))
                return
            
            #zoom alla selezione
            box = self.lyr.boundingBoxOfSelected()
            map = iface.mapCanvas()
            map.setExtent(box)
            map.refresh()

            #crea gruppo per layers temporanei
            new_group_lyr = self.root.insertGroup(0, 'temp')
            new_group_lyr.setExpanded(False)
            
            #salva le feat selezionate in uno shp, lo aggiunge al gruppo e cambia lo stile (per usarla nell'img)
            processing.run("native:saveselectedfeatures", { 'INPUT' : self.lyr, 
                        'OUTPUT' : '{}/aoi.shp'.format(out_tempdir.name) })
            aoi_pathfile = os.path.join(out_tempdir.name, 'aoi.shp')
            lyr_aoi = QgsVectorLayer(aoi_pathfile, 'aoi')
            QgsProject.instance().addMapLayers([lyr_aoi], False)
            new_group_lyr.insertLayer(-1, lyr_aoi)
            aoi_symbol = QgsFillSymbol.createSimple({'border_width_map_unit_scale': '3x:0,0,0,0,0,0', 'color': '243,166,178,0', 'outline_color': '255,255,0,255', 'outline_style': 'solid', 'outline_width': '0.6', 'outline_width_unit': 'MM'})
            lyr_aoi.renderer().setSymbol(aoi_symbol)
            lyr_aoi.triggerRepaint()
            iface.layerTreeView().refreshLayerSymbology(lyr_aoi.id())
            
            #iterazione sulle particelle selezionate, in questo ciclo vengono recuperate le informazioni dalle tabelle degli attributi dei layer urbanistici
            sez_sel_list = []
            fog_sel_list = []
            map_sel_list = []
            temp_feat = []
            temp_feat_name = 0
            temp_dict = {}
            temp_skipped_msgs = {}   # <-- raccolta messaggi da inserire nel CDU per particella
            skipped_particelle = []  # <-- elenco unico di (foglio, mappale, sezione) interessate dallo skipdict_to_print = {}
            dict_to_print = {}      # <-- corregge NameError: inizializza il contenitore usato dopo
            msg_nome_check = 0
            msg_descr_check = 0
            msg_rif_check = 0
            msg_art_check = 0
            count_map = 0
            for ii in selectedF:
                count_map += 1
                self.dlg.textLog.append(self.tr('Elaborazione particella n. {} di {}.\n'.format(count_map, self.lyr.selectedFeatureCount())))
                QCoreApplication.processEvents()
                if self.lyr.fields().lookupField("SEZIONE") != -1:
                    #print('la sezione esiste')
                    sel_sezione = ii[self.sez_list[0].casefold()]
                    sez_sel_list.append(sel_sezione)
                    #print('la sezione è {}'.format(sel_sezione))
                else:
                    sel_sezione = 'NULL'
                    sez_sel_list.append(sel_sezione)

                sel_foglio = ii[self.fog_list[0].casefold()]
                fog_sel_list.append(sel_foglio)
                #print('il foglio è {}'.format(sel_foglio))
                sel_particella = ii[self.map_list[0].casefold()]
                map_sel_list.append(sel_particella)
                #print('il mappale è {}'.format(sel_particella))
                if sel_sezione == NULL or sel_sezione == '' or sel_sezione == '-' or sel_sezione == 'NULL':
                    stringa_cat = '<p> Il terreno oggetto della richiesta e distinto in Catasto al foglio <b>' + sel_foglio + '</b> con il mappale <b>' + sel_particella + '</b> interseca le seguenti mappe del <b>' + selectedGroup + '</b>:<br></p>'
                else:
                    stringa_cat = '<p> Il terreno oggetto della richiesta e distinto in Catasto alla sezione <b>' + sel_sezione + '</b> e al foglio <b>' + sel_foglio + '</b> con il mappale <b>' + sel_particella + '</b> interseca le seguenti mappe del <b>' + selectedGroup + '</b>:<br></p>'

                #salva la singola feat selezionata in un memory layer e lo aggiunge al gruppo (necessario per il clip)
                vl = QgsVectorLayer("Polygon?crs={}".format(self.lyr.crs().authid()), "temporary_feat{}".format(temp_feat_name), "memory")
                temp_feat.append(vl)
                pr = vl.dataProvider()
                vl.startEditing()
                pr.addFeatures( [ ii ] )
                vl.commitChanges()
                QgsProject.instance().addMapLayer(vl, False)
                new_group_lyr.insertLayer(-1, vl)
                
                for fl_feat in vl.getFeatures():
                    # calcola area della particella selezionata in m² (CRS sempre proiettato)
                    area_sel = fl_feat.geometry().area()
                temp_feat_name += 1
                
                #legge gruppi, sottogruppi e layers nel layer tree e aggiunge a un dizionario solo quelli che intersecano l'area di interesse
                lyrs = []
                lyrs_tmp = []
                layers = []
                layers_name = []
                subgr_name = []
                layers_dict = {}
                
                for child in self.root.children():
                    if isinstance(child, QgsLayerTreeGroup):
                        if child.name() == selectedGroup:
                            for gr in child.children():
                                if isinstance(gr, QgsLayerTreeGroup):
                                #print(gr.name())
                                    lyrs_tmp = gr.findLayers()
                                    for lt in lyrs_tmp:
                                        lyrs.append(lt)
                                        subgr_name.append(gr.name())
                                elif isinstance(gr, QgsLayerTreeLayer):
                                    subgr_name.append('')
                                    lyrs.append(gr)
                            g = 0
                            for l in lyrs:
                                #print(lyr.name())
                                #print(lyr.layerId())
                                processing.run("native:selectbylocation", {'INPUT': l.layer(),
                                        'PREDICATE': [0],
                                        'INTERSECT': vl,
                                        'METHOD': 0})
                                if l.layer().selectedFeatureCount() > 0:
                                    #print('{} interseca {}'.format(vl.name(), l.name()))
                                    layers.append(l.layer())
                                    layers_name.append(l.name())
                                    layers_dict[layers[-1]] = (subgr_name[g], layers_name[-1])
                                    l.layer().removeSelection()
                                g += 1
                
                
                if len(layers) > 0:
                    #print(len(layers))
                    shp_count = 0
                    pos = 0
                    intersec_name = []
                    print_dict = {}
                    empty_clip = 0
                    check_feat = 0
                    check_double = 0
                    for key, value in layers_dict.items():
                        file_name = 'intersect_{}_{}.gpkg'.format(shp_count, vl.name())
                        try:
                            if selectedAlgoIndex == 0:
                                processing.run("native:clip", {'INPUT': key,
                                    'OVERLAY': vl,
                                    'OUTPUT': '{}/{}'.format(out_tempdir.name, file_name)})
                            else:
                                processing.run("gdal:clipvectorbypolygon", {'INPUT': key,
                                    'MASK': vl,
                                    'OUTPUT': '{}/{}'.format(out_tempdir.name, file_name)})
                        except:
                            self.dlg.textLog.append(self.tr('ATTENZIONE: sono stati riscontrati problemi nell\'intersezione fra la particella selezionata e il layer {}. Il CDU non verrà creato.\n'.format(layers_dict[key][1])))
                            QCoreApplication.processEvents()
                            rm_group = self.root.findGroup('temp')
                            if rm_group is not None:
                                for child in rm_group.children():
                                    QgsProject.instance().removeMapLayer(child.layerId())
                                self.root.removeChildNode(rm_group)
                            # assicurati di pulire la directory temporanea prima di uscire
                            try:
                                if self.out_tempdir_s:
                                    self.out_tempdir_s.cleanup()
                            except Exception:
                                pass
                            self.out_tempdir_s = None
                            map.refresh()
                            return

                        int_lyr_pathfile = os.path.join(out_tempdir.name, file_name)
                        int_lyr_name = file_name.split('.')
                        lyr_intersect = QgsVectorLayer(int_lyr_pathfile, int_lyr_name[0])
                        QgsProject.instance().addMapLayers([lyr_intersect], False)
                        new_group_lyr.insertLayer(pos, lyr_intersect)
                        pos += 1
                        shp_count += 1
                        intersec_name.append(int_lyr_name[0])
                        layers_dict[key] = (value[0], value[1], intersec_name[-1])
                        
                        alias = key.attributeAliases()
                        #print(key.name())
                        #print(alias)
                        descr_list = []
                        nome_list = []
                        rif_list = []
                        art_list = []
                        descr_check = 0
                        nome_check = 0
                        rif_check = 0
                        art_check = 0
                        for keys, values in alias.items():
                            if values.casefold() == 'descrizione'.casefold() or keys.casefold() == 'descrizione'.casefold():
                                descr_list.insert(0, keys)
                                descr_check += 1
                            if values.casefold() == 'nome'.casefold() or keys.casefold() == 'nome'.casefold():
                                nome_list.insert(0, keys)
                                nome_check += 1
                            if values.casefold() == 'riferimento legislativo'.casefold() or keys.casefold() == 'riferimento legislativo'.casefold():
                                rif_list.insert(0, keys)
                                rif_check += 1
                            if values.casefold() == 'articolo'.casefold() or keys.casefold() == 'articolo'.casefold():
                                art_list.insert(0, keys)
                                art_check += 1

                        sel_lyr_int = QgsProject.instance().mapLayersByName(layers_dict[key][2])
                        
                        
                        # per il filtro: conteggio geometrie ignorate
                        skipped_small = 0
                        skipped_details = []  # raccolta dettagliata per il log
                        for fl in sel_lyr_int[0].getFeatures():
                            if sel_lyr_int[0].featureCount() > 0:
                                unique_id = layers_dict[key][2] + '_' + str(fl.id())
                                # calcola area di intersezione in m² (compatibile con più versioni di QGIS)
                                area = fl.geometry().area()
                                # filtro richiesto: ignora intersezioni < 1 m² se checkbox attiva
                                if self.checkIntBox and area < 1.0:
                                    skipped_small += 1
                                    # salva dettaglio: (layer-nome, fid, area, foglio, mappale, sezione)
                                    skipped_details.append(
                                        (layers_dict[key][1], fl.id(), area, sel_foglio, sel_particella, sel_sezione)
                                    )
                                    continue
                                area_perc = (area * 100 / area_sel) 
                                if descr_check == 1:
                                    descr = '- Descrizione: {}'.format(fl[descr_list[0]])
                                    if fl[descr_list[0]] == NULL:
                                        descr = '- Descrizione: -'
                                else:
                                    descr = '- Descrizione: -'
                                if nome_check == 1:
                                    nome = '- Nome: {}'.format(fl[nome_list[0]])
                                    if fl[nome_list[0]] == NULL:
                                        nome = '- Nome: -'
                                else:
                                    nome = '- Nome: -'
                                if rif_check == 1:
                                    rif_leg = '- Riferimento legislativo: {}'.format(fl[rif_list[0]])
                                    if fl[rif_list[0]] == NULL:
                                        rif_leg = '- Riferimento legislativo: -'
                                else:
                                    rif_leg = '- Riferimento legislativo: -'
                                if art_check == 1:
                                    rif_nto = '- Articolo: {}'.format(fl[art_list[0]])
                                    if fl[art_list[0]] == NULL:
                                        rif_nto = '- Articolo: -'
                                else:
                                    rif_nto = '- Articolo: -'
                                if area < 0.5:
                                    area_tot = '- Area intersecata (m<sup>2</sup>): {:,.3f}'.format(area).replace(",", ".")
                                else:
                                    area_tot = '- Area intersecata (m<sup>2</sup>): {:,.0f}'.format(area).replace(",", ".")
                                if area_perc < 0.5:
                                    area_tot_perc = '- Area intersecata (%): {}'.format(round(area_perc, 3))
                                else:
                                    area_tot_perc = '- Area intersecata (%): {}'.format(round(area_perc))
                                if layers_dict[key][0]:
                                    sbgr_lyr = '{} - {}'.format(layers_dict[key][0], layers_dict[key][1])
                                else:
                                    sbgr_lyr = '{}'.format(layers_dict[key][1])
                                print_dict[unique_id] = (sbgr_lyr, nome, descr, rif_leg, rif_nto, area_tot, area_tot_perc)
                                if not stringa_cat in temp_dict.keys():
                                    temp_dict[stringa_cat] = print_dict
                                    check_double += 1
                                check_feat += 1
                        if skipped_small > 0:
                            # messaggio riepilogativo + dettaglio per geometria
                            self.dlg.textLog.append(self.tr(
                                'ATTENZIONE: {} geometrie con area intersecata < 1 m² ignorate nel layer {}.\n'
                                .format(skipped_small, layers_dict[key][1])
                            ))
                            # crea snippet HTML da inserire nel CDU (riferimento alla particella)
                            note_html = (
                                '<p style="font-size:9pt; color:#555;">'
                                '<b>Nota informativa</b><br>'
                                'Si informa che, ai fini della redazione del presente documento, '
                                'per motivi di validità topologica delle geometrie, non sono state considerate '
                                'le aree che intersecano l’area di interesse con superficie inferiore a 1 m<sup>2</sup> '
                                '(riferimento: Foglio <b>{}</b>, Mappale <b>{}</b>).'
                                '</p>'
                            ).format(sel_foglio, sel_particella)
                            # salva il messaggio associato alla stringa_cat corrente
                            temp_skipped_msgs[stringa_cat] = note_html
                            # registra la particella (evita duplicati)
                            part_key = (str(sel_foglio), str(sel_particella), None if sel_sezione in (None, 'NULL', '') else str(sel_sezione))
                            if part_key not in skipped_particelle:
                                skipped_particelle.append(part_key)
                            # dettaglio nel log (come già fatto)
                            for lay_name, fid, a, fog, mapp, sez in skipped_details:
                                a_fmt = round(a, 3) if a < 1 else int(round(a))
                                sez_txt = '' if (sez == 'NULL' or sez == '' or sez is None) else f', Sez. {sez}'
                                self.dlg.textLog.append(self.tr(
                                    " - {}: fid={} (area {} m²) — Foglio {}, Mappale {}{}\n"
                                    .format(lay_name, fid, a_fmt, fog, mapp, sez_txt)
                                ))
                            QCoreApplication.processEvents()
                    #check su eventuali particelle che non intersecano nulla ma per cui il clip genera comunque un layer senza features
                    if check_feat == 0:
                        if sel_sezione == 'NULL' or sel_sezione == '' or sel_sezione == '-' or sel_sezione == NULL:
                            self.dlg.textLog.append(self.tr('ATTENZIONE: il terreno identificato dal foglio {} e mappale {} non interseca alcun layer.\n'.format(sel_foglio, sel_particella)))
                            QCoreApplication.processEvents()
                        else:
                            self.dlg.textLog.append(self.tr('ATTENZIONE: il terreno identificato dalla sezione {}, foglio {} e mappale {} non interseca alcun layer.\n'.format(sel_sezione, sel_foglio, sel_particella)))
                            QCoreApplication.processEvents()
                            
                    #check su eventuali particelle con setesso valore per sezione, foglio e mappale
                    if check_double == 0:
                        if sel_sezione == 'NULL' or sel_sezione == '' or sel_sezione == '-' or sel_sezione == NULL:
                            self.dlg.textLog.append(self.tr('ATTENZIONE: è stata trovata un\'altra particella con foglio {} e mappale {}. Non verrà stampata nel CDU. Verificare il layer terreni_catastali.\n'.format(sel_foglio, sel_particella)))
                            QCoreApplication.processEvents()
                        else:
                            self.dlg.textLog.append(self.tr('ATTENZIONE: è stata trovata un\'altra particella con sezione {}, foglio {} e mappale {}. Non verrà stampata nel CDU. Verificare il layer terreni_catastali.\n'.format(sel_sezione, sel_foglio, sel_particella)))
                            QCoreApplication.processEvents()

                    for key_td, value_td in temp_dict.items():
                        #print('questa è la chiave: {}'.format(key_pl))
                        #print('questa è il valore: {}'.format(value_pl))
                        text = ''
                        for ktd, vtd in value_td.items():
                            if self.checkAreaBox == True and self.checkAreaPercBox == True:
                                text += '<p><b>' + vtd[0] + '</b><br>' + vtd[1] + '<br>' + vtd[2] + '<br>' + vtd[3] + '<br>' + vtd[4] + '<br>' + vtd[5] + '<br>' + vtd[6] +'<br><br></p>'
                            elif self.checkAreaBox == True and self.checkAreaPercBox == False:
                                text += '<p><b>' + vtd[0] + '</b><br>' + vtd[1] + '<br>' + vtd[2] + '<br>' + vtd[3] + '<br>' + vtd[4] + '<br>' + vtd[5] + '<br><br></p>'
                            elif self.checkAreaBox == False and self.checkAreaPercBox == True:
                                text += '<p><b>' + vtd[0] + '</b><br>' + vtd[1] + '<br>' + vtd[2] + '<br>' + vtd[3] + '<br>' + vtd[4] + '<br>' + vtd[6] + '<br><br></p>'
                            else:
                                text += '<p><b>' + vtd[0] + '</b><br>' + vtd[1] + '<br>' + vtd[2] + '<br>' + vtd[3] + '<br>' + vtd[4] + '<br><br></p>'
                        dict_to_print[key_td] = text
                        
                else:
                    if sel_sezione == 'NULL' or sel_sezione == '' or sel_sezione == '-' or sel_sezione == NULL:
                        self.dlg.textLog.append(self.tr('ATTENZIONE: il terreno identificato dal foglio {} e mappale {} non interseca alcun layer.\n'.format(sel_foglio, sel_particella)))
                        QCoreApplication.processEvents()
                    else:
                        self.dlg.textLog.append(self.tr('ATTENZIONE: il terreno identificato dalla sezione {}, foglio {} e mappale {} non interseca alcun layer.\n'.format(sel_sezione, sel_foglio, sel_particella)))
                        QCoreApplication.processEvents()
            
            self.lyr.removeSelection()

            #crea la printer per stampare il pdf
            printer = QPrinter()
            printer.setPageSize(QPrinter.A4)
            #printer.setPageMargins(10, 10, 10, 10, QPrinter.Millimeter)
            printer.setFullPage(True)
            printer.setOutputFormat(QPrinter.PdfFormat)
            if self.cdu_file_name == '':
                cdu_pdf_name = 'cdu_{}.pdf'.format(datetime.now().strftime("%d%m%Y_%H%M%S"))
            else:
                cdu_pdf_name = '{}.pdf'.format(self.cdu_file_name)
            #print('il nome file è {}'.format(cdu_pdf_name))
            cdu_pdf_path = os.path.join(self.cdu_path_folder, cdu_pdf_name)
            printer.setOutputFileName(cdu_pdf_path)

            #compone l'html e stampa il pdf
            stringa = '<!DOCTYPE html><html><head><style>p {font-size: 13px;}</style></head><body>'
            if self.input_logo_path != '':
                if os.path.isfile(self.input_logo_path):
                    im = Image.open(self.input_logo_path)
                    #print(im.size)   # return value is a tuple, ex.: (1200, 800)
                    w = im.size[0]
                    h = im.size[1]
                    fw = 60 * w/h
                    stringa += '<p style="text-align:center; vertical-align: middle;"><img height="60" width="' + str(round(fw)) + '" src="' + self.input_logo_path + '"></p>'
                else:
                    self.dlg.textLog.append(self.tr('ATTENZIONE: il file {} non è stato trovato, il Logo non verrà stampato.\n'.format(self.input_logo_path)))
                    QCoreApplication.processEvents()
            stringa += '<h2 style="text-align:center">' + self.CduTitle + ' - Comune di ' + self.CduComune + '</h2>'
            stringa += '<hr><br>'
            if self.protocollo == '':
                stringa += '<p>Prot. n°<br>'
            else:
                stringa += '<p>Prot. n° ' + self.protocollo + '<br>'
            if self.checkDataBox == False:
                stringa += 'Lì, </p>'
            else:
                stringa += 'Lì, ' + self.data.toString( Qt.DefaultLocaleShortDate) + '</p>'
            stringa += '<h3 style="text-align:center">Il Responsabile del Servizio</h3>'
            if self.richiedente == '':
                stringa += '<p>Vista la richiesta del _________________________________________________________ <br><br>'
            else:
                stringa += '<p>Vista la richiesta del <i>' + self.richiedente + ' </i>'
            if self.checkDataBox == False:
                stringa += 'presentata in data ____/____/____ '
            else:
                stringa += 'presentata in data <i>' + self.data.toString( Qt.DefaultLocaleShortDate) + '  </i>'
            if self.protocollo == '':
                stringa += 'prot. n. ________;<br></p>'
            else:
                stringa += 'prot. n. <i>' + self.protocollo + '</i>;<br></p>'
            if self.input_txt_path != '':
                if os.path.isfile(self.input_txt_path):
                    txt_file = open(self.input_txt_path, "r")
                    #print(file.read())
                    for line in txt_file:
                        stringa += '<div style="font-size: 13px;">' + line + '</div>'
                    txt_file.close()
                else:
                    self.dlg.textLog.append(self.tr('ATTENZIONE: il file TXT {} non è stato trovato, il Testo non verrà stampato.\n'.format(self.input_txt_path)))
                    QCoreApplication.processEvents()
            stringa += '<h3 style="text-align:center">Attesta e Certifica che</h3>'
            
            
            for key_dtp, value_dtp in dict_to_print.items():
                stringa += key_dtp
                stringa += value_dtp
                                   

            if self.checkMapBox == True:
                #crea immagine della mappa centrata sull'area di interesse
                img = QImage(QSize(500, 500), QImage.Format_ARGB32_Premultiplied)

                settings = QgsMapSettings()
                img_layers = QgsProject.instance().mapLayersByName('terreni_catastali')
                img_layers2 = QgsProject.instance().mapLayersByName('aoi')
                print_layers = layers.copy()
                print_layers.insert(0, img_layers[0])
                print_layers.insert(0, img_layers2[0])
                settings.setDestinationCrs(iface.mapCanvas().mapSettings().destinationCrs())
                settings.setLayers(print_layers)
                rect = QgsRectangle(box)
                rect.scale(2.5)
                settings.setExtent(rect)
                settings.setOutputSize(img.size())
                
                #salva l'immagine della mappa come png
                pdfPainter = QPainter()
                pdfPainter.begin(img)
                render = QgsMapRendererCustomPainterJob(settings, pdfPainter)
                render.start()
                render.waitForFinished()
                pdfPainter.setPen(QPen(QColor(51, 51, 51, 255), 2.0))
                pdfPainter.drawRect(0,0,500,500);
                pdfPainter.end()
                img_path_file = os.path.join(out_tempdir.name, 'map.png')
                img.save(img_path_file)
                
                stringa += '<p style="text-align:center"><img src="' + img_path_file + '"></p>'
            stringa += (
                '<p style="text-align:center"> Il presente CDU è stato creato automaticamente in data '
                '{} alle ore {} utilizzando il plugin CDU Creator di QGIS.</p>'
            ).format(datetime.now().strftime("%d-%m-%Y"), datetime.now().strftime("%H:%M:%S"))
            # se esistono particelle con intersezioni < 1 m² scartate, inserisci avviso riassuntivo
            if skipped_particelle:
                parts = []
                for fog, mapp, sez in skipped_particelle:
                    if sez and sez not in ('NULL', ''):
                        parts.append(self.tr('Sez. {0}, Foglio {1}, Mappale {2}').format(sez, fog, mapp))
                    else:
                        parts.append(self.tr('Foglio {0}, Mappale {1}').format(fog, mapp))
                elenco = '; '.join(parts)
                note_html_template = (
                    '<p style="font-size:9pt; color:#555;">'
                    '<b>Nota informativa</b><br>'
                    'Si informa che, ai fini della redazione del presente documento, '
                    'per motivi di validità topologica delle geometrie, non sono state considerate le aree che '
                    'intersecano l’area di interesse con superficie inferiore a 1 m<sup>2</sup> '
                    '(riferimento: {})</p>'
                )
                stringa += self.tr(note_html_template).format(elenco)
            stringa += '<h3 style="text:left">Nota legale</h3>'
            stringa += (
                '<p style="text-align:justify; font-size:10pt;">'
                'Il presente certificato non può essere prodotto agli organi della Pubblica Amministrazione '
                'o ai privati gestori di Pubblici Servizi '
                '(<b>art. 15, legge 12 novembre 2011, n. 183</b>).<br>'
                'Quanto sopra ai fini e per gli effetti dell’<b>art. 30, comma 2, DPR 380/2001</b>.<br>'
                'Si rilascia la presente certificazione <i>per gli usi consentiti dalla legge</i>.'
                '</p>'
                '<p style="text-align:right">Il Responsabile del Servizio</p>'
            )
            stringa += '</body></html>'
            doc = QTextDocument()
            doc.setHtml(stringa)
            doc.print(printer)
            self.dlg.textLog.append(self.tr('Il file PDF {} è stato salvato nella cartella {}.\n'.format(cdu_pdf_name, self.cdu_path_folder)))
            QCoreApplication.processEvents()
            if self.checkOdtBox == True:
                if self.cdu_file_name == '':
                    cdu_odt_name = 'cdu_{}.odt'.format(datetime.now().strftime("%d%m%Y_%H%M%S"))
                else:
                    cdu_odt_name = '{}.odt'.format(self.cdu_file_name)
                #print('il nome file è {}'.format(cdu_pdf_name))
                cdu_odt_path = os.path.join(self.cdu_path_folder, cdu_odt_name)
                writer = QTextDocumentWriter()
                #print(writer.supportedDocumentFormats())
                writer.setFormat(QByteArray(b'ODF'))
                writer.setFileName(cdu_odt_path)
                writer.write(doc)
                self.dlg.textLog.append(self.tr('Il file ODT {} è stato salvato nella cartella {}.\n'.format(cdu_odt_name, self.cdu_path_folder)))
                QCoreApplication.processEvents()
                    
            self.dlg.textLog.append(self.tr('ATTENDERE...il processo terminerà a breve.\n'))
            QCoreApplication.processEvents()
            for k, sfm in enumerate(sez_sel_list):
                if self.sezioneIndex != 0:
                    if sfm == 'NULL' or sfm == '' or sfm == NULL:
                        self.lyr.selectByExpression("{} is NULL AND {}='{}' AND {}='{}'".format(self.sez_list[0].casefold(), self.fog_list[0].casefold(), fog_sel_list[k], self.map_list[0].casefold(), map_sel_list[k]), self.lyr.AddToSelection)
                    else:
                        self.lyr.selectByExpression("{}='{}' AND {}='{}' AND {}='{}'".format(self.sez_list[0].casefold(), sfm, self.fog_list[0].casefold(), fog_sel_list[k], self.map_list[0].casefold(), map_sel_list[k]), self.lyr.AddToSelection)
                else:
                    if sfm == 'NULL' or sfm == '' or sfm == NULL:
                        print('sez null')
                        self.lyr.selectByExpression("{}='{}' AND {}='{}'".format(self.fog_list[0].casefold(), fog_sel_list[k], self.map_list[0].casefold(), map_sel_list[k]), self.lyr.AddToSelection)
                    else:
                        #print('sez not null')
                        self.lyr.selectByExpression("{}='{}' AND {}='{}' AND {}='{}'".format(self.sez_list[0].casefold(), sfm, self.fog_list[0].casefold(), fog_sel_list[k], self.map_list[0].casefold(), map_sel_list[k]), self.lyr.AddToSelection)

            #rimuove il gruppo temporaneo
            rm_group = self.root.findGroup('temp')
            if rm_group is not None:
                for child in rm_group.children():
                    QgsProject.instance().removeMapLayer(child.layerId())
                self.root.removeChildNode(rm_group)
            map.refresh()
            # pulizia sicura della cartella temporanea usata dal run()
            try:
                if self.out_tempdir_s:
                    self.out_tempdir_s.cleanup()
            except Exception:
                pass
                self.out_tempdir_s = None
            self.dlg.textLog.append(self.tr('PROCESSO TERMINATO...\n'))
            QCoreApplication.processEvents()
