# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CCTVMapper
                                 A QGIS plugin
 The plugin plots CCTV Mapper using a CSV file
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-06-20
        git sha              : $Format:%H$
        copyright            : (C) 2019 by Ed B
        email                : boesiii@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtCore import QSettings, QTranslator, qVersion, QCoreApplication, QVariant
from PyQt5.QtGui import QIcon
from PyQt5.QtWidgets import QAction, QFileDialog
from qgis.core import QgsProject, QgsExpression, QgsFeatureRequest, QgsVectorLayer, QgsField,QgsFeature, QgsGeometry

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .cctv_mapper_dialog import CCTVMapperDialog
import os.path
import csv


class CCTVMapper:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'CCTVMapper_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&CCTV Mapper')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('CCTVMapper', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToVectorMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/cctv_mapper/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'CCTV Mapper'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginVectorMenu(
                self.tr(u'&CCTV Mapper'),
                action)
            self.iface.removeToolBarIcon(action)
            
    def create_mem_layer (self):
        uri = "Point?crs=epsg:2272"
        self.temp_layer = QgsVectorLayer(uri, 'temp_points','memory')
        self.provider = self.temp_layer.dataProvider()
        # add fields
        self.provider.addAttributes([QgsField('PIPE_ID', QVariant.String),
                                    QgsField('LOCATION',  QVariant.String),
                                    QgsField('START_MH',  QVariant.String),
                                    QgsField('END_MH',  QVariant.String),
                                    QgsField('TOT_LEN',  QVariant.String),
                                    QgsField('SURV_LEN',  QVariant.String),
                                    QgsField('MAIN_DIA',  QVariant.String),
                                    QgsField('MAIN_MATL',  QVariant.String),
                                    QgsField('DIRECTION',  QVariant.String),
                                    QgsField('DISTANCE',  QVariant.String),
                                    QgsField('CODE',  QVariant.String),
                                    QgsField('DESCR',  QVariant.String),
                                    QgsField('CLOCK',  QVariant.String),
                                    QgsField('LAT_DIA',  QVariant.String),
                                    QgsField('GRADE',  QVariant.String),
                                    QgsField('COMMENT',  QVariant.String),
                                    QgsField('ERROR',  QVariant.String),
                                    
                                    ]) #if attributes are added then you will need to populate them when creating points
        self.temp_layer.updateFields() # tell the vector layer to fetch changes from the provider
        # QgsMapLayerRegistry.instance().addMapLayer(self.temp_layer)
        QgsProject.instance().addMapLayer(self.temp_layer)
        
    def create_point (self, data):
        #create point feature
        ft =  QgsFeature()
        # print (point)
        ft.setGeometry(data[-1])
        # Every attribute has to be filled in when creating new features for temporary layers
        # print (data[0:16])                  
        ft.setAttributes(data[0:17])
        self.provider.addFeature(ft)
        self.temp_layer.updateExtents()
        print ('created point')
            
    def select_csv_file(self):
        csv_folder = os.path.join(os.getenv('APPDATA') + '/QGIS/QGIS3/profiles/default/python/plugins/cctv_mapper/data/')
        print (csv_folder)
        filename, _filter = QFileDialog.getOpenFileName(self.dlg, 'Select output file', csv_folder, '*.csv')
        self.dlg.lineEdit.setText(filename)
        
        
    def get_point_geometry(self, pid, dist, direction):
        # print (pid)
        exp = QgsExpression('FACILITYID = \'' + pid + '\'')
        request = QgsFeatureRequest(exp)
        selection = self.layer.getFeatures(request)        
        for feature in selection:
            feature_length = feature.geometry().length()
            print (feature_length)
            if (direction != 'Downstream'):
                dist = feature_length - dist
            if (dist > feature_length):
                length_error = 'distance longer than feature length point placed at end'
            else:
                length_error = 'none'
                
    
            pt_geom = feature.geometry().interpolate(dist)
        return pt_geom, length_error


    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = CCTVMapperDialog()
            self.dlg.pushButton.clicked.connect(self.select_csv_file)
            
        # Fetch the currently loaded layers
        layers = QgsProject.instance().layerTreeRoot().children()
        # Clear the contents of the comboBox from previous runs
        self.dlg.comboBox.clear()
        # Populate the comboBox with names of all the loaded layers
        self.dlg.comboBox.addItems([layer.name() for layer in layers])

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            # pass
            
            filename = self.dlg.lineEdit.text()
            selectedLayerIndex = self.dlg.comboBox.currentIndex()
            self.layer = layers[selectedLayerIndex].layer()
            self.create_mem_layer ()
            # points = []
            new_points = []
            # pt = ''
            with open(filename, 'r') as csv_file:
                csv_reader = csv.reader(csv_file, delimiter=',')
                next(csv_reader)
                for row in csv_reader:
                    # print (row)
                    # if lin
                    point,error = self.get_point_geometry (row[0], float(row[9]), row[8])
                    # print (point)
                    row.append(error)                   
                    row.append(point)
                    new_points.append(row)
                    # points.append(point)
                    # pipeid = row[0]
                    # print (row)
                # print csv_reader
                
            # for point in points:
                # print (point)
                # self.create_point (point)
            
            # print (new_points)
            
            for item in new_points:
                self.create_point (item)
