# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CAV
                                 A QGIS plugin
Realiza o cálculo, comparação e análises estatísticas do volume e área
referente a determinada cota de um modelo digital de terreno.

 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-01-19
        git sha              : $Format:%H$
        copyright            : (C) 2023 by  Felipe Catão Mesquita Santos;
                                            Julio Cesar de Oliveira;
                                            Italo Oliveira Ferreira
        email                : felipe.mesquita@ufv.com; oliveirajc@ufv.br;
                               italo.ferreira@ufv.br
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, QVariant, QStandardPaths
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QFileDialog, QTableWidgetItem, QMessageBox, QProgressBar, QListWidget, QWidget
from qgis.core import *



from .resources import *

import os.path
import processing
import os
import matplotlib.pyplot as plt
import numpy as np
def r2_score_manual(y_true, y_pred):
    ss_res = np.sum((y_true - y_pred) ** 2)
    ss_tot = np.sum((y_true - np.mean(y_true)) ** 2)
    r2_score = 1 - (ss_res / ss_tot)
    return r2_score


import reportlab.lib.pagesizes as pagina
import sqlite3
import pandas as pd
from .CAV_dialog import CAVDialog
from .database_FT import Data_base_FT
from reportlab.lib.pagesizes import A4
from reportlab.platypus import Table, TableStyle
from reportlab.lib import colors
from reportlab.lib.units import inch
from reportlab.pdfgen import canvas


class CAV:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """



        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'CAV_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&CAV')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None


    def setWindowTitle(self, param):
        pass


# noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('CAV', message)

    def add_action(
            self,
            icon_path,
            text,
            callback,
            enabled_flag=True,
            add_to_menu=True,
            add_to_toolbar=True,
            status_tip=None,
            whats_this=None,
            parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/CAV/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Cota_Area_Volume'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&CAV'),
                action)
            self.iface.removeToolBarIcon(action)

    def carregaRaster(self):
        """ preencher o combobox com as layers raster do projeto"""
        self.dlg.comboBox.clear()
        self.dlg.comboBox_5.clear()
        lista_layers = [layer for layer in QgsProject.instance().mapLayers().values()]
        lista_layers_raster, lista_layers_pol = [], []
        for layer in lista_layers:
            if layer.type() == QgsMapLayer.RasterLayer:
                lista_layers_raster.append(layer.name())

            if isinstance(layer, QgsVectorLayer) and layer.geometryType() == QgsWkbTypes.PolygonGeometry:
                lista_layers_pol.append(layer.name())
        self.dlg.comboBox.addItems(lista_layers_raster)
        self.dlg.comboBox_5.addItems(lista_layers_pol)
        self.estatistica()


    def carregaRaster_2(self):
        """ preencher o combobox com as layers raster do projeto"""
        self.dlg.comboBox_2.clear()
        lista_layers = [layer for layer in QgsProject.instance().mapLayers().values()]
        lista_layers_raster = []
        for layer in lista_layers:
            if layer.type() == QgsMapLayer.RasterLayer:
                lista_layers_raster.append(layer.name())
        self.dlg.comboBox_2.addItems(lista_layers_raster)
        self.estatistica_2()


    def abrirRaster(self):
        """ abre uma janela para selecionar o raster no HD"""
        camada_abrir = str(QFileDialog.getOpenFileName(caption="Escolha a camada...", filter="GTiff (*.tif)")[0])
        img = QgsRasterLayer(camada_abrir, str.split(os.path.basename(camada_abrir), ".")[0],'gdal')
        # adicionar dado na tela caso a camada_abrir tiver conteudo
        if (camada_abrir != ""):
            if img.isValid():
                if (self.dlg.checkBox_4.isChecked()):
                    if img.crs() != self.camadaEnt_3().crs():
                        msg = QMessageBox()
                        msg.setIcon(QMessageBox.Information)
                        msg.setWindowTitle("Atenção")
                        msg.setText("Os arquivos (limite e MDT) não possuem o mesmo EPSG.")
                        msg.exec()
                        return ()

                self.iface.addRasterLayer(camada_abrir, str.split(os.path.basename(camada_abrir), ".")[0])
                self.carregaRaster()
                self.estatistica()
                if (self.dlg.checkBox_2.isChecked()):
                    self.carregaRaster_2()
                    self.estatistica_2()
                    self.dlg.comboBox_2.setCurrentText(camada_abrir)
                    self.dlg.comboBox.setCurrentText(
                    self.dlg.comboBox.currentText())  # recupera o reservatorio nº1 selecionado
                    self.estatistica()  # recupera a estatistica do reservatorio nº1


    def abrirVetor(self):
        """ abre uma janela para selecionar o vetor no HD"""
        camada_abrir = str(QFileDialog.getOpenFileName(caption="Escolha a camada...", filter="shape (*.shp)")[0])
        layer = QgsVectorLayer(camada_abrir, str.split(os.path.basename(camada_abrir), ".")[0], "ogr")
        # adicionar dado na tela caso a camada_abrir tiver conteudo e se for shape com geometria do tipo poligono
        if (camada_abrir != ""):
            if layer.isValid():
                if layer.geometryType() == QgsWkbTypes.PolygonGeometry:
                    self.iface.addVectorLayer(camada_abrir, str.split(os.path.basename(camada_abrir), ".")[0],"ogr")
                    self.carregaRaster()
                else:
                    msg = QMessageBox()
                    msg.setIcon(QMessageBox.Information)
                    msg.setWindowTitle("Atenção")
                    msg.setText("A geometria do arquivo tem que ser do tipo polígono!")
                    msg.exec()

    def camadaEnt(self):
        """ definir uma layer especifica no combobox"""
        layer_limite = None
        nomecamada = self.dlg.comboBox.currentText()
        for lyr in QgsProject.instance().mapLayers().values():
            if lyr.name() == nomecamada:
                layer_limite = lyr
                break
        return layer_limite

    def camadaEnt_2(self):
        """ definir uma layer especifica no combobox"""
        layer_limite = None
        nomecamada = self.dlg.comboBox_2.currentText()
        for lyr in QgsProject.instance().mapLayers().values():
            if lyr.name() == nomecamada:
                layer_limite = lyr
                break
        return layer_limite

    def camadaEnt_3(self):
        """ definir uma layer especifica no combobox"""
        layer_limite = None
        nomecamada = self.dlg.comboBox_5.currentText()
        for lyr in QgsProject.instance().mapLayers().values():
            if lyr.name() == nomecamada:
                layer_limite = lyr
                break
        return layer_limite

    def definirSaida(self):
        """ abre uma janela de dialogo para definir o local da layer a ser salvo"""
        camada_salvar = str(QFileDialog.getSaveFileName(caption="Defina o nome ...", filter="PDF files (*.pdf)")[0])
        self.dlg.lineEdit.setText(camada_salvar)

    def variaveis(self):
        """ define as variaveis utilizadas na funcao"""
        self.camada = self.camadaEnt()
        self.camada_2 = self.camadaEnt_2()
        self.limitevetor = self.camadaEnt_3()
        self.saida = self.dlg.lineEdit.text()  # endereco do arquivo a ser salvo
        self.cotamaxima = self.dlg.doubleSpinBox.value()
        self.intervalo = self.dlg.doubleSpinBox_2.value()
        self.cotamin = self.dlg.doubleSpinBox_3.value()

    def estatistica(self):
        try:
            self.dlg.listWidget.clear()
            nome = self.camadaEnt()
            if self.dlg.checkBox_4.isChecked():
                nome_vetor = self.camadaEnt_3()
                if nome_vetor.crs() == nome.crs():  # Verificar se o dados possuem o mesmo CRS
                    reserv1_recorte = processing.run("gdal:cliprasterbymasklayer",
                                        {'INPUT': nome,
                                         'MASK': nome_vetor,
                                         'SOURCE_CRS': None, 'TARGET_CRS': None, 'NODATA': None, 'ALPHA_BAND': False,
                                         'CROP_TO_CUTLINE': True, 'KEEP_RESOLUTION': True, 'SET_RESOLUTION': False,
                                         'X_RESOLUTION': None, 'Y_RESOLUTION': None, 'MULTITHREADING': False, 'OPTIONS': '',
                                         'DATA_TYPE': 0, 'EXTRA': '', 'OUTPUT': 'TEMPORARY_OUTPUT'})
                    nome = QgsRasterLayer(reserv1_recorte['OUTPUT'], str.split(os.path.basename(reserv1_recorte['OUTPUT']), ".")[0], 'gdal')
                else:
                    msg = QMessageBox()
                    msg.setIcon(QMessageBox.Information)
                    msg.setWindowTitle("Atenção")
                    msg.setText("Os arquivos (limite e MDT) não possuem o mesmo EPSG.")
                    msg.exec()
                    return ()

            stats = nome.dataProvider().bandStatistics(1)
            msg_stats = (
                "Estatística Descritiva da Imagem: \n Valor minimo = {} \n Valor maximo ={}".format(
                    round(float(stats.minimumValue), 3), round(float(stats.maximumValue), 3)))
            self.dlg.listWidget.addItem(msg_stats)

            return (stats)
        except:
            return ()

    def estatistica_2(self):
        try:
            self.dlg.listWidget_2.clear()
            nome = self.camadaEnt_2()
            if self.dlg.checkBox_4.isChecked():
                nome_vetor = self.camadaEnt_3()
                if nome_vetor.crs() == nome.crs():  # Verificar se o dados possuem o mesmo CRS
                    reserv1_recorte = processing.run("gdal:cliprasterbymasklayer",
                                                     {'INPUT': nome,
                                                      'MASK': nome_vetor,
                                                      'SOURCE_CRS': None, 'TARGET_CRS': None, 'NODATA': None,
                                                      'ALPHA_BAND': False,
                                                      'CROP_TO_CUTLINE': True, 'KEEP_RESOLUTION': True,
                                                      'SET_RESOLUTION': False,
                                                      'X_RESOLUTION': None, 'Y_RESOLUTION': None,
                                                      'MULTITHREADING': False, 'OPTIONS': '',
                                                      'DATA_TYPE': 0, 'EXTRA': '', 'OUTPUT': 'TEMPORARY_OUTPUT'})
                    nome = QgsRasterLayer(reserv1_recorte['OUTPUT'],
                                          str.split(os.path.basename(reserv1_recorte['OUTPUT']), ".")[0], 'gdal')
                else:
                    msg = QMessageBox()
                    msg.setIcon(QMessageBox.Information)
                    msg.setWindowTitle("Atenção")
                    msg.setText("Os arquivos (limite e MDT) não possuem o mesmo EPSG.")
                    msg.exec()
                    return ()

            stats = nome.dataProvider().bandStatistics(1)
            msg_stats = (
                "Estatística Descritiva da Imagem: \n Valor minimo = {} \n Valor maximo ={}".format(
                    round(float(stats.minimumValue), 3), round(float(stats.maximumValue), 3)))
            self.dlg.listWidget_2.addItem(msg_stats)

            return (stats)
        except:
            return ()

    def relatorio_PDF(self, tab_DADOS, tab_AREA, tab_VOL,tab_AREA_2, tab_VOL_2, layer_1, layer_2):
        # conectando na base de dados
        cnx = sqlite3.connect(str(QStandardPaths.standardLocations(QStandardPaths.AppDataLocation)[0]
                                  + '/profiles/default/python/plugins/cav/banco_ficha.db'))

        # endereco da imagem do cabecalho
        cabe = str(QStandardPaths.standardLocations(QStandardPaths.AppDataLocation)[0]
                   + '/profiles/default/python/plugins/cav/simbolos/cabecalho.png')
        # endereco da imagem do rodape
        roda = str(QStandardPaths.standardLocations(QStandardPaths.AppDataLocation)[0]
                   + '/profiles/default/python/plugins/cav/simbolos/rodape.png')
        reserv = pd.read_sql_query("""SELECT * FROM Ficha_tecnica""", cnx)

        id = self.dlg.tb_reservatorio.currentRow()  # identifica o reservaorio (ou linha da QTwidget) que esta selecionado

        # Crie o arquivo PDF
        c = canvas.Canvas(self.saida, pagesize=pagina.A4)
        # Adicione informações do relatório

        # cabeçalho da pagina 1
        c.drawImage((cabe), 50, 750, width=500, height= 50)
        c.setFont("Helvetica-Bold", 14)
        c.drawCentredString(300,720, "Ficha Técnica do Reservatório")
        c.setFont("Helvetica", 12)
        c.drawString(50, 700, f"Nome: {reserv['FT00'].to_list()[id]}")
        c.drawString(50, 680, f"Empresa: {reserv['FT01'].to_list()[id]}")
        c.drawString(50, 660, f"UF: {reserv['FT02'].to_list()[id]}")
        c.drawString(50, 640, f"Municípios da Margem Direita: {reserv['FT03'].to_list()[id]}")
        c.drawString(50, 620, f"Municípios da Margem Esquerda: {reserv['FT04'].to_list()[id]}")
        c.drawString(50, 600, f"Bacia Hidrográfica: {reserv['FT05'].to_list()[id]}")
        c.drawString(50, 580, f"Sub-Bacia Hidrográfica: {reserv['FT06'].to_list()[id]}")
        c.drawString(50, 560, f"Rio: {reserv['FT07'].to_list()[id]}")
        c.drawString(50, 540, f"Potência Instalada (MW): {reserv['FT08'].to_list()[id]}")
        c.drawString(50, 520, f"Vazão Média de Longo Termo (m3/S): {reserv['FT09'].to_list()[id]}")
        c.drawString(50, 500, f"Latitude / Longitude do Barramento (Coordenada Geográfica): {reserv['FT10'].to_list()[id]}")
        c.drawString(50, 480, f"Área de Drenagem Total  da UHE (km²): {reserv['FT11'].to_list()[id]}")
        c.drawString(50, 460, f"Área Incremental da UHE (km²): {reserv['FT12'].to_list()[id]}")
        c.drawString(50, 440, f"Área Inundada Original (km²): {reserv['FT13'].to_list()[id]}")
        c.drawString(50, 420, f"Área Inundada Atualizada (km²): {reserv['FT14'].to_list()[id]}")
        c.drawString(50, 400, f"Volume Útil Original (hm3): {reserv['FT15'].to_list()[id]}")
        c.drawString(50, 380, f"Volume Útil Atualizado (hm3): {reserv['FT16'].to_list()[id]}")
        c.drawString(50, 360, f"Volume Máximo Normal Original (Hm³ ): {reserv['FT17'].to_list()[id]}")
        c.drawString(50, 340, f"Volume Máximo Normal Atualizado (Hm³ ): {reserv['FT18'].to_list()[id]}")
        c.drawString(50, 320, f"Volume Máximo Maximorum Original (Hm³ ): {reserv['FT19'].to_list()[id]}")
        c.drawString(50, 300, f"Volume Máximo Maximorum Atualizado (Hm³ ): {reserv['FT20'].to_list()[id]}")
        c.drawString(50, 280, f"N.A Montante (Sistema Local) (m) -  (Max. Maximorum): {reserv['FT21'].to_list()[id]}")
        c.drawString(50, 260, f"N.A Montante (Sistema Local) (m) -  (Max. Normal): {reserv['FT22'].to_list()[id]}")
        c.drawString(50, 240, f"N.A Montante (Sistema Local) (m) -  (Min. Normal): {reserv['FT23'].to_list()[id]}")
        c.drawString(50, 220, f"N.A. Jusante (Sistema Local) (m): {reserv['FT24'].to_list()[id]}")
        c.drawString(50, 200, f"Potencial de Produção de Sedimentos (ton/km2/ano) : {reserv['FT25'].to_list()[id]}")
        c.drawString(50, 180, f"Regime de Operação do Reservatório (Ror): {reserv['FT26'].to_list()[id]}")
        c.drawString(50, 160, f"Posição Relativa da Cascata (Prc): {reserv['FT27'].to_list()[id]}")
        c.drawString(50, 140, f"Magnitude e Importância dos efeitos do assoreamento (MI): {reserv['FT28'].to_list()[id]}")
        c.drawString(50, 120, f"Nível de Criticidade  (NC): {reserv['FT29'].to_list()[id]}")
        c.drawString(50, 100, f"Data de atualização da CAV : {reserv['FT30'].to_list()[id]}")

        # rodape da pagina 1
        c.drawImage((roda), 50, 40, width=500, height=50)
        c.showPage() # encerra a pagina 1

        # cabeçalho da pagina 2
        c.drawImage((cabe), 50, 750, width=500, height=50)
        # inserir o grafico da curva CAV
        c.drawImage(str(os.path.splitext(self.saida)[0] + '_Curva_CAV.png'), 50, 350,width=500, height=400,
                    preserveAspectRatio=True)
        # rodape da pagina 2
        c.drawImage((roda), 50, 40, width=500, height=50)
        c.showPage()  # encerra a pagina 2

        # cabeçalho da pagina 3
        c.drawImage((cabe), 50, 750, width=500, height=50)

        c.setFont("Helvetica-Bold", 12)
        c.drawCentredString(300, 730,  f"RESULTADOS DO RESERVATÓRIO DE REFERÊNCIA {self.dlg.comboBox.currentText()}")
        c.setFont("Helvetica", 12)
        c.drawString(50, 710,  f"CURVAS AJUSTADAS - ÁREA (em km²)")

        # Inserindo uma tabela com as curvas ajustadas
        data = [tab_AREA.columns.tolist()] + tab_AREA.values.tolist()

        table_style = TableStyle([
            ('BACKGROUND', (0, 0), (-1, 0), colors.grey),
            ('TEXTCOLOR', (0, 0), (-1, 0), colors.whitesmoke),
            ('ALIGN', (0, 0), (-1, -1), 'CENTER'),
            ('BOTTOMPADDING', (0, 0), (-1, 0), 12),
            ('BACKGROUND', (0, 1), (-1, -1), colors.white),
            ('GRID', (0, 0), (-1, -1), 1, colors.black)
        ])
        tabela = Table(data, colWidths=[90,40,370], style= table_style)

        tabela.wrapOn(c, 500, 700)
        tabela.drawOn(c, 50, 605)

        c.drawString(50, 585, f"CURVAS AJUSTADAS - VOLUME (em hm³)")

        data = [tab_VOL.columns.tolist()] + tab_VOL.values.tolist()

        tabela = Table(data, colWidths=[90,40,370], style= table_style)

        tabela.wrapOn(c, 500, 700)
        tabela.drawOn(c, 50, 480)

        if self.dlg.checkBox_2.isChecked():  # montar relatorio com os dados dos reservatorios 1 e 2
            c.setFont("Helvetica-Bold", 12)
            c.drawCentredString(300, 460, f"RESULTADOS DO RESERVATÓRIO ATUALIZADO {self.dlg.comboBox_2.currentText()}")
            c.setFont("Helvetica", 12)
            c.drawString(50, 440, f"CURVAS AJUSTADAS - ÁREA (em km²)")

            # Inserindo uma tabela
            data = [tab_AREA_2.columns.tolist()] + tab_AREA_2.values.tolist()

            tabela = Table(data, colWidths=[90, 40, 370], style= table_style)

            tabela.wrapOn(c, 500, 700)
            tabela.drawOn(c, 50, 335)

            c.drawString(50, 315, f"CURVAS AJUSTADAS - VOLUME (em hm³)")

            data = [tab_VOL_2.columns.tolist()] + tab_VOL_2.values.tolist()

            tabela = Table(data, colWidths=[90, 40, 370], style= table_style)

            tabela.wrapOn(c, 500, 700)
            tabela.drawOn(c, 50, 210)


        if (self.dlg.checkBox_5.isChecked()):
            """ se a opção para efetuar o teste estatistico estiver habilitada, será acrescentado no relatório
             o resultado do teste """
            resposta, p_value, stat_1, stat_2 = self.analise_estatistica_entre_reservatorios(layer_1,layer_2)

            c.setFont("Helvetica-Bold", 12)
            c.drawCentredString(300, 190, f"---- TESTE ESTATÍSTICO PARA AS DISCREPÂNCIAS ENTRE OS RESERVATÓRIOS ---")
            c.setFont("Helvetica", 12)
            c.drawString(50, 175, f"Teste t-student a nível de significância {self.dlg.comboBox_6.currentText()}")
            c.drawString(50, 160, f"p-valor = {p_value}")
            c.drawString(50, 145, f"Cota Média do Reservatório de Referência  ({self.dlg.comboBox.currentText()}) = {round(stat_1, 5)}")
            c.drawString(50, 130, f"Cota Média do Reservatório Atualizado  ({self.dlg.comboBox_2.currentText()}) = {round(stat_2, 5)}")
            c.drawString(50, 115, f"Conclusão: ")
            # Posição inicial
            x = 120
            y = 115
            lines = [resposta[i:i + 80] for i in range(0, len(resposta), 80)]
            for line in lines:
                c.drawString(x, y, line)
                y -= 15

        # rodape da pagina 3
        c.drawImage((roda), 50, 40, width=500, height=50)
        c.showPage()  # encerra a pagina 3

        # cabeçalho da pagina 4
        c.drawImage((cabe), 50, 750, width=500, height=50)

        c.setFont("Helvetica-Bold", 12)
        c.drawCentredString(300, 730, f"ESTATÍSTICA DESCRITIVA")
        c.setFont("Helvetica", 12)
        c.drawString(50, 710, f"R1 - reservatório de Referência")
        c.drawString(50, 690, f"R2 - reservatório Atualizado")

        dados = tab_DADOS.describe().values.round(5).tolist()
        nome_coluna = ["var"] + tab_DADOS.describe().columns.tolist()
        index = [""] + tab_DADOS.describe().index.tolist()

        # Inserir nome das colunas como primeira linha dos dados
        dados.insert(0, nome_coluna)

        # Inserir índices como primeira coluna em cada linha
        for i in range(1, len(dados)):
            dados[i].insert(0, index[i])

        tabela = Table(dados, colWidths=[50, 80, 80, 80, 80, 80], style=table_style)

        tabela.wrapOn(c, 500, 700)
        tabela.drawOn(c, 50, 500)

        # apresentar uma descrição das informações apresentadas na tabela estatística descritiva

        textobject = c.beginText()
        textobject.setTextOrigin(50, 480)
        textobject.setFont("Helvetica-Oblique", 10)

        textobject.textLines(""" 
        count - nº de observações realizadas entre a conta mínima e máxima conforme o intervalo definido.
        mean - média das observações.
        std - desvio padrão das observações.
        min - valor mínimo entre as observações.
        25%, 50%, 75% - percentil entre as observações.
        max - valor máximo entre as observações.
        """)
        c.drawText(textobject)


        # rodape da pagina 4
        c.drawImage((roda), 50, 40, width=500, height=50)
        c.showPage()  # encerra a pagina 4

        # Tamanho da página A4
        width, height = A4

        # Altura da linha da tabela
        row_height = 20

        # Número máximo de linhas por página
        max_rows_per_page = int((height - 2 * inch) // row_height)

        data = [tab_DADOS.round(5).columns.tolist()] + tab_DADOS.values.round(5).tolist()

        # Distribuição dos dados em partes para cada página
        header = data[0]  # Cabeçalho da tabela
        data_rows = data[1:]  # Linhas de dados

        # Comece a partir da segunda linha
        current_row = 0
        current_page = 1

        while current_row < len(data_rows):
            # cabeçalho da pagina 5
            c.drawImage((cabe), 50, 750, width=500, height=50)
            c.setFont("Helvetica-Bold", 12)
            c.drawCentredString(300, 730, f"TABELA CURVA CAV")
            c.setFont("Helvetica", 12)

            # Parte atual dos dados
            chunk = [header] + data_rows[current_row:current_row + max_rows_per_page - 1]

            # Crie a tabela para esta parte dos dados
            table = Table(chunk, colWidths=[1.2 * inch] * len(chunk[0]), style=table_style)

            # Adicione a tabela ao Canvas
            table.wrapOn(c, width - 2 * inch, height - 2 * inch)
            table.drawOn(c, inch, height - 1.6 * inch - table._height)

            # Adicione a página atual ao documento
            # rodape da pagina
            c.drawImage((roda), 50, 40, width=500, height=50)
            c.showPage()

            current_row += max_rows_per_page - 1
            current_page += 1

        # Feche o arquivo PDF
        c.save()

    def plotar_grafico(self, cot, arrea, arrea_2, voll, voll_2):
        fig, ax1 = plt.subplots(figsize=(9, 6))

        from matplotlib.ticker import StrMethodFormatter
        ax1.yaxis.set_major_formatter(StrMethodFormatter('{x:,.3f}'))  # configurando as casas decimais no eixo y - area

        # plotando os dados originais
        ax1.plot(cot, arrea, color="blue", marker='', linestyle='-',
                 label=str('Área (' + self.dlg.comboBox.currentText() + ')'))

        if (self.dlg.checkBox_2.isChecked()):
            ax1.plot(cot, arrea_2, color="blue", marker='', linestyle='--',
                     label=str('Área (' + self.dlg.comboBox_2.currentText() + ')'))
        plt.legend(loc='best')  # plotando legenda da area
        ax2 = ax1.twinx()       # inserindo o segundo eixo no grafico
        ax2.yaxis.set_major_formatter(
            StrMethodFormatter('{x:,.3f}'))  # configurando as casas decimais no eixo y - volume
        ax2.plot(cot, voll, color="green", marker='', linestyle='-.',
                 label=str('Volume (' + self.dlg.comboBox.currentText() + ')'))
        if (self.dlg.checkBox_2.isChecked()):
            ax2.plot(cot, voll_2, color="green", marker='', linestyle=':',
                     label=str('Volume (' + self.dlg.comboBox_2.currentText() + ')'))
        plt.legend(loc='best')  # plotando legenda do volume

        # configurando os textos dos eixos
        ax1.set_ylabel("Area (km2)", color="blue")
        ax2.set_ylabel("Volume (hm3)", color="green")

        ax1.tick_params(axis='y', colors="blue")
        ax2.tick_params(axis='y', colors="green")

        # plotando titulo & legenda
        if (self.dlg.checkBox_2.isChecked()):
            titulo = str('Curva CAV (' + self.dlg.comboBox.currentText() + ' X ' +  self.dlg.comboBox_2.currentText() + ')')
        else:
            titulo = str('Curva CAV (' + self.dlg.comboBox.currentText() + ')')
        plt.title(titulo, fontsize=15, fontweight='bold')
        plt.gca().invert_yaxis()
        ax1.set_xlabel("cotas (m)")
        plt.show()

    def curvas_ajustadas(self, cotas, areas, volumes):
        # gerando as curvas (INICIO) ------------------------------------------

        # MODELO polinomial - grau 3

        # Ajustando um modelo para a area
        model_area_pol3 = np.poly1d(np.polyfit(cotas, areas, 3))
        # Ajustando um modelo para o volume
        model_vol_pol3 = np.poly1d(np.polyfit(cotas, volumes, 3))

        # Obtendo o texto da equacao polinomial
        ## para curva area
        msg_area_pol3 = f"y_area = {round(model_area_pol3[0], 6)} " \
                        f"{'{0:{1}}'.format(round(model_area_pol3[1], 6), '-' if round(model_area_pol3[1]) < 0 else '+')}*x " \
                        f"{'{0:{1}}'.format(round(model_area_pol3[2], 6), '-' if round(model_area_pol3[2]) < 0 else '+')}*x^2 " \
                        f"{'{0:{1}}'.format(round(model_area_pol3[3], 6), '-' if round(model_area_pol3[3]) < 0 else '+')}*x^3"
        ## para curva volume
        msg_vol_pol3 = f"y_area = {round(model_vol_pol3[0], 6)} " \
                       f"{'{0:{1}}'.format(round(model_vol_pol3[1], 6), '-' if round(model_vol_pol3[1]) < 0 else '+')}*x " \
                       f"{'{0:{1}}'.format(round(model_vol_pol3[2], 6), '-' if round(model_vol_pol3[2]) < 0 else '+')}*x^2 " \
                       f"{'{0:{1}}'.format(round(model_vol_pol3[3], 6), '-' if round(model_vol_pol3[3]) < 0 else '+')}*x^3"
        # Calculo do Ajuste para cada curva
        r2_area_pol3 = r2_score_manual(np.array(areas), model_area_pol3(cotas)).round(3)
        r2_vol_pol3 = r2_score_manual(np.array(volumes), model_vol_pol3(cotas)).round(3)

        # MODELO polinomial - grau 2

        # Ajustando um modelo para a area
        model_area_pol2 = np.poly1d(np.polyfit(cotas, areas, 2))
        # Ajustando um modelo para o volume
        model_vol_pol2 = np.poly1d(np.polyfit(cotas, volumes, 2))

        # Obtendo o texto da equacao polinomial
        ## para curva area
        msg_area_pol2 = f"y_area = {round(model_area_pol2[0], 6)} " \
                        f"{'{0:{1}}'.format(round(model_area_pol2[1], 6), '-' if round(model_area_pol2[1]) < 0 else '+')}*x " \
                        f"{'{0:{1}}'.format(round(model_area_pol2[2], 6), '-' if round(model_area_pol2[2]) < 0 else '+')}*x^2 "
        ## para curva volume
        msg_vol_pol2 = f"y_area = {round(model_vol_pol2[0], 6)} " \
                       f"{'{0:{1}}'.format(round(model_vol_pol2[1], 6), '-' if round(model_vol_pol2[1]) < 0 else '+')}*x " \
                       f"{'{0:{1}}'.format(round(model_vol_pol2[2], 6), '-' if round(model_vol_pol2[2]) < 0 else '+')}*x^2 "
        # Calculo do Ajuste para cada curva
        r2_area_pol2 = r2_score_manual(np.array(areas), model_area_pol2(cotas)).round(3)
        r2_vol_pol2 = r2_score_manual(np.array(volumes), model_vol_pol2(cotas)).round(3)

        # MODELO polinomial - grau 1

        # Ajustando um modelo para a area
        model_area_pol1 = np.poly1d(np.polyfit(cotas, areas, 1))
        # Ajustando um modelo para o volume
        model_vol_pol1 = np.poly1d(np.polyfit(cotas, volumes, 1))

        # Obtendo o texto da equacao polinomial
        ## para curva area
        msg_area_pol1 = f"y_area = {round(model_area_pol1[0], 6)} " \
                        f"{'{0:{1}}'.format(round(model_area_pol1[1], 6), '-' if round(model_area_pol1[1]) < 0 else '+')}*x "
        ## para curva volume
        msg_vol_pol1 = f"y_area = {round(model_vol_pol1[0], 6)} " \
                       f"{'{0:{1}}'.format(round(model_vol_pol1[1], 6), '-' if round(model_vol_pol1[1]) < 0 else '+')}*x "

        # Calculo do Ajuste para cada curva
        r2_area_pol1 = r2_score_manual(np.array(areas), model_area_pol1(cotas)).round(3)
        r2_vol_pol1 = r2_score_manual(np.array(volumes), model_vol_pol1(cotas)).round(3)

        # MODELO logaritmo -----------------------------------------------------------------------------

        def monoLog(x, m, b):
            return m * np.log(x) + b

        from scipy.optimize import curve_fit
        # Ajustando um modelo para a area
        model_area_log, cova = curve_fit(monoLog, cotas, areas, maxfev=10000)
        # Ajustando um modelo para o volume
        model_vol_log, cova = curve_fit(monoLog, cotas, volumes, maxfev=10000)

        # Obtendo o texto da equacao logaritmica

        ## para curva area
        msg_area_log1 = f"y_area = {round(model_area_log[1], 6)} " \
                        f"{'{0:{1}}'.format(round(model_area_log[0], 6), '-' if round(model_area_log[0]) < 0 else '+')} * ln(x)"
        ## para curva volume
        msg_vol_log1 = f"y_area = {round(model_vol_log[1], 6)} " \
                       f"{'{0:{1}}'.format(round(model_vol_log[0], 6), '-' if round(model_vol_log[0]) < 0 else '+')} * ln(x)"
        # Calculo do Ajuste para cada curva
        r2_area_log1 = r2_score_manual(np.array(areas),
                                monoLog(np.array(cotas), model_area_log[0], model_area_log[1])).round(3)
        r2_vol_log1 = r2_score_manual(np.array(volumes),
                               monoLog(np.array(cotas), model_vol_log[0], model_vol_log[1])).round(3)

       #  gerando as curvas (FIM) -----------------------------------------

        # tabelas contendo as equacoes e ajustes de cada curva

        tab_area = pd.DataFrame({'Ajuste': ['Polinomio Grau 1', 'Polinomio Grau 2', 'Polinomio Grau 3',
                                            'Logaritmico'],
                                 'R²': [r2_area_pol1, r2_area_pol2, r2_area_pol3, r2_area_log1],
                                 'Equação': [msg_area_pol1, msg_area_pol2, msg_area_pol3,
                                             msg_area_log1]})
        tab_vol = pd.DataFrame({'Ajuste': ['Polinomio Grau 1', 'Polinomio Grau 2', 'Polinomio Grau 3',
                                           'Logaritmico'],
                                'R²': [r2_vol_pol1, r2_vol_pol2, r2_vol_pol3, r2_vol_log1],
                                'Equação': [msg_vol_pol1, msg_vol_pol2, msg_vol_pol3, msg_vol_log1]})

        return (tab_area, tab_vol)

    def analise_estatistica_entre_reservatorios (self, layer_1, layer_2):

        """ obter uma imagem de discrepância entre os reservatorios (Diferença = Reservatório 1 - Reservatório 2))
                   Avaliar por meio de um teste t-student se a média das cotas dos reservatórios são iguais.
                   Hipótese H0 - as médias das cotas dos reservatórios são iguais
                   Hipótese H1 - s médias das cotas dos reservatórios são diferentes"""

        # aplicando o teste t student para comparar a media dos MDT´s dos 2 reservatorios

        if (self.dlg.checkBox_4.isChecked()):
            layer_1 = QgsRasterLayer(layer_1, 'recorte_1')
            layer_2 = QgsRasterLayer(layer_2, 'recorte_2')

        # obter a media das profundidades em cada reservatorio
        stat_1 = layer_1.dataProvider().bandStatistics(1).mean
        stat_2 = layer_2.dataProvider().bandStatistics(1).mean

        # layer_1 para array numpy
        provider = layer_1.dataProvider()
        extent = layer_1.extent()
        width = layer_1.width()
        height = layer_1.height()
        block = provider.block(1, extent, width, height)
        img_array_1 = block.data()

        # layer_2 para array numpy
        provider2 = layer_2.dataProvider()
        extent2 = layer_2.extent()
        width2 = layer_2.width()
        height2 = layer_2.height()
        block2 = provider2.block(1, extent2, width2, height2)
        img_array_2 = block2.data()


        # aplicando o teste t

        alpha = float(self.dlg.comboBox_6.currentText().strip("%")) / 100
        from scipy.stats import ttest_ind,t
        t_statistic, p_value = ttest_ind(img_array_1, img_array_2, alternative="two-sided", equal_var=False)

        # calcular o valor crítico da estatística t
        degrees_of_freedom = len(img_array_1) + len(img_array_2) - 2
        t_critical = t.ppf(1 - alpha / 2, degrees_of_freedom)

        # Resposta para o resultado do teste

        if abs(t_statistic) > t_critical:
            resp = f"De acordo com o teste estatísco t_student, a um nível de significância de " \
               f"{self.dlg.comboBox_6.currentText()},   houve um assoreamento significativo no reservatório"

        else:
            resp = f"De acordo com o teste estatísco t_student, a um nível de significância de " \
               f" {self.dlg.comboBox_6.currentText()},  não houve um assoreamento significativo no reservatório"

        return (resp, p_value, stat_1, stat_2)


    def grafico(self):
        self.variaveis()

        if (self.dlg.checkBox_4.isChecked()) and (self.limitevetor is None):
            msg = QMessageBox()
            msg.setIcon(QMessageBox.Information)
            msg.setWindowTitle("Atenção")
            msg.setText("Selecionar o limite do reservatório.")
            msg.exec()
            return ()

        # obtendo os valores maximo e minimo do primeiro MDE
        demMinimum = self.estatistica().minimumValue
        demMaximum = self.estatistica().maximumValue


        # se estiver usando o segundo MDE, o valor minimo será o menor valor entre os 2 modelos
        if self.dlg.checkBox_2.isChecked():
            demMinimum = min(self.estatistica().minimumValue, self.estatistica_2().minimumValue)

        # verificando os valores informados na janela de entrada de dados

        if (self.cotamin < demMinimum) or (self.cotamin > demMaximum) or \
                (self.cotamaxima < demMinimum) or (self.cotamaxima > demMaximum) or \
                (self.intervalo == 0) or \
                (abs(self.cotamaxima - self.cotamin) < self.intervalo) or \
                (self.cotamin > self.cotamaxima) or \
                ((self.dlg.checkBox.isChecked()) and (self.saida == "")):

            msg = QMessageBox()
            msg.setIcon(QMessageBox.Information)
            msg.setWindowTitle("Atenção")

            if (self.cotamaxima < demMinimum):
                msg.setText("O valor da 'Cota Máxima' está abaixo do mínimo possível!")
            if (self.cotamaxima > demMaximum):
                msg.setText("O valor do 'Cota Máxima' está acima do máximo possível!")
            if (self.cotamin < demMinimum):
                msg.setText("O valor da 'Cota Mínima' está abaixo do mínimo possível!")
            if (self.cotamin > demMaximum):
                msg.setText("O valor da 'Cota Mínima' está acima do máximo possível!")
            if (self.intervalo == 0):
                msg.setText("Informar um valor para o 'Intervalo de Cotas'!")
            if (abs(self.cotamaxima - self.cotamin) < self.intervalo):
                msg.setText("Intervalo de Cotas superior ao permitido!")
            if (self.cotamin > self.cotamaxima):
                msg.setText("O valor da 'Cota Mínima' está acima da 'Cota Máxima'!")
            if ((self.dlg.checkBox.isChecked()) and (self.saida == "")):
                msg.setText("Inserir o nome do arquivo de saida!")

            msg.exec()

        else:
            cota_minima = self.cotamin
            cota = self.cotamaxima
            cotas = []
            areas = []
            volumes = []
            areas_2 = []
            volumes_2 = []


            # gerar e analisar a barra de progresso
            if (self.dlg.checkBox_2.isChecked()):   # se checkbox estiver marcado sera analisado 2 reservatorios
                n_passos = int((abs(self.cotamaxima) - abs(cota_minima)) / (abs(self.intervalo)))*2
            else:                                   # sera analisado 1 reservatorio
                n_passos = int((abs(self.cotamaxima) - abs(cota_minima)) / (abs(self.intervalo)))*1
            valor = 0  # valor da barra de progresso


            # recortar os MDT dos reservatorios com base no limite
            if (self.dlg.checkBox_4.isChecked()):
                if self.limitevetor.crs() == self.camada.crs():   # Verificar se o dados possuem o mesmo CRS
                    reserv1_recorte= processing.run("gdal:cliprasterbymasklayer",
                                       {'INPUT': self.camada,
                                        'MASK': self.limitevetor,
                                        'SOURCE_CRS': None, 'TARGET_CRS': None, 'NODATA': None, 'ALPHA_BAND': False,
                                        'CROP_TO_CUTLINE': True, 'KEEP_RESOLUTION': True, 'SET_RESOLUTION': False,
                                        'X_RESOLUTION': None, 'Y_RESOLUTION': None, 'MULTITHREADING': False, 'OPTIONS': '',
                                        'DATA_TYPE': 0, 'EXTRA': '', 'OUTPUT': 'TEMPORARY_OUTPUT'})
                    self.iface.addRasterLayer(reserv1_recorte['OUTPUT'], "recorte_1")
                    camada_entrada = reserv1_recorte['OUTPUT']
                    if (self.dlg.checkBox_2.isChecked()):  # se checkbox estiver marcado sera recortado o 2º reservatorio
                        if self.limitevetor.crs() == self.camada_2.crs():
                            reserv2_recorte = processing.run("gdal:cliprasterbymasklayer",
                                                             {'INPUT': self.camada_2,
                                                              'MASK': self.limitevetor,
                                                              'SOURCE_CRS': None, 'TARGET_CRS': None, 'NODATA': None,
                                                              'ALPHA_BAND': False,
                                                              'CROP_TO_CUTLINE': True, 'KEEP_RESOLUTION': True,
                                                              'SET_RESOLUTION': False,
                                                              'X_RESOLUTION': None, 'Y_RESOLUTION': None,
                                                              'MULTITHREADING': False, 'OPTIONS': '',
                                                              'DATA_TYPE': 0, 'EXTRA': '', 'OUTPUT': 'TEMPORARY_OUTPUT'})
                            self.iface.addRasterLayer(reserv2_recorte['OUTPUT'], "recorte_2")
                            camada_entrada2 = reserv2_recorte['OUTPUT']
                        else:
                            msg = QMessageBox()
                            msg.setIcon(QMessageBox.Information)
                            msg.setWindowTitle("Atenção")
                            msg.setText("Os arquivos (limite e MDT) não possuem o mesmo EPSG.")
                            msg.exec()
                            return
                else:
                    msg = QMessageBox()
                    msg.setIcon(QMessageBox.Information)
                    msg.setWindowTitle("Atenção")
                    msg.setText("Os arquivos (limite e MDT) não possuem o mesmo EPSG.")
                    msg.exec()
                    return
            else:
                camada_entrada = self.camada
                camada_entrada2 = self.camada_2

            while cota >= cota_minima:
                resultado = processing.run("native:rastersurfacevolume",
                                           {'INPUT': camada_entrada, 'BAND': 1, 'LEVEL': cota, 'METHOD': 1,
                                            'OUTPUT_HTML_FILE': 'TEMPORARY_OUTPUT',
                                            'OUTPUT_TABLE': 'TEMPORARY_OUTPUT'})
                areas.append(abs(resultado['AREA'] / 1000000))  # valor de area em km2
                volumes.append(abs(resultado['VOLUME'] / 1000000))  # valor de volume em hm3 - hectometro

                if (self.dlg.checkBox_2.isChecked()):  # se checkbox estiver marcado sera analisado 2 reservatorios
                    valor = valor + (100 / n_passos)
                    self.dlg.progressBar.setValue(valor)

                    resultado_2 = processing.run("native:rastersurfacevolume",
                                               {'INPUT': camada_entrada2, 'BAND': 1, 'LEVEL': cota, 'METHOD': 1,
                                                'OUTPUT_HTML_FILE': 'TEMPORARY_OUTPUT',
                                                'OUTPUT_TABLE': 'TEMPORARY_OUTPUT'})
                    areas_2.append(abs(resultado_2['AREA'] / 1000000))  # valor de area em km2
                    volumes_2.append(abs(resultado_2['VOLUME'] / 1000000))  # valor de volume em hm3 - hectometro

                cotas.append(cota)
                cota = cota - self.intervalo
                # barra de progresso
                valor = valor + (100 / n_passos)
                self.dlg.progressBar.setValue(valor)

            # Gerando uma tabela
            if (self.dlg.checkBox_2.isChecked()):   # se checkbox estiver marcado gera tabela para 2 reservatorios
                tabela = pd.DataFrame(list(zip(cotas, areas, volumes, areas_2, volumes_2)), columns=['cota', 'R1_area_km2', 'R1_volume_hm3','R2_area_km2', 'R2_volume_hm3'])
            else:                                   # gera tabela para 1 reservatorio
                tabela = pd.DataFrame(list(zip(cotas, areas, volumes)), columns=['cota', 'R1_area_km2', 'R1_volume_hm3'])

            # Gerar no Qgis um vector layer temporario com a tabela da curva CAV
            vl = QgsVectorLayer("None", "temporary_table", "memory")
            pr = vl.dataProvider()
            vl.startEditing()
            fieldlist = [QgsField(fieldname, QVariant.Double) for fieldname in tabela.columns]

            pr.addAttributes(fieldlist)
            vl.updateFields()

            for i in tabela.index.to_list():
                fet = QgsFeature()
                newrow = tabela[tabela.columns].iloc[i].tolist()
                fet.setAttributes(newrow)
                pr.addFeatures([fet])
            vl.commitChanges()
            # adicionando no Qgis
            QgsProject.instance().addMapLayer(vl)

            # ---------------------- Imagem Diferença entre Reservatórios (inicio) -------------------------------------
            # gerar imagem de diferença entre os reservatórios se checkbox estiver marcado
            if self.dlg.checkBox_6.isChecked():
                # Configurar a expressão de cálculo para a diferença entre 2 reservatorios
                expression = f'\"{self.camada.name()}@1" - \"{self.camada_2.name()}@1"'

                esta_res = processing.run("qgis:rastercalculator", {'EXPRESSION': expression,
                                                                    'LAYERS': [
                                                                        self.camada.dataProvider().dataSourceUri()],
                                                                    'CELLSIZE': None,
                                                                    'EXTENT': None,
                                                                    'CRS': None,
                                                                    'OUTPUT': 'TEMPORARY_OUTPUT'})
                self.iface.addRasterLayer(esta_res['OUTPUT'], "Diferença_Reservatorios")
            # ---------------------- Imagem Diferença entre Reservatórios (fim) -------------------------------------

            # ---------------------- Ajuste de Curvas (inicio) -----------------------------------------------------

            tab_area, tab_vol = self.curvas_ajustadas(cotas, areas, volumes)

            if (self.dlg.checkBox_2.isChecked()):  # se checkbox estiver marcado gera ajuste de curva para o 2º reservatorio
                 tab_area_2, tab_vol_2 = self.curvas_ajustadas(cotas,areas_2,volumes_2)
            # ---------------------- Ajuste de Curvas (fim) -------------------------------------------------------

            # ---------------------- Gerar o Grafico da Curva CAV --------------------------------------------------
            self.plotar_grafico(cotas, areas, areas_2, volumes, volumes_2)

            # ---------------------- Gerar o relatorio  (inicio) -------------------------------------------------
            if (self.dlg.checkBox.isChecked()):
                # salvando no disco o grafico
                plt.savefig(os.path.splitext(self.saida)[0] + '_Curva_CAV.png')
                if (self.dlg.checkBox_2.isChecked()):
                    self.relatorio_PDF(tabela, tab_area, tab_vol, tab_area_2, tab_vol_2, camada_entrada, camada_entrada2)

                else:
                    self.relatorio_PDF(tabela, tab_area, tab_vol,"", "",camada_entrada,"")

                if (self.dlg.checkBox_3.isChecked()):
                    # salvando a cruva CAV no formato *.CSV
                    tabela.round(3).to_csv(os.path.splitext(self.saida)[0] + '_Curva_CAV.csv',index = False, header=True)
            # ---------------------- Gerar o relatorio  (fim) -----------------------------------------------------

            self.dlg.progressBar.reset()  # limpando a progressbar

    def limparFT (self):
        self.dlg.FT000.clear(), self.dlg.FT001.clear(), self.dlg.FT002.clear(), self.dlg.FT003.clear(), self.dlg.FT004.clear(),
        self.dlg.FT005.clear(), self.dlg.FT006.clear(), self.dlg.FT007.clear(), self.dlg.FT008.clear(),
        self.dlg.FT009.clear(), self.dlg.FT010.clear(), self.dlg.FT011.clear(), self.dlg.FT012.clear(),
        self.dlg.FT013.clear(), self.dlg.FT014.clear(), self.dlg.FT015.clear(), self.dlg.FT016.clear(),
        self.dlg.FT017.clear(), self.dlg.FT018.clear(), self.dlg.FT019.clear(), self.dlg.FT020.clear(),
        self.dlg.FT021.clear(), self.dlg.FT022.clear(), self.dlg.FT023.clear(), self.dlg.FT024.clear(),
        self.dlg.FT025.clear(), self.dlg.FT026.clear(), self.dlg.FT027.clear(), self.dlg.FT028.clear(),
        self.dlg.FT029.clear(), self.dlg.FT030.clear()


    def cadastrar_reservatorio(self):
        """ para cadastrar os dados do reservatorio"""
        db2 = Data_base_FT()
        db2.connect()
        db2.criar_tabela_FT()

        fichaTecnica = (
            self.dlg.FT000.text(), self.dlg.FT001.text(), self.dlg.FT002.text(), self.dlg.FT003.text(), self.dlg.FT004.text(),
            self.dlg.FT005.text(), self.dlg.FT006.text(), self.dlg.FT007.text(), self.dlg.FT008.text(),
            self.dlg.FT009.text(), self.dlg.FT010.text(), self.dlg.FT011.text(), self.dlg.FT012.text(),
            self.dlg.FT013.text(), self.dlg.FT014.text(), self.dlg.FT015.text(), self.dlg.FT016.text(),
            self.dlg.FT017.text(), self.dlg.FT018.text(), self.dlg.FT019.text(), self.dlg.FT020.text(),
            self.dlg.FT021.text(), self.dlg.FT022.text(), self.dlg.FT023.text(), self.dlg.FT024.text(),
            self.dlg.FT025.text(), self.dlg.FT026.text(), self.dlg.FT027.text(), self.dlg.FT028.text(),
            self.dlg.FT029.text(), self.dlg.FT030.text()
        )

        # CADASTRAR NO BANCO DE DADOS
        resp = db2.cadastrar_FT(fichaTecnica)


        if resp == "OK":
            msg = QMessageBox()
            msg.setIcon(QMessageBox.Information)
            msg.setWindowTitle("Casdastro Realizado")
            msg.setText("Cadastro Realizado com sucesso")
            msg.exec()
            db2.close_connection()
            self.buscar_reservatorio()
            self.limparFT()
            return
        else:
            msg = QMessageBox()
            msg.setIcon(QMessageBox.Critical)
            msg.setWindowTitle("Erro")
            msg.setText("Erro ao cadastrar, verifique se as informações foram preenchidadas corretamente!")
            msg.exec()
            db2.close_connection()
            return

    def buscar_reservatorio(self):

        db2 = Data_base_FT()
        db2.connect()
        result = db2.select_all_FT()

        self.dlg.tb_reservatorio.clearContents()
        self.dlg.tb_reservatorio.setRowCount(len(result))

        for row, text in enumerate(result):
            for column, data in enumerate(text):
                self.dlg.tb_reservatorio.setItem(row, column, QTableWidgetItem(str(data)))

        db2.close_connection()

    def atualizar_reservatorio(self):

        dados = []
        update_dados = []

        for row in range(self.dlg.tb_reservatorio.rowCount()):
            for column in range(self.dlg.tb_reservatorio.columnCount()):
                dados.append(self.dlg.tb_reservatorio.item(row, column).text())
            update_dados.append(dados)
            dados = []

        # ATUALIZAR DADOS NO BANCO
        db2 = Data_base_FT()
        db2.connect()

        for emp in update_dados:
            db2.update_FT(tuple(emp))

        db2.close_connection()

        msg = QMessageBox()
        msg.setIcon(QMessageBox.Information)
        msg.setWindowTitle("Atualização de Dados")
        msg.setText("Dados atualizados com sucesso!")
        msg.exec()

        self.dlg.tb_reservatorio.reset()
        self.buscar_reservatorio()

    def deletar_reservatorio(self):

        db2 = Data_base_FT()
        db2.connect()

        msg = QMessageBox()
        msg.setWindowTitle("Excluir")
        msg.setText("Este registro será excluído.")
        msg.setInformativeText("Você tem certeza que deseja excluir?")
        msg.setStandardButtons(QMessageBox.Yes | QMessageBox.No)
        resp = msg.exec()

        if resp == QMessageBox.Yes:
            id = self.dlg.tb_reservatorio.selectionModel().currentIndex().siblingAtColumn(0).data()
            result = db2.delete_FT(id)
            self.buscar_reservatorio()

            msg = QMessageBox()
            msg.setIcon(QMessageBox.Information)
            msg.setWindowTitle("RESERVATORIO")
            msg.setText(result)
            msg.exec()

        db2.close_connection()

    def gerar_excel_2(self):

        cnx = sqlite3.connect("system.db")

        empresas = pd.read_sql_query("""SELECT * FROM Empresas""", cnx)

        empresas.to_excel("Empresas.xlsx", sheet_name='empresas', index=False)

        msg = QMessageBox()
        msg.setIcon(QMessageBox.Information)
        msg.setWindowTitle("Excel")
        msg.setText("Relatório Excel gerado com sucesso!")
        msg.exec()

    def check_item (self):
        """ habilita ou desabilita botões e caixa de texto relacionado à geração de relatório"""
        if (self.dlg.checkBox.isChecked()):             # se checkbox estiver marcado serao habilitados os itens abaixo
            self.dlg.lineEdit.setEnabled(True)          # campo com o endereço do relatorio a ser salvo
            self.dlg.toolButton_3.setEnabled(True)      # botao para salvar o endereço
            self.dlg.tb_reservatorio.setEnabled(True)   # janela com os relatorios cadastrados
            self.dlg.btn_excluir_2.setEnabled(True)     # botao excluir relatorio
            self.dlg.btn_alterar_2.setEnabled(True)     # botao alterar relatorio
            self.dlg.checkBox_3.setEnabled(True)        # botao para salvar a curva CAV no formato *.CSV
            if (self.dlg.checkBox_2.isChecked()):
                self.dlg.comboBox_6.setEnabled(True)        # campo para definir o nivel de significância
                self.dlg.checkBox_5.setEnabled(True)        # Checkbox da analise estatistica

            
        else:                                            # se checkbox não estiver marcado serao desabilitados os itens abaixo
            self.dlg.lineEdit.setEnabled(False)
            self.dlg.toolButton_3.setEnabled(False)
            self.dlg.tb_reservatorio.setEnabled(False)
            self.dlg.btn_excluir_2.setEnabled(False)
            self.dlg.btn_alterar_2.setEnabled(False)
            self.dlg.checkBox_3.setEnabled(False)
            self.dlg.comboBox_6.setEnabled(False)
            self.dlg.checkBox_5.setEnabled(False)

    def check_item2 (self):
        """ habilita ou desabilita botões e caixa de texto relacionado ao reservatorio nº2"""
        if (self.dlg.checkBox_2.isChecked()):             # se checkbox estiver marcado serao habilitados os itens abaixo
            self.dlg.comboBox_2.setEnabled(True)          # campo com o endereço do reservatorio nº2
            self.dlg.toolButton_2.setEnabled(True)        # botao para abrir o endereço do reservatorio nº2
            self.dlg.listWidget_2.setEnabled(True)        # janela com a estatistica descritiva
            self.dlg.checkBox_6.setEnabled(True)          # opção para gerar imagem de diferenças entre reservatórios
            self.carregaRaster_2()
            self.estatistica_2()
            if (self.dlg.checkBox.isChecked()):
                self.dlg.comboBox_6.setEnabled(True)        # campo para definir o nivel de significância
                self.dlg.checkBox_5.setEnabled(True)        # Checkbox da analise estatistica

        else:
            self.dlg.comboBox_2.setEnabled(False)
            self.dlg.toolButton_2.setEnabled(False)
            self.dlg.listWidget_2.setEnabled(False)
            self.dlg.checkBox_6.setEnabled(False)
            self.dlg.comboBox_2.clear()
            self.dlg.listWidget_2.clear()
            self.dlg.comboBox_6.setEnabled(False)
            self.dlg.checkBox_5.setEnabled(False)
            self.dlg.checkBox_5.setChecked(False)
            self.dlg.checkBox_6.setChecked(False)

    def check_item3 (self):
        """ habilita ou desabilita botões e caixa de texto relacionado ao reservatorio nº2"""
        if (self.dlg.checkBox_4.isChecked()):             # se checkbox estiver marcado serao habilitados os itens abaixo
            self.dlg.comboBox_5.setEnabled(True)          # campo com o endereço do reservatorio nº2
            self.dlg.toolButton_6.setEnabled(True)        # botao para abrir o endereço do reservatorio nº2

        else:
            self.dlg.comboBox_5.setEnabled(False)
            self.dlg.toolButton_6.setEnabled(False)

        if len(self.dlg.comboBox_5.currentText()) != 0:
            if len(self.dlg.comboBox.currentText()) != 0:
                self.estatistica()
                self.estatistica_2()

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started

        self.dlg = CAVDialog()

        # show the dialog
        self.dlg.show()

        # adicionar as funcoes criadas
        self.carregaRaster()
        self.dlg.toolButton.clicked.connect(self.abrirRaster)
        self.dlg.toolButton_2.clicked.connect(self.abrirRaster)
        self.dlg.toolButton_3.clicked.connect(self.definirSaida)
        self.dlg.toolButton_6.clicked.connect(self.abrirVetor)
        self.dlg.pushButton.clicked.connect(self.grafico)

        # atualizar a lisWidget com os dados da estatistica da imagem
        self.dlg.comboBox.activated.connect(self.estatistica)
        self.dlg.comboBox_2.activated.connect(self.estatistica_2)

        # Páginas do Sistema
        self.dlg.btn_menu_cav.clicked.connect(lambda: self.dlg.Pages.setCurrentWidget(self.dlg.pg_CAV))
        self.dlg.btn_menu_sobre.clicked.connect(lambda: self.dlg.Pages.setCurrentWidget(self.dlg.pg_about))
        self.dlg.btn_menu_contatos.clicked.connect(lambda: self.dlg.Pages.setCurrentWidget(self.dlg.pg_contatos))

        # Páginas Cadastrar e Relacionar os reservatorio
        self.dlg.FT_cadastrar.clicked.connect(self.cadastrar_reservatorio)
        self.dlg.btn_alterar_2.clicked.connect(self.atualizar_reservatorio)
        self.dlg.btn_excluir_2.clicked.connect(self.deletar_reservatorio)

        # ler e atualizar os dados dos reservatorios página - reservatorio
        self.buscar_reservatorio()

        self.dlg.checkBox.clicked.connect(self.check_item)
        self.dlg.checkBox_2.clicked.connect(self.check_item2)
        self.dlg.checkBox_4.clicked.connect(self.check_item3)

        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            pass


