# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CatastroHistoriaDock
                                 A QGIS plugin
 Catálogo completo de servicios disponibles a través de la Infraestructura de Datos Espaciales de España (IDEE).
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2023-09-27
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Laura García de Marina Vázquez
        email                : lauragarciademarina@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from PyQt5 import QtCore, QtGui, QtWidgets
import os

class CatastroHistoriaDock(QtWidgets.QDockWidget):
    def __init__(self, iface, parent=None):
        """Constructor."""
        super(CatastroHistoriaDock, self).__init__(parent)
        self.iface = iface
        self.setupUi()

    def setupUi(self):
        self.setFeatures(QtWidgets.QDockWidget.DockWidgetClosable | QtWidgets.QDockWidget.DockWidgetMovable)
        self.iface.addDockWidget(QtCore.Qt.LeftDockWidgetArea, self)
        font = QtGui.QFont()
        font.setFamily("Arial")
        font.setPointSize(10)
        self.setFont(font)
        self.setWindowTitle("Catastro con Historia")
        #En el dock necesitamos añadir un widget que sirva de contenedor para nuestro layout
        self.container = QtWidgets.QWidget()
        self.setWidget(self.container)
        #A partir de ahora añadimos todo al contenedor, no al dock
        self.verticalLayout = QtWidgets.QVBoxLayout(self.container)        
        self.gridLayout = QtWidgets.QGridLayout()
        self.verticalLayout.addLayout(self.gridLayout)


        """SELECCIÓN DE FECHA"""
        self.fecha_historia_lbl = QtWidgets.QLabel(self.container)
        self.fecha_historia_lbl.setText('Fecha historia')
        self.fecha_historia_lbl.adjustSize()
        self.gridLayout.addWidget(self.fecha_historia_lbl, 0, 0, 1, 1)
        self.fecha_historia = QtWidgets.QDateEdit(self.container)
        d = QtCore.QDateTime(2002, 1, 1, 0, 0) #la historia no está disponible antes del 01/01/2002
        self.fecha_historia.setMinimumDateTime(d) #establecer fecha mínima
        self.gridLayout.addWidget(self.fecha_historia, 0, 1, 1, 1)

        """SELECCIÓN DEL EPSG"""
        self.EPSG_lbl = QtWidgets.QLabel(self.container)
        self.EPSG_lbl.setText('Sist. Referencia')
        self.EPSG_lbl.adjustSize()
        self.gridLayout.addWidget(self.EPSG_lbl, 1, 0, 1, 1)
        self.EPSG_combobox = QtWidgets.QComboBox(self.container)
        self.EPSG_combobox.addItems(['EPSG:32628 - WGS84 HUSO 28', 'EPSG:25829 - ETRS89 HUSO 29', 'EPSG:25830 - ETRS89 HUSO 30', 'EPSG:25831 - ETRS89 HUSO 31'])
        self.gridLayout.addWidget(self.EPSG_combobox, 1, 1, 1, 1)

        """BOTÓN DE CARGA"""
        self.carga_btn = QtWidgets.QPushButton(self.container)
        sizePolicy = QtWidgets.QSizePolicy(QtWidgets.QSizePolicy.Fixed, QtWidgets.QSizePolicy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.carga_btn.sizePolicy().hasHeightForWidth())
        self.carga_btn.setSizePolicy(sizePolicy)
        self.carga_btn.setText("Cargar")
        self.gridLayout.addWidget(self.carga_btn, 2, 1, 1, 1)
        
        