# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CatastroHistoria
                                 A QGIS plugin
 Catálogo completo de servicios disponibles a través de la Infraestructura de Datos Espaciales de España (IDEE).
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-09-27
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Laura García de Marina Vázquez
        email                : lauragarciademarina@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtCore import QSettings, QTranslator, QCoreApplication, Qt
from PyQt5.QtGui import QIcon
from PyQt5 import QtNetwork
from PyQt5 import QtWidgets
from xml.dom import minidom
from qgis.gui import QgsMapCanvas, QgsMapToolIdentify
from qgis.core import QgsProject, QgsRasterLayer, QgsLayerTreeLayer, QgsMapThemeCollection


# Import the code for the dialog
from .Catastro_Historia_Dock import CatastroHistoriaDock
import os.path


class CatastroHistoria:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        self.icon_path = self.plugin_dir + "/icon.png"

        # Declare instance attributes
        self.actions = []
        self.menu = 'Catastro con Historia'

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):

        icon = QIcon(self.icon_path)
        action = QtWidgets.QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        self.add_action(
            self.icon_path,
            text="Catastro con Historia",
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                'Catastro con Historia',
                action)
            self.iface.removeToolBarIcon(action)
        


    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.ui = CatastroHistoriaDock(self.iface)
            self.ui.carga_btn.clicked.connect(self.split_screen)


        # show the dialog
        self.ui.show()


    def split_screen(self):
        
        """VARIABLES EXTRAÍDAS DE LA GUI"""
        crs = self.ui.EPSG_combobox.currentText().split(' - ')[0]
        print('crs: {}'.format(crs))
        fecha = self.ui.fecha_historia.date().toString(Qt.ISODate)
        print('fecha historia: {}'.format(fecha))

        """CONTENIDO ESTÁTICO"""
        nombre_canvas_historia = 'Catastro a {}'.format(fecha)
        nombre_capa_historia = 'Catastro Historia {}'.format(fecha)
        nombre_capa_actual = 'Catastro Actual'
        nombre_capa_PNOA = 'Ortofotos PNOA M.A.'
        

        canvas = self.iface.createNewMapCanvas(nombre_canvas_historia)
        if canvas != None:
            #Aquí solo entra si todavía no existe una ventana con la historia a esta fecha
            self.canvas_historia = canvas
            """AÑADIR CAPAS"""
            uri = 'format=image/png&layers=OI.OrthoimageCoverage&styles=OI.OrthoimageCoverage.Default&crs={}&url=https://www.ign.es/wms-inspire/pnoa-ma'.format(crs)
            self.createLayer(uri, nombre_capa_PNOA)
            uri = 'format=image/png&layers=Catastro&styles&crs={}&url=http://ovc.catastro.meh.es/Cartografia/WMS/ServidorWMS.aspx?time={}'.format(crs, fecha)
            self.createLayer(uri, nombre_capa_historia)
            uri = 'format=image/png&layers=Catastro&styles&crs={}&url=http://ovc.catastro.meh.es/Cartografia/WMS/ServidorWMS.aspx'.format(crs)
            self.createLayer(uri, nombre_capa_actual)

            """AÑADIR TEMA A LA HISTORIA"""
            #Se crea o actualiza el tema para la pantalla de la derecha con la capa de historia
            #Si no se aplica un tema, las capas se sincronizan con la ventana principal (pantalla izquierda)
            self.createMapTheme(nombre_capa_historia)

            """ACTIVAR ACTUAL COMO MAPA PRINCIPAL"""
            #En la pantallla principal, dejar solo activa la capa actual, en la izquierda aparece la historia al aplicar el tema
            for layer in QgsProject.instance().layerTreeRoot().children():
                if layer.name() == nombre_capa_actual or layer.name() == nombre_capa_PNOA:
                    layer.setItemVisibilityChecked(True)
                else:
                    layer.setItemVisibilityChecked(False)

            """SINCRONIZAR MAPAS"""
            self.iface.mapCanvas().extentsChanged.connect(lambda: self.syncExtent(self.iface.mapCanvas().objectName(), canvas))
            #TODO: Gestionar la desconexión y la eliminación de temas cuando se cierra el mapa de historia
        else:
            print('Ya existe un canvas con la historia a fecha {}'.format(fecha))


    def createLayer(self, uri, nombre_capa):
        #Se añade la capa si no existe ya en el panel
        capas = [layer for layer in QgsProject.instance().layerTreeRoot().children() if layer.name() == nombre_capa]
        if len(capas) == 0:
                rlayer = QgsRasterLayer(uri, nombre_capa, 'wms')
                QgsProject.instance().addMapLayer(rlayer) #add layer to the registry
                print('Creando capa {}'.format(nombre_capa))
                self.addLayerToCanvas(rlayer)
    
    def addLayerToCanvas(self, rlayer):
        if rlayer.isValid():
            self.iface.mapCanvas().setLayers([rlayer])
            self.iface.mapCanvas().zoomToFullExtent()
        else:
            print('La capa WMS {} no es válida'.format(rlayer.name()))
            print(rlayer.error().message())


    def createMapTheme(self, nombre_capa_historia):
        #Colección de temas existentes
        mapThemesCollection = QgsProject.instance().mapThemeCollection()
        #Dejar activa solo la capa de historia para crear el tema
        for layer in QgsProject.instance().layerTreeRoot().children():
            if layer.name() == nombre_capa_historia:
                layer.setItemVisibilityChecked(True)
            else:
                layer.setItemVisibilityChecked(False)
        #Crear el tema
        mapThemeRecord = QgsMapThemeCollection.createThemeFromCurrentState(
            QgsProject.instance().layerTreeRoot(),
            self.iface.layerTreeView().layerTreeModel()
        )
        #Añadir el tema
        if nombre_capa_historia in mapThemesCollection.mapThemes():
            mapThemesCollection.update(nombre_capa_historia, mapThemeRecord)
            print('Tema actualizado para la capa {}'.format(nombre_capa_historia))
        else:
            mapThemesCollection.insert(nombre_capa_historia, mapThemeRecord)
            print('Tema creado para la capa {}'.format(nombre_capa_historia))
        #Establecer el tema de la pantalla de historia. Deja de sincronizar con la principal para mostrar solo la capa de historia.
        self.canvas_historia.setTheme(nombre_capa_historia)
        print('Tema añadido a la pantalla de historia')
        self.canvas_historia.zoomToFullExtent()
        self.canvas_historia.refresh()


    def syncExtent(self, canvasName, canvas):
        if canvas in self.iface.mapCanvases():
            #Obtener extensión y escala de la pantalla principal
            extent = self.iface.mapCanvas().extent()
            scale = self.iface.mapCanvas().scale()
            #Sincronizar pantalla de historia (derecha)
            canvas.setExtent(extent)
            #canvas.zoomScale(scale)
            canvas.refresh()