# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CartoGraphDialog
                                 A QGIS plugin
 This plugin creates graphs
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2024-04-16
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Jilin University
        email                : 1970329479@qq.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import sqlite3
import sys
# import resources_rc
# import pydevd_pycharm
from PyQt5 import QtGui
from PyQt5.QtCore import QMimeData,Qt,QObject
from PyQt5.QtGui import QIcon, QFont, QColor
from PyQt5.QtWidgets import QVBoxLayout, QHBoxLayout, QFileDialog, QMainWindow, QMessageBox, QStatusBar, QLabel, \
    QComboBox, QWidget
from qgis.PyQt import uic

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
from qgis._core import QgsLayerTreeModel, QgsProject, QgsCoordinateReferenceSystem, QgsVectorLayer, QgsMapLayer, \
    QgsApplication, QgsPrintLayout, QgsLayoutSize, QgsLayoutItemLegend, QgsLayoutExporter, QgsUnitTypes, QgsLayerTree, \
    QgsLayoutItemMap, QgsLayoutPoint, QgsLayoutItemScaleBar, QgsLayoutItemLabel, QgsRectangle, QgsMapSettings, \
    QgsLayoutItemPage, QgsLegendRenderer, QgsLegendStyle, QgsLayerTreeNode, QgsLayoutItemMapGrid, QgsLayoutItemPicture
from qgis._gui import QgsLayerTreeView, QgsMapCanvas, QgsLayerTreeMapCanvasBridge, QgsMapToolIdentifyFeature
from qgis.core import QgsMapLayerType
from qgis.utils import iface

from .qgisUitils.plgSimplifyDialog import polygonSimplifyWindow
from .qgisUitils.plgEliminateDialog import polygonEliminateWindow
from .qgisUitils.fielddissolveDialog import FieldDissolveWindow
from .qgisUitils.plgSmoothDialog import   polygonSmoothWindow
from .qgisUitils.plgExaggerateDialog import  polygonExaggerateWindow
from .qgisUitils.layerLayoutDialog import layerLayoutDialog
from .qgisUitils.LabelDialog import  SetlabelWindow
from .qgisUitils.LayerUtils import  addMapLayer,readVectorFile,readRasterFile
from .qgisUitils.qgisMenu import  menuProvider
from .qgisUitils.ChangeProjDialog import ProjChangeWindow

from .qgisUitils.layerPropWindowWidgter import LayerPropWindowWidgeter

sys.path.append(os.path.dirname(__file__))
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'TryMainWindow.ui'))

PROJECT = QgsProject.instance()


class MyQObject(QObject):
    def __del__(self):
        print("QObject被销毁了！")


class CartoGraphDialog(QMainWindow, FORM_CLASS):
    def __init__(self, iface,parent=None):
        """Constructor."""
        super(CartoGraphDialog, self).__init__(parent)
        self.setupUi(self)
        self.iface = iface
        self.qobject = QObject()
        self.qobject.destroyed.connect(self.on_object_destroyed)

        self.setWindowTitle("Cartographer")
        # 2 初始化图层树
        vl = QVBoxLayout(self.dockWidgetContents)  #左侧目录树以垂直形式布局
        self.layerTreeView = QgsLayerTreeView(self)
        vl.addWidget(self.layerTreeView)
        # 3 初始化地图画布
        self.mapCanvas = QgsMapCanvas(self)
        hl = QHBoxLayout(self.frame)  #ui中有frame和dockwidget，右侧画布(frame)以水平形式布局
        hl.setContentsMargins(0, 0, 0, 0)  # 设置周围间距
        hl.addWidget(self.mapCanvas)
        # 4 设置图层树风格
        self.model = QgsLayerTreeModel(PROJECT.layerTreeRoot(), self)
        self.model.setFlag(QgsLayerTreeModel.AllowNodeRename)  # 允许图层节点重命名
        self.model.setFlag(QgsLayerTreeModel.AllowNodeReorder)  # 允许图层拖拽排序
        self.model.setFlag(QgsLayerTreeModel.AllowNodeChangeVisibility)  # 允许改变图层节点可视性
        self.model.setFlag(QgsLayerTreeModel.ShowLegendAsTree)  # 展示图例
        self.model.setAutoCollapseLegendNodes(10)  # 当节点数大于等于10时自动折叠
        self.layerTreeView.setModel(self.model)
        # 4 建立图层树与地图画布的桥接
        self.layerTreeBridge = QgsLayerTreeMapCanvasBridge(PROJECT.layerTreeRoot(), self.mapCanvas, self)

        # 5 初始加载影像
        self.firstAdd = True
        # 6 允许拖拽文件
        self.setAcceptDrops(True)  #继承的QWidget的属性
        # 7 图层树右键菜单创建
        self.rightMenuProv = menuProvider(self)
        self.layerTreeView.setMenuProvider(self.rightMenuProv)  #定义菜单的样式类来源
        # 8.0 设置默认参考坐标系为WGS84
        self.mapCanvas.setDestinationCrs(QgsCoordinateReferenceSystem("EPSG:4326"))

        # 8 状态栏控件
        self.statusBar = QStatusBar()
        self.statusBar.setStyleSheet('color: black; border: none')
        self.statusXY = QLabel('{:<40}'.format(''))  # x y 坐标状态
        self.statusBar.addWidget(self.statusXY, 1)
        self.statusScaleLabel = QLabel('比例尺')
        self.statusScaleComboBox = QComboBox(self)
        self.statusScaleComboBox.setFixedWidth(120)
        self.statusScaleComboBox.addItems(  #comboBox用来选择比例尺
            ["1:500", "1:1000", "1:2500", "1:5000", "1:10000", "1:25000", "1:100000", "1:500000", "1:1000000"])
        self.statusScaleComboBox.setEditable(True)
        self.statusBar.addWidget(self.statusScaleLabel)
        self.statusBar.addWidget(self.statusScaleComboBox)
        self.statusCrsLabel = QLabel( #获取并打印图层的坐标系统以及对应ID
            f"坐标系: {self.mapCanvas.mapSettings().destinationCrs().description()}-{self.mapCanvas.mapSettings().destinationCrs().authid()}")
        self.statusBar.addWidget(self.statusCrsLabel) #貌似不需要设置控件位置，只需要在状态栏中添加
        self.setStatusBar(self.statusBar)

        # A 按钮、菜单栏功能
        self.connectFunc()

        # B 初始设置控件
        self.action_Editshp.setEnabled(False)
        self.editTempLayer: QgsVectorLayer = self.layerTreeView.currentLayer()  # 设置为none代表当前处于不能编辑状态

        #为操作按钮设置图标
        icon4 = QtGui.QIcon()
        icon4.addPixmap(QtGui.QPixmap(":/plugins/CartoGrapher/resources/OpenShp.svg"), QtGui.QIcon.Normal, QtGui.QIcon.On)
        self.action_0.setIcon(icon4)

        icon5 = QtGui.QIcon()
        icon5.addPixmap(QtGui.QPixmap(":/plugins/CartoGrapher/resources/OpenRaster.svg"), QtGui.QIcon.Normal,QtGui.QIcon.On)
        self.action_1.setIcon(icon5)

        icon1 = QtGui.QIcon()
        icon1.addPixmap(QtGui.QPixmap(":/plugins/CartoGrapher/resources/sign.svg"), QtGui.QIcon.Normal, QtGui.QIcon.On)
        self.action_2.setIcon(icon1)

        icon2 = QtGui.QIcon()
        icon2.addPixmap(QtGui.QPixmap(":/plugins/CartoGrapher/resources/click.svg"), QtGui.QIcon.Normal, QtGui.QIcon.On)
        self.action_3.setIcon(icon2)

        icon3 = QtGui.QIcon()
        icon3.addPixmap(QtGui.QPixmap(":/plugins/CartoGrapher/resources/delete.svg"), QtGui.QIcon.Normal, QtGui.QIcon.On)
        self.action_4.setIcon(icon3)

        icon6 = QtGui.QIcon()
        icon6.addPixmap(QtGui.QPixmap(":/plugins/CartoGrapher/resources/Reproj.svg"), QtGui.QIcon.Normal,
                        QtGui.QIcon.On)
        self.action_5.setIcon(icon6)


    def connectFunc(self):
        """窗体控件都包含一个trigger，在此处设置插件中动态控件的连接"""
        self.ActionOpen_raster.triggered.connect(self.actionOpenRasterTriggered)
        self.action_1.triggered.connect(self.actionOpenRasterTriggered)
        self.ActionOpen_shp.triggered.connect(self.actionOpenShpTriggered)
        self.action_0.triggered.connect(self.actionOpenShpTriggered)
        self.mapCanvas.destinationCrsChanged.connect(self.showCrs) #不只是监听控件的变化，还可以监听属性值的改变建立连接
        self.mapCanvas.scaleChanged.connect(self.autoScaleChange) #代表图层缩放时比例尺的自动变化
        self.statusScaleComboBox.editTextChanged.connect(self.editScaleChange) #代表通过改变comboBox的方式修改比例尺
        self.mapCanvas.xyCoordinates.connect(self.showXY) #xyCoordinates函数同样返回的是signals
        self.layerTreeView.clicked.connect(self.layerClicked)
        self.action_Editshp.triggered.connect(self.actionEditShp) #此处是一个事件函数
        self.action_2.triggered.connect(self.actionEditShp) #此处是一个事件函数
        self.action_Selectfeature.triggered.connect(self.actionSelectFeatureTriggered) #启动编辑
        self.action_3.triggered.connect(self.actionSelectFeatureTriggered) #启动编辑
        self.action_Deletefeature.triggered.connect(self.actionDeleteShp)
        self.action_4.triggered.connect(self.actionDeleteShp)
        self.action_DissolveByField.triggered.connect(self.actionDissolveByField)  #单击动作启动同属性合并
        self.action_EliminatePolygon.triggered.connect(self.actionEliminatePolygons)
        self.action_Simplify.triggered.connect(self.actionSimplifyPolygons)
        self.action_TransformCrs.triggered.connect(self.TransformCrs) #修改图层参考坐标系
        self.action_5.triggered.connect(self.TransformCrs) #修改图层参考坐标系
        self.action_Layout.triggered.connect(self.mapLayout)
        self.action_Smooth.triggered.connect(self.actionSmoothPolygons)
        self.action_Exaggerate.triggered.connect(self.actionExaggeratePolygons)
        self.action_Setlabel.triggered.connect(self.actionSetlabel)

    def on_object_destroyed(self):
        """"""
        print('底层对象已被删除')

    def actionSetlabel(self):
        """Setting label format"""
        if self.action_Setlabel.isChecked():
            self.labelWindow = SetlabelWindow(self.layerTreeView.currentLayer(),self)
            self.labelWindow.show()
        else:
            self.layerTreeView.currentLayer().setLabelsEnabled(False)

    def actionExaggeratePolygons(self):
        """Exaggerate selected polygons"""
        self.exaggerateWindow = polygonExaggerateWindow(self.layerTreeView.currentLayer(),self)
        self.exaggerateWindow.show()

    def actionSmoothPolygons(self):
        """Smooth the polygons """
        self.smoothWindow = polygonSmoothWindow(self.layerTreeView.currentLayer(),self.iface,self)
        self.smoothWindow.show()

    def mapLayout(self):
        """Setting the lay out items and legends"""
        self.layout = layerLayoutDialog(self.layerTreeView.currentLayer(),self.iface,self)
        self.layout.show()
        # layer = self.layerTreeView.currentLayer()
        #
        # project = QgsProject.instance()
        # manager = project.layoutManager()
        # layoutName = 'MyLayout'
        # layouts_list = manager.printLayouts()
        # # 移除项目中重复的布局
        # for layout in layouts_list:
        #     if layout.name() == layoutName:
        #         manager.removeLayout(layout)
        # layout = QgsPrintLayout(project)
        # layout.initializeDefaults()
        # layout.pageCollection().pages()[0].setPageSize(QgsLayoutSize(310, 230, QgsUnitTypes.LayoutMillimeters))
        # layout.setName(layoutName)
        #
        # manager.addLayout(layout)
        #
        # # 获取页面大小
        # width = layout.width()
        # print(width)
        # page = QgsLayoutItemPage(layout)
        #
        # # 创建地图项目
        # map = QgsLayoutItemMap(layout)
        # map.setRect(20, 20, 20, 20)  #起始坐标的xy，高和宽，此处只是在初始化过程中的随意设置
        # map.zoomToExtent(iface.mapCanvas().extent())
        # map.setCrs(QgsCoordinateReferenceSystem(4610))
        # # print('extent now:',map.extent())
        # # print(map.crs())
        #
        #
        # # set the map extent
        # ms = QgsMapSettings()
        # ms.setDestinationCrs(QgsCoordinateReferenceSystem(4610))
        # # layer.setCrs(QgsCoordinateReferenceSystem(4610))
        # print("layer:",layer.crs())
        # print(ms.destinationCrs())
        # ms.setLayers([layer])  # set layers to be mapped
        # rect = QgsRectangle(ms.fullExtent()) #设置地图的全副作为地图的显示范围
        # # print('extent:',ms.fullExtent())  #到这里已经是xian 80坐标系
        # rect.scale(1.0) # 缩放比例系数，数值越大图层越小
        # ms.setExtent(rect)
        # map.setExtent(rect)
        # map.mapUnitsToLayoutUnits()
        # map.setFrameEnabled(True)
        #
        # map.setBackgroundColor(QColor(255, 255, 255, 0))
        # # map.zoomToExtent(iface.mapCanvas().extent())
        # layout.addLayoutItem(map)
        #
        # map.attemptMove(QgsLayoutPoint(20, 30, QgsUnitTypes.LayoutMillimeters))
        # map.attemptResize(QgsLayoutSize(160, 160, QgsUnitTypes.LayoutMillimeters))
        #
        #
        # #设置图例
        # legend = QgsLayoutItemLegend(layout)
        # legend.setTitle("图     例")
        # legend.setTitleAlignment(Qt.AlignmentFlag.AlignHCenter) #设置图例水平居中
        # layerTree = QgsLayerTree()
        # layerTree.addLayer(layer)
        # legend.model().setRootGroup(layerTree)
        # tree_layer = legend.model().rootGroup().findLayer(layer)  # QgsLayerTreeLayer 继承自 QgsLayerTreeNode
        # print(tree_layer)
        # QgsLegendRenderer.setNodeLegendStyle(tree_layer, QgsLegendStyle.Hidden) #设置起始节点隐藏
        # legend.updateLegend()
        # legend.setLegendFilterByMapEnabled(True)
        # layout.addLayoutItem(legend)
        # legend.attemptMove(QgsLayoutPoint(210, 15, QgsUnitTypes.LayoutMillimeters))
        #
        # # 设置比例尺
        # scalebar = QgsLayoutItemScaleBar(layout)
        # scalebar.setStyle('Single Box')
        # scalebar.setUnits(QgsUnitTypes.DistanceKilometers)
        # scalebar.setNumberOfSegments(3)  #比例尺上分隔线的数量
        # scalebar.setNumberOfSegmentsLeft(0)
        # scalebar.setUnitsPerSegment(1)
        # scalebar.setLinkedMap(map)
        # scalebar.setUnitLabel('km')
        # scalebar.setFont(QFont('Arial', 14))
        # scalebar.update()
        # scalebar.attemptResize(QgsLayoutSize(23,23,QgsUnitTypes.LayoutMillimeters))
        # layout.addLayoutItem(scalebar)
        # scalebar.attemptMove(QgsLayoutPoint(270, 25, QgsUnitTypes.LayoutMillimeters))
        # print('runnnn')
        #
        #
        # #创建指北针
        # north = QgsLayoutItemPicture(layout)
        # north.setPicturePath("D:\\QGIS\\apps\\qgis\\svg\\arrows\\NorthArrow_02.svg")
        # layout.addLayoutItem(north)
        # north.attemptResize(QgsLayoutSize(18, 18, QgsUnitTypes.LayoutMillimeters))
        # north.attemptMove(QgsLayoutPoint(270, 5, QgsUnitTypes.LayoutMillimeters))
        #
        # # 创建网格
        # # 要用map.grid才能起作用
        # map.grid().setEnabled(True)
        # map.grid().setIntervalY(0.05)
        # map.grid().setIntervalX(0.05)
        # map.grid().setCrs(QgsCoordinateReferenceSystem(4610))
        # map.grid().setUnits(QgsLayoutItemMapGrid.MapUnit)
        # map.grid().setFrameStyle(QgsLayoutItemMapGrid.ExteriorTicks)
        # map.grid().setAnnotationFormat(3)  #设置标注格式
        # map.grid().setAnnotationEnabled(True)
        # # grid.setCrs(QgsCoordinateReferenceSystem(4610))
        #
        # #设置标题
        # title = QgsLayoutItemLabel(layout)
        # title.setText("内蒙古北山地区双红山幅地质图")
        # title.setFont(QFont('宋体', 24))
        # title.adjustSizeToText()
        # layout.addLayoutItem(title)
        # title.attemptMove(QgsLayoutPoint(60 , 5, QgsUnitTypes.LayoutMillimeters)) #使得标题水平居中
        #
        # layout = manager.layoutByName(layoutName)
        # exporter = QgsLayoutExporter(layout)
        #
        # fn = 'D:\\专业课资料\\毕业设计\\测试数据\\layout_export.pdf'
        # fn2 = 'D:\\专业课资料\\毕业设计\\测试数据\\layout_export.png'
        # exporter.exportToImage(fn2, QgsLayoutExporter.ImageExportSettings())
        # exporter.exportToPdf(fn, QgsLayoutExporter.PdfExportSettings())
        # QMessageBox.information(self,'Process result','The lay out has been exported successfully!',QMessageBox.Ok)

    def TransformCrs(self):
        """Change the coordination system of the layer """
        layer = self.layerTreeView.currentLayer()
        if layer == '':
            QMessageBox.warning(self,'Process error','Please put in file!')
        self.projWindow = ProjChangeWindow(self.layerTreeView.currentLayer(),self)
        self.projWindow.show()
        # # layer.setCrs(QgsCoordinateReferenceSystem(4326,QgsCoordinateReferenceSystem.EpsgCrsId))
        # con = sqlite3.connect(QgsApplication.srsDatabaseFilePath())
        # cur = con.cursor()
        # cur.execute('select * from vw_srs')
        # rows = cur.fetchall()
        # for crs in rows:
        #     # do something...
        #     print(crs)
        # cur.close()
        # con.close()


    def actionSimplifyPolygons(self):
        """This function is used to show the simplification pop up"""
        self.simplifyWindow = polygonSimplifyWindow(self.layerTreeView.currentLayer(),self)
        self.simplifyWindow.show()

    def actionEliminatePolygons(self):
        """This function is used to show elimination pop up """
        self.eliminateWindow = polygonEliminateWindow(self.layerTreeView.currentLayer(),self)
        self.eliminateWindow.show()

    def actionDissolveByField(self):
        """本函数用于启动同属性合并弹窗"""
        self.dissolveWindow = FieldDissolveWindow(self.layerTreeView.currentLayer(),self)
        self.dissolveWindow.show()

    def actionDeleteShp(self):
        if not self.editTempLayer.isEditable():
            QMessageBox.warning(self,'错误提示','当前图层未处于编辑状态!',QMessageBox.Close)
            return
        elif len(self.editTempLayer.selectedFeatureIds()) == 0:
            QMessageBox.warning(self,'错误提示','你没有选中任何要素!',QMessageBox.Close)
        else:
            self.editTempLayer.deleteSelectedFeatures()

    def selectToolIdentified(self, feature): #选中要素
        print(feature.id())
        layerTemp: QgsVectorLayer = self.layerTreeView.currentLayer()
        if layerTemp.type() == QgsMapLayerType.VectorLayer:
            if feature.id() in layerTemp.selectedFeatureIds(): #如果已经选中了则取消选中
                layerTemp.deselect(feature.id())
            else:
                layerTemp.removeSelection() #取消当前的选中
                layerTemp.select(feature.id())


    def actionSelectFeatureTriggered(self):
        if self.action_Selectfeature.isChecked(): #控件被勾选后
            if self.mapCanvas.mapTool():  #mapTool包括拖拽图层、缩放等
                self.mapCanvas.unsetMapTool(self.mapCanvas.mapTool())
            self.selectTool = QgsMapToolIdentifyFeature(self.mapCanvas)
            self.selectTool.setCursor(Qt.ArrowCursor)  #设置指针样式为箭头
            self.selectTool.featureIdentified.connect(self.selectToolIdentified)  #featureIdentified返回选中的要素ID作为参数
            layers = self.mapCanvas.layers()
            if layers:
                self.selectTool.setLayer(self.layerTreeView.currentLayer())
            self.mapCanvas.setMapTool(self.selectTool)
        else:
            layerTemp: QgsVectorLayer = self.layerTreeView.currentLayer()
            layerTemp.removeSelection()
            if self.mapCanvas.mapTool():
                self.mapCanvas.unsetMapTool(self.mapCanvas.mapTool())

    def layerClicked(self):  #图层被单击、双击时触发事件
        curLayer: QgsMapLayer = self.layerTreeView.currentLayer()
        if curLayer and type(curLayer) == QgsVectorLayer and not curLayer.readOnly():
            self.action_Editshp.setEnabled(True)
        else:
            self.action_Editshp.setEnabled(False)

    def actionEditShp(self):
        self.editTempLayer: QgsVectorLayer = self.layerTreeView.currentLayer()
        if self.action_Editshp.isChecked():  #如果控件被打勾了
            eidtBox = QMessageBox.question(self,'信息提示','确定要开启编辑模式吗?',QMessageBox.Yes | QMessageBox.No, QMessageBox.Yes)
            if eidtBox == QMessageBox.Yes:
                self.editTempLayer.startEditing()
            else:
                self.action_Editshp.setEnabled(True)
        else:
            saveShpEdit = QMessageBox.question(self, '保存编辑', "确定要将编辑内容保存到内存吗？", QMessageBox.Yes | QMessageBox.No,
                                               QMessageBox.No)
            if saveShpEdit == QMessageBox.Yes:
                self.editTempLayer.commitChanges()
            else:
                self.editTempLayer.rollBack()
        self.mapCanvas.refresh()
        # self.editTempLayer = None

    def autoScaleChange(self,scale): #scalechange事件会返回一个signal记号，需要设置参数
        self.statusScaleComboBox.setEditText(f"1:{int(scale)}")

    def showXY(self, point):
        x = point.x()
        y = point.y()
        self.statusXY.setText(f'{x:.6f}, {y:.6f}')

    def editScaleChange(self,str):
        left,right = str.split(':')[0],str.split(':')[-1]
        if int(left) == 1 and int(right) > 0 and int(right) != int(self.mapCanvas.scale()):
            self.mapCanvas.zoomScale(int(right))
            self.mapCanvas.zoomWithCenter()

    def showCrs(self):
        mapsettings:QgsMapCanvas.mapSettings = self.mapCanvas.mapSettings() #前面仅是指代类型，后面才是为类进行实例化
        #添加新的图层后，参考系标签内容自动变化
        self.statusCrsLabel.setText(f"坐标系: {mapsettings.destinationCrs().description()}-{mapsettings.destinationCrs().authid()}")


    def actionOpenRasterTriggered(self):
        data_file, ext = QFileDialog.getOpenFileName(self, '打开', '',
                                                 'GeoTiff(*.tif;*tiff;*img;*TIF;*TIFF);;All Files(*);;JPEG(*.jpg;*.jpeg;*.JPG;*.JPEG);;*.png;;*.pdf')
        if data_file:
            self.addRasterLayer(data_file)

    #设置允许拖拽文件
    def dragEnterEvent(self, fileData):
            if fileData.mimeData().hasUrls():
                fileData.accept()
            else:
                fileData.ignore()

    # 拖拽文件事件
    def dropEvent(self, fileData):
        mimeData: QMimeData = fileData.mimeData()   #QmimeData以一种合适的形式存储数据信息，并能用于复制和拖拽等操作
        filePathList = [u.path()[1:] for u in mimeData.urls()]
        for filePath in filePathList:
            filePath: str = filePath.replace("/", "//")
            if filePath.split(".")[-1] in ["tif", "TIF", "tiff", "img","TIFF", "GTIFF", "png", "jpg", "pdf"]:   #进行拖入文件类型的判定
                self.addRasterLayer(filePath)
            elif filePath.split(".")[-1] in ["shp", "SHP", "gpkg", "geojson", "kml"]:
                self.addVectorLayer(filePath)
            elif filePath == "":
                pass
            else:
                QMessageBox.about(self, '警告', f'{filePath}为不支持的文件类型，目前支持栅格影像和shp矢量')

    #链接打开shp图层事件机制
    def actionOpenShpTriggered(self):
        data_file, ext = QFileDialog.getOpenFileName(self, '打开', '',
                                                     "ShapeFile(*.shp);;All Files(*);;Other(*.gpkg;*.geojson;*.kml)")
        if data_file:
            self.addVectorLayer(data_file)

    def addRasterLayer(self, rasterFilePath):
        rasterLayer = readRasterFile(rasterFilePath)
        if self.firstAdd:
            addMapLayer(rasterLayer, self.mapCanvas, True)
            self.firstAdd = False
        else:
            addMapLayer(rasterLayer, self.mapCanvas)  #若并非第一次加载图层，则使用当前画布的默认设置

    def addVectorLayer(self, vectorFilePath):
        vectorLayer = readVectorFile(vectorFilePath)
        if self.firstAdd:
            addMapLayer(vectorLayer, self.mapCanvas, True)
            self.firstAdd = False
        else:
            addMapLayer(vectorLayer, self.mapCanvas)

    def addRasterLayer(self, rasterFilePath):
        rasterLayer = readRasterFile(rasterFilePath)
        if self.firstAdd:
            addMapLayer(rasterLayer, self.mapCanvas, True)
            self.firstAdd = False
        else:
            addMapLayer(rasterLayer, self.mapCanvas)