# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CartoDruidSyncDialog
                                 A QGIS plugin
 Plugin to synchronize SQLite databases to Cartodruid Synchronization services at ITACyL
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2023-01-20
        git sha              : $Format:%H$
        copyright            : (C) 2023 by ITACyL
        email                : gustavo.rio@itacyl.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os
from urllib.parse import urlparse

from qgis.core import QgsApplication
from PyQt5.QtGui import QTextCursor
from PyQt5.QtWidgets import QMessageBox, QDialog, QTextEdit
from qgis.PyQt import QtWidgets
from qgis.PyQt import uic

if os.environ.get("TEST_RUNNING", 0):
    from dialog_table_filter import TableFilterScreen
    import plugin_settings as stt
    from plugin_settings import WksConfig
else:
    from .dialog_table_filter import TableFilterScreen
    from . import plugin_settings as stt
    from .plugin_settings import WksConfig

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
# FORM_CLASS, _ = uic.loadUiType(os.path.join(
#     os.path.dirname(__file__), 'cartodruid_sync_dialog_base.ui'))
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'dialog_conf_sync.ui'))


class CartoDruidConfSyncDialog(QtWidgets.QDialog, FORM_CLASS):

    def __init__(self, parent=None, listener=None):
        """Constructor."""
        super(CartoDruidConfSyncDialog, self).__init__(parent)
        self.listener = listener
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)

        self.wks_config = None
        self.table_list = None
        self.selection_list = None
        self.plugin_confs = None

        self.__initGui()

    def __initGui(self):
        # go to first screen
        self.__go_wks_config()
        # bind actions to ui components
        self.btn_next.clicked.connect(self.__go_table_filter)
        self.btn_prev.clicked.connect(self.__go_wks_config)
        self.btn_help_wks.clicked.connect(self.__open_help_dialog)
        self.__create_help_dialog()
        self.dlg_table_filter = TableFilterScreen(dialog=self, listener=self.listener)

    def __create_help_dialog(self):
        dialog = QDialog()
        dialog.setFixedSize(475, 300)
        text_edit = QTextEdit()
        text_edit.setReadOnly(True)
        # get current user language to find proper info.
        lang = QgsApplication.instance().locale()
        if lang not in ["en", "es"]:  # TODO: make this dynamic
            lang = "en"
        html_file = stt.resolve_path(f"i18n/wks_help.{lang}.html")
        with open(html_file, "r") as file:
            help_content = file.read().replace("\n", "")

        text_edit.insertHtml(help_content)
        text_edit.moveCursor(QTextCursor.Start)
        layout = QtWidgets.QVBoxLayout()
        layout.addWidget(text_edit)
        dialog.setLayout(layout)
        dialog.setModal(True)
        self.help_dialog = dialog

    def __open_help_dialog(self):
        self.help_dialog.show()

    def go_config(self):
        self.__go_wks_config()

    def __go_wks_config(self):
        self.stackedWidget.setCurrentIndex(0)

    def __go_table_filter(self):
        messages = self.validate()
        if messages:
            QMessageBox.question(None, "Error en los datos", "\n".join(messages), QMessageBox.Ok)
            return
        self.stackedWidget.setCurrentIndex(1)

    def load_settings(self, wks_config: WksConfig):
        """
        Load sync configuration into dialog dialog widgets
        :param wks_config:
        :return:
        """
        if wks_config is None:
            return

        self.wksId.setText(wks_config.wks)
        self.userName.setText(wks_config.username)
        self.userApikey.setText(wks_config.apikey)
        self.endpoint.setText(wks_config.endpoint)
        self.fileWidget.setFilePath(wks_config.db_file)

        self.dlg_table_filter.load_settings(wks_config)

    def accept(self):
        messages = self.validate()
        if messages:
            QMessageBox.question(None, "Error en los datos", "\n".join(messages), QMessageBox.Ok)
            return
        super().accept()

    def close(self):
        self.__go_wks_config()
        super().close()

    def validate(self):
        wks_config = self.get_wks_config()
        messages = []
        for attribute, info_msg in [("wks", "identificador workspace"), ("username", "Nombre de usuario"),
                                    ("apikey", "apikey"), ("endpoint", "endpoint"),
                                    ("db_file", "fichero de la bd")]:
            value = getattr(wks_config, attribute)
            if not value:
                messages.append(f"El campo {info_msg} es obligatorio.")
        # check endpoint format
        try:
            result = urlparse(wks_config.endpoint)
            if not all([result.scheme, result.netloc]):
                raise Exception("Invalid URL")
        except Exception:
            messages.append("El campo endpoint tiene un formato incorrecto.")
        return messages

    def get_wks_config(self):
        """
        Returns WksConfig object created from user input
        :return:
        """
        wks = self.wksId.text()
        username = self.userName.text()
        apikey = self.userApikey.text()
        endpoint = self.endpoint.text()
        file_path = self.fileWidget.filePath().replace('\\', '/')
        table_filter = self.dlg_table_filter.get_table_filter()

        return stt.WksConfig(file_path, wks, username, apikey, endpoint, table_filter=table_filter)
