# -*- coding: utf-8 -*-
"""
/***************************************************************************
 carte25k
                                 A QGIS plugin
 carte25k
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-09-11
        git sha              : $Format:%H$
        copyright            : (C) 2019 by ENSG
        email                : jacques.beilin@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction

from qgis.core import Qgis, QgsProject, QgsPageSizeRegistry, QgsLayoutItemPage, \
                        QgsCoordinateReferenceSystem, QgsCoordinateTransform, \
                        QgsPrintLayout, QgsLayoutItemMap, QgsLayoutItemMapGrid, \
                        QgsLayoutItemLabel, QgsLayoutPoint, QgsUnitTypes, \
                        QgsLayoutSize, QgsLayoutExporter, QgsLayoutItemPage, \
                        QgsRectangle, QgsPoint
                        
from qgis.gui import QgsMapToolEmitPoint

from PyQt5.QtWidgets import QFileDialog
from PyQt5.QtCore import Qt

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .carte25k_dialog import carte25kDialog
from .gpstime import gpstime
import os.path
import re
import json
import numpy as np

class carte25k:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        self.home_dir = os.path.expanduser("~")

        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'carte25k_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&carte25k')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None
        
        

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('carte25k', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/carte25k/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u''),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&carte25k'),
                action)
            self.iface.removeToolBarIcon(action)
            
    def loadParams(self):    

        with open(os.path.join(self.plugin_dir,'conf','config.json'), "r") as f:  
            L = f.readlines()
            s = ""
            for l in L:
                s += l
            self.config = json.loads(s)
            
            
        try:
            self.PATH_SAVE_PDF = self.config["output_pdf_file"]
        except:
            self.PATH_SAVE_PDF = ""
            
        self.config["output_pdf_file"] = self.PATH_SAVE_PDF
        self.dlg.pdfFileName.setText(self.PATH_SAVE_PDF) 
        
        project = QgsProject.instance() 
        
        self.dlg.pbCreateMap.clicked.connect(self.createMap)
        
        taillesPages = QgsPageSizeRegistry()
        c = 0
        defaultPage = "A4"
        posDefault = 0
        for page in taillesPages.entries():
            self.dlg.formatsPage.addItem(page.displayName)
            if re.search(page.displayName, defaultPage):
                posDefault = c      
            c+=1
            
        self.dlg.formatsPage.setCurrentIndex(posDefault)
        
        self.dlg.MapCrsWidget.setCrs(project.crs())
        
        for sc in self.config["Scales"]:
            self.dlg.scale.addItem(str(sc))
            
        self.writeJsonConfigFile()
            
    def writeJsonConfigFile(self):
        with open(os.path.join(self.plugin_dir,'conf','config.json'), "w") as write_file:
            json.dump(self.config, write_file, indent=4)
            
    def SetPdfFileName(self):
        fileName = QFileDialog.getSaveFileName(self.dlg, u"Set file name for pdf export", self.PATH_SAVE_PDF, filter="*.pdf")# | QFileDialog.DontResolveSymlinks )
        print("fichier pdf :", fileName[0])

        if not fileName:
            return

        self.PATH_SAVE_PDF = fileName[0]
        self.dlg.pdfFileName.setText(self.PATH_SAVE_PDF)
        self.config["output_pdf_file"] = self.PATH_SAVE_PDF
        
        self.writeJsonConfigFile()
       
    def createMap(self):    
        
        rect = self.iface.mapCanvas().extent()
        title = "map"     
        t = gpstime()
        outPathPdf = os.path.join(self.home_dir, "qgis_PrintLayout_Carte25k_%s.pdf" % t.st_iso_epoch())
        taillesPages = QgsPageSizeRegistry()
        taillePage = taillesPages.find(self.dlg.formatsPage.currentText())[0]
        print("Page size : ", self.dlg.formatsPage.currentText(), taillePage)
        if self.dlg.paysage.isChecked():
            orientation = QgsLayoutItemPage.Landscape
        else:
            orientation = QgsLayoutItemPage.Portrait
            
        scale = float(self.dlg.scale.currentText())
        
        mapCrs = self.dlg.MapCrsWidget.crs()
        
        gridCrs = self.dlg.GridCrsWidget.crs()
        
        try:
            bboxOrPoint = self.mapCenter
        except:
            bboxOrPoint = rect
            
        self.exportLayout(mapCrs, gridCrs, taillePage, orientation, scale, bboxOrPoint, title, outPathPdf)
        try:
            del self.mapCenter
        except:
            print("Unable to delete mapCenter")
        self.dlg.coord.setText("")

        
    def exportLayout(self, mapCrs, gridCrs, pageSize, orientation, scale, bboxOrPoint, title, outPathPdf, mapLayerList = [], layoutName = "PrintLayout_Carte25k"):
        """ Export de la carte vers une image ou un pdf 
        
        param crs:
        type crs: 
        param pageSize:
        type pageSize:
        param orientation:
        type orientation:
        param scale:
        type scale:
        param bboxOrPoint: emprise de la cart ou centre de la carte
        type bboxOrPoint: QgsRectangle ou QgsPoint
        param title: titre en bas a gauche de la carte
        type title: str
        param outPath: chemin complet de la carte exportee
        type outPath: str
        param mapLayerList: liste des layer a dessiner. Si la liste est vide on affiche tout ce qui est visible
        type mapLayerList: liste de [QgsVectorLayer, QgsRasterLayer]
        param layoutName:
        type layoutName:
        
        Source : https://data.library.virginia.edu/how-to-create-and-export-print-layouts-in-python-for-qgis-3/
        
        """

        # Recuperation du projet courant
        project = QgsProject.instance() 
        
        print(mapCrs.description())
        
        s = str(type(bboxOrPoint))
        print(s)
        if re.search('QgsRectangle', s):
            rect = bboxOrPoint
        else:          
            delta = 1e-4
            rect = QgsRectangle(bboxOrPoint.x() - delta, bboxOrPoint.y() - delta, bboxOrPoint.x() + delta, bboxOrPoint.y() + delta)
        
        print(rect)

        # Passage en web Mercator
#        crs3758 = QgsCoordinateReferenceSystem("epsg:3857")
#        project.setCrs(crs3758)
        #FIXME : rendre la zone UTM dépendante de la longitude du centre de zone
#        nZoneUtm = 32
#        crsUTM = QgsCoordinateReferenceSystem("epsg:326%02d" % (nZoneUtm))
    
        tr = QgsCoordinateTransform(QgsProject.instance().crs(), mapCrs, QgsProject.instance())
        rect = tr.transform(rect)
        
        # Creation ou recuperation du layout d'impression
        manager = project.layoutManager() 
        layouts_list = manager.printLayouts()
        
        if len(layouts_list) == 0:
            layout = QgsPrintLayout(project)  
            layout.setName(layoutName)
            manager.addLayout(layout)
        else:
            layout_exist = False
            for layout in layouts_list:
                if layout.name() == layoutName:
                    layout_exist = True
                    print('Cleaning layout')
                    layout.clear()
                    break
                if not layout_exist:
                    layout = QgsPrintLayout(project)
                    layout.setName(layoutName)
                    manager.addLayout(layout)
                    
                    
        #initializes default settings for blank print layout canvas
        layout.initializeDefaults()  
        
        # dimentionnement de la page
        pc = layout.pageCollection()
        page = pc.pages()[0]
        page.setPageSize(pageSize.displayName, orientation)
#        print(page.pageSize().width(), page.pageSize().height(), page.orientation())
          
        # Ajout de la carte
        map = QgsLayoutItemMap(layout)
        # deplacement et changement de taille du layout
        marge = 15
#        print("scale", scale)
#        print("page", page.pageSize().width(), page.pageSize().height())
        width = (page.pageSize().width() - 2 * marge) * scale 
        height = (page.pageSize().height() - 2 * marge) * scale
        xCenter = 0.5 * (rect.xMinimum() + rect.xMaximum())
        yCenter = 0.5 * (rect.yMinimum() + rect.yMaximum())
#        print("center", xCenter, yCenter, "width", width, "height", height)
        xMin = xCenter - width / 1e3 / 2
        xMax = xCenter + width / 1e3 / 2
        yMin = yCenter - height / 1e3 / 2
        yMax = yCenter + height / 1e3 / 2
#        print("rectprint",xMin, yMin, xMax, yMax)
        rectPrint = QgsRectangle(xMin, yMin, xMax, yMax)
        
        map.attemptMove(QgsLayoutPoint(marge, marge, QgsUnitTypes.LayoutMillimeters))
        map.attemptResize(QgsLayoutSize(width / scale, height / scale, QgsUnitTypes.LayoutMillimeters))  
        map.setLayers(mapLayerList)
        map.setFrameEnabled(True)
        map.setCrs(mapCrs)
        map.setExtent(rectPrint)
        map.updateBoundingRect()
        layout.addLayoutItem(map)
        map.setScale(scale)
        
        print("Scale =", scale)

        # grille
        grid = QgsLayoutItemMapGrid("grid", map)
        grid.setCrs(gridCrs)
        
        terrain_tickmarks_interval = scale * self.config["tickmarks_interval_cm"] / 100
        print("terrain_tickmarks_interval =", terrain_tickmarks_interval)
        
        if grid.crs().isGeographic():
            terrain_tickmarks_interval *= 2
            d2r = np.pi / 180
            coord_intervals_seconds = self.config["coord_intervals_seconds"]
            print(coord_intervals_seconds)
            coord_intervals_meters = np.array(coord_intervals_seconds) / 3600 * d2r * 6378137.0
            print(coord_intervals_meters)
            coord_intervals_meters2 = np.abs(terrain_tickmarks_interval - coord_intervals_meters)
            print(coord_intervals_meters2)
            mini = np.argmin(coord_intervals_meters2)
            intervals_seconds = coord_intervals_seconds[mini]
            dxy = intervals_seconds / 3600
            print(scale, mini, intervals_seconds, dxy)
            
            grid.setIntervalX(dxy) 
            grid.setIntervalY(dxy)
            grid.setAnnotationFormat(QgsLayoutItemMapGrid.DegreeMinute)
        else:
            coord_intervals_meters = np.array(self.config["coord_intervals_meters"])
            coord_intervals_meters2 = np.abs(terrain_tickmarks_interval - coord_intervals_meters)
            mini = np.argmin(coord_intervals_meters2)
            dxy = coord_intervals_meters[mini]
            
            grid.setIntervalX(dxy) 
            grid.setIntervalY(dxy)
            grid.setAnnotationFormat(QgsLayoutItemMapGrid.CustomFormat)
            grid.setAnnotationExpression('@grid_number / 1000')
            grid.setAnnotationPrecision(0)

      
        grid.setStyle(QgsLayoutItemMapGrid.Cross)
        grid.setFrameStyle(QgsLayoutItemMapGrid.InteriorTicks)
        grid.setAnnotationEnabled(True)
        grid.setAnnotationDirection(QgsLayoutItemMapGrid.Vertical, QgsLayoutItemMapGrid.Left)
        grid.setAnnotationDirection(QgsLayoutItemMapGrid.VerticalDescending, QgsLayoutItemMapGrid.Right)

        map.grids().addItem(grid)

        label = QgsLayoutItemLabel(layout)
        label.setText(gridCrs.authid() + ' - ' + gridCrs.description())
        label.attemptMoveBy(marge, page.pageSize().height() - 0.6 * marge)
        label.adjustSizeToText()
        layout.addItem(label)                                           
     
        layout.updateBounds()
        
        self.iface.messageBar().pushMessage(
                u"A printlayout has been created (menu Project/Layouts/PrintLayout_Carte25k)",
                level=Qgis.Success,
                duration=1
                ) 
        
        try:
            if not self.config["output_pdf_file"]=="":
                self.save2pdf(layout, self.config["output_pdf_file"])
        except Exception as err:
            self.iface.messageBar().pushMessage(
                    u"Unable to create pdf map (%s)" % self.config["output_pdf_file"],
                    level=Qgis.Error,
                    duration=1
                    ) 
            print(str(err))       
      
        self.dlg.close()
        
    def save2png(self, layout, outPath):

        exporter = QgsLayoutExporter(layout)
        
        try:
            exporter.exportToImage(outPath, QgsLayoutExporter.ImageExportSettings())
        except Exception as err:
            print(err)
            pass     
        
    def save2pdf(self, layout, outPath):

        exporter = QgsLayoutExporter(layout)
        settings = QgsLayoutExporter.PdfExportSettings()
        
        settings.writeGeoPdf = True
        settings.appendGeoreference = True
        
        try:
            settings.dpi = self.config["dpi"]
        except Exception as err:
            print(err)
            settings.dpi = 200
        
        try:
            exporter.exportToPdf(outPath, settings)
        except Exception as err:
            print(err)
            pass   
        
        
    def getPoint(self):
        self.dlg.hide()
        self.iface.mapCanvas().setMapTool(self.pointTool)
        
        
    def display_point(self, point):  
        self.mapCenter = QgsPoint(point.x(), point.y())
        
        self.dlg.coord.setText("E : %.3f, N : %.3f" % (self.mapCenter.x(), self.mapCenter.y()))
        self.dlg.show()
        self.pointTool.canvasClicked.disconnect()
        self.iface.mapCanvas().unsetMapTool(self.pointTool)
        

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = carte25kDialog()
            self.dlg.getXY.clicked.connect(self.getPoint)
            self.dlg.pb_data.clicked.connect(self.SetPdfFileName)
            self.loadParams() 

        # show the dialog
        self.dlg.show()
        self.dlg.MapCrsWidget.setCrs(QgsProject.instance().crs())
        self.dlg.setWindowFlags(Qt.WindowStaysOnTopHint)
        self.pointTool = QgsMapToolEmitPoint(self.iface.mapCanvas())
        self.pointTool.canvasClicked.connect(self.display_point)
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
