# -*- coding: utf-8 -*-

"""
/***************************************************************************
CartAGen4QGIS
A QGIS plugin
Cartographic generalization
Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
-------------------
        begin                : 2023-05-11
        copyright            : (C) 2023 by Guillaume Touya, Justin Berli & Paul Bourcier
        email                : guillaume.touya@ign.fr
 ***************************************************************************/
"""

__author__ = 'Guillaume Touya, Justin Berli & Paul Bourcier'
__date__ = '2023-05-11'
__copyright__ = '(C) 2023 by Guillaume Touya, Justin Berli & Paul Bourcier'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
from qgis.core import QgsProcessingProvider
from qgis.PyQt.QtGui import QIcon

class CartAGen4QGISProvider(QgsProcessingProvider):

    def __init__(self):
        """
        Default constructor.
        """
        QgsProcessingProvider.__init__(self)
        self._icon = None
        self._algorithms_loaded = False

    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        self._icon = None
        self._algorithms_loaded = False

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """
        # Éviter de charger plusieurs fois
        if self._algorithms_loaded:
            return
        
        try:
            # Import retardé pour éviter les problèmes de dépendances
            from .algorithms import (
                SquaringQGIS,
                BuildingSimplificationRuasQGIS,
                BuildingDisplacementRandomQGIS,
                MorphologicalAmalgamation,
                BoffetArea,
                ClosePolygon,
                VisvalingamWhyattQGIS,
                RaposoSimplificationQGIS,
                DouglasPeucker,
                GaussianSmoothing,
                DetectRoundaboutsQGIS,
                DetectDeadEnds,
                EliminateDeadEnds,
                CollapseRoundaboutsQGIS,
                DetectBranchingCrossroads,
                CollapseBranchingCrossroads,
                DetectDualCarriageways,
                CollapseDualCarriageways,
                BuildStrokes,
                RuralTraffic,
                ReduceKmeans,
                ReduceLabelgrid,
                ReduceQuadtree,
                HullDelaunay,
                HullSwingingArm,
                VectorHeatmap
            )

            # Buildings
            self.addAlgorithm(SquaringQGIS())
            self.addAlgorithm(BuildingSimplificationRuasQGIS())
            self.addAlgorithm(BuildingDisplacementRandomQGIS())
            self.addAlgorithm(MorphologicalAmalgamation())
            self.addAlgorithm(BoffetArea())
            self.addAlgorithm(ClosePolygon())
            
            # Lines
            self.addAlgorithm(VisvalingamWhyattQGIS())
            self.addAlgorithm(RaposoSimplificationQGIS())
            self.addAlgorithm(DouglasPeucker())
            self.addAlgorithm(GaussianSmoothing())
            
            # General
            # self.addAlgorithm(ConstraintMethodQGIS())

            # Network
            self.addAlgorithm(DetectRoundaboutsQGIS())
            self.addAlgorithm(DetectDeadEnds())
            self.addAlgorithm(EliminateDeadEnds())
            self.addAlgorithm(CollapseRoundaboutsQGIS())
            self.addAlgorithm(DetectBranchingCrossroads())
            self.addAlgorithm(CollapseBranchingCrossroads())
            self.addAlgorithm(DetectDualCarriageways())
            self.addAlgorithm(CollapseDualCarriageways())
            self.addAlgorithm(BuildStrokes())
            self.addAlgorithm(RuralTraffic())

            # Tools
            self.addAlgorithm(NetworkFacesQGIS())
            
            # Points
            self.addAlgorithm(ReduceKmeans())
            self.addAlgorithm(ReduceLabelgrid())
            self.addAlgorithm(ReduceQuadtree())
            self.addAlgorithm(HullDelaunay())
            self.addAlgorithm(HullSwingingArm())
            self.addAlgorithm(VectorHeatmap())
            
            self._algorithms_loaded = True
            
        except Exception as e:
            from qgis.core import QgsMessageLog, Qgis
            QgsMessageLog.logMessage(
                f"Error while loading CartAGen algorithms: {str(e)}",
                'CartAGen4QGIS',
                Qgis.Critical
            )

    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        return 'CartAGen'

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        return self.tr('CartAGen')

    def icon(self):
        """
        Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        # Hide the icon to avoid recreating it every time
        if self._icon is None:
            try:
                # Try to koad the icon from the parent module
                from cartagen4qgis import get_plugin_icon
                self._icon = get_plugin_icon()
            except Exception:
                # In case of error, return empty icon to avoid crash
                try:
                    self._icon = QIcon()
                except:
                    return QIcon()
        
        return self._icon

    def longName(self):
        """
        Returns the a longer version of the provider name, which can include
        extra details such as version numbers. E.g. "Lastools LIDAR tools
        (version 2.2.1)". This string should be localised. The default
        implementation returns the same string as name().
        """
        return self.name()