# -*- coding: utf-8 -*-

"""
/***************************************************************************
 CartAGen4QGIS
                                 A QGIS plugin
 Cartographic generalization
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-05-11
        copyright            : (C) 2023 by Guillaume Touya, Justin Berli & Paul Bourcier
        email                : guillaume.touya@ign.fr
 ***************************************************************************/
"""

__author__ = 'Guillaume Touya, Justin Berli & Paul Bourcier'
__date__ = '2023-05-11'
__copyright__ = '(C) 2023 by Guillaume Touya, Justin Berli & Paul Bourcier'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (
    QgsProcessing, QgsFeatureSink, QgsProcessingAlgorithm,
    QgsFeature, QgsGeometry, QgsProcessingParameterDefinition,
    QgsWkbTypes, QgsVectorLayer, QgsField, QgsFields
)
from qgis.core import (
    QgsProcessingParameterFeatureSource,
    QgsProcessingParameterFeatureSink,
    QgsProcessingParameterBoolean,
    QgsProcessingParameterNumber,
    QgsProcessingParameterDistance,
    QgsProcessingParameterField
)
from qgis.PyQt.QtCore import QVariant

class BuildStrokes(QgsProcessingAlgorithm):
    """
    This method computes the strokes in a Strokenetwork using a loop on network features, and updates its strokes attribute.

    Parameters:

            self (StrokeNetwork) – The network in which we expect to compute strokes

            attributeNames (list[str]) – List of attribute names to be used as a criteria for continuity.

            deviatAngle (float) – Thresholds for the maximum angle between two segments at the junction of two sections belonging to the same stroke.

            deviatSum – Thresholds for the maximum angle between two sections belonging to the same stroke.
    """

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.

    OUTPUT = 'OUTPUT'
    INPUT = 'INPUT'

    DEVIAT_ANGLE = 'DEVIAT_ANGLE'
    DEVIAT_SUM = 'DEVIAT_SUM'

    ATTRIBUTES_NAMES = 'ATTRIBUTES_NAMES'

    def initAlgorithm(self, config):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """

        # We add the input vector features source.
        self.addParameter(
            QgsProcessingParameterFeatureSource(
                self.INPUT,
                self.tr('Input road network'),
                [QgsProcessing.TypeVectorLine]
            )
        )
        
        deviat_angle = QgsProcessingParameterNumber(
            self.DEVIAT_ANGLE,
            self.tr('Maximum angle between two segments at a junction'),
            type=QgsProcessingParameterNumber.Double,
            defaultValue=45,
            optional=False
        )
        deviat_angle.setFlags(deviat_angle.flags() | QgsProcessingParameterDefinition.FlagAdvanced)
        self.addParameter(deviat_angle)

        deviat_sum = QgsProcessingParameterNumber(
            self.DEVIAT_SUM,
            self.tr('Maximum angle between two sections belonging to the same stroke'),
            type=QgsProcessingParameterNumber.Double,
            defaultValue=30,
            optional=False
        )
        deviat_sum.setFlags(deviat_sum.flags() | QgsProcessingParameterDefinition.FlagAdvanced)
        self.addParameter(deviat_sum)

        self.addParameter(QgsProcessingParameterField(self.ATTRIBUTES_NAMES,
            self.tr('Attributes to be used as a criteria for continuity'),
            None, 'INPUT', QgsProcessingParameterField.Any, True, optional = True))

        # We add a feature sink in which to store our processed features (this
        # usually takes the form of a newly created vector layer when the
        # algorithm is run in QGIS).
        self.addParameter(
            QgsProcessingParameterFeatureSink(
                self.OUTPUT,
                self.tr('Stroke network')
            )
        )

    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """
        from cartagen.enrichment.network import strokes_roads
        from cartagen4qgis.src.tools import list_to_qgis_feature
        import geopandas as gpd
        from shapely import Polygon
        from shapely.wkt import loads

        # Get the QGIS source from the parameters
        source = self.parameterAsSource(parameters, self.INPUT, context)

        # Convert the source to GeoDataFrame, get the list of records and the number of entities
        gdf = gpd.GeoDataFrame.from_features(source.getFeatures())

        feedback.setProgress(1) # set the loading bar to 1 %
        
        # Retrieve parameters
        deviat_angle = self.parameterAsDouble(parameters, self.DEVIAT_ANGLE, context)
        deviat_sum = self.parameterAsDouble(parameters, self.DEVIAT_SUM, context)
        attr =  self.parameterAsFields(parameters, self.ATTRIBUTES_NAMES, context)
     
        # Actual algorithm
        gdf = strokes_roads(gdf, attr, angle=deviat_angle, angle_sum=deviat_sum)
        feedback.setProgress(95) # set the loading bar to 95 %

        # Converts the gdf into a list of dicts, and this list into a list of qgis features
        res = gdf.to_dict('records')
        res = list_to_qgis_feature(res)
       
        # Define the output sink
        (sink, dest_id) = self.parameterAsSink(
            parameters, self.OUTPUT, context,
            fields=res[0].fields(),
            geometryType=QgsWkbTypes.LineString,
            crs=source.sourceCrs()
        )
        
        #add features to the sink
        sink.addFeatures(res, QgsFeatureSink.FastInsert)
        
        feedback.setProgress(100) # set the loading bar to 100 %
        
        return {
            self.OUTPUT: dest_id
        }

    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'Build stroke network'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr(self.name())

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'Network'

    def shortHelpString(self):
        """
        Returns a localised short helper string for the algorithm. This string
        should provide a basic description about what the algorithm does and the
        parameters and outputs associated with it..
        """
        return self.tr("This method computes the strokes in a Stroke network using a loop on network features, and updates its strokes attribute.\nAttributeNames : list of attribute names to be used as a criteria for continuity.\nDeviatAngle : threshold for the maximum angle between two segments at the junction of two sections belonging to the same stroke.\nDeviatSum : thresholds for the maximum angle between two sections belonging to the same stroke.")
        
    def icon(self):
        """
        Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        from cartagen4qgis import get_plugin_icon
        return get_plugin_icon()

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return BuildStrokes()

