# -*- coding: utf-8 -*-

"""
/***************************************************************************
 CartAGen4QGIS
                                 A QGIS plugin
 Cartographic generalization
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-05-11
        copyright            : (C) 2023 by Guillaume Touya, Justin Berli & Paul Bourcier
        email                : guillaume.touya@ign.fr
 ***************************************************************************/
"""

__author__ = 'Guillaume Touya, Justin Berli & Paul Bourcier'
__date__ = '2023-05-11'
__copyright__ = '(C) 2023 by Guillaume Touya, Justin Berli & Paul Bourcier'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import QgsProcessing, QgsFeatureSink, QgsProcessingAlgorithm, QgsFeature, QgsGeometry, QgsProcessingParameterDefinition
from qgis.core import QgsProcessingParameterFeatureSource, QgsProcessingParameterFeatureSink, QgsProcessingParameterNumber

class BuildingSimplificationRuasQGIS(QgsProcessingAlgorithm):
    """
    Simplify buildings
    """
    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.

    OUTPUT = 'OUTPUT'
    INPUT = 'INPUT'
    THRESHOLD = 'THRESHOLD'
    PARALLEL_LIMIT = 'PARALLEL_LIMIT' 
    ORTHOGONAL_LIMIT = 'ORTHOGONAL_LIMIT' 

    def initAlgorithm(self, config):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """
        import math

        # We add the input vector features source.
        self.addParameter(
            QgsProcessingParameterFeatureSource(
                self.INPUT,
                self.tr('Input buildings'),
                [QgsProcessing.TypeVectorPolygon]
            )
        )

        self.addParameter(
            QgsProcessingParameterNumber(
                self.THRESHOLD,
                self.tr('Edge threshold'),
                type=QgsProcessingParameterNumber.Integer,
                defaultValue=5,
                optional=False
            )
        )

        parallel_limit = QgsProcessingParameterNumber(
                self.PARALLEL_LIMIT,
                self.tr('Parallel limit'),
                type=QgsProcessingParameterNumber.Double,
                defaultValue=20*math.pi/180,
                optional=True
            )
        parallel_limit.setMetadata({'widget_wrapper':{ 'decimals': 2 }})
        parallel_limit.setFlags(parallel_limit.flags() | QgsProcessingParameterDefinition.FlagAdvanced)
        
        orthogonal_limit = QgsProcessingParameterNumber(
                self.ORTHOGONAL_LIMIT,
                self.tr('Parallel limit'),
                type=QgsProcessingParameterNumber.Double,
                defaultValue=20*math.pi/180,
                optional=True
            )
        orthogonal_limit.setMetadata({'widget_wrapper':{ 'decimals': 2 }})
        orthogonal_limit.setFlags(orthogonal_limit.flags() | QgsProcessingParameterDefinition.FlagAdvanced)
        
        self.addParameter(parallel_limit)
        self.addParameter(orthogonal_limit)

        # We add a feature sink in which to store our processed features (this
        # usually takes the form of a newly created vector layer when the
        # algorithm is run in QGIS).
        self.addParameter(
            QgsProcessingParameterFeatureSink(
                self.OUTPUT,
                self.tr('Simplified Buildings')
            )
        )

    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """
        from cartagen import simplify_building
        from shapely.wkt import loads

        # Retrieve the feature source and sink. The 'dest_id' variable is used
        # to uniquely identify the feature sink, and must be included in the
        # dictionary returned by the processAlgorithm function.
        source = self.parameterAsSource(parameters, self.INPUT, context)

        # Create the ouptput sink
        (sink, dest_id) = self.parameterAsSink(parameters, self.OUTPUT,
                context, source.fields(), source.wkbType(), source.sourceCrs())

        # Compute the number of steps to display within the progress bar and
        # get features from source
        total = 100.0 / source.featureCount() if source.featureCount() else 0
        features = source.getFeatures()

        for current, feature in enumerate(features):
            # Stop the algorithm if cancel button has been clicked
            if feedback.isCanceled():
                break

            wkt = feature.geometry().asWkt()
            shapely_geom = loads(wkt)
            
            simplified = simplify_building(shapely_geom, self.parameterAsInt(parameters,self.THRESHOLD,context), self.parameterAsDouble(parameters,self.ORTHOGONAL_LIMIT,context), self.parameterAsDouble(parameters,self.PARALLEL_LIMIT,context))

            result = QgsFeature()
            result.setGeometry(QgsGeometry.fromWkt(simplified.wkt))
            result.setAttributes(feature.attributes())

            # Add a feature in the sink
            sink.addFeature(result, QgsFeatureSink.FastInsert)

            # Update the progress bar
            feedback.setProgress(int(current * total))

        # Return the results of the algorithm. In this case our only result is
        # the feature sink which contains the processed features, but some
        # algorithms may return multiple feature sinks, calculated numeric
        # statistics, etc. These should all be included in the returned
        # dictionary, with keys matching the feature corresponding parameter
        # or output names.
        return {
            self.OUTPUT: dest_id
        }

    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'Ruas simplification'

    def shortHelpString(self):
        """
        Returns a localised short helper string for the algorithm. This string
        should provide a basic description about what the algorithm does and the
        parameters and outputs associated with it..
        """
        return self.tr("Simplify buildings by removing edges.\nThis algorithm proposed by Ruas analyses the edges of the polygon to find the ones that should be removed and how they can be replaced.\nEdge_threshold : minimum length of an edge to be considered by the simplification algorithm.\nParallel_limit (optional) : limit angle to consider an edge into the parallel case of the simplification algorithm. The default value is set to 20*π/180\nOrthogonal_limit (optional) : limit angle to consider an edge into the orthogonal case of the simplification algorithm. The default value is set to 20*π/180")
        

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr(self.name())

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'Buildings'
    
    def icon(self):
        """
        Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        from cartagen4qgis import get_plugin_icon
        return get_plugin_icon()

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return BuildingSimplificationRuasQGIS()
