# -*- coding: utf-8 -*-

"""
/***************************************************************************
 CartAGen4QGIS
                                 A QGIS plugin
 Cartographic generalization
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-05-11
        copyright            : (C) 2023 by Guillaume Touya, Justin Berli & Paul Bourcier
        email                : guillaume.touya@ign.fr
 ***************************************************************************/
"""

__author__ = 'Guillaume Touya, Justin Berli & Paul Bourcier'
__date__ = '2023-05-11'
__copyright__ = '(C) 2023 by Guillaume Touya, Justin Berli & Paul Bourcier'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (
    QgsProcessing, QgsFeatureSink, QgsProcessingAlgorithm,
    QgsFeature, QgsGeometry, QgsProcessingParameterDefinition
)
from qgis.core import (
    QgsProcessingParameterFeatureSource,
    QgsProcessingParameterFeatureSink,
    QgsProcessingParameterBoolean,
    QgsProcessingParameterNumber,
    QgsProcessingParameterDistance,
    QgsProcessingParameterMultipleLayers,
    QgsProcessingParameterMatrix,
    QgsProcessingOutputMultipleLayers
)

import geopandas
from cartagen4qgis import PLUGIN_ICON
from cartagen import LeastSquaresMethod
from shapely import Polygon
from shapely.wkt import loads

class ConstraintMethodQGIS(QgsProcessingAlgorithm):
    """
    Iteratively and randomly displace buildings to avoid spatial conflicts
    """

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.

    OUTPUT = 'OUTPUT'
    
    INPUT_OBJECTS = 'INPUT_OBJECTS'

    CONFLICTS = 'CONFLICTS'
    DISTANCES = 'DISTANCES'

    MAX_ITERATIONS = 'MAX_ITERATIONS'
    NORM_TOLERANCE = 'NORM_TOLERANCE'

    def initAlgorithm(self, config):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """

        # We add the input vector features source.
        self.addParameter(
            QgsProcessingParameterMultipleLayers(
                self.INPUT_OBJECTS,
                self.tr('Input objects to generalize'),
                layerType=QgsProcessing.TypeVectorLine,
                optional=True
            )
        )

        self.addParameter(
            QgsProcessingParameterMatrix(
                self.CONFLICTS,
                self.tr('Spatial conflicts'),
                hasFixedNumberRows=False
            )
        )

        self.addParameter(
            QgsProcessingParameterMatrix(
                self.DISTANCES,
                self.tr('Distances'),
                hasFixedNumberRows=False
            )
        )

        maxtrials = QgsProcessingParameterNumber(
            self.MAX_ITERATIONS,
            self.tr('Maximum iterations'),
            type=QgsProcessingParameterNumber.Integer,
            defaultValue=1000,
            optional=False
        )
        maxtrials.setFlags(maxtrials.flags() | QgsProcessingParameterDefinition.FlagAdvanced)

        normtol = QgsProcessingParameterNumber(
            self.NORM_TOLERANCE,
            self.tr('Norm tolerance'),
            type=QgsProcessingParameterNumber.Double,
            defaultValue=0.05,
            optional=False
        )
        normtol.setMetadata({'widget_wrapper':{ 'decimals': 2 }})
        normtol.setFlags(normtol.flags() | QgsProcessingParameterDefinition.FlagAdvanced)


        # We add a feature sink in which to store our processed features (this
        # usually takes the form of a newly created vector layer when the
        # algorithm is run in QGIS).
        self.addParameter(
            QgsProcessingParameterFeatureSink(
                self.OUTPUT,
                self.tr('Generalized')
            )
        )
                

    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """

    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'Constraint Method'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr(self.name())

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'General'

    def icon(self):
        """
        Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        return PLUGIN_ICON

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return ConstraintMethodQGIS()