# -*- coding: utf-8 -*-

"""
/***************************************************************************
 CartAGen4QGIS
                                 A QGIS plugin
 Cartographic generalization
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-05-11
        copyright            : (C) 2023 by Guillaume Touya, Justin Berli & Paul Bourcier
        email                : guillaume.touya@ign.fr
 ***************************************************************************/
"""

__author__ = 'Guillaume Touya, Justin Berli & Paul Bourcier'
__date__ = '2023-05-11'
__copyright__ = '(C) 2023 by Guillaume Touya, Justin Berli & Paul Bourcier'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
from qgis.core import QgsProcessingProvider
from .algorithms import *
from .tools import *
from cartagen4qgis import PLUGIN_ICON

class CartAGen4QGISProvider(QgsProcessingProvider):

    def __init__(self):
        """
        Default constructor.
        """
        QgsProcessingProvider.__init__(self)

    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        pass

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """

        # Buildings
        self.addAlgorithm(SquaringQGIS())
        self.addAlgorithm(BuildingSimplificationRuasQGIS())
        self.addAlgorithm(BuildingDisplacementRandomQGIS())
        self.addAlgorithm(MorphologicalAmalgamation())
        self.addAlgorithm(BoffetArea())
        self.addAlgorithm(ClosePolygon())
        
        # Lines
        self.addAlgorithm(VisvalingamWhyattQGIS())
        self.addAlgorithm(RaposoSimplificationQGIS())
        self.addAlgorithm(DouglasPeucker())
        self.addAlgorithm(GaussianSmoothing())
        
        # General
        # self.addAlgorithm(ConstraintMethodQGIS())

        # Network
        self.addAlgorithm(DetectRoundaboutsQGIS())
        self.addAlgorithm(DetectDeadEnds())
        self.addAlgorithm(EliminateDeadEnds())
        self.addAlgorithm(CollapseRoundaboutsQGIS())
        self.addAlgorithm(DetectBranchingCrossroads())
        self.addAlgorithm(CollapseBranchingCrossroads())
        self.addAlgorithm(DetectDualCarriageways())
        self.addAlgorithm(CollapseDualCarriageways())
        self.addAlgorithm(BuildStrokes())

        # Tools
        self.addAlgorithm(NetworkFacesQGIS())
        
        # Points
        self.addAlgorithm(ReduceKmeans())
        self.addAlgorithm(ReduceLabelgrid())
        self.addAlgorithm(ReduceQuadtree())
        self.addAlgorithm(HullDelaunay())
        self.addAlgorithm(HullSwingingArm())
        self.addAlgorithm(VectorHeatmap())

    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        return 'CartAGen'

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        return self.tr('CartAGen')

    def icon(self):
        """
        Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        return PLUGIN_ICON

    def longName(self):
        """
        Returns the a longer version of the provider name, which can include
        extra details such as version numbers. E.g. "Lastools LIDAR tools
        (version 2.2.1)". This string should be localised. The default
        implementation returns the same string as name().
        """
        return self.name()
