# coding=utf-8
"""Dialog test.

.. note:: This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 3 of the License, or
     (at your option) any later version.

"""
import unittest

from carroyage_dockwidget import CarroyageDockWidget

from .utilities import get_qgis_app

__author__ = 'etienne.loks@iggdrasil.net'
__date__ = '2025-04-10'
__copyright__ = 'Copyright 2025, Iggdrasil'

QGIS_APP, CANVAS, IFACE, PARENT = get_qgis_app()


class CarroyageDockWidgetTest(unittest.TestCase):
    """Simple test button works. Could be improved if needed."""

    def setUp(self):
        """Runs before each test."""
        self.dialog = CarroyageDockWidget(None)

    def tearDown(self):
        """Runs after each test."""
        self.dialog = None

    def test_dialog_ok(self):
        """Test we can click OK."""
        button = self.dialog.valid_button_box.button(self.dialog.valid_button_box.Ok)
        button.click()
        result = self.dialog.isVisible()
        # close the dock
        self.assertEqual(result, False)

    def test_dialog_cancel(self):
        """Test we can click cancel."""
        button = self.dialog.valid_button_box.button(self.dialog.valid_button_box.Cancel)
        button.click()
        result = self.dialog.isVisible()
        # close the dock
        self.assertEqual(result, False)


if __name__ == "__main__":
    test_loader = unittest.TestLoader()
    suite = test_loader.loadTestsFromTestCase(CarroyageDockWidgetTest)
    runner = unittest.TextTestRunner(verbosity=2)
    runner.run(suite)
