# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Canvas2Extent
                                 A QGIS plugin
 Automatic Canvas to layout extent
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2026-02-20
        git sha              : $Format:%H$
        copyright            : (C) 2026 by Giuseppe De Marco
        email                : demarco.giuseppe@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import *
from qgis.PyQt.QtGui import *
from qgis.PyQt.QtWidgets import *
# Initialize Qt resources from file resources.py
from . import resources_rc
# Import the code for the dialog
from .canvas2extent_dialog import Canvas2ExtentDialog
import os.path


class Canvas2Extent:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'Canvas2Extent_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Canvas2Extent')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Canvas2Extent', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/canvas2extent/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Canvas2Extent'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Canvas2Extent'),
                action)
            self.iface.removeToolBarIcon(action)

    #custom functions begin------------------------------------------------------------
    def load_layout(self):
        from qgis.core import QgsProject, QgsLayout, QgsLayoutItemMap, QgsLayoutManager
        from qgis.utils import iface
        # get current project
        project = QgsProject.instance()
        #set combobox and clear
        layoutlist1=self.dlg.ComboLayout
        layoutlist1.clear()
        # get layout manager to show layouts
        layout_manager = project.layoutManager()
        lays = layout_manager.layouts()
        names=[]
        # list all the layouts available and put into combobox
        for item in lays:
            name = item.name()
            names.append(name)
        layoutlist1.addItems(names)
        self.iface.messageBar().pushMessage("C2E",name+" layout found: "+"   Now choose and press Update...")

    def update_layout(self):
        from qgis.core import QgsProject, QgsLayout, QgsLayoutItemMap, QgsLayoutManager
        from qgis.utils import iface
        #get input data
        layoutlist1=self.dlg.ComboLayout
        canvas = iface.mapCanvas()
        extent = canvas.extent()
        # get current project
        project = QgsProject.instance()
        # get layout manager to show layouts
        layout_manager = project.layoutManager()
        #Get specific layout
        layout_name = layoutlist1.currentText()  # get layout id 
        layout = layout_manager.layoutByName(layout_name)# set layout to work on
        if layout is None:
            self.iface.messageBar().pushMessage("C2E"," layout not found: "+"   please make a layout to use this plugin...")
        else:
        # get layout map item
            map_item = None
            for item in layout.items():
                if isinstance(item, QgsLayoutItemMap):
                    map_item = item
            # Set map_item layout extent from map canvas extent for each map item
                    map_item.setExtent(extent)
            # updates layout
            layout.refresh()
            self.iface.messageBar().pushMessage("C2E",layout_name+" layout updated: "+"   Now you can go and check results")

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = Canvas2ExtentDialog()

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        #Buttons events
        self.dlg.Load.clicked.connect(self.load_layout)
        self.dlg.Update.clicked.connect(self.update_layout)
        # See if OK was pressed
        if result==1:
            self.dlg.ComboLayout.clear()
            pass
