"""
Model exported as python.
Name : routeGenerator
Group : Mavic 3 Enterprise
With QGIS : 32812
"""

from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterFeatureSource
from qgis.core import QgsProcessingParameterFeatureSink
from qgis.core import QgsCoordinateReferenceSystem
from qgis.core import QgsProcessingParameterFile
from qgis.core import QgsProcessingParameterNumber
from qgis.core import QgsProcessingParameterString
import processing


class routeGenerator(QgsProcessingAlgorithm):

    def initAlgorithm(self, config=None):
        #self.addParameter(QgsProcessingParameterFeatureSource('pontos', 'Pontos', types=[QgsProcessing.TypeVectorPoint], defaultValue=None))
        self.addParameter(QgsProcessingParameterFile('pontos', 'Optimized Points', behavior=QgsProcessingParameterFile.File, fileFilter='Todos arquivos (*.*)', defaultValue=None))
        self.addParameter(QgsProcessingParameterFile('base', 'Base point', behavior=QgsProcessingParameterFile.File, fileFilter='Todos arquivos (*.*)', defaultValue=None))
        self.addParameter(QgsProcessingParameterString('nome_da_misso', 'Mission Name', multiLine=False, defaultValue='Cluster'))
        self.addParameter(QgsProcessingParameterNumber('altitude_de_aproximao', 'Approach Altitude', type=QgsProcessingParameterNumber.Integer, minValue=5, maxValue=50, defaultValue=8))
        self.addParameter(QgsProcessingParameterNumber('altitude_de_voo', 'Flight Altitude (Slices x Slice Height)', type=QgsProcessingParameterNumber.Integer, minValue=10, maxValue=200, defaultValue=40))
        self.addParameter(QgsProcessingParameterNumber('safeAltitude', 'Safe Return to Home (RTH) Altitude', type=QgsProcessingParameterNumber.Integer, minValue=80, maxValue=800, defaultValue=80))
        self.addParameter(QgsProcessingParameterNumber('maxAltitude', 'Maximum Flight Altitude', type=QgsProcessingParameterNumber.Integer, minValue=120, maxValue=800, defaultValue=120))
        self.addParameter(QgsProcessingParameterFile('pasta', 'Folder to save JSON for UgCS', behavior=QgsProcessingParameterFile.Folder, fileFilter='Todos os arquivos (*.*)', defaultValue=None))

    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(9, model_feedback)
        results = {}
        outputs = {}

        import json
        import geopandas as gpd

        missao = str(parameters['nome_da_misso'])+"-"
        altitudeAproximacao = parameters['altitude_de_aproximao']
        altitudeVoo = parameters['altitude_de_voo']

        safeAltitude =  float(parameters['safeAltitude'])
        maxAltitude = float(parameters['maxAltitude'])

        # Function to create a payload profile
        def create_payload_profile(name, focal_length, sensor_width, sensor_height, sensor_horizontal_pixels, sensor_vertical_pixels):
            return {
                "name": name,
                "shortName": None,
                "payloadType": "CAMERA",
                "imageKey": "dji_m3e",
                "parameters": {
                    "weight": 0.15,
                    "frequency": 0.0,
                    "power": 0.0,
                    "trueFocalLength": focal_length,
                    "sensorWidth": sensor_width,
                    "sensorHeight": sensor_height,
                    "sensorHorizontalPixels": sensor_horizontal_pixels,
                    "sensorVerticalPixels": sensor_vertical_pixels,
                    "minTriggeringInterval": 0.7,
                    "scanningFov": None,
                    "scanningRange": None,
                    "scanningSpeed": None
                }
            }

        # Function to create a vehicle profile
        def create_vehicle_profile(name, payload_profiles):
            return {
                "name": name,
                "vehicleType": "MULTICOPTER",
                "modelKey": "default",
                "imageKey": "dji_mavic_3_enterprise",
                "platformCode": "DjiMavic3Enterprise",
                "primary": True,
                "payloadProfiles": payload_profiles,
                "parameters": {
                    # Add other parameters as needed
                }
            }

        # Function to create a waypoint segment
        def create_waypoint_segment(latitude, longitude, altitude, tilt, zoom_level, linha):
            if linha == 1:
                return {
                    "type": "Waypoint",
                    "actions": [
                        {
                            "type" : "Heading",
                            "heading" : 0.0,
                            "relativeToNextWaypoint" : False,
                            "relativeToNorth" : True
                        },
                        {
                            "type": "CameraControl",
                            "tilt": tilt,
                            "roll": None,
                            "yaw": None,
                            "zoomLevel": zoom_level
                        },
                        {
                            "type": "CameraTrigger",
                            "state": "SINGLE_SHOT"
                        },
                        {
                            "type": "CameraControl",
                            "tilt": tilt,
                            "roll": None,
                            "yaw": None,
                            "zoomLevel": 191
                        },
                        {
                            "type": "CameraTrigger",
                            "state": "SINGLE_SHOT"
                        }
                    ],
                    "point": {
                        "latitude": latitude,
                        "longitude": longitude,
                        "altitude": altitude,
                        "altitudeType": "AGL"
                    },
                    "parameters": {
                        "avoidObstacles": True,
                        "avoidTerrain": True,
                        "speed": 15.0,
                        "wpTurnType": "STOP_AND_TURN",
                        "altitudeType": "AGL"
                    }
                }
            elif linha ==2:
                    return {
                    "type": "Waypoint",
                    "actions": [
                        {
                           "type": "CameraControl",
                            "tilt": tilt,
                             "roll": None,
                            "yaw": None,
                            "zoomLevel": zoom_level
                        },
                        {
                            "type": "CameraTrigger",
                            "state": "SINGLE_SHOT"
                        }
                    ],
                    "point": {
                        "latitude": latitude,
                        "longitude": longitude,
                        "altitude": altitude,
                        "altitudeType": "AGL"
                    },
                    "parameters": {
                        "avoidObstacles": True,
                        "avoidTerrain": True,
                        "speed": 15.0,
                        "wpTurnType": "STOP_AND_TURN",
                        "altitudeType": "AGL"
                    }
                }
            elif linha == 3:
                    return {
                    "type": "Waypoint",
                    "actions": [
                    ],
                    "point": {
                        "latitude": latitude,
                        "longitude": longitude,
                        "altitude": altitude,
                        "altitudeType": "AGL"
                    },
                    "parameters": {
                        "avoidObstacles": True,
                        "avoidTerrain": True,
                        "speed": 15.0,
                        "wpTurnType": "STOP_AND_TURN",
                        "altitudeType": "AGL"
                    }
                }

        # Function to create the entire JSON structure
        def create_json_structure(waypoints, hexagon):
            # Payload profiles
            wide_payload = create_payload_profile("DJI Mavic 3 (Wide)", 0.01247, 0.018, 0.0135, 5280.0, 3956.0)
            zoom_payload = create_payload_profile("DJI Mavic 3 (Zoom)", 0.0299, 0.0064, 0.0048, 4000.0, 3000.0)
            
            # Vehicle profile
            vehicle_profiles = [wide_payload, zoom_payload]
            mavic_3e_vehicle = create_vehicle_profile("DJI Mavic 3E", ["DJI Mavic 3 (Wide)", "DJI Mavic 3 (Zoom)"])
            
            # Waypoint segments
            # waypoint_segments = [create_waypoint_segment(**coords) for coords in waypoints]

            if hexagon <= 9:
                hexagon = '0'+str(hexagon)
            else:
                hexagon = str(hexagon)

            # Route
            route = {
                "name": missao+str(hexagon),
                "creationTime": 1702919212618,
                "scheduledTime": 1702919184382,
                "startDelay": 0.0,
                "vehicleProfile": "DJI Mavic 3E",
                "trajectoryType": None,
                "safeAltitude": safeAltitude,
                "maxAltitude": maxAltitude,
                "initialSpeed" : 10.00,
                "maxSpeed": 0.0,
                "failsafes": {
                    "rcLost": "GO_HOME",
                    "gpsLost": None,
                    "lowBattery": None,
                    "datalinkLost": None
                },
                "checkAerodromeNfz": True,
                "checkCustomNfz": True,
                "segments": waypoints,
                "takeoffHeight": 0.0
            }

            # JSON structure
            json_structure = {
                "version": {
                    "major": 4,
                    "minor": 14,
                    "build": 1398,
                    "component": "DATABASE"
                },
                "payloadProfiles": [wide_payload, zoom_payload],
                "vehicleProfiles": [mavic_3e_vehicle],
                "route": route
            }

            return json_structure

        # Function to export JSON to a file
        def export_to_json(json_structure, file_path):
            with open(file_path, 'w') as json_file:
                json.dump(json_structure, json_file, indent=2)






        # Reprojetar camada
        alg_params = {
            'INPUT': parameters['pontos'],
            'OPERATION': '',
            'TARGET_CRS': QgsCoordinateReferenceSystem('EPSG:31981'),
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['pontos'] = processing.run('native:reprojectlayer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        # Dissolver
        alg_params = {
            'FIELD': ['hexagon'],
            'INPUT': outputs['pontos']['OUTPUT'],
            'SEPARATE_DISJOINT': False,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Dissolver'] = processing.run('native:dissolve', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        hexagonos = processing.run('native:dissolve', {
            'FIELD': ['hexagon'],
            'INPUT': outputs['pontos']['OUTPUT'],
            'SEPARATE_DISJOINT': False,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }, context=context, feedback=feedback)['OUTPUT']

        hexagonostt = hexagonos.featureCount()
        feedback.pushInfo('hexagonostt '+str(hexagonostt))

        counter = 1

        # Read the base gpkg
        gdf_base = gpd.read_file(str(parameters['base']))

        base_latitude = (gdf_base.geometry.y * 0.0577058550375415) / 3.3063019
        base_longtude = (gdf_base.geometry.x * -1.14043183435171) / -65.3419309
 

        while counter <= hexagonostt:

            # Read the points gpkg
            gdf_bruto = gpd.read_file(str(parameters['pontos']))

            # Filtrar os dados com base na coluna "hexagon"
            filtro = gdf_bruto['hexagon'] == counter
            gdf = gdf_bruto[filtro]

            # Definir o número de linhas por grupo
            #linhas_por_grupo = int(gdf['point'].count() / gdf['group'].nunique())
            linhas_por_grupo = 3

            waypoint_segments = [
                {
                "type" : "Waypoint",
                "actions" : [ ],
                "point" : {
                    "latitude" : base_latitude[0],
                    "longitude" : base_longtude[0],
                    "altitude" : safeAltitude,
                    "altitudeType" : "AGL"
                },
                "parameters" : {
                    "avoidObstacles" : True,
                    "avoidTerrain" : True,
                    "speed" : 15.0,
                    "wpTurnType" : "STOP_AND_TURN",
                    "altitudeType" : "AGL",
                    "cornerRadius" : None
                }
                }
            ]

            # Iterar sobre os grupos
            for grupo, sub_df in gdf.groupby('group'):
                # Iterar sobre as linhas em grupos de linhas_por_grupo
                for i in range(0, len(sub_df), linhas_por_grupo):
                    grupo_de_tres = sub_df.iloc[i:i+linhas_por_grupo]
                    # Iterar sobre cada uma das três linhas
                    linha = 1
                    for index, row in grupo_de_tres.iterrows():
                        # Aqui você tem acesso a cada linha individualmente
                        # print("Grupo:", grupo)
                        # print("Índice:", index)
                        # print(row)
                        # print("----")

                        if linha == 1:

                            altitude = altitudeVoo
                            # conversão das coordenadas para o sistema arbitrário do UGCS
                            coordinates_list = [
                                {"latitude": (row.geometry.y * 0.0577058550375415) / 3.3063019, "longitude": (row.geometry.x * -1.14043183435171) / -65.3419309, "altitude": altitude, "tilt": 1.5707963267948966, "zoom_level": 24, "linha": linha}
                            ]
                            waypoint_segments = waypoint_segments + [create_waypoint_segment(**coords) for coords in coordinates_list]

                            linha += 1

                        elif linha == 2:

                            altitude = altitudeAproximacao
                            # conversão das coordenadas para o sistema arbitrário do UGCS
                            coordinates_list = [
                                {"latitude": (row.geometry.y * 0.0577058550375415) / 3.3063019, "longitude": (row.geometry.x * -1.14043183435171) / -65.3419309, "altitude": altitude, "tilt": 1.5707963267948966, "zoom_level": 191, "linha": linha}
                            ]
                            waypoint_segments = waypoint_segments + [create_waypoint_segment(**coords) for coords in coordinates_list]

                            linha += 1

                        elif linha == 3:

                            altitude = altitudeVoo
                            # conversão das coordenadas para o sistema arbitrário do UGCS
                            coordinates_list = [
                                {"latitude": (row.geometry.y * 0.0577058550375415) / 3.3063019, "longitude": (row.geometry.x * -1.14043183435171) / -65.3419309, "altitude": altitude, "tilt": 1.5707963267948966, "zoom_level": 24, "linha": linha}
                            ]
                            waypoint_segments = waypoint_segments + [create_waypoint_segment(**coords) for coords in coordinates_list]

                            linha += 1
                        else:
                            feedback.pushInfo('falhou')


            # Create the JSON structure
            json_structure = create_json_structure(waypoint_segments, counter)

            if counter <= 9:
                num = '0'+str(counter)
            else:
                num = str(counter)

            # Specify the file path for the export
            json_file_path = str(parameters['pasta'])+"\cluster-"+num+".json"

            # Export the JSON structure to a file
            export_to_json(json_structure, json_file_path)

            feedback.pushInfo(f'JSON structure has been exported to {json_file_path}')

            counter += 1

        return results

    def name(self):
        return 'routeGenerator'

    def displayName(self):
        return '9 - Route Generator for UgCS'

    # def group(self):
    #     return 'Mavic 3 Enterprise'

    # def groupId(self):
    #     return 'Mavic 3 Enterprise'

    def createInstance(self):
        return routeGenerator()
