"""
Model exported as python.
Name : orderPoints
Group : Mavic 3 Enterprise
With QGIS : 32812
"""

from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterFeatureSource
from qgis.core import QgsProcessingParameterFeatureSink
from qgis.core import QgsCoordinateReferenceSystem
from qgis.core import QgsProcessingParameterNumber
import processing


class orderPoints(QgsProcessingAlgorithm):

    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterFeatureSource('base', 'Base Point', types=[QgsProcessing.TypeVectorPoint], defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSource('pontos', 'Useful Points ("hexagon" column cannot skip numbers)', types=[QgsProcessing.TypeVectorPoint], defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('saida', 'Optimized Points - Save as GPKG', type=QgsProcessing.TypeVectorLine, createByDefault=True, defaultValue=None))

    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(3, model_feedback)
        results = {}
        outputs = {}

        pontos_saida = []

        parameters['saida'].destinationName = 'Optimized Points - Save as GPKG'

        # Reprojetar camada
        alg_params = {
            'INPUT': parameters['base'],
            'OPERATION': '',
            'TARGET_CRS': QgsCoordinateReferenceSystem('EPSG:31981'),
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['base'] = processing.run('native:reprojectlayer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        # Reprojetar camada
        alg_params = {
            'INPUT': parameters['pontos'],
            'OPERATION': '',
            'TARGET_CRS': QgsCoordinateReferenceSystem('EPSG:31981'),
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['pontos'] = processing.run('native:reprojectlayer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        # Dissolver
        alg_params = {
            'FIELD': ['hexagon'],
            'INPUT': outputs['pontos']['OUTPUT'],
            'SEPARATE_DISJOINT': False,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Dissolver'] = processing.run('native:dissolve', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        hexagonos = processing.run('native:dissolve', {
            'FIELD': ['hexagon'],
            'INPUT': outputs['pontos']['OUTPUT'],
            'SEPARATE_DISJOINT': False,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }, context=context, feedback=feedback)['OUTPUT']

        hexagonostt = hexagonos.featureCount()
        feedback.pushInfo('hexagonostt '+str(hexagonostt))

        # counter = 1
        counter = hexagonostt

        while counter <= hexagonostt:

            # Extrair por atributo
            alg_params = {
                'FIELD': 'hexagon',
                'INPUT': outputs['pontos']['OUTPUT'],
                'OPERATOR': 0,  # =
                'VALUE': counter,
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['ExtrairPorAtributo'] = processing.run('native:extractbyattribute', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

            # Reprojetar camada
            pontos = processing.run('native:reprojectlayer',{
                'INPUT': outputs['ExtrairPorAtributo']['OUTPUT'],
                'OPERATION': '',
                'TARGET_CRS': QgsCoordinateReferenceSystem('EPSG:31981'),
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }, context=context, feedback=feedback)['OUTPUT']

            pontostt = pontos.featureCount()
            feedback.pushInfo('pontostt '+str(pontostt))

            # Linha mais curta entre feições
            alg_params = {
                'DESTINATION': outputs['ExtrairPorAtributo']['OUTPUT'],
                'DISTANCE': None,
                'METHOD': 0,  # Distance to Nearest Point on feature
                'NEIGHBORS': 1,
                'SOURCE': outputs['base']['OUTPUT'],
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['LinhaMaisCurtaEntreFeies'] = processing.run('native:shortestline', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

            feedback.setCurrentStep(1)
            if feedback.isCanceled():
                return {}
            
            ponto = 1
            feedback.pushInfo('ponto '+str(ponto))

            # Associar atributos por localização
            alg_params = {
                'DISCARD_NONMATCHING': True,
                'INPUT': outputs['ExtrairPorAtributo']['OUTPUT'],
                'JOIN': outputs['LinhaMaisCurtaEntreFeies']['OUTPUT'],
                'JOIN_FIELDS': [''],
                'METHOD': 0,  # Criar feição separada para cada feição correspondente (um-para-muitos)
                'PREDICATE': [0],  # interseccionam
                'PREFIX': '',
                'NON_MATCHING': QgsProcessing.TEMPORARY_OUTPUT,
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['Associar'+str(ponto)] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

            feedback.setCurrentStep(2)
            if feedback.isCanceled():
                return {}
            
            # Editar campos
            alg_params = {
                'FIELDS_MAPPING': [{'expression': '1','length': 0,'name': 'point','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'},
                                {'expression': ponto,'length': 0,'name': 'group','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'},
                                {'expression': '"hexagon"','length': 0,'name': 'hexagon','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'},
                                {'expression': '"fatia"','length': 0,'name': 'fatia','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'}],
                'INPUT': outputs['Associar'+str(ponto)]['OUTPUT'],
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['EditarCampos'+str(ponto)] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
            
            pontos_saida.append(outputs['EditarCampos'+str(ponto)]['OUTPUT'])

            while ponto <= pontostt:

                # Linha mais curta entre feições
                alg_params = {
                    'DESTINATION': outputs['Associar'+str(ponto)]['NON_MATCHING'],
                    'DISTANCE': None,
                    'METHOD': 0,  # Distance to Nearest Point on feature
                    'NEIGHBORS': 1,
                    'SOURCE': outputs['Associar'+str(ponto)]['OUTPUT'],
                    'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                }
                outputs['Linha'+str(ponto)] = processing.run('native:shortestline', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                ponto += 1
                feedback.pushInfo('ponto '+str(ponto))

                # Associar atributos por localização
                alg_params = {
                    'DISCARD_NONMATCHING': True,
                    'INPUT': outputs['Associar'+str(ponto-1)]['NON_MATCHING'],
                    'JOIN': outputs['Linha'+str(ponto-1)]['OUTPUT'],
                    'JOIN_FIELDS': [''],
                    'METHOD': 0,  # Criar feição separada para cada feição correspondente (um-para-muitos)
                    'PREDICATE': [0],  # interseccionam
                    'PREFIX': '',
                    'NON_MATCHING': QgsProcessing.TEMPORARY_OUTPUT,
                    'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                }
                outputs['Associar'+str(ponto)] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                feedback.setCurrentStep(2)
                if feedback.isCanceled():
                    return {}
                
                # Editar campos
                alg_params = {
                    'FIELDS_MAPPING': [{'expression': '1','length': 0,'name': 'point','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'},
                                    {'expression': ponto,'length': 0,'name': 'group','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'},
                                    {'expression': '"hexagon"','length': 0,'name': 'hexagon','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'},
                                    {'expression': '"fatia"','length': 0,'name': 'fatia','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'}],
                    'INPUT': outputs['Associar'+str(ponto)]['OUTPUT'],
                    'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                }
                outputs['EditarCampos'+str(ponto)] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
                
                pontos_saida.append(outputs['EditarCampos'+str(ponto)]['OUTPUT'])

            counter += 1


        # Mesclar camadas vetoriais
        alg_params = {
            'CRS': None,
            'LAYERS': pontos_saida,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['MesclarCamadasVetoriais'] = processing.run('native:mergevectorlayers', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        if feedback.isCanceled():
            return {}
        
        # Editar campos
        alg_params = {
            'FIELDS_MAPPING': [{'expression': '2','length': 0,'name': 'point','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'},
                            {'expression': '"group"','length': 0,'name': 'group','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'},
                            {'expression': '"hexagon"','length': 0,'name': 'hexagon','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'},
                            {'expression': '"fatia"','length': 0,'name': 'fatia','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'}],
            'INPUT': outputs['MesclarCamadasVetoriais']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EditarCampos2'] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        
        if feedback.isCanceled():
            return {}
    
        # Editar campos
        alg_params = {
            'FIELDS_MAPPING': [{'expression': '3','length': 0,'name': 'point','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'},
                            {'expression': '"group"','length': 0,'name': 'group','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'},
                            {'expression': '"hexagon"','length': 0,'name': 'hexagon','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'},
                            {'expression': '"fatia"','length': 0,'name': 'fatia','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'}],
            'INPUT': outputs['MesclarCamadasVetoriais']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EditarCampos3'] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        
        if feedback.isCanceled():
            return {}

        # Mesclar camadas vetoriais
        alg_params = {
            'CRS': QgsCoordinateReferenceSystem('EPSG:4326'),
            'LAYERS': [outputs['MesclarCamadasVetoriais']['OUTPUT'],outputs['EditarCampos2']['OUTPUT'],outputs['EditarCampos3']['OUTPUT']],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['MesclarCamadasVetoriais2'] = processing.run('native:mergevectorlayers', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        if feedback.isCanceled():
            return {}

        # Executar SQL
        alg_params = {
            'INPUT_DATASOURCES': outputs['MesclarCamadasVetoriais2']['OUTPUT'],
            'INPUT_GEOMETRY_CRS': None,
            'INPUT_GEOMETRY_FIELD': '',
            'INPUT_GEOMETRY_TYPE': None,
            'INPUT_QUERY': 'select * from input1\norder by "hexagon","group","point"',
            'INPUT_UID_FIELD': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ExecutarSql'] = processing.run('qgis:executesql', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(3)
        if feedback.isCanceled():
            return {}

        # Descartar campo(s)
        alg_params = {
            'COLUMN': ['layer','path','fid'],
            'INPUT': outputs['ExecutarSql']['OUTPUT'],
            'OUTPUT': parameters['saida']
        }
        outputs['DescartarCampos2'] = processing.run('native:deletecolumn', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}

        results['saida'] = outputs['DescartarCampos2']['OUTPUT']

        return results

    def name(self):
        return 'orderPoints'

    def displayName(self):
        return '8 - Order Points'

    # def group(self):
    #     return 'Mavic 3 Enterprise'

    # def groupId(self):
    #     return 'Mavic 3 Enterprise'

    def createInstance(self):
        return orderPoints()
