"""
Model exported as python.
Name : createPoints
Group : Mavic 3 Enterprise
With QGIS : 32812
"""

from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterRasterLayer
from qgis.core import QgsProcessingParameterFeatureSink
from qgis.core import QgsCoordinateReferenceSystem
from qgis.core import QgsProcessingParameterNumber
from qgis.core import QgsProcessingParameterDefinition
from qgis.core import QgsProcessingParameterFeatureSource
import processing


class createPoints(QgsProcessingAlgorithm):

    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterRasterLayer('dem', 'Clipped DSM', defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSource('grid_considerado', 'Optimized Grid', types=[QgsProcessing.TypeVectorPolygon], defaultValue=None))

        self.addParameter(QgsProcessingParameterNumber('cortes', 'Number of Slices', type=QgsProcessingParameterNumber.Integer, minValue=1, maxValue=5, defaultValue=5))
        self.addParameter(QgsProcessingParameterNumber('distancia', 'Distance Between Points (meters)', type=QgsProcessingParameterNumber.Integer, minValue=5, maxValue=100, defaultValue=10))
        self.addParameter(QgsProcessingParameterNumber('altura', 'Slice Height (meters)', type=QgsProcessingParameterNumber.Integer, minValue=1, maxValue=50, defaultValue=5))

        self.addParameter(QgsProcessingParameterFeatureSink('pontos', 'Points Created', type=QgsProcessing.TypeVectorPoint, createByDefault=True, supportsAppend=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('fatias', 'Slices', type=QgsProcessing.TypeVectorPolygon, createByDefault=True, supportsAppend=True, defaultValue=None))
  
        escolheGrid = []
        escolheGrid.append(QgsProcessingParameterNumber('inicioGrid', 'Initial Grid', type=QgsProcessingParameterNumber.Integer, minValue=0, maxValue=999, defaultValue=0))
        escolheGrid.append(QgsProcessingParameterNumber('finalGrid', 'Final Grid', type=QgsProcessingParameterNumber.Integer, minValue=0, maxValue=999, defaultValue=0))
        for escolheGrid in escolheGrid:
            escolheGrid.setFlags(escolheGrid.flags() | QgsProcessingParameterDefinition.FlagAdvanced)
            self.addParameter(escolheGrid)

    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(1, model_feedback)
        results = {}
        outputs = {}

        parameters['pontos'].destinationName = 'Points Created'
        parameters['fatias'].destinationName = 'Slices'

        altura = int(parameters['altura'])
        distancia = int(parameters['distancia'])
        cortes = int(parameters['cortes'])

        inicioGrid = int(parameters['inicioGrid'])
        finalGrid = int(parameters['finalGrid'])

        pontosGerados = []

        fatias = []

        # Editar campos
        alg_params = {
            'FIELDS_MAPPING': [{'expression': '$id','length': 0,'name': 'id','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'}],
            'INPUT': parameters['grid_considerado'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EditarCampos'] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        if feedback.isCanceled():
            return {}
    
        # Reprojetar camada
        alg_params = {
            'INPUT': outputs['EditarCampos']['OUTPUT'],
            'OPERATION': '',
            'TARGET_CRS': QgsCoordinateReferenceSystem('EPSG:31981'),
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['grideprincipal'] = processing.run('native:reprojectlayer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        # Reprojetar camada
        hexagonos = processing.run('native:reprojectlayer',{
            'INPUT': outputs['EditarCampos']['OUTPUT'],
            'OPERATION': '',
            'TARGET_CRS': QgsCoordinateReferenceSystem('EPSG:31981'),
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }, context=context, feedback=feedback)['OUTPUT']

        maximo = hexagonos.featureCount()

        feedback.pushInfo(str(hexagonos.featureCount()))

        if inicioGrid == 0:
            counter = 1
        else:
            counter = inicioGrid

        if finalGrid > maximo:
            finalGrid = maximo
            
        if finalGrid != 0:
            maximo = finalGrid
            
        feedback = QgsProcessingMultiStepFeedback(maximo, model_feedback)

        while counter <= maximo:

            # Extrair por expressão
            alg_params = {
                'EXPRESSION': '$id = '+ str(counter),
                'INPUT': outputs['grideprincipal']['OUTPUT'],
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['ExtrairPorExpresso'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

            if feedback.isCanceled():
                return {}

            # Recortar raster pela camada de máscara
            alg_params = {
                'ALPHA_BAND': False,
                'CROP_TO_CUTLINE': True,
                'DATA_TYPE': 0,  # Use Camada de entrada Tipo Dado
                'EXTRA': '',
                'INPUT': parameters['dem'],
                'KEEP_RESOLUTION': False,
                'MASK': outputs['ExtrairPorExpresso']['OUTPUT'],
                'MULTITHREADING': False,
                'NODATA': None,
                'OPTIONS': '',
                'SET_RESOLUTION': False,
                'SOURCE_CRS': None,
                'TARGET_CRS': QgsCoordinateReferenceSystem('EPSG:31981'),
                'TARGET_EXTENT': None,
                'X_RESOLUTION': None,
                'Y_RESOLUTION': None,
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['RecortarRasterPelaCamadaDeMscara'] = processing.run('gdal:cliprasterbymasklayer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

            if feedback.isCanceled():
                return {}

            # Estatísticas da camada raster
            alg_params = {
                'BAND': 1,
                'INPUT': outputs['RecortarRasterPelaCamadaDeMscara']['OUTPUT'],
                'OUTPUT_HTML_FILE': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['EstatsticasDaCamadaRaster'] = processing.run('native:rasterlayerstatistics', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

            maximum = outputs['EstatsticasDaCamadaRaster']['MAX']

            if feedback.isCanceled():
                return {}
            
            fatia = 1
               
            while fatia <= cortes:
                
                if fatia == 1:

                    # Reclassificar por tabela
                    alg_params = {
                        'DATA_TYPE': 5,  # Float32
                        'INPUT_RASTER': outputs['RecortarRasterPelaCamadaDeMscara']['OUTPUT'],
                        'NODATA_FOR_MISSING': False,
                        'NO_DATA': 0,
                        'RANGE_BOUNDARIES': 0,  # min < valor <= max
                        'RASTER_BAND': 1,
                        'TABLE': ['-9999',str(maximum-altura),'0'],
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['ReclassificarPorTabela'] = processing.run('native:reclassifybytable', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    if feedback.isCanceled():
                        return {}
                                        
                    # Contornos dos Polígonos
                    alg_params = {
                        'BAND': 1,
                        'CREATE_3D': False,
                        'EXTRA': '',
                        'FIELD_NAME_MAX': 'ELEV_MAX',
                        'FIELD_NAME_MIN': 'ELEV_MIN',
                        'IGNORE_NODATA': False,
                        'INPUT': outputs['ReclassificarPorTabela']['OUTPUT'],
                        'INTERVAL': 10,
                        'NODATA': None,
                        'OFFSET': 0,
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['ContornosDosPolgonos'] = processing.run('gdal:contour_polygon', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    if feedback.isCanceled():
                        return {}

                    # Buffer
                    alg_params = {
                        'DISSOLVE': True,
                        'DISTANCE': 0,
                        'END_CAP_STYLE': 0,  # Arredondado
                        'INPUT': outputs['ContornosDosPolgonos']['OUTPUT'],
                        'JOIN_STYLE': 0,  # Arredondado
                        'MITER_LIMIT': 2,
                        'SEGMENTS': 5,
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['Buffer'] = processing.run('native:buffer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    if feedback.isCanceled():
                        return {}

                    # Multipartes para partes simples
                    alg_params = {
                        'INPUT': outputs['Buffer']['OUTPUT'],
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['MultipartesParaPartesSimples'] = processing.run('native:multiparttosingleparts', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    if feedback.isCanceled():
                        return {}

                    # Extrair por expressão
                    alg_params = {
                        'EXPRESSION': "area(  transform( $geometry, @layer_crs ,'EPSG:31981'))>5",
                        'INPUT': outputs['MultipartesParaPartesSimples']['OUTPUT'],
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['ExtrairPorExpresso1'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    if feedback.isCanceled():
                        return {}
                    
                    # Pixels de raster para pontos
                    alg_params = {
                        'FIELD_NAME': 'VALUE',
                        'INPUT_RASTER': outputs['ReclassificarPorTabela']['OUTPUT'],
                        'RASTER_BAND': 1,
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['PixelsDeRasterParaPontos'] = processing.run('native:pixelstopoints', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    if feedback.isCanceled():
                        return {}

                    # Estatísticas zonais
                    alg_params = {
                        'COLUMN_PREFIX': '_',
                        'INPUT': outputs['ExtrairPorExpresso1']['OUTPUT'],
                        'INPUT_RASTER': outputs['ReclassificarPorTabela']['OUTPUT'],
                        'RASTER_BAND': 1,
                        'STATISTICS': [6],  # Máximo
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['EstatsticasZonais'] = processing.run('native:zonalstatisticsfb', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    if feedback.isCanceled():
                        return {}

                    # Associar atributos por localização
                    alg_params = {
                        'DISCARD_NONMATCHING': False,
                        'INPUT': outputs['PixelsDeRasterParaPontos']['OUTPUT'],
                        'JOIN': outputs['EstatsticasZonais']['OUTPUT'],
                        'JOIN_FIELDS': [''],
                        'METHOD': 0,  # Criar feição separada para cada feição correspondente (um-para-muitos)
                        'PREDICATE': [0],  # interseccionam
                        'PREFIX': '',
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['AssociarAtributosPorLocalizao'] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    feedback.setCurrentStep(10)
                    if feedback.isCanceled():
                        return {}

                    # Editar campos
                    alg_params = {
                        'FIELDS_MAPPING': [{'expression': 'round("VALUE",3)','length': 10,'name': 'VALUE','precision': 3,'sub_type': 0,'type': 6,'type_name': 'double precision'},{'expression': 'round("_max",3)','length': 10,'name': '_max','precision': 3,'sub_type': 0,'type': 6,'type_name': 'double precision'}],
                        'INPUT': outputs['AssociarAtributosPorLocalizao']['OUTPUT'],
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['EditarCampos'] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    feedback.setCurrentStep(11)
                    if feedback.isCanceled():
                        return {}


                    check = processing.run('native:extractbyexpression',{
                        'EXPRESSION': "area(  transform( $geometry, @layer_crs ,'EPSG:31981'))>5",
                        'INPUT': outputs['MultipartesParaPartesSimples']['OUTPUT'],
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT,
                        'FAIL_OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }, context=context, feedback=feedback)['OUTPUT']

                    if check.featureCount() > 0:

                        # Extrair por expressão
                        alg_params = {
                            'EXPRESSION': '"VALUE" >= "_max"',
                            'INPUT': outputs['EditarCampos']['OUTPUT'],
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['ExtrairPorExpresso'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        # Extração aleatória dentro de subconjuntos
                        alg_params = {
                            'FIELD': '_max',
                            'INPUT': outputs['ExtrairPorExpresso']['OUTPUT'],
                            'METHOD': 0,  # Número de feições selecionadas
                            'NUMBER': 1,
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['ExtraoAleatriaDentroDeSubconjuntos'] = processing.run('qgis:randomextractwithinsubsets', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        # Reprojetar camada
                        alg_params = {
                            'INPUT': outputs['ExtraoAleatriaDentroDeSubconjuntos']['OUTPUT'],
                            'OPERATION': '',
                            'TARGET_CRS': QgsCoordinateReferenceSystem('EPSG:31981'),
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['ReprojetarCamada'] = processing.run('native:reprojectlayer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        # Editar campos
                        alg_params = {
                            'FIELDS_MAPPING': [{'expression': '0','length': 0,'name': 'qnt_pt','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'}],
                            'INPUT': outputs['ReprojetarCamada']['OUTPUT'],
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['EditarCampos'] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}
                    

                        if counter != 1 and counter > inicioGrid:

                            # Mesclar camadas vetoriais
                            alg_params = {
                                'CRS': None,
                                'LAYERS': fatias,
                                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                            }
                            outputs['MesclarCamadasVetoriais'] = processing.run('native:mergevectorlayers', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                            if feedback.isCanceled():
                                return {}
                            
                            # Extrair por localização
                            alg_params = {
                                'INPUT': outputs['EditarCampos']['OUTPUT'],
                                'INTERSECT': outputs['MesclarCamadasVetoriais']['OUTPUT'],
                                'PREDICATE': [2],  # desunidos
                                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                            }
                            outputs['ExtrairPorLocalizao'] = processing.run('native:extractbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                            if feedback.isCanceled():
                                return {}

                            # Buffer
                            alg_params = {
                                'DISSOLVE': False,
                                'DISTANCE': distancia,
                                'END_CAP_STYLE': 0,  # Arredondado
                                'INPUT': outputs['ExtrairPorLocalizao']['OUTPUT'],
                                'JOIN_STYLE': 0,  # Arredondado
                                'MITER_LIMIT': 2,
                                'SEGMENTS': 5,
                                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                            }
                            outputs['Buffer'] = processing.run('native:buffer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                            if feedback.isCanceled():
                                return {}
                            
                        else:

                            # Buffer
                            alg_params = {
                                'DISSOLVE': False,
                                'DISTANCE': distancia,
                                'END_CAP_STYLE': 0,  # Arredondado
                                'INPUT': outputs['EditarCampos']['OUTPUT'],
                                'JOIN_STYLE': 0,  # Arredondado
                                'MITER_LIMIT': 2,
                                'SEGMENTS': 5,
                                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                            }
                            outputs['Buffer'] = processing.run('native:buffer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                            if feedback.isCanceled():
                                return {}

                        # Unir atributos pela localização (sumário)
                        alg_params = {
                            'DISCARD_NONMATCHING': False,
                            'INPUT': outputs['Buffer']['OUTPUT'],
                            'JOIN': outputs['Buffer']['OUTPUT'],
                            'JOIN_FIELDS': [''],
                            'PREDICATE': [0],  # interseccionam
                            'SUMMARIES': [0],  # Contagem
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['UnirAtributosPelaLocalizaoSumrio'] = processing.run('qgis:joinbylocationsummary', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        # Extrair por expressão
                        alg_params = {
                            'EXPRESSION': '"qnt_pt_count" <= 1',
                            'INPUT': outputs['UnirAtributosPelaLocalizaoSumrio']['OUTPUT'],
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT,
                            'FAIL_OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['ExtrairPorExpresso'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        fail = processing.run('native:extractbyexpression',{
                            'EXPRESSION': '"qnt_pt_count" <= 1',
                            'INPUT': outputs['UnirAtributosPelaLocalizaoSumrio']['OUTPUT'],
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT,
                            'FAIL_OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }, context=context, feedback=feedback)['OUTPUT']

                        if fail.featureCount() > 0:

                            # Centroides
                            alg_params = {
                                'ALL_PARTS': False,
                                'INPUT': outputs['ExtrairPorExpresso']['OUTPUT'],
                                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                            }
                            outputs['Centroides'+str(counter)+str(fatia)] = processing.run('native:centroids', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                            # Editar campos
                            alg_params = {
                                'FIELDS_MAPPING': [{'expression': counter,'length': 0,'name': 'hexagon','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'},
                                                {'expression': fatia,'length': 0,'name': 'fatia','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'},
                                                {'expression': maximum,'length': 10,'name': 'maximum','precision': 3,'sub_type': 0,'type': 6,'type_name': 'double precision'}],
                                'INPUT': outputs['Centroides'+str(counter)+str(fatia)]['OUTPUT'],
                                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                            }
                            outputs['EditarCampos'] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                            pontosGerados.append(outputs['EditarCampos']['OUTPUT'])
                            
                        else:
                            pass

                        # Buffer
                        alg_params = {
                            'DISSOLVE': False,
                            'DISTANCE': distancia,
                            'END_CAP_STYLE': 0,  # Arredondado
                            'INPUT': outputs['MultipartesParaPartesSimples']['OUTPUT'],
                            'JOIN_STYLE': 0,  # Arredondado
                            'MITER_LIMIT': 2,
                            'SEGMENTS': 5,
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['Buffer'] = processing.run('native:buffer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}
                        
                        fatias.append(outputs['Buffer']['OUTPUT'])

                    feedback.pushInfo(str(fatia)+str(' fatia 1'))
                    fatia += 1 
                                        
                elif fatia == 2:
                    #TODO:

                    # Reclassificar por tabela
                    alg_params = {
                        'DATA_TYPE': 5,  # Float32
                        'INPUT_RASTER': outputs['RecortarRasterPelaCamadaDeMscara']['OUTPUT'],
                        'NODATA_FOR_MISSING': False,
                        'NO_DATA': 0,
                        'RANGE_BOUNDARIES': 0,  # min < valor <= max
                        'RASTER_BAND': 1,
                        'TABLE': ['-9999',str(maximum-(altura*2)),'0',str(maximum-altura),'9999','0'],
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['ReclassificarPorTabela'] = processing.run('native:reclassifybytable', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    if feedback.isCanceled():
                        return {}
                                        
                    # Contornos dos Polígonos
                    alg_params = {
                        'BAND': 1,
                        'CREATE_3D': False,
                        'EXTRA': '',
                        'FIELD_NAME_MAX': 'ELEV_MAX',
                        'FIELD_NAME_MIN': 'ELEV_MIN',
                        'IGNORE_NODATA': False,
                        'INPUT': outputs['ReclassificarPorTabela']['OUTPUT'],
                        'INTERVAL': 10,
                        'NODATA': None,
                        'OFFSET': 0,
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['ContornosDosPolgonos'] = processing.run('gdal:contour_polygon', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    if feedback.isCanceled():
                        return {}

                    # Buffer
                    alg_params = {
                        'DISSOLVE': True,
                        'DISTANCE': 0,
                        'END_CAP_STYLE': 0,  # Arredondado
                        'INPUT': outputs['ContornosDosPolgonos']['OUTPUT'],
                        'JOIN_STYLE': 0,  # Arredondado
                        'MITER_LIMIT': 2,
                        'SEGMENTS': 5,
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['Buffer'] = processing.run('native:buffer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    if feedback.isCanceled():
                        return {}

                    # Multipartes para partes simples
                    alg_params = {
                        'INPUT': outputs['Buffer']['OUTPUT'],
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['MultipartesParaPartesSimples'] = processing.run('native:multiparttosingleparts', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    if feedback.isCanceled():
                        return {}

                    # Extrair por expressão
                    alg_params = {
                        'EXPRESSION': "area(  transform( $geometry, @layer_crs ,'EPSG:31981'))>5",
                        'INPUT': outputs['MultipartesParaPartesSimples']['OUTPUT'],
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['ExtrairPorExpresso1'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    if feedback.isCanceled():
                        return {}
                    
                    # Pixels de raster para pontos
                    alg_params = {
                        'FIELD_NAME': 'VALUE',
                        'INPUT_RASTER': outputs['ReclassificarPorTabela']['OUTPUT'],
                        'RASTER_BAND': 1,
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['PixelsDeRasterParaPontos'] = processing.run('native:pixelstopoints', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    if feedback.isCanceled():
                        return {}

                    # Estatísticas zonais
                    alg_params = {
                        'COLUMN_PREFIX': '_',
                        'INPUT': outputs['ExtrairPorExpresso1']['OUTPUT'],
                        'INPUT_RASTER': outputs['ReclassificarPorTabela']['OUTPUT'],
                        'RASTER_BAND': 1,
                        'STATISTICS': [6],  # Máximo
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['EstatsticasZonais'] = processing.run('native:zonalstatisticsfb', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    if feedback.isCanceled():
                        return {}

                    # Associar atributos por localização
                    alg_params = {
                        'DISCARD_NONMATCHING': False,
                        'INPUT': outputs['PixelsDeRasterParaPontos']['OUTPUT'],
                        'JOIN': outputs['EstatsticasZonais']['OUTPUT'],
                        'JOIN_FIELDS': [''],
                        'METHOD': 0,  # Criar feição separada para cada feição correspondente (um-para-muitos)
                        'PREDICATE': [0],  # interseccionam
                        'PREFIX': '',
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['AssociarAtributosPorLocalizao'] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    feedback.setCurrentStep(10)
                    if feedback.isCanceled():
                        return {}

                    # Editar campos
                    alg_params = {
                        'FIELDS_MAPPING': [{'expression': 'round("VALUE",3)','length': 10,'name': 'VALUE','precision': 3,'sub_type': 0,'type': 6,'type_name': 'double precision'},{'expression': 'round("_max",3)','length': 10,'name': '_max','precision': 3,'sub_type': 0,'type': 6,'type_name': 'double precision'}],
                        'INPUT': outputs['AssociarAtributosPorLocalizao']['OUTPUT'],
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['EditarCampos'] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    feedback.setCurrentStep(11)
                    if feedback.isCanceled():
                        return {}


                    check = processing.run('native:extractbyexpression',{
                        'EXPRESSION': "area(  transform( $geometry, @layer_crs ,'EPSG:31981'))>5",
                        'INPUT': outputs['MultipartesParaPartesSimples']['OUTPUT'],
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT,
                        'FAIL_OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }, context=context, feedback=feedback)['OUTPUT']

                    if check.featureCount() > 0:

                        # Extrair por expressão
                        alg_params = {
                            'EXPRESSION': '"VALUE" >= "_max"',
                            'INPUT': outputs['EditarCampos']['OUTPUT'],
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['ExtrairPorExpresso'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        # Extração aleatória dentro de subconjuntos
                        alg_params = {
                            'FIELD': '_max',
                            'INPUT': outputs['ExtrairPorExpresso']['OUTPUT'],
                            'METHOD': 0,  # Número de feições selecionadas
                            'NUMBER': 1,
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['ExtraoAleatriaDentroDeSubconjuntos'] = processing.run('qgis:randomextractwithinsubsets', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        # Reprojetar camada
                        alg_params = {
                            'INPUT': outputs['ExtraoAleatriaDentroDeSubconjuntos']['OUTPUT'],
                            'OPERATION': '',
                            'TARGET_CRS': QgsCoordinateReferenceSystem('EPSG:31981'),
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['ReprojetarCamada'] = processing.run('native:reprojectlayer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        # Editar campos
                        alg_params = {
                            'FIELDS_MAPPING': [{'expression': '0','length': 0,'name': 'qnt_pt','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'}],
                            'INPUT': outputs['ReprojetarCamada']['OUTPUT'],
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['EditarCampos'] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        # Mesclar camadas vetoriais
                        alg_params = {
                            'CRS': None,
                            'LAYERS': fatias,
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['MesclarCamadasVetoriais'] = processing.run('native:mergevectorlayers', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}
                        
                        # Extrair por localização
                        alg_params = {
                            'INPUT': outputs['EditarCampos']['OUTPUT'],
                            'INTERSECT': outputs['MesclarCamadasVetoriais']['OUTPUT'],
                            'PREDICATE': [2],  # desunidos
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['ExtrairPorLocalizao'] = processing.run('native:extractbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        # Buffer
                        alg_params = {
                            'DISSOLVE': False,
                            'DISTANCE': distancia,
                            'END_CAP_STYLE': 0,  # Arredondado
                            'INPUT': outputs['ExtrairPorLocalizao']['OUTPUT'],
                            'JOIN_STYLE': 0,  # Arredondado
                            'MITER_LIMIT': 2,
                            'SEGMENTS': 5,
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['Buffer'] = processing.run('native:buffer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        # Unir atributos pela localização (sumário)
                        alg_params = {
                            'DISCARD_NONMATCHING': False,
                            'INPUT': outputs['Buffer']['OUTPUT'],
                            'JOIN': outputs['Buffer']['OUTPUT'],
                            'JOIN_FIELDS': [''],
                            'PREDICATE': [0],  # interseccionam
                            'SUMMARIES': [0],  # Contagem
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['UnirAtributosPelaLocalizaoSumrio'] = processing.run('qgis:joinbylocationsummary', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        # Extrair por expressão
                        alg_params = {
                            'EXPRESSION': '"qnt_pt_count" <= 1',
                            'INPUT': outputs['UnirAtributosPelaLocalizaoSumrio']['OUTPUT'],
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT,
                            'FAIL_OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['ExtrairPorExpresso'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        fail = processing.run('native:extractbyexpression',{
                            'EXPRESSION': '"qnt_pt_count" <= 1',
                            'INPUT': outputs['UnirAtributosPelaLocalizaoSumrio']['OUTPUT'],
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT,
                            'FAIL_OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }, context=context, feedback=feedback)['OUTPUT']

                        if fail.featureCount() > 0:

                            # Centroides
                            alg_params = {
                                'ALL_PARTS': False,
                                'INPUT': outputs['ExtrairPorExpresso']['OUTPUT'],
                                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                            }
                            outputs['Centroides'+str(counter)+str(fatia)] = processing.run('native:centroids', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                            # Editar campos
                            alg_params = {
                                'FIELDS_MAPPING': [{'expression': counter,'length': 0,'name': 'hexagon','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'},
                                                {'expression': fatia,'length': 0,'name': 'fatia','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'},
                                                {'expression': maximum,'length': 10,'name': 'maximum','precision': 3,'sub_type': 0,'type': 6,'type_name': 'double precision'}],
                                'INPUT': outputs['Centroides'+str(counter)+str(fatia)]['OUTPUT'],
                                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                            }
                            outputs['EditarCampos'] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                            pontosGerados.append(outputs['EditarCampos']['OUTPUT'])
                            
                        else:
                            pass

                        # Buffer
                        alg_params = {
                            'DISSOLVE': False,
                            'DISTANCE': distancia,
                            'END_CAP_STYLE': 0,  # Arredondado
                            'INPUT': outputs['MultipartesParaPartesSimples']['OUTPUT'],
                            'JOIN_STYLE': 0,  # Arredondado
                            'MITER_LIMIT': 2,
                            'SEGMENTS': 5,
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['Buffer'] = processing.run('native:buffer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}
                        
                        fatias.append(outputs['Buffer']['OUTPUT'])

                    feedback.pushInfo(str(fatia)+str(' fatia 2'))
                    fatia += 1 

                elif fatia == 3:
                    #TODO:

                    # Reclassificar por tabela
                    alg_params = {
                        'DATA_TYPE': 5,  # Float32
                        'INPUT_RASTER': outputs['RecortarRasterPelaCamadaDeMscara']['OUTPUT'],
                        'NODATA_FOR_MISSING': False,
                        'NO_DATA': 0,
                        'RANGE_BOUNDARIES': 0,  # min < valor <= max
                        'RASTER_BAND': 1,
                        'TABLE': ['-9999',str(maximum-(altura*3)),'0',str(maximum-(altura*2)),'9999','0'],
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['ReclassificarPorTabela'] = processing.run('native:reclassifybytable', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    if feedback.isCanceled():
                        return {}
                                        
                    # Contornos dos Polígonos
                    alg_params = {
                        'BAND': 1,
                        'CREATE_3D': False,
                        'EXTRA': '',
                        'FIELD_NAME_MAX': 'ELEV_MAX',
                        'FIELD_NAME_MIN': 'ELEV_MIN',
                        'IGNORE_NODATA': False,
                        'INPUT': outputs['ReclassificarPorTabela']['OUTPUT'],
                        'INTERVAL': 10,
                        'NODATA': None,
                        'OFFSET': 0,
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['ContornosDosPolgonos'] = processing.run('gdal:contour_polygon', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    if feedback.isCanceled():
                        return {}

                    # Buffer
                    alg_params = {
                        'DISSOLVE': True,
                        'DISTANCE': 0,
                        'END_CAP_STYLE': 0,  # Arredondado
                        'INPUT': outputs['ContornosDosPolgonos']['OUTPUT'],
                        'JOIN_STYLE': 0,  # Arredondado
                        'MITER_LIMIT': 2,
                        'SEGMENTS': 5,
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['Buffer'] = processing.run('native:buffer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    if feedback.isCanceled():
                        return {}

                    # Multipartes para partes simples
                    alg_params = {
                        'INPUT': outputs['Buffer']['OUTPUT'],
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['MultipartesParaPartesSimples'] = processing.run('native:multiparttosingleparts', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    if feedback.isCanceled():
                        return {}

                    # Extrair por expressão
                    alg_params = {
                        'EXPRESSION': "area(  transform( $geometry, @layer_crs ,'EPSG:31981'))>5",
                        'INPUT': outputs['MultipartesParaPartesSimples']['OUTPUT'],
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['ExtrairPorExpresso1'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    if feedback.isCanceled():
                        return {}
                    
                    # Pixels de raster para pontos
                    alg_params = {
                        'FIELD_NAME': 'VALUE',
                        'INPUT_RASTER': outputs['ReclassificarPorTabela']['OUTPUT'],
                        'RASTER_BAND': 1,
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['PixelsDeRasterParaPontos'] = processing.run('native:pixelstopoints', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    if feedback.isCanceled():
                        return {}

                    # Estatísticas zonais
                    alg_params = {
                        'COLUMN_PREFIX': '_',
                        'INPUT': outputs['ExtrairPorExpresso1']['OUTPUT'],
                        'INPUT_RASTER': outputs['ReclassificarPorTabela']['OUTPUT'],
                        'RASTER_BAND': 1,
                        'STATISTICS': [6],  # Máximo
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['EstatsticasZonais'] = processing.run('native:zonalstatisticsfb', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    if feedback.isCanceled():
                        return {}

                    # Associar atributos por localização
                    alg_params = {
                        'DISCARD_NONMATCHING': False,
                        'INPUT': outputs['PixelsDeRasterParaPontos']['OUTPUT'],
                        'JOIN': outputs['EstatsticasZonais']['OUTPUT'],
                        'JOIN_FIELDS': [''],
                        'METHOD': 0,  # Criar feição separada para cada feição correspondente (um-para-muitos)
                        'PREDICATE': [0],  # interseccionam
                        'PREFIX': '',
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['AssociarAtributosPorLocalizao'] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    feedback.setCurrentStep(10)
                    if feedback.isCanceled():
                        return {}

                    # Editar campos
                    alg_params = {
                        'FIELDS_MAPPING': [{'expression': 'round("VALUE",3)','length': 10,'name': 'VALUE','precision': 3,'sub_type': 0,'type': 6,'type_name': 'double precision'},{'expression': 'round("_max",3)','length': 10,'name': '_max','precision': 3,'sub_type': 0,'type': 6,'type_name': 'double precision'}],
                        'INPUT': outputs['AssociarAtributosPorLocalizao']['OUTPUT'],
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['EditarCampos'] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    feedback.setCurrentStep(11)
                    if feedback.isCanceled():
                        return {}


                    check = processing.run('native:extractbyexpression',{
                        'EXPRESSION': "area(  transform( $geometry, @layer_crs ,'EPSG:31981'))>5",
                        'INPUT': outputs['MultipartesParaPartesSimples']['OUTPUT'],
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT,
                        'FAIL_OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }, context=context, feedback=feedback)['OUTPUT']

                    if check.featureCount() > 0:

                        # Extrair por expressão
                        alg_params = {
                            'EXPRESSION': '"VALUE" >= "_max"',
                            'INPUT': outputs['EditarCampos']['OUTPUT'],
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['ExtrairPorExpresso'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        # Extração aleatória dentro de subconjuntos
                        alg_params = {
                            'FIELD': '_max',
                            'INPUT': outputs['ExtrairPorExpresso']['OUTPUT'],
                            'METHOD': 0,  # Número de feições selecionadas
                            'NUMBER': 1,
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['ExtraoAleatriaDentroDeSubconjuntos'] = processing.run('qgis:randomextractwithinsubsets', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        # Reprojetar camada
                        alg_params = {
                            'INPUT': outputs['ExtraoAleatriaDentroDeSubconjuntos']['OUTPUT'],
                            'OPERATION': '',
                            'TARGET_CRS': QgsCoordinateReferenceSystem('EPSG:31981'),
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['ReprojetarCamada'] = processing.run('native:reprojectlayer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        # Editar campos
                        alg_params = {
                            'FIELDS_MAPPING': [{'expression': '0','length': 0,'name': 'qnt_pt','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'}],
                            'INPUT': outputs['ReprojetarCamada']['OUTPUT'],
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['EditarCampos'] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        # Mesclar camadas vetoriais
                        alg_params = {
                            'CRS': None,
                            'LAYERS': fatias,
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['MesclarCamadasVetoriais'] = processing.run('native:mergevectorlayers', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}
                        
                        # Extrair por localização
                        alg_params = {
                            'INPUT': outputs['EditarCampos']['OUTPUT'],
                            'INTERSECT': outputs['MesclarCamadasVetoriais']['OUTPUT'],
                            'PREDICATE': [2],  # desunidos
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['ExtrairPorLocalizao'] = processing.run('native:extractbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        # Buffer
                        alg_params = {
                            'DISSOLVE': False,
                            'DISTANCE': distancia,
                            'END_CAP_STYLE': 0,  # Arredondado
                            'INPUT': outputs['ExtrairPorLocalizao']['OUTPUT'],
                            'JOIN_STYLE': 0,  # Arredondado
                            'MITER_LIMIT': 2,
                            'SEGMENTS': 5,
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['Buffer'] = processing.run('native:buffer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        # Unir atributos pela localização (sumário)
                        alg_params = {
                            'DISCARD_NONMATCHING': False,
                            'INPUT': outputs['Buffer']['OUTPUT'],
                            'JOIN': outputs['Buffer']['OUTPUT'],
                            'JOIN_FIELDS': [''],
                            'PREDICATE': [0],  # interseccionam
                            'SUMMARIES': [0],  # Contagem
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['UnirAtributosPelaLocalizaoSumrio'] = processing.run('qgis:joinbylocationsummary', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        # Extrair por expressão
                        alg_params = {
                            'EXPRESSION': '"qnt_pt_count" <= 1',
                            'INPUT': outputs['UnirAtributosPelaLocalizaoSumrio']['OUTPUT'],
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT,
                            'FAIL_OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['ExtrairPorExpresso'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        fail = processing.run('native:extractbyexpression',{
                            'EXPRESSION': '"qnt_pt_count" <= 1',
                            'INPUT': outputs['UnirAtributosPelaLocalizaoSumrio']['OUTPUT'],
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT,
                            'FAIL_OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }, context=context, feedback=feedback)['OUTPUT']

                        if fail.featureCount() > 0:

                            # Centroides
                            alg_params = {
                                'ALL_PARTS': False,
                                'INPUT': outputs['ExtrairPorExpresso']['OUTPUT'],
                                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                            }
                            outputs['Centroides'+str(counter)+str(fatia)] = processing.run('native:centroids', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                            # Editar campos
                            alg_params = {
                                'FIELDS_MAPPING': [{'expression': counter,'length': 0,'name': 'hexagon','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'},
                                                {'expression': fatia,'length': 0,'name': 'fatia','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'},
                                                {'expression': maximum,'length': 10,'name': 'maximum','precision': 3,'sub_type': 0,'type': 6,'type_name': 'double precision'}],
                                'INPUT': outputs['Centroides'+str(counter)+str(fatia)]['OUTPUT'],
                                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                            }
                            outputs['EditarCampos'] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                            pontosGerados.append(outputs['EditarCampos']['OUTPUT'])
                            
                        else:
                            pass

                        # Buffer
                        alg_params = {
                            'DISSOLVE': False,
                            'DISTANCE': distancia,
                            'END_CAP_STYLE': 0,  # Arredondado
                            'INPUT': outputs['MultipartesParaPartesSimples']['OUTPUT'],
                            'JOIN_STYLE': 0,  # Arredondado
                            'MITER_LIMIT': 2,
                            'SEGMENTS': 5,
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['Buffer'] = processing.run('native:buffer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}
                        
                        fatias.append(outputs['Buffer']['OUTPUT'])

                    feedback.pushInfo(str(fatia)+str(' fatia 3'))
                    fatia += 1 

                elif fatia == 4:
                    #TODO:

                    # Reclassificar por tabela
                    alg_params = {
                        'DATA_TYPE': 5,  # Float32
                        'INPUT_RASTER': outputs['RecortarRasterPelaCamadaDeMscara']['OUTPUT'],
                        'NODATA_FOR_MISSING': False,
                        'NO_DATA': 0,
                        'RANGE_BOUNDARIES': 0,  # min < valor <= max
                        'RASTER_BAND': 1,
                        'TABLE': ['-9999',str(maximum-(altura*4)),'0',str(maximum-(altura*3)),'9999','0'],
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['ReclassificarPorTabela'] = processing.run('native:reclassifybytable', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    if feedback.isCanceled():
                        return {}
                                        
                    # Contornos dos Polígonos
                    alg_params = {
                        'BAND': 1,
                        'CREATE_3D': False,
                        'EXTRA': '',
                        'FIELD_NAME_MAX': 'ELEV_MAX',
                        'FIELD_NAME_MIN': 'ELEV_MIN',
                        'IGNORE_NODATA': False,
                        'INPUT': outputs['ReclassificarPorTabela']['OUTPUT'],
                        'INTERVAL': 10,
                        'NODATA': None,
                        'OFFSET': 0,
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['ContornosDosPolgonos'] = processing.run('gdal:contour_polygon', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    if feedback.isCanceled():
                        return {}

                    # Buffer
                    alg_params = {
                        'DISSOLVE': True,
                        'DISTANCE': 0,
                        'END_CAP_STYLE': 0,  # Arredondado
                        'INPUT': outputs['ContornosDosPolgonos']['OUTPUT'],
                        'JOIN_STYLE': 0,  # Arredondado
                        'MITER_LIMIT': 2,
                        'SEGMENTS': 5,
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['Buffer'] = processing.run('native:buffer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    if feedback.isCanceled():
                        return {}

                    # Multipartes para partes simples
                    alg_params = {
                        'INPUT': outputs['Buffer']['OUTPUT'],
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['MultipartesParaPartesSimples'] = processing.run('native:multiparttosingleparts', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    if feedback.isCanceled():
                        return {}

                    # Extrair por expressão
                    alg_params = {
                        'EXPRESSION': "area(  transform( $geometry, @layer_crs ,'EPSG:31981'))>5",
                        'INPUT': outputs['MultipartesParaPartesSimples']['OUTPUT'],
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['ExtrairPorExpresso1'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    if feedback.isCanceled():
                        return {}
                    
                    # Pixels de raster para pontos
                    alg_params = {
                        'FIELD_NAME': 'VALUE',
                        'INPUT_RASTER': outputs['ReclassificarPorTabela']['OUTPUT'],
                        'RASTER_BAND': 1,
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['PixelsDeRasterParaPontos'] = processing.run('native:pixelstopoints', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    if feedback.isCanceled():
                        return {}

                    # Estatísticas zonais
                    alg_params = {
                        'COLUMN_PREFIX': '_',
                        'INPUT': outputs['ExtrairPorExpresso1']['OUTPUT'],
                        'INPUT_RASTER': outputs['ReclassificarPorTabela']['OUTPUT'],
                        'RASTER_BAND': 1,
                        'STATISTICS': [6],  # Máximo
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['EstatsticasZonais'] = processing.run('native:zonalstatisticsfb', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    if feedback.isCanceled():
                        return {}

                    # Associar atributos por localização
                    alg_params = {
                        'DISCARD_NONMATCHING': False,
                        'INPUT': outputs['PixelsDeRasterParaPontos']['OUTPUT'],
                        'JOIN': outputs['EstatsticasZonais']['OUTPUT'],
                        'JOIN_FIELDS': [''],
                        'METHOD': 0,  # Criar feição separada para cada feição correspondente (um-para-muitos)
                        'PREDICATE': [0],  # interseccionam
                        'PREFIX': '',
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['AssociarAtributosPorLocalizao'] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    feedback.setCurrentStep(10)
                    if feedback.isCanceled():
                        return {}

                    # Editar campos
                    alg_params = {
                        'FIELDS_MAPPING': [{'expression': 'round("VALUE",3)','length': 10,'name': 'VALUE','precision': 3,'sub_type': 0,'type': 6,'type_name': 'double precision'},{'expression': 'round("_max",3)','length': 10,'name': '_max','precision': 3,'sub_type': 0,'type': 6,'type_name': 'double precision'}],
                        'INPUT': outputs['AssociarAtributosPorLocalizao']['OUTPUT'],
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['EditarCampos'] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    feedback.setCurrentStep(11)
                    if feedback.isCanceled():
                        return {}


                    check = processing.run('native:extractbyexpression',{
                        'EXPRESSION': "area(  transform( $geometry, @layer_crs ,'EPSG:31981'))>5",
                        'INPUT': outputs['MultipartesParaPartesSimples']['OUTPUT'],
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT,
                        'FAIL_OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }, context=context, feedback=feedback)['OUTPUT']

                    if check.featureCount() > 0:

                        # Extrair por expressão
                        alg_params = {
                            'EXPRESSION': '"VALUE" >= "_max"',
                            'INPUT': outputs['EditarCampos']['OUTPUT'],
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['ExtrairPorExpresso'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        # Extração aleatória dentro de subconjuntos
                        alg_params = {
                            'FIELD': '_max',
                            'INPUT': outputs['ExtrairPorExpresso']['OUTPUT'],
                            'METHOD': 0,  # Número de feições selecionadas
                            'NUMBER': 1,
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['ExtraoAleatriaDentroDeSubconjuntos'] = processing.run('qgis:randomextractwithinsubsets', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        # Reprojetar camada
                        alg_params = {
                            'INPUT': outputs['ExtraoAleatriaDentroDeSubconjuntos']['OUTPUT'],
                            'OPERATION': '',
                            'TARGET_CRS': QgsCoordinateReferenceSystem('EPSG:31981'),
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['ReprojetarCamada'] = processing.run('native:reprojectlayer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        # Editar campos
                        alg_params = {
                            'FIELDS_MAPPING': [{'expression': '0','length': 0,'name': 'qnt_pt','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'}],
                            'INPUT': outputs['ReprojetarCamada']['OUTPUT'],
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['EditarCampos'] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        # Mesclar camadas vetoriais
                        alg_params = {
                            'CRS': None,
                            'LAYERS': fatias,
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['MesclarCamadasVetoriais'] = processing.run('native:mergevectorlayers', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}
                        
                        # Extrair por localização
                        alg_params = {
                            'INPUT': outputs['EditarCampos']['OUTPUT'],
                            'INTERSECT': outputs['MesclarCamadasVetoriais']['OUTPUT'],
                            'PREDICATE': [2],  # desunidos
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['ExtrairPorLocalizao'] = processing.run('native:extractbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        # Buffer
                        alg_params = {
                            'DISSOLVE': False,
                            'DISTANCE': distancia,
                            'END_CAP_STYLE': 0,  # Arredondado
                            'INPUT': outputs['ExtrairPorLocalizao']['OUTPUT'],
                            'JOIN_STYLE': 0,  # Arredondado
                            'MITER_LIMIT': 2,
                            'SEGMENTS': 5,
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['Buffer'] = processing.run('native:buffer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        # Unir atributos pela localização (sumário)
                        alg_params = {
                            'DISCARD_NONMATCHING': False,
                            'INPUT': outputs['Buffer']['OUTPUT'],
                            'JOIN': outputs['Buffer']['OUTPUT'],
                            'JOIN_FIELDS': [''],
                            'PREDICATE': [0],  # interseccionam
                            'SUMMARIES': [0],  # Contagem
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['UnirAtributosPelaLocalizaoSumrio'] = processing.run('qgis:joinbylocationsummary', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        # Extrair por expressão
                        alg_params = {
                            'EXPRESSION': '"qnt_pt_count" <= 1',
                            'INPUT': outputs['UnirAtributosPelaLocalizaoSumrio']['OUTPUT'],
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT,
                            'FAIL_OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['ExtrairPorExpresso'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        fail = processing.run('native:extractbyexpression',{
                            'EXPRESSION': '"qnt_pt_count" <= 1',
                            'INPUT': outputs['UnirAtributosPelaLocalizaoSumrio']['OUTPUT'],
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT,
                            'FAIL_OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }, context=context, feedback=feedback)['OUTPUT']

                        if fail.featureCount() > 0:

                            # Centroides
                            alg_params = {
                                'ALL_PARTS': False,
                                'INPUT': outputs['ExtrairPorExpresso']['OUTPUT'],
                                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                            }
                            outputs['Centroides'+str(counter)+str(fatia)] = processing.run('native:centroids', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                            # Editar campos
                            alg_params = {
                                'FIELDS_MAPPING': [{'expression': counter,'length': 0,'name': 'hexagon','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'},
                                                {'expression': fatia,'length': 0,'name': 'fatia','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'},
                                                {'expression': maximum,'length': 10,'name': 'maximum','precision': 3,'sub_type': 0,'type': 6,'type_name': 'double precision'}],
                                'INPUT': outputs['Centroides'+str(counter)+str(fatia)]['OUTPUT'],
                                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                            }
                            outputs['EditarCampos'] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                            pontosGerados.append(outputs['EditarCampos']['OUTPUT'])
                            
                        else:
                            pass

                        # Buffer
                        alg_params = {
                            'DISSOLVE': False,
                            'DISTANCE': distancia,
                            'END_CAP_STYLE': 0,  # Arredondado
                            'INPUT': outputs['MultipartesParaPartesSimples']['OUTPUT'],
                            'JOIN_STYLE': 0,  # Arredondado
                            'MITER_LIMIT': 2,
                            'SEGMENTS': 5,
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['Buffer'] = processing.run('native:buffer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}
                        
                        fatias.append(outputs['Buffer']['OUTPUT'])

                    feedback.pushInfo(str(fatia)+str(' fatia 4'))
                    fatia += 1

                elif fatia == 5:
                #TODO:

                    # Reclassificar por tabela
                    alg_params = {
                        'DATA_TYPE': 5,  # Float32
                        'INPUT_RASTER': outputs['RecortarRasterPelaCamadaDeMscara']['OUTPUT'],
                        'NODATA_FOR_MISSING': False,
                        'NO_DATA': 0,
                        'RANGE_BOUNDARIES': 0,  # min < valor <= max
                        'RASTER_BAND': 1,
                        'TABLE': ['-9999',str(maximum-(altura*5)),'0',str(maximum-(altura*4)),'9999','0'],
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['ReclassificarPorTabela'] = processing.run('native:reclassifybytable', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    if feedback.isCanceled():
                        return {}
                                        
                    # Contornos dos Polígonos
                    alg_params = {
                        'BAND': 1,
                        'CREATE_3D': False,
                        'EXTRA': '',
                        'FIELD_NAME_MAX': 'ELEV_MAX',
                        'FIELD_NAME_MIN': 'ELEV_MIN',
                        'IGNORE_NODATA': False,
                        'INPUT': outputs['ReclassificarPorTabela']['OUTPUT'],
                        'INTERVAL': 10,
                        'NODATA': None,
                        'OFFSET': 0,
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['ContornosDosPolgonos'] = processing.run('gdal:contour_polygon', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    if feedback.isCanceled():
                        return {}

                    # Buffer
                    alg_params = {
                        'DISSOLVE': True,
                        'DISTANCE': 0,
                        'END_CAP_STYLE': 0,  # Arredondado
                        'INPUT': outputs['ContornosDosPolgonos']['OUTPUT'],
                        'JOIN_STYLE': 0,  # Arredondado
                        'MITER_LIMIT': 2,
                        'SEGMENTS': 5,
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['Buffer'] = processing.run('native:buffer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    if feedback.isCanceled():
                        return {}

                    # Multipartes para partes simples
                    alg_params = {
                        'INPUT': outputs['Buffer']['OUTPUT'],
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['MultipartesParaPartesSimples'] = processing.run('native:multiparttosingleparts', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    if feedback.isCanceled():
                        return {}

                    # Extrair por expressão
                    alg_params = {
                        'EXPRESSION': "area(  transform( $geometry, @layer_crs ,'EPSG:31981'))>5",
                        'INPUT': outputs['MultipartesParaPartesSimples']['OUTPUT'],
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['ExtrairPorExpresso1'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    if feedback.isCanceled():
                        return {}
                    
                    # Pixels de raster para pontos
                    alg_params = {
                        'FIELD_NAME': 'VALUE',
                        'INPUT_RASTER': outputs['ReclassificarPorTabela']['OUTPUT'],
                        'RASTER_BAND': 1,
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['PixelsDeRasterParaPontos'] = processing.run('native:pixelstopoints', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    if feedback.isCanceled():
                        return {}

                    # Estatísticas zonais
                    alg_params = {
                        'COLUMN_PREFIX': '_',
                        'INPUT': outputs['ExtrairPorExpresso1']['OUTPUT'],
                        'INPUT_RASTER': outputs['ReclassificarPorTabela']['OUTPUT'],
                        'RASTER_BAND': 1,
                        'STATISTICS': [6],  # Máximo
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['EstatsticasZonais'] = processing.run('native:zonalstatisticsfb', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    if feedback.isCanceled():
                        return {}

                    # Associar atributos por localização
                    alg_params = {
                        'DISCARD_NONMATCHING': False,
                        'INPUT': outputs['PixelsDeRasterParaPontos']['OUTPUT'],
                        'JOIN': outputs['EstatsticasZonais']['OUTPUT'],
                        'JOIN_FIELDS': [''],
                        'METHOD': 0,  # Criar feição separada para cada feição correspondente (um-para-muitos)
                        'PREDICATE': [0],  # interseccionam
                        'PREFIX': '',
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['AssociarAtributosPorLocalizao'] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    feedback.setCurrentStep(10)
                    if feedback.isCanceled():
                        return {}

                    # Editar campos
                    alg_params = {
                        'FIELDS_MAPPING': [{'expression': 'round("VALUE",3)','length': 10,'name': 'VALUE','precision': 3,'sub_type': 0,'type': 6,'type_name': 'double precision'},{'expression': 'round("_max",3)','length': 10,'name': '_max','precision': 3,'sub_type': 0,'type': 6,'type_name': 'double precision'}],
                        'INPUT': outputs['AssociarAtributosPorLocalizao']['OUTPUT'],
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }
                    outputs['EditarCampos'] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                    feedback.setCurrentStep(11)
                    if feedback.isCanceled():
                        return {}


                    check = processing.run('native:extractbyexpression',{
                        'EXPRESSION': "area(  transform( $geometry, @layer_crs ,'EPSG:31981'))>5",
                        'INPUT': outputs['MultipartesParaPartesSimples']['OUTPUT'],
                        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT,
                        'FAIL_OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                    }, context=context, feedback=feedback)['OUTPUT']

                    if check.featureCount() > 0:

                        # Extrair por expressão
                        alg_params = {
                            'EXPRESSION': '"VALUE" >= "_max"',
                            'INPUT': outputs['EditarCampos']['OUTPUT'],
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['ExtrairPorExpresso'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        # Extração aleatória dentro de subconjuntos
                        alg_params = {
                            'FIELD': '_max',
                            'INPUT': outputs['ExtrairPorExpresso']['OUTPUT'],
                            'METHOD': 0,  # Número de feições selecionadas
                            'NUMBER': 1,
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['ExtraoAleatriaDentroDeSubconjuntos'] = processing.run('qgis:randomextractwithinsubsets', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        # Reprojetar camada
                        alg_params = {
                            'INPUT': outputs['ExtraoAleatriaDentroDeSubconjuntos']['OUTPUT'],
                            'OPERATION': '',
                            'TARGET_CRS': QgsCoordinateReferenceSystem('EPSG:31981'),
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['ReprojetarCamada'] = processing.run('native:reprojectlayer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        # Editar campos
                        alg_params = {
                            'FIELDS_MAPPING': [{'expression': '0','length': 0,'name': 'qnt_pt','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'}],
                            'INPUT': outputs['ReprojetarCamada']['OUTPUT'],
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['EditarCampos'] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        # Mesclar camadas vetoriais
                        alg_params = {
                            'CRS': None,
                            'LAYERS': fatias,
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['MesclarCamadasVetoriais'] = processing.run('native:mergevectorlayers', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}
                        
                        # Extrair por localização
                        alg_params = {
                            'INPUT': outputs['EditarCampos']['OUTPUT'],
                            'INTERSECT': outputs['MesclarCamadasVetoriais']['OUTPUT'],
                            'PREDICATE': [2],  # desunidos
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['ExtrairPorLocalizao'] = processing.run('native:extractbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        # Buffer
                        alg_params = {
                            'DISSOLVE': False,
                            'DISTANCE': distancia,
                            'END_CAP_STYLE': 0,  # Arredondado
                            'INPUT': outputs['ExtrairPorLocalizao']['OUTPUT'],
                            'JOIN_STYLE': 0,  # Arredondado
                            'MITER_LIMIT': 2,
                            'SEGMENTS': 5,
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['Buffer'] = processing.run('native:buffer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        # Unir atributos pela localização (sumário)
                        alg_params = {
                            'DISCARD_NONMATCHING': False,
                            'INPUT': outputs['Buffer']['OUTPUT'],
                            'JOIN': outputs['Buffer']['OUTPUT'],
                            'JOIN_FIELDS': [''],
                            'PREDICATE': [0],  # interseccionam
                            'SUMMARIES': [0],  # Contagem
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['UnirAtributosPelaLocalizaoSumrio'] = processing.run('qgis:joinbylocationsummary', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        # Extrair por expressão
                        alg_params = {
                            'EXPRESSION': '"qnt_pt_count" <= 1',
                            'INPUT': outputs['UnirAtributosPelaLocalizaoSumrio']['OUTPUT'],
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT,
                            'FAIL_OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['ExtrairPorExpresso'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}

                        fail = processing.run('native:extractbyexpression',{
                            'EXPRESSION': '"qnt_pt_count" <= 1',
                            'INPUT': outputs['UnirAtributosPelaLocalizaoSumrio']['OUTPUT'],
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT,
                            'FAIL_OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }, context=context, feedback=feedback)['OUTPUT']

                        if fail.featureCount() > 0:

                            # Centroides
                            alg_params = {
                                'ALL_PARTS': False,
                                'INPUT': outputs['ExtrairPorExpresso']['OUTPUT'],
                                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                            }
                            outputs['Centroides'+str(counter)+str(fatia)] = processing.run('native:centroids', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                            # Editar campos
                            alg_params = {
                                'FIELDS_MAPPING': [{'expression': counter,'length': 0,'name': 'hexagon','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'},
                                                {'expression': fatia,'length': 0,'name': 'fatia','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'},
                                                {'expression': maximum,'length': 10,'name': 'maximum','precision': 3,'sub_type': 0,'type': 6,'type_name': 'double precision'}],
                                'INPUT': outputs['Centroides'+str(counter)+str(fatia)]['OUTPUT'],
                                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                            }
                            outputs['EditarCampos'] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                            pontosGerados.append(outputs['EditarCampos']['OUTPUT'])
                            
                        else:
                            pass

                        # Buffer
                        alg_params = {
                            'DISSOLVE': False,
                            'DISTANCE': distancia,
                            'END_CAP_STYLE': 0,  # Arredondado
                            'INPUT': outputs['MultipartesParaPartesSimples']['OUTPUT'],
                            'JOIN_STYLE': 0,  # Arredondado
                            'MITER_LIMIT': 2,
                            'SEGMENTS': 5,
                            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
                        }
                        outputs['Buffer'] = processing.run('native:buffer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

                        if feedback.isCanceled():
                            return {}
                        
                        fatias.append(outputs['Buffer']['OUTPUT'])

                    feedback.pushInfo(str(fatia)+str(' fatia 5'))
                    fatia += 1 

            feedback.pushInfo(str(counter))
            
            counter += 1

            feedback.setCurrentStep(counter)

        else:
            pass



        # Mesclar camadas vetoriais
        alg_params = {
            'CRS': None,
            'LAYERS': fatias,
            'OUTPUT': parameters['fatias']
        }
        outputs['MesclarCamadasVetoriais333'] = processing.run('native:mergevectorlayers', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['fatias'] = outputs['MesclarCamadasVetoriais333']['OUTPUT']
        
        if feedback.isCanceled():
            return {}
            
            
            
            
        # Mesclar camadas vetoriais
        alg_params = {
            'CRS': None,
            'LAYERS': pontosGerados,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['MesclarCamadasVetoriais'] = processing.run('native:mergevectorlayers', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        if feedback.isCanceled():
            return {}

        # Descartar campo(s)
        alg_params = {
            'COLUMN': ['layer','path'],
            'INPUT': outputs['MesclarCamadasVetoriais']['OUTPUT'],
            'OUTPUT': parameters['pontos']
        }
        outputs['DescartarCampos2'] = processing.run('native:deletecolumn', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['pontos'] = outputs['DescartarCampos2']['OUTPUT']

        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}
                
        return results

    def name(self):
        return 'createPoints'

    def displayName(self):
        return '6 - Create Points'

    # def group(self):
    #     return 'Mavic 3 Enterprise'

    # def groupId(self):
    #     return 'Mavic 3 Enterprise'

    def createInstance(self):
        return createPoints()
