"""
Model exported as python.
Name : orderGrid
Group : Mavic 3 Enterprise
With QGIS : 32812
"""

from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterFeatureSource
from qgis.core import QgsProcessingParameterFeatureSink
from qgis.core import QgsCoordinateReferenceSystem
import processing


class orderGrid(QgsProcessingAlgorithm):

    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterFeatureSource('base', 'Base Point', types=[QgsProcessing.TypeVectorPoint], defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSource('grid', 'Grid Created', types=[QgsProcessing.TypeVectorPolygon], defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('saida', 'Optimized Grid', type=QgsProcessing.TypeVectorLine, createByDefault=True, defaultValue=None))

    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(3, model_feedback)
        results = {}
        outputs = {}

        grid_saida = []

        parameters['saida'].destinationName = 'Optimized Grid'

        # Reprojetar camada
        alg_params = {
            'INPUT': parameters['base'],
            'OPERATION': '',
            'TARGET_CRS': QgsCoordinateReferenceSystem('EPSG:31981'),
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['base'] = processing.run('native:reprojectlayer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        # Reprojetar camada
        alg_params = {
            'INPUT': parameters['grid'],
            'OPERATION': '',
            'TARGET_CRS': QgsCoordinateReferenceSystem('EPSG:31981'),
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['grid'] = processing.run('native:reprojectlayer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        # Reprojetar camada
        grid = processing.run('native:reprojectlayer',{
            'INPUT': parameters['grid'],
            'OPERATION': '',
            'TARGET_CRS': QgsCoordinateReferenceSystem('EPSG:31981'),
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }, context=context, feedback=feedback)['OUTPUT']

        gridtt = grid.featureCount()
        feedback.pushInfo('gridtt '+str(gridtt))

        # Linha mais curta entre feições
        alg_params = {
            'DESTINATION': outputs['grid']['OUTPUT'],
            'DISTANCE': None,
            'METHOD': 0,  # Distance to Nearest Point on feature
            'NEIGHBORS': 1,
            'SOURCE': outputs['base']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['LinhaMaisCurtaEntreFeies'] = processing.run('native:shortestline', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}
        
        # Extrair vértices
        alg_params = {
            'INPUT': outputs['LinhaMaisCurtaEntreFeies']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ExtrairVrtices'] = processing.run('native:extractvertices', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        
        # Buffer
        alg_params = {
            'DISSOLVE': False,
            'DISTANCE': 0.01,
            'END_CAP_STYLE': 2,  # Quadrado
            'INPUT': outputs['ExtrairVrtices']['OUTPUT'],
            'JOIN_STYLE': 1,  # Pontiagudo
            'MITER_LIMIT': 2,
            'SEGMENTS': 5,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Buffer'] = processing.run('native:buffer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        if feedback.isCanceled():
            return {}

        gridUn = 1
        feedback.pushInfo('gridUn '+str(gridUn))

        # Associar atributos por localização
        alg_params = {
            'DISCARD_NONMATCHING': True,
            'INPUT': outputs['grid']['OUTPUT'],
            'JOIN': outputs['Buffer']['OUTPUT'],
            'JOIN_FIELDS': [''],
            'METHOD':  1,  # Tomar atributos apenas da primeira feição coincidente (uma-por-uma)
            'PREDICATE': [0],  # interseccionam
            'PREFIX': '',
            'NON_MATCHING': QgsProcessing.TEMPORARY_OUTPUT,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Associar'+str(gridUn)] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(2)
        if feedback.isCanceled():
            return {}
        
        # Editar campos
        alg_params = {
            'FIELDS_MAPPING': [{'expression': gridUn,'length': 0,'name': 'hexagon','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'}],
            'INPUT': outputs['Associar'+str(gridUn)]['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EditarCampos'+str(gridUn)] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        
        grid_saida.append(outputs['EditarCampos'+str(gridUn)]['OUTPUT'])

        while gridUn <= gridtt:

            # Linha mais curta entre feições
            alg_params = {
                'DESTINATION': outputs['Associar'+str(gridUn)]['NON_MATCHING'],
                'DISTANCE': None,
                'METHOD': 0,  # Distance to Nearest Point on feature
                'NEIGHBORS': 1,
                'SOURCE': outputs['base']['OUTPUT'],
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['Linha'+str(gridUn)] = processing.run('native:shortestline', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

            # Extrair vértices
            alg_params = {
                'INPUT': outputs['Linha'+str(gridUn)]['OUTPUT'],
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['ExtrairVrtices'+str(gridUn)] = processing.run('native:extractvertices', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
            
            gridUn += 1
            feedback.pushInfo('gridUn '+str(gridUn))

            # Buffer
            alg_params = {
                'DISSOLVE': False,
                'DISTANCE': 0.01,
                'END_CAP_STYLE': 2,  # Quadrado
                'INPUT': outputs['ExtrairVrtices'+str(gridUn-1)]['OUTPUT'],
                'JOIN_STYLE': 1,  # Pontiagudo
                'MITER_LIMIT': 2,
                'SEGMENTS': 5,
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['Buffer'] = processing.run('native:buffer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

            if feedback.isCanceled():
                return {}

            # Associar atributos por localização
            alg_params = {
                'DISCARD_NONMATCHING': True,
                'INPUT': outputs['Associar'+str(gridUn-1)]['NON_MATCHING'],
                'JOIN': outputs['Buffer']['OUTPUT'],
                'JOIN_FIELDS': [''],
                'METHOD':  1,  # Tomar atributos apenas da primeira feição coincidente (uma-por-uma)
                'PREDICATE': [0],  # interseccionam
                'PREFIX': '',
                'NON_MATCHING': QgsProcessing.TEMPORARY_OUTPUT,
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['Associar'+str(gridUn)] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

            feedback.setCurrentStep(2)
            if feedback.isCanceled():
                return {}
            
            # Editar campos
            alg_params = {
                'FIELDS_MAPPING': [{'expression': gridUn,'length': 0,'name': 'hexagon','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'}],
                'INPUT': outputs['Associar'+str(gridUn)]['OUTPUT'],
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['EditarCampos'+str(gridUn)] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
            
            grid_saida.append(outputs['EditarCampos'+str(gridUn)]['OUTPUT'])


        # Mesclar camadas vetoriais
        alg_params = {
            'CRS': None,
            'LAYERS': grid_saida,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['MesclarCamadasVetoriais'] = processing.run('native:mergevectorlayers', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        if feedback.isCanceled():
            return {}

        # Executar SQL
        alg_params = {
            'INPUT_DATASOURCES': outputs['MesclarCamadasVetoriais']['OUTPUT'],
            'INPUT_GEOMETRY_CRS': None,
            'INPUT_GEOMETRY_FIELD': '',
            'INPUT_GEOMETRY_TYPE': None,
            'INPUT_QUERY': 'select * from input1\norder by "group"',
            'INPUT_UID_FIELD': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ExecutarSql'] = processing.run('qgis:executesql', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(3)
        if feedback.isCanceled():
            return {}

        # Descartar campo(s)
        alg_params = {
            'COLUMN': ['layer','path','fid'],
            'INPUT': outputs['ExecutarSql']['OUTPUT'],
            'OUTPUT': parameters['saida']
        }
        outputs['DescartarCampos2'] = processing.run('native:deletecolumn', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        results['saida'] = outputs['DescartarCampos2']['OUTPUT']

        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}

        return results

    def name(self):
        return 'optimizeGrid'

    def displayName(self):
        return '4 - Optimize Grid'

    # def group(self):
    #     return 'Mavic 3 Enterprise'

    # def groupId(self):
    #     return 'Mavic 3 Enterprise'

    def createInstance(self):
        return orderGrid()
