"""
Model exported as python.
Name : createFirstFlight
Group : Mavic 3 Enterprise
With QGIS : 32812
"""

from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterFeatureSource
from qgis.core import QgsProcessingParameterFeatureSink
from qgis.core import QgsCoordinateReferenceSystem
import processing


class createFirstFlight(QgsProcessingAlgorithm):

    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterFeatureSource('parcela', 'Area Plot', types=[QgsProcessing.TypeVectorPolygon], defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSource('ponto_da_base', 'Base Point', types=[QgsProcessing.TypeVectorPoint], defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('Saida', 'Flight Plan - Save as KML for UgCS', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))

    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(7, model_feedback)
        results = {}
        outputs = {}
        
        parameters['Saida'].destinationName = 'Flight Plan - Save as KML for UgCS'

        # Reprojetar camada
        alg_params = {
            'INPUT': parameters['ponto_da_base'],
            'OPERATION': '',
            'TARGET_CRS': QgsCoordinateReferenceSystem('EPSG:31981'),
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ReprojetarCamada'] = processing.run('native:reprojectlayer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}

        # Reprojetar camada
        alg_params = {
            'INPUT': parameters['parcela'],
            'OPERATION': '',
            'TARGET_CRS': QgsCoordinateReferenceSystem('EPSG:31981'),
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ReprojetarCamadaParcela'] = processing.run('native:reprojectlayer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(2)
        if feedback.isCanceled():
            return {}
        
        # Buffer
        alg_params = {
            'DISSOLVE': False,
            'DISTANCE': 30,
            'END_CAP_STYLE': 2,  # Quadrado
            'INPUT': outputs['ReprojetarCamadaParcela']['OUTPUT'],
            'JOIN_STYLE': 0,  # Arredondado
            'MITER_LIMIT': 2,
            'SEGMENTS': 5,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['BufferParcela'] = processing.run('native:buffer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(5)
        if feedback.isCanceled():
            return {}
            
        # Dissolver
        alg_params = {
            'FIELD': [''],
            'INPUT': outputs['BufferParcela']['OUTPUT'],
            'SEPARATE_DISJOINT': False,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Dissolver'] = processing.run('native:dissolve', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(3)
        if feedback.isCanceled():
            return {}

        # Linha mais curta entre feições
        alg_params = {
            'DESTINATION': outputs['ReprojetarCamada']['OUTPUT'],
            'DISTANCE': None,
            'METHOD': 0,  # Distance to Nearest Point on feature
            'NEIGHBORS': 1,
            'SOURCE': outputs['Dissolver']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['LinhaMaisCurtaEntreFeies'] = processing.run('native:shortestline', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(4)
        if feedback.isCanceled():
            return {}

        # Buffer
        alg_params = {
            'DISSOLVE': False,
            'DISTANCE': 30,
            'END_CAP_STYLE': 2,  # Quadrado
            'INPUT': outputs['LinhaMaisCurtaEntreFeies']['OUTPUT'],
            'JOIN_STYLE': 0,  # Arredondado
            'MITER_LIMIT': 2,
            'SEGMENTS': 5,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Buffer'] = processing.run('native:buffer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(5)
        if feedback.isCanceled():
            return {}

        # Mesclar camadas vetoriais
        alg_params = {
            'CRS': None,
            'LAYERS': [outputs['Dissolver']['OUTPUT'],outputs['Buffer']['OUTPUT']],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['MesclarCamadasVetoriais'] = processing.run('native:mergevectorlayers', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(6)
        if feedback.isCanceled():
            return {}

        # Dissolver
        alg_params = {
            'FIELD': [''],
            'INPUT': outputs['MesclarCamadasVetoriais']['OUTPUT'],
            'SEPARATE_DISJOINT': False,
            'OUTPUT': parameters['Saida']
        }
        outputs['Dissolver'] = processing.run('native:dissolve', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Saida'] = outputs['Dissolver']['OUTPUT']
            
        return results

    def name(self):
        return 'createMappingFlight'

    def displayName(self):
        return '2 - Create Mapping Flight'

    # def group(self):
    #     return 'Mavic 3 Enterprise'

    # def groupId(self):
    #     return 'Mavic 3 Enterprise'

    def createInstance(self):
        return createFirstFlight()
