"""
Model exported as python.
Name : baseCreator
Group : Mavic 3 Enterprise
With QGIS : 32812
"""

from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterFeatureSink

import processing


class baseCreator(QgsProcessingAlgorithm):

    def initAlgorithm(self, config):
        """
        Definition of the inputs and output of the algorithm.
        """

        self.addParameter(QgsProcessingParameterFeatureSink('novaArea', 'Base Point - Save as GPKG', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))


    def processAlgorithm(self, parameters, context, model_feedback):
        """
        The processing itself.
        """

        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(3, model_feedback)
        results = {}
        outputs = {}

        parameters['novaArea'].destinationName = 'Base Point - Save as GPKG'

        # Criar camada pela extensão
        alg_params = {
            'INPUT': '-60.014603942,-39.256933375,-24.505255098,-3.615706065 [EPSG:4326]',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['CriarCamadaPelaExtenso'] = processing.run('native:extenttolayer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}

        # Extrair por expressão
        alg_params = {
            'EXPRESSION': '\"id\" = 99',
            'INPUT': outputs['CriarCamadaPelaExtenso']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ExtrairPorExpresso'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(2)
        if feedback.isCanceled():
            return {}
        
        
        # Extrair vértices
        alg_params = {
            'INPUT': outputs['ExtrairPorExpresso']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ExtrairVrtices'] = processing.run('native:extractvertices', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        

        # Editar campos
        alg_params = {
            'FIELDS_MAPPING': [],
            'INPUT': outputs['ExtrairVrtices']['OUTPUT'],
            'OUTPUT': parameters['novaArea']
        }
        outputs['EditarCampos'] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['novaArea'] = outputs['EditarCampos']['OUTPUT']
        return results

    def name(self):
        return 'createBasePoint'

    def displayName(self):
        return '1 - Create Base Point'

    # def group(self):
    #     return 'Mavic 3 Enterprise'

    # def groupId(self):
    #     return 'Mavic 3 Enterprise'

    def createInstance(self):
        return baseCreator()
