# -*- coding: utf-8 -*-

"""
/***************************************************************************
 CanopyZoomPhotos
                                 A QGIS plugin
 This plugin helps to create an orthomosaic flight plan, identify the tallest trees on area, crete multiples flight plan to acquire zoom images from each tree selected.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-09-22
        copyright            : (C) 2025 by Herbert Lincon Santos
        email                : hlincon.santos@outlook.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Herbert Lincon Santos'
__date__ = '2025-09-22'
__copyright__ = '(C) 2025 by Herbert Lincon Santos'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import sys
import inspect

from qgis.core import QgsProcessingAlgorithm, QgsApplication
from .capony_zoom_photos_provider import CanopyZoomPhotosProvider

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)


class CanopyZoomPhotosPlugin(object):

    def __init__(self):
        self.provider = None

    def initProcessing(self):
        """Init Processing provider for QGIS >= 3.8."""
        self.provider = CanopyZoomPhotosProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def initGui(self):
        self.initProcessing()

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)
