"""
Model exported as python.
Name : createGrid
Group : Mavic 3 Enterprise
With QGIS : 32812
"""

from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterFeatureSource
from qgis.core import QgsProcessingParameterFeatureSink
from qgis.core import QgsCoordinateReferenceSystem
from qgis.core import QgsProcessingParameterNumber
from qgis.core import QgsProcessingParameterEnum
import processing


class createGrid(QgsProcessingAlgorithm):

    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterFeatureSource('parcela_da_rea', 'Area Plot', types=[QgsProcessing.TypeVectorPolygon], defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('Grid', 'Grid', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterNumber('larguraGrid', 'Grid Width (meters)', type=QgsProcessingParameterNumber.Integer, minValue=100, maxValue=500, defaultValue=250))
        self.addParameter(QgsProcessingParameterEnum('tipoGrid', 'Grid Type', options=['Hexagon','Rectangle','Diamond'], allowMultiple=False, usesStaticStrings=False, defaultValue=[]))

    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(3, model_feedback)
        results = {}
        outputs = {}

        parameters['Grid'].destinationName = 'Grid Created'

        larguraGrid = int(parameters['larguraGrid'])
        tipoGrid = int(parameters['tipoGrid'])

        if tipoGrid == 0:
            tipoGrid = 4
        elif tipoGrid == 1:
            tipoGrid = 2
        else:
            tipoGrid = 3

        # Reprojetar camada
        alg_params = {
            'INPUT': parameters['parcela_da_rea'],
            'OPERATION': '',
            'TARGET_CRS': QgsCoordinateReferenceSystem('EPSG:31981'),
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ReprojetarCamada'] = processing.run('native:reprojectlayer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}

        # Buffer
        alg_params = {
            'DISSOLVE': False,
            'DISTANCE': 250,
            'END_CAP_STYLE': 2,  # Quadrado
            'INPUT': outputs['ReprojetarCamada']['OUTPUT'],
            'JOIN_STYLE': 1,  # Pontiagudo
            'MITER_LIMIT': 2,
            'SEGMENTS': 5,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Buffer'] = processing.run('native:buffer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(2)
        if feedback.isCanceled():
            return {}

        # Criar grade
        alg_params = {
            'CRS': outputs['Buffer']['OUTPUT'],
            'EXTENT': outputs['Buffer']['OUTPUT'],
            'HOVERLAY': 0,
            'HSPACING': larguraGrid,
            'TYPE': tipoGrid,  # Hexágono (Polígono)
            'VOVERLAY': 0,
            'VSPACING': larguraGrid,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['CriarGrade'] = processing.run('native:creategrid', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        
        if feedback.isCanceled():
            return {}
        
        # Editar campos
        alg_params = {
            'FIELDS_MAPPING': [{'expression': '$id','length': 0,'name': 'hexagon','precision': 0,'sub_type': 0,'type': 2,'type_name': 'integer'}],
            'INPUT': outputs['CriarGrade']['OUTPUT'],
            'OUTPUT': parameters['Grid']
        }
        outputs['EditarCampos'] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        results['Grid'] = outputs['CriarGrade']['OUTPUT']
        return results

    def name(self):
        return 'createGrid'

    def displayName(self):
        return '3 - Create Grid'

    # def group(self):
    #     return 'Mavic 3 Enterprise'

    # def groupId(self):
    #     return 'Mavic 3 Enterprise'

    def createInstance(self):
        return createGrid()
