# -*- coding: utf-8 -*-

"""
/***************************************************************************
 CanopyZoomPhotos
                                 A QGIS plugin
 This plugin helps to create an orthomosaic flight plan, identify the tallest trees on area, crete multiples flight plan to acquire zoom images from each tree selected.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-09-22
        copyright            : (C) 2025 by Herbert Lincon Santos
        email                : hlincon.santos@outlook.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Herbert Lincon Santos'
__date__ = '2025-09-22'
__copyright__ = '(C) 2025 by Herbert Lincon Santos'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.core import QgsProcessingProvider
from .capony_zoom_photos_algorithm import CanopyZoomPhotosAlgorithm

from .funcs.baseCreator import *
from .funcs.clearPoints import *
from .funcs.createFirstFlight import *
from .funcs.createGrid import *
from .funcs.createPoints import *
from .funcs.cutDSM import *
from .funcs.orderGrid import *
from .funcs.orderPoints import *
from .funcs.routeGenerator import *

class CanopyZoomPhotosProvider(QgsProcessingProvider):

    def __init__(self):
        """
        Default constructor.
        """
        QgsProcessingProvider.__init__(self)

    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        pass

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """
        self.addAlgorithm(CanopyZoomPhotosAlgorithm())
        
        self.addAlgorithm(baseCreator())
        self.addAlgorithm(clearPoints())
        self.addAlgorithm(createGrid())
        self.addAlgorithm(createFirstFlight())
        self.addAlgorithm(createPoints())
        self.addAlgorithm(cutDSM())
        self.addAlgorithm(orderGrid())
        self.addAlgorithm(orderPoints())
        self.addAlgorithm(routeGenerator())

    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        return 'Canopy Zoom Photos'

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        return self.tr('Canopy Zoom Photos')

    def icon(self):
        """
        Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        return QgsProcessingProvider.icon(self)

    def longName(self):
        """
        Returns the a longer version of the provider name, which can include
        extra details such as version numbers. E.g. "Lastools LIDAR tools
        (version 2.2.1)". This string should be localised. The default
        implementation returns the same string as name().
        """
        return self.name()
