CREATE INDEX IF NOT EXISTS geo_commune_geom_idx ON geo_commune USING gist (geom);
CREATE INDEX IF NOT EXISTS geo_section_geom_idx ON geo_section USING gist (geom);
CREATE INDEX IF NOT EXISTS geo_subdsect_geom_idx ON geo_subdsect USING gist (geom);
CREATE INDEX IF NOT EXISTS geo_parcelle_geom_idx ON geo_parcelle USING gist (geom);
CREATE INDEX IF NOT EXISTS geo_subdfisc_geom_idx ON geo_subdfisc USING gist (geom);
CREATE INDEX IF NOT EXISTS geo_voiep_geom_idx ON geo_voiep USING gist (geom);
CREATE INDEX IF NOT EXISTS geo_numvoie_geom_idx ON geo_numvoie USING gist (geom);
CREATE INDEX IF NOT EXISTS geo_lieudit_geom_idx ON geo_lieudit USING gist (geom);
CREATE INDEX IF NOT EXISTS geo_batiment_geom_idx ON geo_batiment USING gist (geom);
CREATE INDEX IF NOT EXISTS geo_zoncommuni_geom_idx ON geo_zoncommuni USING gist (geom);
CREATE INDEX IF NOT EXISTS geo_tronfluv_geom_idx ON geo_tronfluv USING gist (geom);
CREATE INDEX IF NOT EXISTS geo_tronroute_geom_idx ON geo_tronroute USING gist (geom);
CREATE INDEX IF NOT EXISTS geo_ptcanv_geom_idx ON geo_ptcanv USING gist (geom);
CREATE INDEX IF NOT EXISTS geo_borne_geom_idx ON geo_borne USING gist (geom);
CREATE INDEX IF NOT EXISTS geo_croix_geom_idx ON geo_croix USING gist (geom);
CREATE INDEX IF NOT EXISTS geo_symblim_geom_idx ON geo_symblim USING gist (geom);
CREATE INDEX IF NOT EXISTS geo_tpoint_geom_idx ON geo_tpoint USING gist (geom);
CREATE INDEX IF NOT EXISTS geo_tline_geom_idx ON geo_tline USING gist (geom);
CREATE INDEX IF NOT EXISTS geo_tsurf_geom_idx ON geo_tsurf USING gist (geom);
CREATE INDEX IF NOT EXISTS geo_label_geom_idx ON geo_label USING gist (geom);
CREATE INDEX IF NOT EXISTS geo_unite_fonciere_geom_idx ON geo_unite_fonciere USING gist (geom);

-- attributes
CREATE INDEX IF NOT EXISTS geo_commune_tex2_idx ON geo_commune (tex2);
CREATE INDEX IF NOT EXISTS geo_section_idu_idx ON geo_section (idu);
CREATE INDEX IF NOT EXISTS geo_parcelle_idu_idx ON geo_parcelle (idu);
CREATE INDEX IF NOT EXISTS geo_parcelle_geo_parcelle ON geo_parcelle (geo_parcelle);
CREATE INDEX IF NOT EXISTS geo_section_geo_commune_idx ON geo_section (geo_commune);
CREATE INDEX IF NOT EXISTS geo_parcelle_geo_section_idx ON geo_parcelle (geo_section);
CREATE INDEX IF NOT EXISTS geo_unite_fonciere_comptecommunal_idx ON geo_unite_fonciere (comptecommunal);
CREATE INDEX IF NOT EXISTS geo_label_ogc_fid_idx ON geo_label (ogc_fid );
CREATE INDEX IF NOT EXISTS geo_label_x_label_idx ON geo_label (x_label );
CREATE INDEX IF NOT EXISTS geo_label_y_label_idx ON geo_label (y_label );
CREATE INDEX IF NOT EXISTS geo_label_ogr_obj_lnk_layer_idx ON geo_label (ogr_obj_lnk_layer);
CREATE INDEX IF NOT EXISTS idx_proprietaire_ccocom ON proprietaire (ccocom);
CREATE INDEX IF NOT EXISTS idx_commune_ccocom ON commune (ccocom);
CREATE INDEX IF NOT EXISTS idx_commune_majic_ccocom ON commune_majic (ccocom);
CREATE INDEX IF NOT EXISTS idx_proprietaire_ccodro ON proprietaire (ccodro);
CREATE INDEX IF NOT EXISTS idx_proprietaire_proprietaire ON proprietaire (proprietaire);
CREATE INDEX IF NOT EXISTS idx_proprietaire_comptecommunal ON proprietaire (comptecommunal);
CREATE INDEX IF NOT EXISTS idx_local00_parcelle ON local00 (parcelle);
CREATE INDEX IF NOT EXISTS idx_local00_voie ON local00 (voie);
CREATE INDEX IF NOT EXISTS idx_local00_voie_substr ON local00 ((substr(voie, 1, 6) || substr(voie, 12, 4)));
CREATE INDEX IF NOT EXISTS idx_local10_local00 ON local10 (local00);
CREATE INDEX IF NOT EXISTS idx_local10_comptecommunal ON local10 (comptecommunal);
CREATE INDEX IF NOT EXISTS idx_pevexoneration_pev ON pevexoneration (pev);
CREATE INDEX IF NOT EXISTS idx_pevtaxation_pev ON pevtaxation (pev);
CREATE INDEX IF NOT EXISTS idx_parcelle_voie ON parcelle (voie);
CREATE INDEX IF NOT EXISTS idx_parcelle_voie_substr ON parcelle ((substr(voie, 1, 6) || substr(voie, 12, 4)));
CREATE INDEX IF NOT EXISTS idx_parcelle_comptecommunal ON parcelle (comptecommunal);
