﻿-- nomenclature gpdl (parcelle)
INSERT INTO gpdl VALUES ('0','la parcelle n''appartient pas à une pdl');
INSERT INTO gpdl VALUES ('1','la parcelle est référence de pdl (identifie une pdl)');
INSERT INTO gpdl VALUES ('2','la parcelle est composante de pdl mais ne l''identifie pas');
-- nomenclature gnexps (suf)
INSERT INTO gnexps VALUES ('CD', 'Exonération permanente des parts communale et départementale(Bien d''une région situe dans une autre région)');
INSERT INTO gnexps VALUES ('CR', 'Exonération permanente des parts communale et régionale (Bien d''un département situe dans un autre département)');
INSERT INTO gnexps VALUES ('DR', 'Exonération permanente des parts départementale et régionale (Bien d''une commune situe dans une autre commune)');
INSERT INTO gnexps VALUES ('EP', 'Exonération permanente totale');
INSERT INTO gnexps VALUES ('NI', 'Non imposable - Exonération toutes collectivités');
INSERT INTO gnexps VALUES ('RT', 'Exonération des chemins de remembrements association foncière de remembrement');
INSERT INTO gnexps VALUES ('CC', 'exonération des parts TSE et TATFNB pour les biens communaux situés sur le territoire d’une autre commune de la métropole de Lyon');
INSERT INTO gnexps VALUES ('DD', 'exonération des parts communale, intercommunale et TSE pour les biens appartenant à un département situés en dehors de son territoire');
INSERT INTO gnexps VALUES ('GG', 'exonération des parts TSE et TAFNB pour les biens appartenant à un EPCI ou à la métropole de Lyon et situés en dehors de son territoire');
INSERT INTO gnexps VALUES ('GN', 'transfert de propriétés non bâties par l’État aux grands ports maritimes affectés à un service public ou d utilité générale et non productifs de revenus');

-- nomenclature cgrnum (suf)
INSERT INTO cgrnum VALUES ('01', 'Terres');
INSERT INTO cgrnum VALUES ('02', 'Prés');
INSERT INTO cgrnum VALUES ('03', 'Vergers');
INSERT INTO cgrnum VALUES ('04', 'Vignes');
INSERT INTO cgrnum VALUES ('05', 'Bois');
INSERT INTO cgrnum VALUES ('06', 'Landes');
INSERT INTO cgrnum VALUES ('07', 'Carrières');
INSERT INTO cgrnum VALUES ('08', 'Eaux');
INSERT INTO cgrnum VALUES ('09', 'Jardins');
INSERT INTO cgrnum VALUES ('10', 'Terrains à bâtir');
INSERT INTO cgrnum VALUES ('11', 'Terrains d''agrément');
INSERT INTO cgrnum VALUES ('12', 'Chemin de fer');
INSERT INTO cgrnum VALUES ('13', 'Sol');
-- nomenclature dsgrpf (suf)
INSERT INTO dsgrpf VALUES ('AB', 'Terrains à bâtir');
INSERT INTO dsgrpf VALUES ('AG', 'Terrains d’agrément');
INSERT INTO dsgrpf VALUES ('B', 'Bois');
INSERT INTO dsgrpf VALUES ('BF', 'Futaies Feuillues');
INSERT INTO dsgrpf VALUES ('BM', 'Futaies Mixtes');
INSERT INTO dsgrpf VALUES ('BO', 'Oseraies');
INSERT INTO dsgrpf VALUES ('BP', 'Peupleraies');
INSERT INTO dsgrpf VALUES ('BR', 'Futaies résineuses');
INSERT INTO dsgrpf VALUES ('BS', 'Taillis sous Futaies');
INSERT INTO dsgrpf VALUES ('BT', 'Taillis simples');
INSERT INTO dsgrpf VALUES ('CA', 'Carrières');
INSERT INTO dsgrpf VALUES ('CH', 'Chemins de fer, Canaux de Navigation');
INSERT INTO dsgrpf VALUES ('E', 'Eaux');
INSERT INTO dsgrpf VALUES ('J', 'Jardins');
INSERT INTO dsgrpf VALUES ('L', 'Landes');
INSERT INTO dsgrpf VALUES ('LB', 'Landes Boisées');
INSERT INTO dsgrpf VALUES ('P', 'Prés');
INSERT INTO dsgrpf VALUES ('PA', 'Pâtures ou Pâturages');
INSERT INTO dsgrpf VALUES ('PC', 'Pacages ou Pâtis');
INSERT INTO dsgrpf VALUES ('PE', 'Prés d''embouche');
INSERT INTO dsgrpf VALUES ('PH', 'Herbages');
INSERT INTO dsgrpf VALUES ('PP', 'Prés, Pâtures ou Herbages plantes');
INSERT INTO dsgrpf VALUES ('S', 'Sols');
INSERT INTO dsgrpf VALUES ('T', 'Terre');
INSERT INTO dsgrpf VALUES ('TP', 'Terres plantées');
INSERT INTO dsgrpf VALUES ('VE', 'Vergers');
INSERT INTO dsgrpf VALUES ('VI', 'Vignes');
-- nomenclature cnatsp (suf)
INSERT INTO cnatsp VALUES ('ABREU', 'Abreuvoirs');
INSERT INTO cnatsp VALUES ('ABRIC', 'Abricotiers');
INSERT INTO cnatsp VALUES ('ACACI', 'Acacias');
INSERT INTO cnatsp VALUES ('AEROD', 'Aérodromes');
INSERT INTO cnatsp VALUES ('AIRE', 'Aire ou Airial');
INSERT INTO cnatsp VALUES ('ALLEE', 'Allée (no groupe)');
INSERT INTO cnatsp VALUES ('ALLUV', 'Alluvions');
INSERT INTO cnatsp VALUES ('AMAND', 'Amandiers');
INSERT INTO cnatsp VALUES ('ARDOI', 'Ardoiseries');
INSERT INTO cnatsp VALUES ('ARGIL', 'Argilière');
INSERT INTO cnatsp VALUES ('ASPER', 'Aspergeraie');
INSERT INTO cnatsp VALUES ('AULNE', 'Aulnaie');
INSERT INTO cnatsp VALUES ('AVENU', 'Avenue');
INSERT INTO cnatsp VALUES ('BALLA', 'Ballastière');
INSERT INTO cnatsp VALUES ('BAMBO', 'Bambouseraie');
INSERT INTO cnatsp VALUES ('BASS', 'Bassins');
INSERT INTO cnatsp VALUES ('BIEF', 'Bief');
INSERT INTO cnatsp VALUES ('BOUL', 'Boulaie');
INSERT INTO cnatsp VALUES ('BROUS', 'Broussailles ou buissons');
INSERT INTO cnatsp VALUES ('BRUY', 'Bruyères');
INSERT INTO cnatsp VALUES ('BTIGE', 'Verger exploite en basses tiges');
INSERT INTO cnatsp VALUES ('BUIS', 'Buissière');
INSERT INTO cnatsp VALUES ('CAMP', 'Terrain de camping');
INSERT INTO cnatsp VALUES ('CANAL', 'Canal');
INSERT INTO cnatsp VALUES ('CASS', 'Cassis');
INSERT INTO cnatsp VALUES ('CEDRA', 'Cédratiers');
INSERT INTO cnatsp VALUES ('CERCL', 'Cerclières');
INSERT INTO cnatsp VALUES ('CERIS', 'Cerisaie ou cerisiers');
INSERT INTO cnatsp VALUES ('CHASS', 'Terrain de chasse');
INSERT INTO cnatsp VALUES ('CHAT', 'Châtaigneraie');
INSERT INTO cnatsp VALUES ('CHEM', 'Chemin de remembrement');
INSERT INTO cnatsp VALUES ('CHENE', 'Chênes');
INSERT INTO cnatsp VALUES ('CHLIE', 'Chênes-lièges');
INSERT INTO cnatsp VALUES ('CHTRU', 'Chênes truffiers');
INSERT INTO cnatsp VALUES ('CHVER', 'Chênes verts');
INSERT INTO cnatsp VALUES ('CIDRE', 'Cidre');
INSERT INTO cnatsp VALUES ('CITRO', 'Citronniers');
INSERT INTO cnatsp VALUES ('CLAIR', 'Claires');
INSERT INTO cnatsp VALUES ('COING', 'Cognassiers');
INSERT INTO cnatsp VALUES ('COULE', 'Bois de couleur');
INSERT INTO cnatsp VALUES ('CRAY', 'Crayère');
INSERT INTO cnatsp VALUES ('CRESS', 'Cressonnière');
INSERT INTO cnatsp VALUES ('CRYPT', 'Cryptomeria');
INSERT INTO cnatsp VALUES ('DIGUE', 'Digues');
INSERT INTO cnatsp VALUES ('DUNE', 'Dunes');
INSERT INTO cnatsp VALUES ('EAU', 'Pièce d''eau');
INSERT INTO cnatsp VALUES ('ECOLE', 'Ecole');
INSERT INTO cnatsp VALUES ('EPICE', 'Epicéas');
INSERT INTO cnatsp VALUES ('ESPAL', 'Verger exploite en espaliers');
INSERT INTO cnatsp VALUES ('ETANG', 'Etangs');
INSERT INTO cnatsp VALUES ('EUCAL', 'Eucalyptus');
INSERT INTO cnatsp VALUES ('FALAI', 'Falaises');
INSERT INTO cnatsp VALUES ('FAMIL', 'Verger familial');
INSERT INTO cnatsp VALUES ('FER', 'Chemin de fer');
INSERT INTO cnatsp VALUES ('FILAO', 'Filao');
INSERT INTO cnatsp VALUES ('FLOR', 'Jardin floral');
INSERT INTO cnatsp VALUES ('FONT', 'Fontaine');
INSERT INTO cnatsp VALUES ('FOSSE', 'Fosse');
INSERT INTO cnatsp VALUES ('FOUG', 'Fougeraie');
INSERT INTO cnatsp VALUES ('FRAMB', 'Framboisiers');
INSERT INTO cnatsp VALUES ('FRICH', 'Friche');
INSERT INTO cnatsp VALUES ('GAREN', 'Garenne');
INSERT INTO cnatsp VALUES ('GENET', 'Genets');
INSERT INTO cnatsp VALUES ('GLAIS', 'Glaisière');
INSERT INTO cnatsp VALUES ('GRAVE', 'Gravière');
INSERT INTO cnatsp VALUES ('HAIES', 'Haies fruitières');
INSERT INTO cnatsp VALUES ('HERB', 'Herbage');
INSERT INTO cnatsp VALUES ('HETRE', 'Hêtres');
INSERT INTO cnatsp VALUES ('HIST', 'Dépendances de monuments historiques');
INSERT INTO cnatsp VALUES ('HORT', 'Jardins horticoles');
INSERT INTO cnatsp VALUES ('HOUBL', 'Houblon');
INSERT INTO cnatsp VALUES ('HTIGE', 'Vergers exploités en hautes tiges');
INSERT INTO cnatsp VALUES ('HUITR', 'Parc à huîtres');
INSERT INTO cnatsp VALUES ('IMM', 'Dépendances d''ensemble immobilier');
INSERT INTO cnatsp VALUES ('IMPRO', 'Lande improductive');
INSERT INTO cnatsp VALUES ('INTEN', 'Verger industriel');
INSERT INTO cnatsp VALUES ('JARD', 'Jardin d’agrément');
INSERT INTO cnatsp VALUES ('JETT', 'Jettins');
INSERT INTO cnatsp VALUES ('JOUAL', 'Joualle');
INSERT INTO cnatsp VALUES ('KIWIS', 'Kiwis');
INSERT INTO cnatsp VALUES ('LAC', 'Lac');
INSERT INTO cnatsp VALUES ('LAGUN', 'Lagune');
INSERT INTO cnatsp VALUES ('LAVOI', 'Lavoir');
INSERT INTO cnatsp VALUES ('LEGUM', 'Légumière de plein champ');
INSERT INTO cnatsp VALUES ('MAQUI', 'Maquis');
INSERT INTO cnatsp VALUES ('MARAI', 'Pré marais');
INSERT INTO cnatsp VALUES ('MARAM', 'Jardin maraîcher aménagé');
INSERT INTO cnatsp VALUES ('MARE', 'Mare');
INSERT INTO cnatsp VALUES ('MAREC', 'Marécage');
INSERT INTO cnatsp VALUES ('MARN', 'Marnière');
INSERT INTO cnatsp VALUES ('MARNA', 'Jardin maraîcher non aménagé');
INSERT INTO cnatsp VALUES ('MELEZ', 'Mélèzes');
INSERT INTO cnatsp VALUES ('MOTTE', 'Mottes');
INSERT INTO cnatsp VALUES ('MUR', 'Mûraies ou mûriers (vergers)');
INSERT INTO cnatsp VALUES ('NATUR', 'Bois naturel');
INSERT INTO cnatsp VALUES ('NOISE', 'Noiseraie ou noisetiers');
INSERT INTO cnatsp VALUES ('NOYER', 'Noyeraie ou noyers');
INSERT INTO cnatsp VALUES ('NPECH', 'Etang non potable');
INSERT INTO cnatsp VALUES ('OLIVE', 'Olivaies ou oliviers');
INSERT INTO cnatsp VALUES ('ORANG', 'Orangers (vergers)');
INSERT INTO cnatsp VALUES ('ORME', 'Ormaie ou ormes');
INSERT INTO cnatsp VALUES ('PACAG', 'Pacage');
INSERT INTO cnatsp VALUES ('PAFEU', 'Pare-feux');
INSERT INTO cnatsp VALUES ('PALMI', 'Bois palmiste');
INSERT INTO cnatsp VALUES ('PARC', 'Parc');
INSERT INTO cnatsp VALUES ('PASS', 'Passage (non groupe)');
INSERT INTO cnatsp VALUES ('PATIS', 'Pâtis');
INSERT INTO cnatsp VALUES ('PATUR', 'Pâture plantée');
INSERT INTO cnatsp VALUES ('PECH', 'Etangs pêchables');
INSERT INTO cnatsp VALUES ('PECHE', 'Pêchers');
INSERT INTO cnatsp VALUES ('PEPIN', 'Pépinières');
INSERT INTO cnatsp VALUES ('PIEDS', 'Pieds-mères (vignes)');
INSERT INTO cnatsp VALUES ('PIERR', 'Pierraille, pierrier');
INSERT INTO cnatsp VALUES ('PIN', 'Pins');
INSERT INTO cnatsp VALUES ('PLAGE', 'Plage');
INSERT INTO cnatsp VALUES ('PLATR', 'Plâtrière');
INSERT INTO cnatsp VALUES ('PLVEN', 'Vergers de plein vent');
INSERT INTO cnatsp VALUES ('POIRE', 'Poiriers');
INSERT INTO cnatsp VALUES ('POMME', 'Pommiers');
INSERT INTO cnatsp VALUES ('POTAG', 'Potagers');
INSERT INTO cnatsp VALUES ('PROTE', 'Bois de protection');
INSERT INTO cnatsp VALUES ('PRUNE', 'Pruniers');
INSERT INTO cnatsp VALUES ('RAIS', 'Raisins de table');
INSERT INTO cnatsp VALUES ('RESER', 'Réservoir');
INSERT INTO cnatsp VALUES ('RESIN', 'Résineux');
INSERT INTO cnatsp VALUES ('RIVAG', 'Rivage (bois de)');
INSERT INTO cnatsp VALUES ('RIZ', 'Rizière');
INSERT INTO cnatsp VALUES ('ROC', 'Rocs ou rochers');
INSERT INTO cnatsp VALUES ('ROUI', 'Routoir ou roussoir');
INSERT INTO cnatsp VALUES ('RUE', 'Rue');
INSERT INTO cnatsp VALUES ('RUINE', 'Ruines');
INSERT INTO cnatsp VALUES ('SABLE', 'Sablière');
INSERT INTO cnatsp VALUES ('SALIN', 'Marais salant');
INSERT INTO cnatsp VALUES ('SAPIN', 'Sapins ou sapinière');
INSERT INTO cnatsp VALUES ('SART', 'Sartières');
INSERT INTO cnatsp VALUES ('SAULE', 'Saulaie ou saussaie');
INSERT INTO cnatsp VALUES ('SERRE', 'Serre');
INSERT INTO cnatsp VALUES ('SOL', 'Sols');
INSERT INTO cnatsp VALUES ('SOURC', 'Source');
INSERT INTO cnatsp VALUES ('SPORT', 'Terrain de sport');
INSERT INTO cnatsp VALUES ('TAMAR', 'Tamarin');
INSERT INTO cnatsp VALUES ('TAUZ', 'Taillis tauzin');
INSERT INTO cnatsp VALUES ('TERRI', 'Terrils');
INSERT INTO cnatsp VALUES ('TOURB', 'Tourbière');
INSERT INTO cnatsp VALUES ('TOUYA', 'Touyas');
INSERT INTO cnatsp VALUES ('VADC', 'Vins d''appellation d''origine contrôlée');
INSERT INTO cnatsp VALUES ('VAGUE', 'Terrain vague');
INSERT INTO cnatsp VALUES ('VANIL', 'Vanille');
INSERT INTO cnatsp VALUES ('VAOC', 'Vins d''appellation d''origine contrôlée');
INSERT INTO cnatsp VALUES ('VCHAS', 'Chasselas');
INSERT INTO cnatsp VALUES ('VDQS', 'Vins délimités de qualité supérieure');
INSERT INTO cnatsp VALUES ('VIGNE', 'Vigne');
INSERT INTO cnatsp VALUES ('VIVIE', 'Vivier');

-- nomenclature ccolloc (sufexoneration, pevexoneration)
-- valeurs conformes à la documentation DGFiP 2019 NBAT 2.2.5 (p.14)
INSERT INTO ccolloc VALUES ('C', 'Commune');
INSERT INTO ccolloc VALUES ('GC', 'Groupement de communes');
INSERT INTO ccolloc VALUES ('TS', 'TSE (taxe spéciale d’équipement)');
INSERT INTO ccolloc VALUES ('A', 'Taxe additionnelle');
-- valeurs obsolètes mais existant toujours en base pour des questions de compatibilité
INSERT INTO ccolloc VALUES ('TC', 'Toutes collectivités');
INSERT INTO ccolloc VALUES ('D', 'Département');
INSERT INTO ccolloc VALUES ('R', 'Région');
INSERT INTO ccolloc VALUES ('OM', 'Taxe sur l’enlèvement des ordures ménagères (TEOM)');

-- nomenclature gnexts (sufexoneration)
-- valeurs conformes à la documentation DGFiP 2020 (2.2.6 p. 14)
INSERT INTO gnexts VALUES ('CB', 'Exonération pour les parcelles exploitées selon le mode de production biologique');
INSERT INTO gnexts VALUES ('DA', 'Exonération des terres agricoles (groupes de cultures 1 à 6, 8 et 9) dans les DOM');
INSERT INTO gnexts VALUES ('ER', 'Terrains boisés présentant un état de futaie irrégulière en équilibre de régénération – Exonération partielle (25 %) de 15 ans, renouvelable');
INSERT INTO gnexts VALUES ('HQ', 'Exonération de 50 % pendant 5 ans pour les subdivisions fiscales dont la nature de culture est soit pré, soit landes');
INSERT INTO gnexts VALUES ('HS', 'Exonération de 100 % pendant 5 ans pour les subdivisions fiscales dont la nature de culture est soit pré, soit landes');
INSERT INTO gnexts VALUES ('NA', 'Exonération Natura 2000');
INSERT INTO gnexts VALUES ('NO', 'Exonération pour plantation de noyer (sur délibération)');
INSERT INTO gnexts VALUES ('OL', 'Exonération pour terrains plantés en olivier (sur délibération)');
INSERT INTO gnexts VALUES ('PB', 'Exonération pour plantation de bois (groupe 5)');
INSERT INTO gnexts VALUES ('PF', 'Feuillus – Plantation et semis, futaies, taillis sous futaie en régénération naturelle – Exonération temporaire de 50 ans');
INSERT INTO gnexts VALUES ('PN', 'Exonération pour terrains dans parc national naturel (DOM)');
INSERT INTO gnexts VALUES ('PP', 'Peupliers – Plantation et semis – Exonération temporaire de 10 ans');
INSERT INTO gnexts VALUES ('PR', 'Résineux – Plantation et semis, futaies, taillis sous futaie en régénération naturelle – Exonération temporaire de 30 ans');
INSERT INTO gnexts VALUES ('TA', 'Exonération des terres agricoles (groupes de cultures 1 à 6, 8 et 9)');
INSERT INTO gnexts VALUES ('TU', 'Exonération pour terrains nouvellement plantés en arbres truffiers – art. 1395 B-II du CGI');
INSERT INTO gnexts VALUES ('VG', 'Vergers, cultures fruitières d’arbres et d’arbustes, vignes');
-- valeurs obsolètes mais existant toujours en base pour des questions de compatibilité
INSERT INTO gnexts VALUES ('TR', 'Exonération pour plantation de truffiers (sur délibération)');
INSERT INTO gnexts VALUES ('HP', 'Exonération temporaire (exonération totale en zone naturelle)');
INSERT INTO gnexts VALUES ('HR', 'Exonération temporaire (exonération de 50% sur proposition de la CCID)');


-- nomenclature ccoeva (local10)
INSERT INTO ccoeva VALUES ('A', 'Méthode comptable');
INSERT INTO ccoeva VALUES ('B', 'Evaluation d’après le bail');
INSERT INTO ccoeva VALUES ('C', 'Evaluation par comparaison');
INSERT INTO ccoeva VALUES ('D', 'Evaluation par voie d’appréciation directe');
INSERT INTO ccoeva VALUES ('E', 'Evaluation spécifique aux transformateurs électriques et appareils à gaz');
INSERT INTO ccoeva VALUES ('T', 'Evaluation par barème (locaux commerciaux et assimilés)');


-- nomenclature dteloc (local10)
INSERT INTO dteloc VALUES ('1', 'Maison');
INSERT INTO dteloc VALUES ('2', 'Appartement');
INSERT INTO dteloc VALUES ('3', 'Dépendances');
INSERT INTO dteloc VALUES ('4', 'Local commercial ou industriel');
INSERT INTO dteloc VALUES ('5', 'DOM = maison dans descriptif');
INSERT INTO dteloc VALUES ('6', 'DOM = appartement sans descriptif');
INSERT INTO dteloc VALUES ('7', 'DOM = dépendance sans descriptif');
INSERT INTO dteloc VALUES ('8', 'Locaux de groupe 4 : évaluation tarifaire (non présente depuis 94)');
-- nomenclature ccoplc (local10)
INSERT INTO ccoplc VALUES (' ', 'Construction particulière');
INSERT INTO ccoplc VALUES ('R', 'Construction classée sur sol d''autrui lors de l''initialisation Majic2 (local, hors pdl, avec attribution différente de la parcelle d''assise)');
INSERT INTO ccoplc VALUES ('S', 'Construction sur plusieurs parcelles mais non soumise au régime de copropriété ou de transparence fiscale');
INSERT INTO ccoplc VALUES ('U', 'Chute d''eau, barrage');
INSERT INTO ccoplc VALUES ('V', 'Construction édifiée sur le domaine public');
INSERT INTO ccoplc VALUES ('W', 'Construction édifiée sous le domaine public');
INSERT INTO ccoplc VALUES ('X', 'Voies ferrées établies sur le terrain d''autrui ou sur le domaine public et dont l''assise ne forme pas parcelle');
INSERT INTO ccoplc VALUES ('Y', 'Construction édifiée sous le domaine cadastre');
INSERT INTO ccoplc VALUES ('Z', 'Construction édifiée sur sol d''autrui');
-- nomenclature cconlc (local10)
INSERT INTO cconlc VALUES ('AP', 'Appartement');
INSERT INTO cconlc VALUES ('AT', 'Antenne téléphone');
INSERT INTO cconlc VALUES ('AU', 'Autoroute');
INSERT INTO cconlc VALUES ('CA', 'Commerce sans boutique');
INSERT INTO cconlc VALUES ('CB', 'Local divers');
INSERT INTO cconlc VALUES ('CD', 'Dépendance commerciale');
INSERT INTO cconlc VALUES ('CH', 'Chantier');
INSERT INTO cconlc VALUES ('CM', 'Commerce avec boutique');
INSERT INTO cconlc VALUES ('DA', 'Dépendance d''appartement');
INSERT INTO cconlc VALUES ('DC', 'Dépendance lieux communs');
INSERT INTO cconlc VALUES ('DE', 'Dépendance bâtie isolée');
INSERT INTO cconlc VALUES ('DM', 'Dépendance de maison');
INSERT INTO cconlc VALUES ('LC', 'Local commun');
INSERT INTO cconlc VALUES ('MA', 'Maison');
INSERT INTO cconlc VALUES ('ME', 'Maison exceptionnelle');
INSERT INTO cconlc VALUES ('MP', 'Maison partagée par une limite territoriale');
INSERT INTO cconlc VALUES ('PP', 'Port de plaisance');
INSERT INTO cconlc VALUES ('SM', 'Sol de maison');
INSERT INTO cconlc VALUES ('U', 'Etablissement industriel');
INSERT INTO cconlc VALUES ('U1', 'Gare');
INSERT INTO cconlc VALUES ('U2', 'Gare : Triage');
INSERT INTO cconlc VALUES ('U3', 'Gare : Atelier matériel');
INSERT INTO cconlc VALUES ('U4', 'Gare : Atelier magasin');
INSERT INTO cconlc VALUES ('U5', 'Gare : Dépôt - Titulaire');
INSERT INTO cconlc VALUES ('U6', 'Gare : Dépôt - Réel');
INSERT INTO cconlc VALUES ('U7', 'Gare : Matériel transport');
INSERT INTO cconlc VALUES ('U8', 'Gare : Entretien matériel roulant');
INSERT INTO cconlc VALUES ('U9', 'Gare : Station usine');
INSERT INTO cconlc VALUES ('UE', 'Transformateur électrique');
INSERT INTO cconlc VALUES ('UG', 'Appareil à gaz');
INSERT INTO cconlc VALUES ('UN', 'Usine nucléaire');
INSERT INTO cconlc VALUES ('US', 'Etablissement industriel');
-- nomenclature top48a (local10)
INSERT INTO top48a VALUES ('1', 'pev imposé au loyer');
INSERT INTO top48a VALUES ('0', 'pev imposé à la vl');
-- nomenclature dnatlc (local10)
INSERT INTO dnatlc VALUES ('A', 'Local occupé par un apprenti ou un salarié agricole');
INSERT INTO dnatlc VALUES ('D', 'DOM = habitation principale occupée par le propriétaire');
INSERT INTO dnatlc VALUES ('L', 'Location autre que propriétaire ou usufruitier');
INSERT INTO dnatlc VALUES ('P', 'Occupé par le propriétaire ou l’usufruitier');
INSERT INTO dnatlc VALUES ('T', 'Location, non affectée à l''habitation, soumise à TVA');
INSERT INTO dnatlc VALUES ('V', 'Vacant');
-- nomenclature dnatcg
INSERT INTO dnatcg VALUES ('AC', 'Addition de construction');
INSERT INTO dnatcg VALUES ('CA', 'Changement d’affectation');
INSERT INTO dnatcg VALUES ('CC', 'Changement de consistance');
INSERT INTO dnatcg VALUES ('CI', 'Changement de l''identification du local');
INSERT INTO dnatcg VALUES ('CN', 'Construction nouvelle');
INSERT INTO dnatcg VALUES ('CU', 'Changement d’utilisation');
INSERT INTO dnatcg VALUES ('CX', 'Modification suite à contentieux');
INSERT INTO dnatcg VALUES ('DL', 'Division de locaux');
INSERT INTO dnatcg VALUES ('DP', 'Démolition partielle');
INSERT INTO dnatcg VALUES ('DT', 'Démolition totale');
INSERT INTO dnatcg VALUES ('ME', 'Modification des critères d’évaluation');
INSERT INTO dnatcg VALUES ('RL', 'Réunion de locaux');
-- nomenclature gimtom
INSERT INTO gimtom VALUES ('', 'Imposable TEOM');
INSERT INTO gimtom VALUES ('E', 'Exonération de TEOM de droit pour les locaux: en exonération NI, EP, CR, DR autre que les locaux d’habitation; de code nature U, US, UE, UG, U1 à U9, AU ; loués par des personnes publiques et affectées à un service public');
INSERT INTO gimtom VALUES ('D', 'Exonération TEOM sur délibération de la collectivité gestionnaire de TEOM (locaux à usage industriel ou commercial, locaux dotés d’un incinérateur)');
INSERT INTO gimtom VALUES ('V', 'Local d’habitation en exonération permanente EP/CR/DR sans fonctionnaire logé (vacants)');
-- nomenclature hlmsem (local10)
INSERT INTO hlmsem VALUES ('5', 'hlm');
INSERT INTO hlmsem VALUES ('6', 'sem');
-- nomenclature ccoaff (pev)
INSERT INTO ccoaff VALUES ('A', 'Locaux commerciaux et biens divers passibles de la TH)');
INSERT INTO ccoaff VALUES ('B', 'Bâtiment industriel (lie a ccoeva = A ou E)');
INSERT INTO ccoaff VALUES ('C', 'Commerce');
INSERT INTO ccoaff VALUES ('E', 'Locaux commerciaux et biens divers non passibles de la TH ni de la TP');
INSERT INTO ccoaff VALUES ('H', 'Habitation');
INSERT INTO ccoaff VALUES ('K', 'Locaux administratifs non passibles de la TH');
INSERT INTO ccoaff VALUES ('L', 'Hôtel');
INSERT INTO ccoaff VALUES ('P', 'Professionnel');
INSERT INTO ccoaff VALUES ('S', 'Biens divers passibles de la TH');
INSERT INTO ccoaff VALUES ('T', 'Terrain industriel (lie à ccoeva = A ou E)');
-- nomenclature gnexpl (pev)
INSERT INTO gnexpl VALUES ('CD', 'Exonération permanente des parts communale et départementale (biens d''une région situés dans une autre région)');
INSERT INTO gnexpl VALUES ('CR', 'Exonération permanente des parts communale et régionale (biens d''un département situés dans un autre département)');
INSERT INTO gnexpl VALUES ('DR', 'Exonération permanente des parts départementale et régionale (biens d''une commune situés dans une autre commune)');
INSERT INTO gnexpl VALUES ('EP', 'Exonération permanente');
INSERT INTO gnexpl VALUES ('NI', 'Non imposable');
INSERT INTO gnexpl VALUES ('PP', 'Exonération de pev secondaire de bien indivis');
INSERT INTO gnexpl VALUES ('GM', 'transfert de propriétés bâties par l’État aux grands ports maritimes affectés à un service public ou d’utilité générale et non productifs de revenus');
-- valeurs obsolètes mais existant toujours en base pour des questions de compatibilité
-- 2021
INSERT INTO gnexpl VALUES ('CM', 'exonération des parts communale, TSE et TEOM pour un immeuble appartenant à une commune et situé sur le territoire d’une autre commune appartenant à la métropole de Lyon');
INSERT INTO gnexpl VALUES ('DM', 'exonération des parts intercommunale, départementale, TSE et TEOM pour un immeuble appartenant à une commune et situé sur le territoire d’une autre commune appartenant à la métropole de Lyon');

-- nomenclature pour ccthp (Occupation du local)
INSERT INTO ccthp VALUES ('B', 'Locaux meublés à usage d’habitation faisant l’objet de locations occasionnelles permanentes ou saisonnières (TH)');
INSERT INTO ccthp VALUES ('D', 'Division fiscale (CFE) ou local démoli (TH)');
INSERT INTO ccthp VALUES ('F', 'Fonctionnaire logé (TH)');
INSERT INTO ccthp VALUES ('G', 'Occupation à titre gratuit (TH)');
INSERT INTO ccthp VALUES ('L', 'Occupation par un locataire (TH)');
INSERT INTO ccthp VALUES ('N', 'Local dépendance non imposable (TH)');
INSERT INTO ccthp VALUES ('P', 'Occupation par le propriétaire (TH)');
INSERT INTO ccthp VALUES ('R', 'Occupation par un artisan exonéré (CFE)');
INSERT INTO ccthp VALUES ('T', 'Local imposé à la taxe professionnelle (TH)');
INSERT INTO ccthp VALUES ('U', 'Utilisation commune (CFE)');
INSERT INTO ccthp VALUES ('V', 'Local vacant');
INSERT INTO ccthp VALUES ('X', 'Occupation par bail rural (TH)');
INSERT INTO ccthp VALUES ('', 'Non défini');

-- nomenclature pour cbtabt (Code exonération HLM Zone sensible)
INSERT INTO cbtabt VALUES ('AS', 'Antisismique dans les DOM');
INSERT INTO cbtabt VALUES ('CV', 'Logements sociaux situés dans un quartier prioritaire – Contrat de ville');

-- nomenclature gnextl (pevexoneration)
-- valeurs conformes à la documentation DGFiP 2020 (BATI 2.2.14 p.18)
INSERT INTO gnextl VALUES ('AD', 'Droit commun (2 ans) - addition de construction');
INSERT INTO gnextl VALUES ('AE', 'Exonération de 20 ans en faveur des logements sociaux qui respectent un certain nombre de normes environnementales pour additions de constructions');
INSERT INTO gnextl VALUES ('AF', '2 ans pour addition de construction avec prêtconventionne, PAP ou PLA');
INSERT INTO gnextl VALUES ('AG', 'Exonération à durée variable pour contrat de partenariat avec une personne publique (addition de construction) – article 1382 1° bis');
INSERT INTO gnextl VALUES ('AK', 'Exonération de 20 ans pour les logements intermédiaires loués dans lesconditions de l’article 279-0 bis A (addition de construction) – art. 1384-0 A du CGI');
INSERT INTO gnextl VALUES ('AL', 'Exo de 15 ans pour logements sociaux (AC)');
INSERT INTO gnextl VALUES ('AM', 'Addition de construction – Ville de Paris – art. 1383 du CGI');
INSERT INTO gnextl VALUES ('AP', 'Exonération annuelle pour installation antipollution');
INSERT INTO gnextl VALUES ('AQ', 'Addition de construction exonération de 2 ans droits acquis');
INSERT INTO gnextl VALUES ('AS', 'Abattement de 30% pour les locaux sociaux situés dans les DOM et équipés contre les risques naturels');
INSERT INTO gnextl VALUES ('AT', 'Exonération de 30 ans pour les logements sociaux respectant certains critères de qualité environnementale (addition de construction).');
INSERT INTO gnextl VALUES ('AU', 'Exonération de 25 ans pour les logements financés au moyen de prêts aidés par l''Etat (addition de construction)');
INSERT INTO gnextl VALUES ('AV', 'Exonération de 25 ans pour les logements financés au moyen de prêts aidés par l''Etat (addition de construction)');
INSERT INTO gnextl VALUES ('AW', 'Exonération de 25 ans pour les logements financés au moyen de prêts aidés par l''Etat (addition de construction)');
INSERT INTO gnextl VALUES ('AY', 'Exo de 15 ans pour logements sociaux (AC)');
INSERT INTO gnextl VALUES ('AZ', 'Exonération de 30 ans pour les logements sociaux respectant certains critères de qualité environnementale (addition de construction).');
INSERT INTO gnextl VALUES ('BD', 'Entreprises situées dans un bassin à redynamiser ou dans une zone de
développement prioritaire, sur délibération.');
INSERT INTO gnextl VALUES ('BE', 'Local situé dans un bassin d''emploi à redynamiser. Article 1383 H du CGI.');
INSERT INTO gnextl VALUES ('BH', 'Locaux à usage de bureau transformés en habitation principale');
INSERT INTO gnextl VALUES ('BS', 'Abattement de 30 % à 100% pour les logements faisant l’objet d’un bail réel solidaire');
INSERT INTO gnextl VALUES ('BU', 'Entreprises situées dans un bassin à redynamiser ou dans une zone de développement prioritaire, de droit.');
INSERT INTO gnextl VALUES ('CE', 'Abattement de 5 ans pour cession relevant de l’article 1388 sexies du CGI (Mayotte)');
INSERT INTO gnextl VALUES ('CV', 'Entreprises situées dans les zones ZRVC (zone de revitalisation des centresvilles)');
INSERT INTO gnextl VALUES ('D', 'Personne âgée et non imposable à l’impôt sur le revenu'); 
INSERT INTO gnextl VALUES ('DF', 'Exonération pour bâtiment déshydratation des fourrages.');
INSERT INTO gnextl VALUES ('DO', 'Exonération spécifique des DOM prévue à l’article 330 de l’annexe II au CGI');
INSERT INTO gnextl VALUES ('EA', 'Economiquement faible - type A');
INSERT INTO gnextl VALUES ('EC', 'Economiquement faible - type C');
INSERT INTO gnextl VALUES ('EE', 'Exonération économiquement faible (ECF) de type E');
INSERT INTO gnextl VALUES ('EF', 'Exonération économiquement faible (ECF) de type F');
INSERT INTO gnextl VALUES ('EI', 'Exonération pour les jeunes entreprises innovantes');
INSERT INTO gnextl VALUES ('EN', 'Exonération entreprise nouvelle.');
INSERT INTO gnextl VALUES ('ES', 'Exonération de 90 à 100% des ouvrages d''un centre de stockage réversible en couche géologique profonde de déchets radioactifs (art 1382 G du CGI');
INSERT INTO gnextl VALUES ('EW', 'Exonération ECF de droits acquis');
INSERT INTO gnextl VALUES ('E1', 'Exonération ECF de droit commun – 100 % – 1ère année');
INSERT INTO gnextl VALUES ('E2', 'Exonération ECF de droit commun – 100 % – 2 e année');
INSERT INTO gnextl VALUES ('E3', 'Exonération ECF de droit commun – 67 % – 3 e année');
INSERT INTO gnextl VALUES ('E4', 'Exonération ECF de droit commun – 33 % – 4 e année');
INSERT INTO gnextl VALUES ('G', 'Exonération économiquement faible (ECF) – type G');
INSERT INTO gnextl VALUES ('GP', 'Grand port maritime');
INSERT INTO gnextl VALUES ('GS', 'Exo pour groupement de coopération sanitaire');
INSERT INTO gnextl VALUES ('G1', 'Transfert de propriétés bâties par l’État aux grands ports maritimes non affectés à un service public ou d’utilité générale ou productifs de revenu – 1ère année – 100 %');
INSERT INTO gnextl VALUES ('G2', 'Transfert de propriétés bâties par l’État aux grands ports maritimes non affectés à un service public ou d’utilité générale ou productifs de revenu – 2e année – 100 %');
INSERT INTO gnextl VALUES ('G3', 'Transfert de propriétés bâties par l’État aux grands ports maritimes non affectés à un service public ou d’utilité générale ou productifs de revenu – 3e année – 75 %');
INSERT INTO gnextl VALUES ('G4', 'Transfert de propriétés bâties par l’État aux grands ports maritimes non affectés à un service public ou d’utilité générale ou productifs de revenu – 4e année – 50 %');
INSERT INTO gnextl VALUES ('G5', 'Transfert de propriétés bâties par l’État aux grands ports maritimes non affectés à un service public ou d’utilité générale ou productifs de revenu – 5e année – 25 %');
INSERT INTO gnextl VALUES ('HU', 'Exo de 15 ans pour logements sociaux acquis ou aménagés');
INSERT INTO gnextl VALUES ('HY', 'Exo de 25 ans pour logements sociaux acquis ou aménagés');
INSERT INTO gnextl VALUES ('LA', 'Durée variable - totale ou partielle - PLA');
INSERT INTO gnextl VALUES ('LE', 'Exonération de 15 ans pour les logements acquis avec l’aide de l’aide de l’État en vue de leur location');
INSERT INTO gnextl VALUES ('LG', 'Exonération établissements publics supérieurs sous contrat avec des sociétés dont le capital est entièrement public');
INSERT INTO gnextl VALUES ('LI', 'Exonération de 15 ans pour les logements sociaux acquis d’un organisme mentionné à l’article L 411.5 du Code de la construction et de l’habitation');
INSERT INTO gnextl VALUES ('LM', 'Local situé dans une zone de revitalisation rurale. Article 1383 E bis du CGI.');
INSERT INTO gnextl VALUES ('LR', 'Durée variable - totale ou partielle habilitation');
INSERT INTO gnextl VALUES ('LW', 'Exonération de 25 ans pour les logements acquis avec l''aide de l''Etat en vue de leur location.');
INSERT INTO gnextl VALUES ('LY', 'Prorogation de 10 ans de l’exonération « LE » prévue à l’art. 1384 C du CGI');
INSERT INTO gnextl VALUES ('MA', 'Minoration de 60 % de la valeur locative des locaux d’habitation situés à Mayotte');
INSERT INTO gnextl VALUES ('MB', 'Boutiques et magasins situés hors d’un ensemble commercial dont la surface est inférieure à 400 m² – art. 1388 quinquies C du CGI');
INSERT INTO gnextl VALUES ('MS', 'Maison de santé');
INSERT INTO gnextl VALUES ('MU', 'Abattement de 50 % sur les modèles U (restitué pour info)');
INSERT INTO gnextl VALUES ('ND', 'Droit commun (2 ans) - construction nouvelle');
INSERT INTO gnextl VALUES ('NI', 'Non imposable');
INSERT INTO gnextl VALUES ('NE', 'Exonération de 20 ans en faveur des logements sociaux qui respectent un certain nombre de normes environnementales pour constructions nouvelles');
INSERT INTO gnextl VALUES ('NF', '2 ans pour construction nouvelle avec prêt conventionne, PAP ou PLA');
INSERT INTO gnextl VALUES ('NG', 'Exonération à durée variable pour contrat de partenariat avec une personne publique (construction nouvelle) – article 1382 1° bis');
INSERT INTO gnextl VALUES ('NK', 'Exonération de 20 ans pour les logements intermédiaires loués dans les conditions de l’article 279-0 bis A (construction nouvelle) – art. 1384-0 A du CGI');
INSERT INTO gnextl VALUES ('NL', 'Exonération de 15 ans pour logements sociaux (CN)');
INSERT INTO gnextl VALUES ('NM', 'Construction nouvelle – Ville de Paris – art. 1383 du CGI');
INSERT INTO gnextl VALUES ('NQ', 'Construction nouvelle exonération de 2 ans droits acquis');
INSERT INTO gnextl VALUES ('NT', 'Exonération de 30 ans pour les logements sociaux respectant certains critères de qualité environnementale (construction nouvelle).');
INSERT INTO gnextl VALUES ('NU', 'Exonération de 25 ans pour les logements financés au moyen de prêts aidés par l''Etat (construction nouvelle)');
INSERT INTO gnextl VALUES ('NV', 'Exonération de 25 ans pour les logements financés au moyen de prêts aidés par l''Etat (construction nouvelle)');
INSERT INTO gnextl VALUES ('NW', 'Exonération de 25 ans pour les logements financés au moyen de prêts aidés par l''Etat (construction nouvelle)');
INSERT INTO gnextl VALUES ('NY', 'Exonération de 25 ans pour logements sociaux (CN)');
INSERT INTO gnextl VALUES ('NZ', 'Exonération de 30 ans pour les logements sociaux respectant certains critères de qualité environnementale (construction nouvelle).');
INSERT INTO gnextl VALUES ('P1', 'Abattement 1ère année sur outillages, équipements et installations spécifiques de manutention portuaires (100 %).');
INSERT INTO gnextl VALUES ('P2', 'Abattement 2ème année sur outillages, équipements et installations spécifiques de manutention portuaires (100 %)');
INSERT INTO gnextl VALUES ('P3', 'Abattement 3ème, 4ème et 5ème années sur outillages, équipements et installations spécifiques de manutention');
INSERT INTO gnextl VALUES ('PC', 'Exonération de 5 ans pour locaux situés dans un pôle de compétitivité art. 1383 F du CGI');
INSERT INTO gnextl VALUES ('PE', 'Prolongation a durée variable d’exonération de droit commun');
INSERT INTO gnextl VALUES ('PI', 'Locaux situés sur des terrains pollués dans le périmètre d’un projet d’intérêt général');
INSERT INTO gnextl VALUES ('QP', 'Quartier prioritaire');
INSERT INTO gnextl VALUES ('QV', 'Locaux HLM se situant dans un quartier prioritaire');
INSERT INTO gnextl VALUES ('RC', 'Exonération pour bail à réhabilitation pris à compter du 01/01/2005 art. 1384 B, 1586 B et 1599 ter E du CGI');
INSERT INTO gnextl VALUES ('RD', 'Exonération d’au plus 5 ans pour les immeubles situés dans les zones de restructuration de la défense');
INSERT INTO gnextl VALUES ('RF', 'Requalification de copropriétés dégradées d’intérêt national acquises par un établissement public foncier');
INSERT INTO gnextl VALUES ('RI', 'Recherche industrielle');
INSERT INTO gnextl VALUES ('RM', 'Exonération pour les locaux achevés avant la mise en place d’un plan de prévention des risques miniers. Article 1383 G ter du CGI');
INSERT INTO gnextl VALUES ('RQ', 'Local achevé avant la mise en place d''un plan de prévention des risques technologiques. Article 1383 G du CGI.');
INSERT INTO gnextl VALUES ('RR', 'Commerces en milieu rural');
INSERT INTO gnextl VALUES ('RT', 'Abattement de 25 % pour les locaux faisant l’objet d’une convention ou d''un contrat de résidence temporaire – art. 1388 quinquies A du CGI');
INSERT INTO gnextl VALUES ('RW', 'Exonération de 50 à 100% pour les locaux ayant fait l''objet de dépenses destinées à économiser l''énergie. Article 1383-O B et 1383-O B du CGI.');
INSERT INTO gnextl VALUES ('R1', 'exonération de 25 ans pour travaux de rénovation lourde');
INSERT INTO gnextl VALUES ('R2', 'exonération de 15 ans pour travaux de rénovation lourde');
INSERT INTO gnextl VALUES ('UM', 'Exonération de 5 ans pour les usines de méthanisation - art. 1387 A du CGI');
INSERT INTO gnextl VALUES ('ZD', 'Abattement zone franche DOM');
INSERT INTO gnextl VALUES ('ZL', 'Transformation local commercial en habitation');
INSERT INTO gnextl VALUES ('ZQ', 'Abattement de 30 % pour les locaux d’habitation situés dans les immeubles collectifs issus de la transformation de locaux industriels ou commerciaux dans le périmètre des quartiers prioritaires de la politique de la ville');
INSERT INTO gnextl VALUES ('ZR', 'Exonération de 15 ans pour locaux situés dans une zone de revitalisation rurale art. 1383 E du CGI');
INSERT INTO gnextl VALUES ('ZT', 'Logement topé ZUS');
INSERT INTO gnextl VALUES ('Z1', 'Exonération de 5 ans de 100 % pour les locaux professionnels en zone France ruralités revitalisation – 1ʳᵉ année');
INSERT INTO gnextl VALUES ('Z2', 'Exonération de 5 ans de 100 % pour les locaux professionnels en zone France ruralités revitalisation – 2ᵉ année');
INSERT INTO gnextl VALUES ('Z3', 'Exonération de 5 ans de 100 % pour les locaux professionnels en zone France ruralités revitalisation – 3ᵉ année');
INSERT INTO gnextl VALUES ('Z4', 'Exonération de 5 ans de 100 % pour les locaux professionnels en zone France ruralités revitalisation – 4ᵉ année');
INSERT INTO gnextl VALUES ('Z5', 'Exonération de 5 ans de 100 % pour les locaux professionnels en zone France ruralités revitalisation – 5ᵉ année');
INSERT INTO gnextl VALUES ('Z6', 'Abattement de 75 % pour les locaux professionnels en zone France ruralités revitalisation – 6ᵉ année');
INSERT INTO gnextl VALUES ('Z7', 'Abattement de 50 % pour les locaux professionnels en zone France ruralités revitalisation – 7ᵉ année');
INSERT INTO gnextl VALUES ('Z8', 'Abattement de 25 % pour les locaux professionnels en zone France ruralités revitalisation – 8ᵉ année');
-- valeurs obsolètes mais existant toujours en base pour des questions de compatibilité
INSERT INTO gnextl VALUES ('AX', 'Longue durée (10 ans) - addition de construction');
INSERT INTO gnextl VALUES ('CD', 'Exonération permanente des parts communale et départementale (biens d''une région situés dans une autre région)');
INSERT INTO gnextl VALUES ('CR', 'Exonération permanente des parts communale et régionale (biens d''un département situés dans un autre département)');
INSERT INTO gnextl VALUES ('DR', 'Exonération permanente des parts départementale et régionale (biens d''une commune situés dans une autre commune)');
INSERT INTO gnextl VALUES ('EB', 'Economiquement faible - type B');
INSERT INTO gnextl VALUES ('EP', 'Exonération permanente');
INSERT INTO gnextl VALUES ('NX', 'Longue durée (10 ans) - construction nouvelle');
INSERT INTO gnextl VALUES ('PP', 'Exonération de pev secondaire de bien indivis');
INSERT INTO gnextl VALUES ('PX', 'Prolongation exonérations NX et AX (5 ans maxi)');
INSERT INTO gnextl VALUES ('RA', 'Exonération de certains établissements industriels durée indéterminée.');
INSERT INTO gnextl VALUES ('ZF', 'Exonération zone franche');
INSERT INTO gnextl VALUES ('ZS', 'Abattement ZUS 30 % HLM SEM (obsolète à partir du format 2012)');
INSERT INTO gnextl VALUES ('ZU', 'Exonération pour nouvelles zones franches');
INSERT INTO gnextl VALUES ('ZV', 'Exonération de 5 ans pour zone franche urbaine de 3éme génération art. 1384 C bis du CGI');


-- nomenclature cconad (pevprincipale, pevdependances)
INSERT INTO cconad VALUES ('CV', 'Cave');
INSERT INTO cconad VALUES ('GA', 'Garage');
INSERT INTO cconad VALUES ('GR', 'Grenier');
INSERT INTO cconad VALUES ('TR', 'Terrasse');
INSERT INTO cconad VALUES ('BC', 'Bûcher');
INSERT INTO cconad VALUES ('BD', 'Buanderie');
INSERT INTO cconad VALUES ('BX', 'Box');
INSERT INTO cconad VALUES ('CL', 'Cellier');
INSERT INTO cconad VALUES ('DC', 'Dépendance de local commun');
INSERT INTO cconad VALUES ('JH', 'Jardin d''hiver');
INSERT INTO cconad VALUES ('PA', 'Elément de pur agrément');
INSERT INTO cconad VALUES ('PI', 'Pièce indépendante');
INSERT INTO cconad VALUES ('PK', 'Parking');
INSERT INTO cconad VALUES ('PS', 'Piscine');
INSERT INTO cconad VALUES ('RS', 'Remise');
INSERT INTO cconad VALUES ('SR', 'Serre');
-- valeurs obsolètes mais existant toujours en base pour des questions de compatibilité
INSERT INTO cconad VALUES ('CD', 'Chambre de domestique');
INSERT INTO cconad VALUES ('GC', 'Grenier/cave');
INSERT INTO cconad VALUES ('GP', 'Garage/parking');
INSERT INTO cconad VALUES ('TT', 'Toiture-terrasse');

-- nomenclature ctpdl (pdl)
INSERT INTO ctpdl VALUES ('BND', 'Libellé BND');
INSERT INTO ctpdl VALUES ('CL', 'Libellé CL');
INSERT INTO ctpdl VALUES ('CV', 'Libellé CV');
INSERT INTO ctpdl VALUES ('TF', 'Libellé TF');
INSERT INTO ctpdl VALUES ('CLV', 'Libellé CLV');
INSERT INTO ctpdl VALUES ('MP', 'Libellé MP');

-- nomenclature cconlo (lots)
INSERT INTO cconlo VALUES ('1', 'lot non bâti');
INSERT INTO cconlo VALUES ('2', 'lot bâti');
INSERT INTO cconlo VALUES ('3', 'lot mixte');
INSERT INTO cconlo VALUES ('4', 'assise de pdl');
INSERT INTO cconlo VALUES ('5', 'lot particulier');
INSERT INTO cconlo VALUES ('6', 'lot multi-communes');

-- nomenclature ccodro (proprietaire)
INSERT INTO ccodro VALUES ('P', 'Propriétaire');
INSERT INTO ccodro VALUES ('U', 'Usufruitier (associé avec N)');
INSERT INTO ccodro VALUES ('N', 'Nu-propriétaire (associé avec U)');
INSERT INTO ccodro VALUES ('B', 'Bailleur à construction (associé avec R)');
INSERT INTO ccodro VALUES ('R', 'Preneur à construction (associé avec B)');
INSERT INTO ccodro VALUES ('F', 'Foncier (associé avec D ou T)');
INSERT INTO ccodro VALUES ('T', 'Ténuyer (associé avec F)');
INSERT INTO ccodro VALUES ('D', 'Domanier (associé avec F)');
INSERT INTO ccodro VALUES ('V', 'Bailleur d''un bail à réhabilitation (associé avec W)');
INSERT INTO ccodro VALUES ('W', 'Preneur d''un bail à réhabilitation (associé avec V)');
INSERT INTO ccodro VALUES ('A', 'Locataire-attributaire (associé avec P)');
INSERT INTO ccodro VALUES ('E', 'Emphytéote (associé avec P)');
INSERT INTO ccodro VALUES ('K', 'Antichrésiste (associé avec P)');
INSERT INTO ccodro VALUES ('L', 'Fonctionnaire logé');
INSERT INTO ccodro VALUES ('G', 'Gérant, mandataire, gestionnaire');
INSERT INTO ccodro VALUES ('S', 'Syndic de copropriété');
INSERT INTO ccodro VALUES ('H', 'Associé dans une société en transparence fiscale (associé avec P)');
INSERT INTO ccodro VALUES ('O', 'Autorisation d''occupation temporaire (70 ans)');
INSERT INTO ccodro VALUES ('J', 'Jeune agriculteur');
INSERT INTO ccodro VALUES ('Q', 'Gestionnaire taxe sur les bureaux (Ile-de-France)');
INSERT INTO ccodro VALUES ('X', 'La Poste, propriétaire et occupant');
INSERT INTO ccodro VALUES ('Y', 'La Poste, occupant et non propriétaire');
INSERT INTO ccodro VALUES ('C', 'Fiduciaire');
INSERT INTO ccodro VALUES ('M', 'Occupant d''une parcelle appartenant au département de Mayotte ou à l''État (associé à P).');
-- valeurs obsolètes mais existant toujours en base pour des questions de compatibilité
-- 2021
INSERT INTO ccodro VALUES ('Z', 'Preneur de bail solidaire (associé à B)');

-- nomenclature ccodem (proprietaire)
INSERT INTO ccodem VALUES ('C', 'Un des copropriétaires');
INSERT INTO ccodem VALUES ('S', 'Succession de');
INSERT INTO ccodem VALUES ('L', 'Propriété en litige');
INSERT INTO ccodem VALUES ('I', 'Indivision simple');
INSERT INTO ccodem VALUES ('V', 'La veuve ou les héritiers de');
-- nomenclature gtoper (proprietaire)
INSERT INTO gtoper VALUES ('1', 'physique');
INSERT INTO gtoper VALUES ('2', 'morale');
-- nomenclature ccoqua (proprietaire)
INSERT INTO ccoqua VALUES ('1', 'M');
INSERT INTO ccoqua VALUES ('2', 'MME');
INSERT INTO ccoqua VALUES ('3', 'MLE');
-- nomenclature dnatpr (proprietaire)
INSERT INTO dnatpr VALUES ('ECF', 'Pers. physique : ECONOMIQUEMENT FAIBLE (NON SERVI)');
INSERT INTO dnatpr VALUES ('FNL', 'Pers. physique : FONCTIONNAIRE LOGE');
INSERT INTO dnatpr VALUES ('DOM', 'Pers. physique : PROPRIETAIRE OCCUPANT DOM');
INSERT INTO dnatpr VALUES ('HLM', 'Pers. Morale : OFFICE HLM');
INSERT INTO dnatpr VALUES ('SEM', 'Pers. Morale : SOCIETE D ECONOMIE MIXTE');
INSERT INTO dnatpr VALUES ('TGV', 'Pers. Morale : SNCF');
INSERT INTO dnatpr VALUES ('RFF', 'Pers. Morale : RESEAU FERRE DE FRANCE');
INSERT INTO dnatpr VALUES ('CLL', 'Pers. Morale : COLLECTIVITE LOCALE');
INSERT INTO dnatpr VALUES ('CAA', 'Pers. Morale : CAISSE ASSURANCE AGRICOLE');
-- nomenclature ccogrm (proprietaire)
INSERT INTO ccogrm VALUES ('0', 'PERSONNES MORALES NON REMARQUABLES');
INSERT INTO ccogrm VALUES ('1', 'ETAT');
INSERT INTO ccogrm VALUES ('2', 'REGION');
INSERT INTO ccogrm VALUES ('3', 'DEPARTEMENT');
INSERT INTO ccogrm VALUES ('4', 'COMMUNE');
INSERT INTO ccogrm VALUES ('5', 'OFFICE HLM');
INSERT INTO ccogrm VALUES ('6', 'PERSONNES MORALES REPRESENTANT DES SOCIETES');
INSERT INTO ccogrm VALUES ('7', 'COPROPRIETAIRE');
INSERT INTO ccogrm VALUES ('8', 'ASSOCIE');
INSERT INTO ccogrm VALUES ('9', 'ETABLISSEMENTS PUBLICS OU ARGANISMES ASSIMILES');
INSERT INTO ccogrm VALUES ('0A', 'CAAA en Alsace-Moselle - PERSONNES MORALES NON REMARQUABLES');
INSERT INTO ccogrm VALUES ('1A', 'CAAA en Alsace-Moselle - ETAT');
INSERT INTO ccogrm VALUES ('2A', 'CAAA en Alsace-Moselle - REGION');
INSERT INTO ccogrm VALUES ('3A', 'CAAA en Alsace-Moselle - DEPARTEMENT');
INSERT INTO ccogrm VALUES ('4A', 'CAAA en Alsace-Moselle - COMMUNE');
INSERT INTO ccogrm VALUES ('5A', 'CAAA en Alsace-Moselle - OFFICE HLM');
INSERT INTO ccogrm VALUES ('6A', 'CAAA en Alsace-Moselle - PERSONNES MORALES REPRESENTANT DES SOCIETES');
INSERT INTO ccogrm VALUES ('7A', 'CAAA en Alsace-Moselle - COPROPRIETAIRE');
INSERT INTO ccogrm VALUES ('8A', 'CAAA en Alsace-Moselle - ASSOCIE');
INSERT INTO ccogrm VALUES ('9A', 'CAAA en Alsace-Moselle - ETABLISSEMENTS PUBLICS OU ARGANISMES ASSIMILES');
-- nomenclature gtyp3 (proprietaire)
INSERT INTO gtyp3 VALUES ('2', '2 LIGNE SERVIE (FORMAT LIBRE)');
INSERT INTO gtyp3 VALUES ('9', 'LIGNE VIDE');
-- nomenclature gtyp4 (proprietaire)
INSERT INTO gtyp4 VALUES ('1', 'ADRESSE CODIFIEE 1');
INSERT INTO gtyp4 VALUES ('2', 'ADRESSE CODIFIEE 2');
INSERT INTO gtyp4 VALUES ('3', 'ADRESSE FORMATEE');
INSERT INTO gtyp4 VALUES ('4', 'ADRESSE BOITE POSTALE OU SERVICE');
INSERT INTO gtyp4 VALUES ('5', 'ADRESSE CEDEX');
INSERT INTO gtyp4 VALUES ('6', 'ADRESSE SECTEUR POSTAL');
INSERT INTO gtyp4 VALUES ('7', 'ADRESSE NON CODIFIEE, NON FORMATABLE');
INSERT INTO gtyp4 VALUES ('8', 'ADRESSE A L ETRANGER');
INSERT INTO gtyp4 VALUES ('9', 'LIGNE VIDE');
-- nomenclature gtyp5 (proprietaire)
INSERT INTO gtyp5 VALUES ('1', 'LIGNE SERVIE (COMMUNE OU LIEU-DIT) 1');
INSERT INTO gtyp5 VALUES ('2', 'LIGNE SERVIE (COMMUNE OU LIEU-DIT) 2');
INSERT INTO gtyp5 VALUES ('3', 'LIGNE SERVIE (COMMUNE OU LIEU-DIT) 3');
INSERT INTO gtyp5 VALUES ('4', 'LIGNE SERVIE FORMAT LIBRE');
INSERT INTO gtyp5 VALUES ('8', 'ADRESSE A L''ETRANGER (libellé de la ville)');
INSERT INTO gtyp5 VALUES ('9', 'LIGNE VIDE');
-- nomenclature gtyp6 (proprietaire)
INSERT INTO gtyp6 VALUES ('2', 'ADRESSE FORMATEE, sous la forme CODE POSTAL sur 5');
INSERT INTO gtyp6 VALUES ('3', 'ADRESSE A L''ETRANGER avec codification du pays en CCOPAY');
INSERT INTO gtyp6 VALUES ('4', 'ADRESSE A L''ETRANGER sans codification du pays.');
INSERT INTO gtyp6 VALUES ('5', 'ADRESSE INCODIFIABLE');
INSERT INTO gtyp6 VALUES ('6', 'ADRESSE CEDEX');
INSERT INTO gtyp6 VALUES ('7', 'POSTES AUX ARMEES');
INSERT INTO gtyp6 VALUES ('9', 'LIGNE VIDE');
-- nomenclature typcom (commune, voie)
INSERT INTO typcom VALUES ('N', 'Commune rurale');
INSERT INTO typcom VALUES ('R', 'Commune recensée');
-- nomenclature natvoi (type de voie)
INSERT INTO natvoi VALUES ('ACH' , 'ANCIEN CHEMIN');
INSERT INTO natvoi VALUES ('AER' , 'AERODROME');
INSERT INTO natvoi VALUES ('AERG', 'AEROGARE');
INSERT INTO natvoi VALUES ('AGL' , 'AGGLOMERATION');
INSERT INTO natvoi VALUES ('AIRE', 'AIRE');
INSERT INTO natvoi VALUES ('ALL' , 'ALLEE');
INSERT INTO natvoi VALUES ('ANGL', 'ANGLE');
INSERT INTO natvoi VALUES ('ARC' , 'ARCADE');
INSERT INTO natvoi VALUES ('ART' , 'ANCIENNE ROUTE');
INSERT INTO natvoi VALUES ('AUT' , 'AUTOROUTE');
INSERT INTO natvoi VALUES ('AV'  , 'AVENUE');
INSERT INTO natvoi VALUES ('BASE', 'BASE');
INSERT INTO natvoi VALUES ('BD'  , 'BOULEVARD');
INSERT INTO natvoi VALUES ('BER' , 'BERGE');
INSERT INTO natvoi VALUES ('BORD', 'BORD');
INSERT INTO natvoi VALUES ('BRE' , 'BARRIERE');
INSERT INTO natvoi VALUES ('BRG' , 'BOURG');
INSERT INTO natvoi VALUES ('BRTL', 'BRETELLE');
INSERT INTO natvoi VALUES ('BSN' , 'BASSIN');
INSERT INTO natvoi VALUES ('CAE' , 'CARRIERA');
INSERT INTO natvoi VALUES ('CALL', 'CALLE');
INSERT INTO natvoi VALUES ('CAMI', 'CAMIN');
INSERT INTO natvoi VALUES ('CAMP', 'CAMP');
INSERT INTO natvoi VALUES ('CAN' , 'CANAL');
INSERT INTO natvoi VALUES ('CAR' , 'CARREFOUR');
INSERT INTO natvoi VALUES ('CARE', 'CARRIERE');
INSERT INTO natvoi VALUES ('CASR', 'CASERNE');
INSERT INTO natvoi VALUES ('CC'  , 'CHEMIN COMMUNAL');
INSERT INTO natvoi VALUES ('CD'  , 'CHEMIN DEPARTEMENTAL');
INSERT INTO natvoi VALUES ('CF'  , 'CHEMIN FORESTIER');
INSERT INTO natvoi VALUES ('CHA' , 'CHASSE');
INSERT INTO natvoi VALUES ('CHE' , 'CHEMIN');
INSERT INTO natvoi VALUES ('CHEM', 'CHEMINEMENT');
INSERT INTO natvoi VALUES ('CHL' , 'CHALET');
INSERT INTO natvoi VALUES ('CHP' , 'CHAMP');
INSERT INTO natvoi VALUES ('CHT' , 'CHATEAU');
INSERT INTO natvoi VALUES ('CHV' , 'CHEMIN VICINAL');
INSERT INTO natvoi VALUES ('CITE', 'CITE');
INSERT INTO natvoi VALUES ('CIVE', 'COURSIVE');
INSERT INTO natvoi VALUES ('CLOS', 'CLOS');
INSERT INTO natvoi VALUES ('CLR' , 'COULOIR');
INSERT INTO natvoi VALUES ('COIN', 'COIN');
INSERT INTO natvoi VALUES ('COL' , 'COL');
INSERT INTO natvoi VALUES ('COR' , 'CORNICHE');
INSERT INTO natvoi VALUES ('CORO', 'CORON');
INSERT INTO natvoi VALUES ('COTE', 'COTE');
INSERT INTO natvoi VALUES ('COUR', 'COUR');
INSERT INTO natvoi VALUES ('CPG' , 'CAMPING');
INSERT INTO natvoi VALUES ('CR'  , 'CHEMIN RURAL');
INSERT INTO natvoi VALUES ('CRS' , 'COURS');
INSERT INTO natvoi VALUES ('CRX' , 'CROIX');
INSERT INTO natvoi VALUES ('CTR' , 'CONTOUR');
INSERT INTO natvoi VALUES ('CTRE', 'CENTRE');
INSERT INTO natvoi VALUES ('DARS', 'DARSE');
INSERT INTO natvoi VALUES ('DEVI', 'DEVIATION');
INSERT INTO natvoi VALUES ('DIG' , 'DIGUE');
INSERT INTO natvoi VALUES ('DOM' , 'DOMAINE');
INSERT INTO natvoi VALUES ('DRA' , 'DRAILLE');
INSERT INTO natvoi VALUES ('DSC' , 'DESCENTE');
INSERT INTO natvoi VALUES ('ECA' , 'ECART');
INSERT INTO natvoi VALUES ('ECL' , 'ECLUSE');
INSERT INTO natvoi VALUES ('EMBR', 'EMBRANCHEMENT');
INSERT INTO natvoi VALUES ('EMP' , 'EMPLACEMENT');
INSERT INTO natvoi VALUES ('ENC' , 'ENCLOS');
INSERT INTO natvoi VALUES ('ENV' , 'ENCLAVE');
INSERT INTO natvoi VALUES ('ESC' , 'ESCALIER');
INSERT INTO natvoi VALUES ('ESP' , 'ESPLANADE');
INSERT INTO natvoi VALUES ('ESPA', 'ESPACE');
INSERT INTO natvoi VALUES ('ETNG', 'ETANG');
INSERT INTO natvoi VALUES ('FD'  , 'FOND');
INSERT INTO natvoi VALUES ('FG'  , 'FAUBOURG');
INSERT INTO natvoi VALUES ('FON' , 'FONTAINE');
INSERT INTO natvoi VALUES ('FOR' , 'FORET');
INSERT INTO natvoi VALUES ('FORT', 'FORT');
INSERT INTO natvoi VALUES ('FOS' , 'FOSSE');
INSERT INTO natvoi VALUES ('FRM' , 'FERME');
INSERT INTO natvoi VALUES ('GAL' , 'GALERIE');
INSERT INTO natvoi VALUES ('GARE', 'GARE');
INSERT INTO natvoi VALUES ('GBD' , 'GRAND BOULEVARD');
INSERT INTO natvoi VALUES ('GPL' , 'GRANDE PLACE');
INSERT INTO natvoi VALUES ('GR'  , 'GRANDE RUE');
INSERT INTO natvoi VALUES ('GREV', 'GREVE');
INSERT INTO natvoi VALUES ('HAB' , 'HABITATION');
INSERT INTO natvoi VALUES ('HAM' , 'HAMEAU');
INSERT INTO natvoi VALUES ('HIP' , 'HIPPODROME');
INSERT INTO natvoi VALUES ('HLE' , 'HALLE');
INSERT INTO natvoi VALUES ('HLG' , 'HALAGE');
INSERT INTO natvoi VALUES ('HLM' , 'HLM');
INSERT INTO natvoi VALUES ('HTR' , 'HAUTEUR');
INSERT INTO natvoi VALUES ('ILE' , 'ILE');
INSERT INTO natvoi VALUES ('ILOT', 'ILOT');
INSERT INTO natvoi VALUES ('IMP' , 'IMPASSE');
INSERT INTO natvoi VALUES ('JARD', 'JARDIN');
INSERT INTO natvoi VALUES ('JTE' , 'JETEE');
INSERT INTO natvoi VALUES ('LAC' , 'LAC');
INSERT INTO natvoi VALUES ('LEVE', 'LEVEE');
INSERT INTO natvoi VALUES ('LICE', 'LICES');
INSERT INTO natvoi VALUES ('LIGN', 'LIGNE');
INSERT INTO natvoi VALUES ('LOT' , 'LOTISSEMENT');
INSERT INTO natvoi VALUES ('MAIL', 'MAIL');
INSERT INTO natvoi VALUES ('MAIS', 'MAISON');
INSERT INTO natvoi VALUES ('MAR' , 'MARCHE');
INSERT INTO natvoi VALUES ('MARE', 'MARE');
INSERT INTO natvoi VALUES ('MAS' , 'MAS');
INSERT INTO natvoi VALUES ('MNE' , 'MORNE');
INSERT INTO natvoi VALUES ('MRN' , 'MARINA');
INSERT INTO natvoi VALUES ('MTE' , 'MONTEE');
INSERT INTO natvoi VALUES ('NTE' , 'NOUVELLE ROUTE');
INSERT INTO natvoi VALUES ('PAE' , 'PETITE AVENUE');
INSERT INTO natvoi VALUES ('PARC', 'PARC');
INSERT INTO natvoi VALUES ('PAS' , 'PASSAGE');
INSERT INTO natvoi VALUES ('PASS', 'PASSE');
INSERT INTO natvoi VALUES ('PCH' , 'PETIT CHEMIN');
INSERT INTO natvoi VALUES ('PCHE', 'PORCHE');
INSERT INTO natvoi VALUES ('PHAR', 'PHARE');
INSERT INTO natvoi VALUES ('PIST', 'PISTE');
INSERT INTO natvoi VALUES ('PKG' , 'PARKING');
INSERT INTO natvoi VALUES ('PL'  , 'PLACE');
INSERT INTO natvoi VALUES ('PLA' , 'PLACA');
INSERT INTO natvoi VALUES ('PLAG', 'PLAGE');
INSERT INTO natvoi VALUES ('PLAN', 'PLAN');
INSERT INTO natvoi VALUES ('PLCI', 'PLACIS');
INSERT INTO natvoi VALUES ('PLE' , 'PASSERELLE');
INSERT INTO natvoi VALUES ('PLN' , 'PLAINE');
INSERT INTO natvoi VALUES ('PLT' , 'PLATEAU');
INSERT INTO natvoi VALUES ('PNT' , 'POINTE');
INSERT INTO natvoi VALUES ('PONT', 'PONT');
INSERT INTO natvoi VALUES ('PORQ', 'PORTIQUE');
INSERT INTO natvoi VALUES ('PORT', 'PORT');
INSERT INTO natvoi VALUES ('POST', 'POSTE');
INSERT INTO natvoi VALUES ('POT' , 'POTERNE');
INSERT INTO natvoi VALUES ('PROM', 'PROMENADE');
INSERT INTO natvoi VALUES ('PRT' , 'PETITE ROUTE');
INSERT INTO natvoi VALUES ('PRV' , 'PARVIS');
INSERT INTO natvoi VALUES ('PTA' , 'PETITE ALLEE');
INSERT INTO natvoi VALUES ('PTE' , 'PORTE');
INSERT INTO natvoi VALUES ('PTR' , 'PETITE RUE');
INSERT INTO natvoi VALUES ('PTTE', 'PLACETTE');
INSERT INTO natvoi VALUES ('QUA' , 'QUARTIER');
INSERT INTO natvoi VALUES ('QUAI', 'QUAI');
INSERT INTO natvoi VALUES ('RAC' , 'RACCOURCI');
INSERT INTO natvoi VALUES ('REM' , 'REMPART');
INSERT INTO natvoi VALUES ('RES' , 'RESIDENCE');
INSERT INTO natvoi VALUES ('RIVE', 'RIVE');
INSERT INTO natvoi VALUES ('RLE' , 'RUELLE');
INSERT INTO natvoi VALUES ('ROC' , 'ROCADE');
INSERT INTO natvoi VALUES ('RPE' , 'RAMPE');
INSERT INTO natvoi VALUES ('RPT' , 'ROND-POINT');
INSERT INTO natvoi VALUES ('RTD' , 'ROTONDE');
INSERT INTO natvoi VALUES ('RTE' , 'ROUTE');
INSERT INTO natvoi VALUES ('RUE' , 'RUE');
INSERT INTO natvoi VALUES ('RUET', 'RUETTE');
INSERT INTO natvoi VALUES ('RUIS', 'RUISSEAU');
INSERT INTO natvoi VALUES ('RULT', 'RUELLETTE');
INSERT INTO natvoi VALUES ('RVE' , 'RAVINE');
INSERT INTO natvoi VALUES ('SAS' , 'SAS');
INSERT INTO natvoi VALUES ('SEN' , 'SENTIER');
INSERT INTO natvoi VALUES ('SQ'  , 'SQUARE');
INSERT INTO natvoi VALUES ('STDE', 'STADE');
INSERT INTO natvoi VALUES ('TER' , 'TERRE');
INSERT INTO natvoi VALUES ('TOUR', 'TOUR');
INSERT INTO natvoi VALUES ('TPL' , 'TERRE-PLEIN');
INSERT INTO natvoi VALUES ('TRA' , 'TRAVERSE');
INSERT INTO natvoi VALUES ('TRAB', 'TRABOULE');
INSERT INTO natvoi VALUES ('TRN' , 'TERRAIN');
INSERT INTO natvoi VALUES ('TRT' , 'TERTRE');
INSERT INTO natvoi VALUES ('TSSE', 'TERRASSE');
INSERT INTO natvoi VALUES ('TUN' , 'TUNNEL');
INSERT INTO natvoi VALUES ('VAL' , 'VAL');
INSERT INTO natvoi VALUES ('VALL', 'VALLON / VALLEE');
INSERT INTO natvoi VALUES ('VC'  , 'VOIE COMMUNALE');
INSERT INTO natvoi VALUES ('VCHE', 'VIEUX CHEMIN');
INSERT INTO natvoi VALUES ('VEN' , 'VENELLE');
INSERT INTO natvoi VALUES ('VGE' , 'VILLAGE');
INSERT INTO natvoi VALUES ('VIA' , 'VIA');
INSERT INTO natvoi VALUES ('VIAD', 'VIADUC');
INSERT INTO natvoi VALUES ('VIL' , 'VILLE');
INSERT INTO natvoi VALUES ('VLA' , 'VILLA');
INSERT INTO natvoi VALUES ('VOIE', 'VOIE');
INSERT INTO natvoi VALUES ('VOIR', 'VOIRIE');
INSERT INTO natvoi VALUES ('VOUT', 'VOUTE');
INSERT INTO natvoi VALUES ('VOY' , 'VOYEUL');
INSERT INTO natvoi VALUES ('VTE' , 'VIEILLE ROUTE');
INSERT INTO natvoi VALUES ('ZA'  , 'ZA');
INSERT INTO natvoi VALUES ('ZAC' , 'ZAC');
INSERT INTO natvoi VALUES ('ZAD' , 'ZAD');
INSERT INTO natvoi VALUES ('ZI'  , 'ZI');
INSERT INTO natvoi VALUES ('ZONE', 'ZONE');
INSERT INTO natvoi VALUES ('ZUP' , 'ZUP');
-- nomenclature natvoiriv (voie)
INSERT INTO natvoiriv VALUES ('A', 'ensembles immobiliers');
INSERT INTO natvoiriv VALUES ('B', 'lieux-dits');
INSERT INTO natvoiriv VALUES ('C', 'lieux-dits');
INSERT INTO natvoiriv VALUES ('D', 'lieux-dits');
INSERT INTO natvoiriv VALUES ('E', 'lieux-dits');
INSERT INTO natvoiriv VALUES ('F', 'lieux-dits');
INSERT INTO natvoiriv VALUES ('G', 'lieux-dits');
INSERT INTO natvoiriv VALUES ('H', 'lieux-dits');
INSERT INTO natvoiriv VALUES ('I', 'lieux-dits');
INSERT INTO natvoiriv VALUES ('J', 'lieux-dits');
INSERT INTO natvoiriv VALUES ('K', 'lieux-dits');
INSERT INTO natvoiriv VALUES ('L', 'lieux-dits');
INSERT INTO natvoiriv VALUES ('M', 'lieux-dits');
INSERT INTO natvoiriv VALUES ('N', 'lieux-dits');
INSERT INTO natvoiriv VALUES ('O', 'lieux-dits');
INSERT INTO natvoiriv VALUES ('P', 'lieux-dits');
INSERT INTO natvoiriv VALUES ('Q', 'lieux-dits');
INSERT INTO natvoiriv VALUES ('R', 'lieux-dits');
INSERT INTO natvoiriv VALUES ('S', 'lieux-dits');
INSERT INTO natvoiriv VALUES ('T', 'lieux-dits');
INSERT INTO natvoiriv VALUES ('U', 'lieux-dits');
INSERT INTO natvoiriv VALUES ('V', 'lieux-dits');
INSERT INTO natvoiriv VALUES ('W', 'lieux-dits');
INSERT INTO natvoiriv VALUES ('X', 'pseudo-voies');
INSERT INTO natvoiriv VALUES ('Y', 'voies provisoires à annuler');
INSERT INTO natvoiriv VALUES ('Z', 'voies provisoires à annuler');
INSERT INTO natvoiriv VALUES ('0', 'voies');
INSERT INTO natvoiriv VALUES ('1', 'voies');
INSERT INTO natvoiriv VALUES ('2', 'voies');
INSERT INTO natvoiriv VALUES ('3', 'voies');
INSERT INTO natvoiriv VALUES ('4', 'voies');
INSERT INTO natvoiriv VALUES ('5', 'voies');
INSERT INTO natvoiriv VALUES ('6', 'voies');
INSERT INTO natvoiriv VALUES ('7', 'voies');
INSERT INTO natvoiriv VALUES ('8', 'voies');
INSERT INTO natvoiriv VALUES ('9', 'voies');
-- nomenclature carvoi (voie)
INSERT INTO carvoi VALUES ('1', 'voie privée');
INSERT INTO carvoi VALUES ('0', 'voie publique');
-- nomenclature annul (voie)
INSERT INTO annul VALUES ('O', 'voie annulée sans transfert');
INSERT INTO annul VALUES ('Q', 'voie annulée avec transfert');
-- nomenclature typvoi (voie)
INSERT INTO typvoi VALUES ('1', 'voie');
INSERT INTO typvoi VALUES ('2', 'ensemble immobilier');
INSERT INTO typvoi VALUES ('3', 'lieu-dit');
INSERT INTO typvoi VALUES ('4', 'pseudo-voie');
INSERT INTO typvoi VALUES ('5', 'voie provisoire');
-- nomenclature indldnbat (voie)
INSERT INTO indldnbat VALUES ('1', 'lieu-dit non bâti');
INSERT INTO indldnbat VALUES ('0', 'lieu-dit bâti');
-- nomenclatures geo
INSERT INTO geo_qupl VALUES ('01', 'Plan régulier établi avant le 20/03/1980');
INSERT INTO geo_qupl VALUES ('02', 'Plan non régulier');
INSERT INTO geo_qupl VALUES ('03', 'Plan de qualité P3 ou classe de précision [10 cm]');
INSERT INTO geo_qupl VALUES ('04', 'Plan de qualité P4 ou classe de précision [20 cm]');
INSERT INTO geo_qupl VALUES ('05', 'Plan de qualité P5 ou classe de précision [40 cm]');
INSERT INTO geo_copl VALUES ('01', 'ancien plan');
INSERT INTO geo_copl VALUES ('02', 'plan rénové par voie de mise à jour');
INSERT INTO geo_copl VALUES ('03', 'plan rénové par voie de renouvellement');
INSERT INTO geo_copl VALUES ('04', 'plan rénové par voie de réfection');
INSERT INTO geo_copl VALUES ('05', 'plan remanié');
INSERT INTO geo_copl VALUES ('06', 'plan obtenu par remembrement ou AFAF');
INSERT INTO geo_copl VALUES ('07', 'plan obtenu par exploitation de plans d''arpentage');
INSERT INTO geo_inp VALUES ('00','inconnu');
INSERT INTO geo_inp VALUES ('01','numérisation manuelle');
INSERT INTO geo_inp VALUES ('02','numérisation par scanner');
INSERT INTO geo_inp VALUES ('03','incorporation directe sans numérisation préalable');
INSERT INTO geo_indp VALUES ('01', 'parcelle figurée au plan');
INSERT INTO geo_indp VALUES ('02', 'parcelle non figurée au plan');
INSERT INTO geo_dur VALUES ('01', 'bâti dur');
INSERT INTO geo_dur VALUES ('02', 'bâti léger');
INSERT INTO geo_can VALUES ('00', 'Inconnu');
INSERT INTO geo_can VALUES ('01', 'IGN');
INSERT INTO geo_can VALUES ('02', 'Cadastre');
INSERT INTO geo_can VALUES ('03', 'Commune');
INSERT INTO geo_can VALUES ('04', 'Équipement');
INSERT INTO geo_can VALUES ('05', 'Département');
INSERT INTO geo_can VALUES ('06', 'SNCF');
INSERT INTO geo_can VALUES ('07', 'RATP');
INSERT INTO geo_can VALUES ('08', 'EDF');
INSERT INTO geo_can VALUES ('09', 'GDF');
INSERT INTO geo_can VALUES ('10', 'Collectivité territoriale');
INSERT INTO geo_can VALUES ('98', 'Divers maîtres d''ouvrage');
INSERT INTO geo_ppln VALUES ('00', 'inconnu');
INSERT INTO geo_ppln VALUES ('01', 'canevas géodésique du 1er ordre');
INSERT INTO geo_ppln VALUES ('02', 'canevas géodésique du 2ème ordre');
INSERT INTO geo_ppln VALUES ('03', 'canevas géodésique du 3ème ordre');
INSERT INTO geo_ppln VALUES ('04', 'canevas géodésique du 4ème ordre');
INSERT INTO geo_ppln VALUES ('05', 'canevas complémentaire (5ème ordre)');
INSERT INTO geo_ppln VALUES ('06', 'canevas d''ensemble ou de stéréopréparation de précision');
INSERT INTO geo_ppln VALUES ('07', 'canevas d''ensemble ou de stéréopréparation ordinaire, y compris triangulation < 1980');
INSERT INTO geo_ppln VALUES ('08', 'canevas polygonal de précision');
INSERT INTO geo_ppln VALUES ('09', 'canevas polygonal ordinaire ou antérieur à 1980');
INSERT INTO geo_ppln VALUES ('10', 'aérocanevas ou charpente photogrammétrique');
INSERT INTO geo_ppln VALUES ('11', 'point de charpente');
INSERT INTO geo_ppln VALUES ('12', 'localisation planimétrique d''un point de nivellement');
INSERT INTO geo_ppln VALUES ('20', 'canevas pérenne ou de précision (depuis 2001)');
INSERT INTO geo_ppln VALUES ('21', 'canevas ordinaire ou préalable à AFAF ou de stéréopréparation pour une PdV inférieure au 1/4000 (depuis 2001)');
INSERT INTO geo_ppln VALUES ('22', 'canevas de stéréopréparation pour une PdV au 1/2500 (depuis 2001)');
INSERT INTO geo_ppln VALUES ('23', 'canevas d''appui pour géoréférencement (depuis 2001)');
INSERT INTO geo_ppln VALUES ('24', 'canevas géodésique RGF93-RRF');
INSERT INTO geo_ppln VALUES ('25', 'canevas géodésique RGF93-RBF');
INSERT INTO geo_ppln VALUES ('26', 'canevas géodésique RGF93-RDF');
INSERT INTO geo_ppln VALUES ('27', 'canevas géodésique WGS84-UTM Nord fuseau 20 (Guadeloupe et Martinique  : 971 et 972)');
INSERT INTO geo_ppln VALUES ('28', 'canevas géodésique RGF95-UTM Nord fuseau 22 (Guyane : 973)');
INSERT INTO geo_ppln VALUES ('29', 'canevas géodésique RGR92-UTM Sud fuseau 40 (Réunion : 974)');
INSERT INTO geo_ppln VALUES ('30', 'canevas géodésique RGM04-UTM Sud fuseau 38 (Mayotte : 976)');
INSERT INTO geo_ppln VALUES ('98', 'point de levé cadastral');
INSERT INTO geo_palt VALUES ('00', 'inconnu');
INSERT INTO geo_palt VALUES ('01', 'canevas de nivellement direct de haute précision');
INSERT INTO geo_palt VALUES ('02', 'canevas de nivellement direct de précision');
INSERT INTO geo_palt VALUES ('03', 'canevas de nivellement direct ordinaire');
INSERT INTO geo_palt VALUES ('04', 'canevas de nivellement indirect géodésique');
INSERT INTO geo_palt VALUES ('05', 'canevas de nivellement indirect trigonométrique');
INSERT INTO geo_palt VALUES ('06', 'cote altimétrique obtenue par photogrammétrie');
INSERT INTO geo_palt VALUES ('98', 'autre canevas de nivellement');
INSERT INTO geo_map VALUES ('00', 'inconnu');
INSERT INTO geo_map VALUES ('01', 'non matérialisé');
INSERT INTO geo_map VALUES ('02', 'matérialisé');
INSERT INTO geo_map VALUES ('03', 'rivet ou boulon');
INSERT INTO geo_map VALUES ('04', 'croix gravée');
INSERT INTO geo_map VALUES ('06', 'pylône');
INSERT INTO geo_map VALUES ('07', 'borne');
INSERT INTO geo_map VALUES ('98', 'autre point net et stable, naturel ou artificiel');
INSERT INTO geo_sym VALUES ('12', 'calvaire');
INSERT INTO geo_sym VALUES ('13', 'texture transparente');
INSERT INTO geo_sym VALUES ('14', 'symbole d''église');
INSERT INTO geo_sym VALUES ('15', 'symbole de mosquée');
INSERT INTO geo_sym VALUES ('16', 'symbole de synagogue');
INSERT INTO geo_sym VALUES ('17', 'limite d''Etat');
INSERT INTO geo_sym VALUES ('18', 'limite de département');
INSERT INTO geo_sym VALUES ('19', 'amorce de limite de commune');
INSERT INTO geo_sym VALUES ('21', 'chemin');
INSERT INTO geo_sym VALUES ('22', 'amorce de voie');
INSERT INTO geo_sym VALUES ('23', 'trottoirs et sentiers');
INSERT INTO geo_sym VALUES ('24', 'gazoduc ou oléoduc');
INSERT INTO geo_sym VALUES ('25', 'aqueduc');
INSERT INTO geo_sym VALUES ('26', 'téléphérique');
INSERT INTO geo_sym VALUES ('27', 'ligne de transport de force');
INSERT INTO geo_sym VALUES ('29', 'rail de chemin de fer');
INSERT INTO geo_sym VALUES ('30', 'flèche de cours d''eau');
INSERT INTO geo_sym VALUES ('31', 'flèche de rattachement d''un numéro deparcelle ou de la référence d''un bâtiment sur le domaine non cadastré');
INSERT INTO geo_sym VALUES ('32', 'limite surfacique ne formant pas parcelle');
INSERT INTO geo_sym VALUES ('33', 'parapet de pont');
INSERT INTO geo_sym VALUES ('34', 'étang, lac, mare');
INSERT INTO geo_sym VALUES ('37', 'tunnel');
INSERT INTO geo_sym VALUES ('39', 'mur mitoyen');
INSERT INTO geo_sym VALUES ('40', 'mur non mitoyen');
INSERT INTO geo_sym VALUES ('41', 'fossé mitoyen');
INSERT INTO geo_sym VALUES ('42', 'fossé non mitoyen');
INSERT INTO geo_sym VALUES ('43', 'clôture mitoyenne');
INSERT INTO geo_sym VALUES ('44', 'clôture non mitoyenne');
INSERT INTO geo_sym VALUES ('45', 'haie mitoyenne');
INSERT INTO geo_sym VALUES ('46', 'haie non mitoyenne');
INSERT INTO geo_sym VALUES ('47', 'halte');
INSERT INTO geo_sym VALUES ('48', 'arrêt');
INSERT INTO geo_sym VALUES ('49', 'station');
INSERT INTO geo_sym VALUES ('50', 'pylône');
INSERT INTO geo_sym VALUES ('51', 'cimetière chrétien');
INSERT INTO geo_sym VALUES ('52', 'cimetière israélite');
INSERT INTO geo_sym VALUES ('53', 'cimetière musulman');
INSERT INTO geo_sym VALUES ('62', 'terrain de sports, petits ruisseaux');
INSERT INTO geo_sym VALUES ('63', 'puits');
INSERT INTO geo_sym VALUES ('64', 'parking, terrasse, surplomb');
INSERT INTO geo_sym VALUES ('65', 'piscine');
INSERT INTO geo_sym VALUES ('71', 'point géodésique borné');
INSERT INTO geo_sym VALUES ('72', 'point géodésique non borné');
INSERT INTO geo_sym VALUES ('73', 'point borné de canevas cadastral ordinaire/préalable à AFAF/appui prise de vues permettant confection plan de classe de précision 20cm');
INSERT INTO geo_sym VALUES ('74', 'point borné de canevas pérenne ou de précision');
INSERT INTO geo_sym VALUES ('75', 'point borné de canevas d''appui d''une prise de vues permettant la confection d''un plan de classe de précision 10cm');
INSERT INTO geo_sym VALUES ('76', 'point borné d''appui de géoréférencement');
INSERT INTO geo_sym VALUES ('77', 'repère NGF');
INSERT INTO geo_sym VALUES ('78', 'borne du NGF');
INSERT INTO geo_sym VALUES ('79', 'nivellement MRL');
INSERT INTO geo_sym VALUES ('80', 'autre repère de nivellement');
INSERT INTO geo_sym VALUES ('81', 'borne limite de commune');
INSERT INTO geo_sym VALUES ('98', 'objet ponctuel/linéaire divers');

-- nomenclatures Forme juridique (depuis 2013) : dformjur
INSERT INTO dformjur VALUES ('0000', Null, '0000 : Organisme de placement collectif en valeurs mobilières sans personnalité morale');
INSERT INTO dformjur VALUES ('1000', Null, 'Entrepreneur individuel');
INSERT INTO dformjur VALUES ('1100', Null, 'Artisan-commerçant');
INSERT INTO dformjur VALUES ('1200', Null, 'Commerçant');
INSERT INTO dformjur VALUES ('1300', Null, 'Artisan');
INSERT INTO dformjur VALUES ('1400', Null, 'Officier public ou ministériel');
INSERT INTO dformjur VALUES ('1500', Null, 'Profession libérale');
INSERT INTO dformjur VALUES ('1600', Null, 'Exploitant agricole');
INSERT INTO dformjur VALUES ('1700', Null, 'Agent commercial');
INSERT INTO dformjur VALUES ('1800', Null, 'Associé gérant de Société');
INSERT INTO dformjur VALUES ('1900', Null, '(Autre) Personne physique');
INSERT INTO dformjur VALUES ('2110', Null, 'Indivision entre personnes physiques');
INSERT INTO dformjur VALUES ('2120', Null, 'Indivision avec personne morale');
INSERT INTO dformjur VALUES ('2210', 'STE', 'Société créée de fait entre personnes physiques');
INSERT INTO dformjur VALUES ('2220', 'STE', 'Société créée de fait avec personne morale');
INSERT INTO dformjur VALUES ('2310', 'STE', 'Société en participation entre personnes physiques');
INSERT INTO dformjur VALUES ('2320', 'STE', 'Société en participation avec personne morale');
INSERT INTO dformjur VALUES ('2385', 'STE', 'Société en participation de professions libérales');
INSERT INTO dformjur VALUES ('2400', Null, 'Fiducie');
INSERT INTO dformjur VALUES ('2700', 'PAR', 'Paroisse hors zone concordataire');
INSERT INTO dformjur VALUES ('2900', Null, 'Autre groupement de droit privé non doté de la personnalité morale');
INSERT INTO dformjur VALUES ('3110', Null, 'Représentation ou agence commerciale d''état ou organisme public étranger immatriculé au RCS');
INSERT INTO dformjur VALUES ('3120', 'STE', 'Société commerciale étrangère immatriculée au RCS');
INSERT INTO dformjur VALUES ('3205', Null, 'Organisation internationale');
INSERT INTO dformjur VALUES ('3210', Null, 'État, collectivité ou établissement public étranger');
INSERT INTO dformjur VALUES ('3220', 'STE', 'Société étrangère non immatriculée au RCS');
INSERT INTO dformjur VALUES ('3290', Null, 'Autre personne morale de droit étranger');
INSERT INTO dformjur VALUES ('4110', 'EPIC', 'Établissement public national à caractère industriel ou commercial doté d''un comptable public');
INSERT INTO dformjur VALUES ('4120', 'EPIC', 'Établissement public national à caractère industriel ou commercial non doté d''un comptable public');
INSERT INTO dformjur VALUES ('4130', Null, 'Exploitant public');
INSERT INTO dformjur VALUES ('4140', 'EPIC', 'Établissement public local à caractère industriel ou commercial');
INSERT INTO dformjur VALUES ('4150', 'REGI', 'Régie d''une collectivité locale à caractère industriel ou commercial');
INSERT INTO dformjur VALUES ('4160', 'BDF', 'Institution Banque de France');
INSERT INTO dformjur VALUES ('5191', 'SCCP', 'Société de caution mutuelle');
INSERT INTO dformjur VALUES ('5192', 'SCCP', 'Société coopérative de banque populaire');
INSERT INTO dformjur VALUES ('5193', 'SCCP', 'Caisse de crédit maritime mutuel');
INSERT INTO dformjur VALUES ('5194', 'SCCP', 'Caisse (fédérale) de crédit mutuel');
INSERT INTO dformjur VALUES ('5195', 'SCCP', 'Association coopérative inscrite (droit local Alsace Moselle)');
INSERT INTO dformjur VALUES ('5196', 'SCCP', 'Caisse d''épargne et de prévoyance à forme coopérative');
INSERT INTO dformjur VALUES ('5202', 'SNC', 'Société en nom collectif');
INSERT INTO dformjur VALUES ('5203', 'SNC', 'Société en nom collectif coopérative');
INSERT INTO dformjur VALUES ('5306', 'SCOM', 'Société en commandite simple');
INSERT INTO dformjur VALUES ('5307', 'SCOM', 'Société en commandite simple coopérative');
INSERT INTO dformjur VALUES ('5308', 'SCOM', 'Société en commandite par actions');
INSERT INTO dformjur VALUES ('5309', 'SCOM', 'Société en commandite par actions coopérative');
INSERT INTO dformjur VALUES ('5310', 'SLP', 'Société en libre partenariat');
INSERT INTO dformjur VALUES ('5370', 'SCOM', 'Société de participations financières de profession libérale société en commandite par action');
INSERT INTO dformjur VALUES ('5385', 'SCOM', 'Société d''exercice libéral en commandite par actions');
INSERT INTO dformjur VALUES ('5410', 'SARL', 'SARL nationale');
INSERT INTO dformjur VALUES ('5415', 'SARL', 'SARL d''économie mixte');
INSERT INTO dformjur VALUES ('5422', 'SARL', 'SARL immobilière pour le commerce et l''industrie (SICOMI)');
INSERT INTO dformjur VALUES ('5426', 'SARL', 'SARL immobilière de gestion');
INSERT INTO dformjur VALUES ('5430', 'SARL', 'SARL d''aménagement foncier et d''équipement rural (SAFER)');
INSERT INTO dformjur VALUES ('5431', 'SARL', 'SARL mixte d''intérêt agricole (SMIA)');
INSERT INTO dformjur VALUES ('5432', 'SARL', 'SARL d''intérêt collectif agricole (SICA)');
INSERT INTO dformjur VALUES ('5442', 'SARL', 'SARL d''attribution');
INSERT INTO dformjur VALUES ('5443', 'SARL', 'SARL coopérative de construction');
INSERT INTO dformjur VALUES ('5451', 'SARL', 'SARL coopérative de consommation');
INSERT INTO dformjur VALUES ('5453', 'SARL', 'SARL coopérative artisanale');
INSERT INTO dformjur VALUES ('5454', 'SARL', 'SARL coopérative d''intérêt maritime');
INSERT INTO dformjur VALUES ('5455', 'SARL', 'SARL coopérative de transport');
INSERT INTO dformjur VALUES ('5458', 'SARL', 'SARL coopérative ouvrière de production et de crédit (SCOP)');
INSERT INTO dformjur VALUES ('5459', 'SARL', 'SARL union de sociétés coopératives');
INSERT INTO dformjur VALUES ('5460', 'SARL', 'Autre SARL coopérative');
INSERT INTO dformjur VALUES ('5470', 'SARL', 'Société de participations financières de profession libérale société à responsabilité limitée');
INSERT INTO dformjur VALUES ('5485', 'SLRL', 'Société d''exercice libéral à responsabilité limitée');
INSERT INTO dformjur VALUES ('5499', 'SARL', 'Société à responsabilité limitée (sans autre indication)');
INSERT INTO dformjur VALUES ('5505', 'SA', 'SA à participation ouvrière à conseil d''administration');
INSERT INTO dformjur VALUES ('5510', 'SA', 'SA nationale à conseil d''administration');
INSERT INTO dformjur VALUES ('5515', 'SEM', 'SA d''économie mixte à conseil d''administration');
INSERT INTO dformjur VALUES ('5520', 'STE', 'Fond à forme sociétale à conseil d’administration');
INSERT INTO dformjur VALUES ('5522', 'STE', 'SA immobilière pour le commerce et l''industrie (SICOMI) à conseil d''administration');
INSERT INTO dformjur VALUES ('5525', 'SA', 'SA immobilière d''investissement à conseil d''administration');
INSERT INTO dformjur VALUES ('5530', Null, 'SA d''aménagement foncier et d''équipement rural (SAFER) à conseil d''administration');
INSERT INTO dformjur VALUES ('5531', 'SA', 'Société anonyme mixte d''intérêt agricole (SMIA) à conseil d''administration');
INSERT INTO dformjur VALUES ('5532', 'SICA', 'SA d''intérêt collectif agricole (SICA) à conseil d''administration');
INSERT INTO dformjur VALUES ('5542', 'SA', 'SA d''attribution à conseil d''administration');
INSERT INTO dformjur VALUES ('5543', 'SA', 'SA coopérative de construction à conseil d''administration');
INSERT INTO dformjur VALUES ('5546', 'SA', 'SA de HLM à conseil d''administration');
INSERT INTO dformjur VALUES ('5547', 'SA', 'SA coopérative de production de HLM à conseil d''administration');
INSERT INTO dformjur VALUES ('5548', 'SA', 'SA de crédit immobilier à conseil d''administration');
INSERT INTO dformjur VALUES ('5551', 'SA', 'SA coopérative de consommation à conseil d''administration');
INSERT INTO dformjur VALUES ('5552', 'SA', 'SA coopérative de commerçants-détaillants à conseil d''administration');
INSERT INTO dformjur VALUES ('5553', 'SA', 'SA coopérative artisanale à conseil d''administration');
INSERT INTO dformjur VALUES ('5554', 'SA', 'SA coopérative (d''intérêt) maritime à conseil d''administration');
INSERT INTO dformjur VALUES ('5555', 'SA', 'SA coopérative de transport à conseil d''administration');
INSERT INTO dformjur VALUES ('5558', 'SCOP', 'SA coopérative ouvrière de production et de crédit (SCOP) à conseil d''administration');
INSERT INTO dformjur VALUES ('5559', 'SA', 'SA union de sociétés coopératives à conseil d''administration');
INSERT INTO dformjur VALUES ('5560', 'SA', 'Autre SA coopérative à conseil d''administration');
INSERT INTO dformjur VALUES ('5570', 'SA', 'Société de participations financières de profession libérale société anonyme à conseil d’administration');
INSERT INTO dformjur VALUES ('5585', 'STE', 'Société d''exercice libéral à forme anonyme à conseil d''administration');
INSERT INTO dformjur VALUES ('5599', 'SA', 'SA à conseil d''administration (s.a.i.)');
INSERT INTO dformjur VALUES ('5605', 'SA', 'SA à participation ouvrière à directoire');
INSERT INTO dformjur VALUES ('5610', 'SA', 'SA nationale à directoire');
INSERT INTO dformjur VALUES ('5615', 'SA', 'SA d''économie mixte à directoire');
INSERT INTO dformjur VALUES ('5620', 'STE', 'Fond à forme sociétale à directoire');
INSERT INTO dformjur VALUES ('5622', 'STE', 'SA immobilière pour le commerce et l''industrie (SICOMI) à directoire');
INSERT INTO dformjur VALUES ('5625', 'STE', 'SA immobilière d''investissement à directoire');
INSERT INTO dformjur VALUES ('5630', Null, 'Safer anonyme à directoire');
INSERT INTO dformjur VALUES ('5631', 'SA', 'SA mixte d''intérêt agricole (SMIA)');
INSERT INTO dformjur VALUES ('5632', 'SA', 'SA d''intérêt collectif agricole (SICA)');
INSERT INTO dformjur VALUES ('5642', 'SA', 'SA d''attribution à directoire');
INSERT INTO dformjur VALUES ('5643', 'SA', 'SA coopérative de construction à directoire');
INSERT INTO dformjur VALUES ('5646', 'SA', 'SA de HLM à directoire');
INSERT INTO dformjur VALUES ('5647', 'STE', 'Société coopérative de production de HLM anonyme à directoire');
INSERT INTO dformjur VALUES ('5648', 'SA', 'SA de crédit immobilier à directoire');
INSERT INTO dformjur VALUES ('5651', 'SA', 'SA coopérative de consommation à directoire');
INSERT INTO dformjur VALUES ('5652', 'SA', 'SA coopérative de commerçants-détaillants à directoire');
INSERT INTO dformjur VALUES ('5653', 'SA', 'SA coopérative artisanale à directoire');
INSERT INTO dformjur VALUES ('5654', 'SA', 'SA coopérative d''intérêt maritime à directoire');
INSERT INTO dformjur VALUES ('5655', 'SA', 'SA coopérative de transport à directoire');
INSERT INTO dformjur VALUES ('5658', 'SCOP', 'SA coopérative ouvrière de production et de crédit (SCOP) à directoire');
INSERT INTO dformjur VALUES ('5659', 'SA', 'SA union de sociétés coopératives à directoire');
INSERT INTO dformjur VALUES ('5660', 'SA', 'Autre SA coopérative à directoire');
INSERT INTO dformjur VALUES ('5670', 'SA', 'Société de participations financières de profession libérale société anonyme à directoire');
INSERT INTO dformjur VALUES ('5685', 'SA', 'Société d''exercice libéral à forme anonyme à directoire');
INSERT INTO dformjur VALUES ('5699', 'SA', 'SA à directoire (s.a.i.)');
INSERT INTO dformjur VALUES ('5710', 'SAS', 'SAS, société par actions simplifiée');
INSERT INTO dformjur VALUES ('5770', 'SAS', 'Société de participations financières de profession libérale société par actions simplifiée');
INSERT INTO dformjur VALUES ('5785', 'SAS', 'Société d''exercice libéral par action simplifiée');
INSERT INTO dformjur VALUES ('5800', 'SE', 'Société européenne');
INSERT INTO dformjur VALUES ('6100', 'CEP', 'Caisse d''Épargne et de Prévoyance');
INSERT INTO dformjur VALUES ('6210', 'GIE', 'Groupement européen d''intérêt économique (GEIE)');
INSERT INTO dformjur VALUES ('6220', 'GIE', 'Groupement d''intérêt économique (GIE)');
INSERT INTO dformjur VALUES ('6316', 'CUMA', 'Coopérative d''utilisation de matériel agricole en commun (CUMA)');
INSERT INTO dformjur VALUES ('6317', 'SCA', 'Société coopérative agricole');
INSERT INTO dformjur VALUES ('6318', 'SCA', 'Union de sociétés coopératives agricoles');
INSERT INTO dformjur VALUES ('6411', 'SAM', 'Société d''assurance à forme mutuelle');
INSERT INTO dformjur VALUES ('6412', 'SAM', 'Société mutuelle d''assurance');
INSERT INTO dformjur VALUES ('6413', 'SAM', 'Union de sociétés mutuelles d''assurances');
INSERT INTO dformjur VALUES ('6414', 'SAM', 'Autre société non commerciale d''assurance');
INSERT INTO dformjur VALUES ('6511', 'STE', 'Société interprofessionnelle de soins ambulatoires');
INSERT INTO dformjur VALUES ('6521', 'SCPI', 'Société civile de placement collectif immobilier (SCPI)');
INSERT INTO dformjur VALUES ('6532', 'SICA', 'Société civile d''intérêt collectif agricole (SICA)');
INSERT INTO dformjur VALUES ('6533', 'GAEC', 'Groupement agricole d''exploitation en commun (GAEC)');
INSERT INTO dformjur VALUES ('6534', 'GFA', 'Groupement foncier agricole');
INSERT INTO dformjur VALUES ('6535', 'GAF', 'Groupement agricole foncier');
INSERT INTO dformjur VALUES ('6536', 'GFO', 'Groupement forestier');
INSERT INTO dformjur VALUES ('6537', 'GPAS', 'Groupement pastoral');
INSERT INTO dformjur VALUES ('6538', 'GFR', 'Groupement foncier et rural');
INSERT INTO dformjur VALUES ('6539', 'STE', 'Société civile foncière');
INSERT INTO dformjur VALUES ('6540', 'SCI', 'Société civile immobilière');
INSERT INTO dformjur VALUES ('6541', 'SCI', 'Société civile immobilière de construction-vente');
INSERT INTO dformjur VALUES ('6542', 'SC', 'Société civile d''attribution');
INSERT INTO dformjur VALUES ('6543', 'SC', 'Société civile coopérative de construction');
INSERT INTO dformjur VALUES ('6544', 'SCI', 'Société civile immobilière d'' accession progressive à la propriété');
INSERT INTO dformjur VALUES ('6551', 'SC', 'Société civile coopérative de consommation');
INSERT INTO dformjur VALUES ('6554', 'SC', 'Société civile coopérative d''intérêt maritime');
INSERT INTO dformjur VALUES ('6558', 'SC', 'Société civile coopérative entre médecins');
INSERT INTO dformjur VALUES ('6560', 'SC', 'Autre société civile coopérative');
INSERT INTO dformjur VALUES ('6561', 'SCP', 'SCP d''avocats');
INSERT INTO dformjur VALUES ('6562', 'SCP', 'SCP d''avocats aux conseils');
INSERT INTO dformjur VALUES ('6563', 'SCP', 'SCP d''avoués d''appel');
INSERT INTO dformjur VALUES ('6564', 'SCP', 'SCP d''huissiers');
INSERT INTO dformjur VALUES ('6565', 'SCP', 'SCP de notaires');
INSERT INTO dformjur VALUES ('6566', 'SCP', 'SCP de commissaires-priseurs');
INSERT INTO dformjur VALUES ('6567', 'SCP', 'SCP de greffiers de tribunal de commerce');
INSERT INTO dformjur VALUES ('6568', 'SCP', 'SCP de conseils juridiques');
INSERT INTO dformjur VALUES ('6569', 'SCP', 'SCP de commissaires aux comptes');
INSERT INTO dformjur VALUES ('6571', 'SCP', 'SCP de médecins');
INSERT INTO dformjur VALUES ('6572', 'SCP', 'SCP de dentistes');
INSERT INTO dformjur VALUES ('6573', 'SCP', 'SCP d''infirmiers');
INSERT INTO dformjur VALUES ('6574', 'SCP', 'SCP de masseurs-kinésithérapeutes');
INSERT INTO dformjur VALUES ('6575', 'SCP', 'SCP de directeurs de laboratoire d''analyse médicale');
INSERT INTO dformjur VALUES ('6576', 'SCP', 'SCP de vétérinaires');
INSERT INTO dformjur VALUES ('6577', 'SCP', 'SCP de géomètres experts');
INSERT INTO dformjur VALUES ('6578', 'SCP', 'SCP d''architectes');
INSERT INTO dformjur VALUES ('6585', 'SC', 'Autre société civile professionnelle');
INSERT INTO dformjur VALUES ('6589', 'CCM', 'Société civile de moyens');
INSERT INTO dformjur VALUES ('6595', 'CCAM', 'Caisse locale de crédit mutuel');
INSERT INTO dformjur VALUES ('6596', 'SCEA', 'Caisse de crédit agricole mutuel');
INSERT INTO dformjur VALUES ('6597', 'EARL', 'Société civile d''exploitation agricole');
INSERT INTO dformjur VALUES ('6598', 'SC', 'Exploitation agricole à responsabilité limitée');
INSERT INTO dformjur VALUES ('6599', Null, 'Autre société civile');
INSERT INTO dformjur VALUES ('6901', Null, 'Autre personne de droit privé inscrite au registre du commerce et des sociétés');
INSERT INTO dformjur VALUES ('7111', Null, 'Autorité constitutionnelle');
INSERT INTO dformjur VALUES ('7112', 'ETAT', 'Autorité administrative ou publique indépendante');
INSERT INTO dformjur VALUES ('7113', 'ETAT', 'Ministère');
INSERT INTO dformjur VALUES ('7120', 'ETAT', 'Service central d''un ministère');
INSERT INTO dformjur VALUES ('7150', 'ETAT', 'Service du ministère de la Défense');
INSERT INTO dformjur VALUES ('7160', 'ETAT', 'Service déconcentré à compétence nationale d''un ministère (horsDéfense)');
INSERT INTO dformjur VALUES ('7171', 'ETAT', 'Service déconcentré de l''État à compétence (inter) régionale');
INSERT INTO dformjur VALUES ('7172', 'ETAT', 'Service déconcentré de l''État à compétence (inter) départementale');
INSERT INTO dformjur VALUES ('7179', 'ETAT', '(Autre) Service déconcentré de l''État à compétence territoriale');
INSERT INTO dformjur VALUES ('7190', Null, 'Ecole nationale non dotée de la personnalité morale');
INSERT INTO dformjur VALUES ('7210', 'COM', 'Commune et commune nouvelle');
INSERT INTO dformjur VALUES ('7220', 'DEPT', 'Département');
INSERT INTO dformjur VALUES ('7225', 'CTOM', 'Territoire d''Outre-mer');
INSERT INTO dformjur VALUES ('7229', 'COLL', '(Autre) Collectivité territoriale');
INSERT INTO dformjur VALUES ('7230', 'COLL', 'Région');
INSERT INTO dformjur VALUES ('7312', Null, 'Commune associée et commune déléguée');
INSERT INTO dformjur VALUES ('7313', Null, 'Section de commune');
INSERT INTO dformjur VALUES ('7314', Null, 'Ensemble urbain');
INSERT INTO dformjur VALUES ('7321', 'ASS', 'Association syndicale autorisée');
INSERT INTO dformjur VALUES ('7322', 'AFU', 'Association foncière urbaine');
INSERT INTO dformjur VALUES ('7323', 'AFR', 'Association foncière de remembrement');
INSERT INTO dformjur VALUES ('7331', 'EP', 'Établissement public local d''enseignement');
INSERT INTO dformjur VALUES ('7340', Null, 'Pôle métropolitain');
INSERT INTO dformjur VALUES ('7341', Null, 'Secteur de commune');
INSERT INTO dformjur VALUES ('7342', 'DISU', 'District urbain');
INSERT INTO dformjur VALUES ('7343', 'COMU', 'Communauté urbaine');
INSERT INTO dformjur VALUES ('7344', Null, 'Métropole');
INSERT INTO dformjur VALUES ('7345', 'SIVO', 'Syndicat intercommunal à vocation multiple (SIVOM)');
INSERT INTO dformjur VALUES ('7346', 'CCOM', 'Communauté de communes');
INSERT INTO dformjur VALUES ('7347', 'COVI', 'Communauté de villes');
INSERT INTO dformjur VALUES ('7348', 'COAG', 'Communauté d''agglomération');
INSERT INTO dformjur VALUES ('7349', Null, 'Autre établissement public local de coopération non spécialisé ou entente');
INSERT INTO dformjur VALUES ('7351', Null, 'Institution interdépartementale ou entente');
INSERT INTO dformjur VALUES ('7352', Null, 'Institution interrégionale ou entente');
INSERT INTO dformjur VALUES ('7353', 'SIVU', 'Syndicat intercommunal à vocation unique (SIVU)');
INSERT INTO dformjur VALUES ('7354', 'SYMC', 'Syndicat mixte fermé');
INSERT INTO dformjur VALUES ('7355', 'SYMI', 'Syndicat mixte ouvert');
INSERT INTO dformjur VALUES ('7356', Null, 'Commission syndicale pour la gestion des biens indivis descommunes');
INSERT INTO dformjur VALUES ('7357', 'PETR', 'Pôle d’équilibre territorial');
INSERT INTO dformjur VALUES ('7361', 'CCAS', 'Centre communal d''action sociale');
INSERT INTO dformjur VALUES ('7362', Null, 'Caisse des écoles');
INSERT INTO dformjur VALUES ('7363', 'CCMU', 'Caisse de crédit municipal');
INSERT INTO dformjur VALUES ('7364', Null, 'Établissement d''hospitalisation');
INSERT INTO dformjur VALUES ('7365', Null, 'Syndicat inter hospitalier');
INSERT INTO dformjur VALUES ('7366', Null, 'Établissement public local social et médico-social');
INSERT INTO dformjur VALUES ('7367', 'CIAS', 'Centre intercommunal d’action social');
INSERT INTO dformjur VALUES ('7371', 'OHLM', 'Office public d''habitation à loyer modéré (OPHLM)');
INSERT INTO dformjur VALUES ('7372', 'SDIS', 'Service départemental d''incendie');
INSERT INTO dformjur VALUES ('7373', 'EP', 'Établissement public local culturel');
INSERT INTO dformjur VALUES ('7378', 'EPA', 'Régie d''une collectivité locale à caractère administratif');
INSERT INTO dformjur VALUES ('7379', 'EPA', '(Autre) Établissement public administratif local');
INSERT INTO dformjur VALUES ('7381', 'EPA', 'Organisme consulaire');
INSERT INTO dformjur VALUES ('7382', 'EPA', 'Établissement public national ayant fonction d''administration centrale');
INSERT INTO dformjur VALUES ('7383', 'EPA', 'Établissement public national à caractère scientifique culturel et professionnel');
INSERT INTO dformjur VALUES ('7384', 'EPA', 'Autre établissement public national d''enseignement');
INSERT INTO dformjur VALUES ('7385', 'EPA', 'Autre établissement public national administratif à compétence territoriale limitée');
INSERT INTO dformjur VALUES ('7389', 'EPA', 'Établissement public national à caractère administratif');
INSERT INTO dformjur VALUES ('7410', 'GIP', 'Groupement d''intérêt public (GIP)');
INSERT INTO dformjur VALUES ('7430', 'EPA', 'Établissement public des cultes d''Alsace-Lorraine');
INSERT INTO dformjur VALUES ('7450', 'EPA', 'Etablissement public administratif, cercle et foyer dans les armées');
INSERT INTO dformjur VALUES ('7470', 'GCS', 'Groupement de coopération sanitaire à gestion publique');
INSERT INTO dformjur VALUES ('7490', Null, 'Autre personne morale de droit administratif');
INSERT INTO dformjur VALUES ('7510', Null, 'Service d''une collectivité locale à comptabilité distincte');
INSERT INTO dformjur VALUES ('7520', Null, 'Régie d''une collectivité locale non dotée de la personnalité morale');
INSERT INTO dformjur VALUES ('8110', 'SSRG', 'Régime général de la Sécurité Sociale');
INSERT INTO dformjur VALUES ('8120', 'SSRS', 'Régime spécial de Sécurité Sociale');
INSERT INTO dformjur VALUES ('8130', 'IRC', 'Institution de retraite complémentaire');
INSERT INTO dformjur VALUES ('8140', 'MSA', 'Mutualité sociale agricole');
INSERT INTO dformjur VALUES ('8150', Null, 'Régime maladie des non-salariés non agricoles');
INSERT INTO dformjur VALUES ('8160', Null, 'Régime vieillesse ne dépendant pas du régime général de laSécurité Sociale');
INSERT INTO dformjur VALUES ('8170', Null, 'Régime d''assurance chômage');
INSERT INTO dformjur VALUES ('8190', Null, 'Autre régime de prévoyance sociale');
INSERT INTO dformjur VALUES ('8210', 'MUT', 'Mutuelle');
INSERT INTO dformjur VALUES ('8250', 'MUT', 'Assurance mutuelle agricole');
INSERT INTO dformjur VALUES ('8290', 'MUT', 'Autre organisme mutualiste');
INSERT INTO dformjur VALUES ('8310', 'COME', 'Comité central économique d''entreprise');
INSERT INTO dformjur VALUES ('8311', 'COME', 'Comité social économique d''établissement');
INSERT INTO dformjur VALUES ('8410', 'OPRO', 'Syndicat de salariés');
INSERT INTO dformjur VALUES ('8420', 'OPRO', 'Syndicat patronal');
INSERT INTO dformjur VALUES ('8450', 'OPRO', 'Ordre professionnel ou assimilé');
INSERT INTO dformjur VALUES ('8470', 'OPRO', 'Centre technique industriel ou comité professionnel du développement économique');
INSERT INTO dformjur VALUES ('8490', 'OPRO', 'Autre organisme professionnel');
INSERT INTO dformjur VALUES ('8510', 'IP', 'Institution de prévoyance');
INSERT INTO dformjur VALUES ('8520', 'IRS', 'Institution de retraite supplémentaire');
INSERT INTO dformjur VALUES ('9110', 'SYCO', 'Syndicat de copropriété');
INSERT INTO dformjur VALUES ('9150', 'ASS', 'Association syndicale libre');
INSERT INTO dformjur VALUES ('9210', 'ASS', 'Association non déclarée');
INSERT INTO dformjur VALUES ('9220', 'ASS', 'Association déclarée');
INSERT INTO dformjur VALUES ('9221', 'ASS', 'Association déclarée d''insertion par l''économique');
INSERT INTO dformjur VALUES ('9222', 'ASS', 'Association intermédiaire');
INSERT INTO dformjur VALUES ('9223', 'ASS', 'Groupement d''employeurs');
INSERT INTO dformjur VALUES ('9224', 'ASS', 'Association d''avocats à responsabilité professionnelle individuelle');
INSERT INTO dformjur VALUES ('9230', 'ASS', 'Association déclarée, reconnue d''utilité publique');
INSERT INTO dformjur VALUES ('9240', 'ASS', 'Congrégation');
INSERT INTO dformjur VALUES ('9260', 'ASS', 'Association de droit local (Bas-Rhin, Haut-Rhin et Moselle)');
INSERT INTO dformjur VALUES ('9300', 'FON', 'Fondation');
INSERT INTO dformjur VALUES ('9900', Null, 'Autre personne morale de droit privé');
INSERT INTO dformjur VALUES ('9970', 'GCS', 'Groupement de coopération sanitaire à gestion privée');
INSERT INTO dformjur VALUES ('F001', Null, 'Les copropriétaires');
INSERT INTO dformjur VALUES ('F002', Null, 'Les associés de sci');
INSERT INTO dformjur VALUES ('F003', Null, 'Professionnels très pauvres du foncier');
-- valeurs obsolètes mais existant toujours en base pour des questions de compatibilité
-- 2021
INSERT INTO dformjur VALUES ('5498', 'EURL', 'SARL unipersonnelle');
INSERT INTO dformjur VALUES ('5720', 'SAS', 'Société par actions simplifiée à associé unique ou société par actions simplifiée unipersonnelle');
INSERT INTO dformjur VALUES ('6588', 'SCM', 'Société civile laitière');


-- nomenclatures Code catégorie du local (depuis 2017) : ccocac
INSERT INTO ccocac VALUES ('MAG1', 'Boutiques et magasins sur rue (exemples : commerces, restaurants, cafés ou agences bancaires pour une surface principale inférieure à 400 m²)');
INSERT INTO ccocac VALUES ('MAG2', 'Commerces sans accès direct sur la rue (surface principale inférieure à 400 m²)');
INSERT INTO ccocac VALUES ('MAG3', 'Magasins appartenant à un ensemble commercial(surface principale inférieure à 400 m²)');
INSERT INTO ccocac VALUES ('MAG4', 'Magasins de grande surface(surface principale comprise entre 400 et 2 499 m²)');
INSERT INTO ccocac VALUES ('MAG5', 'Magasins de très grande surface (surface principale égale ou supérieure à 2 500 m²)');
INSERT INTO ccocac VALUES ('MAG6', 'Stations - service, stations de lavage et assimilables');
INSERT INTO ccocac VALUES ('MAG7', 'Marchés');
INSERT INTO ccocac VALUES ('BUR1', 'Locaux à usage de bureaux d’agencement ancien');
INSERT INTO ccocac VALUES ('BUR2', 'Locaux à usage de bureaux d’agencement récent');
INSERT INTO ccocac VALUES ('BUR3', 'Locaux assimilables à des bureaux mais présentant des aménagements spécifiques');
INSERT INTO ccocac VALUES ('DEP1', 'Lieux de dépôt à ciel ouvert et terrains à usage commercial ou industriel');
INSERT INTO ccocac VALUES ('DEP2', 'Lieux de dépôt couverts');
INSERT INTO ccocac VALUES ('DEP3', 'Parcs de stationnement à ciel ouvert');
INSERT INTO ccocac VALUES ('DEP4', 'Parcs de stationnement couverts');
INSERT INTO ccocac VALUES ('DEP5', 'Installations spécifiques de stockage');
INSERT INTO ccocac VALUES ('ATE1', 'Ateliers artisanaux');
INSERT INTO ccocac VALUES ('ATE2', 'Locaux utilisés pour une activité de transformation, de manutention ou de maintenance');
INSERT INTO ccocac VALUES ('ATE3', 'Chenils, viviers et autres locaux assimilables');
INSERT INTO ccocac VALUES ('HOT1', 'Hôtels « confort » (4 étoiles et plus, ou confort identique)');
INSERT INTO ccocac VALUES ('HOT2', 'Hôtels « supérieur » (2 ou 3 étoiles, ou confort identique)');
INSERT INTO ccocac VALUES ('HOT3', 'Hôtels « standard » (1 étoile, ou confort identique)');
INSERT INTO ccocac VALUES ('HOT4', 'Foyers d’hébergement, centres d’accueil, auberges de jeunesse');
INSERT INTO ccocac VALUES ('HOT5', 'Hôtels clubs, villages de vacances et résidences hôtelières');
INSERT INTO ccocac VALUES ('SPE1', 'Salles de spectacles, musées et locaux assimilables');
INSERT INTO ccocac VALUES ('SPE2', 'Établissements ou terrains affectés à la pratique d’un sport ou à usage de spectacles sportifs');
INSERT INTO ccocac VALUES ('SPE3', 'Salles de loisirs diverses');
INSERT INTO ccocac VALUES ('SPE4', 'Terrains de camping confortables (3 étoiles et plus, ou confort identique)');
INSERT INTO ccocac VALUES ('SPE5', 'Terrains de camping ordinaires(1 ou 2 étoiles, ou confort identique)');
INSERT INTO ccocac VALUES ('SPE6', 'Établissements de détente et de bien - être');
INSERT INTO ccocac VALUES ('SPE7', 'Centres de loisirs, centres de colonies de vacances, maisons de jeunes');
INSERT INTO ccocac VALUES ('ENS1', 'Écoles et institutions privées exploitées dans un but non lucratif');
INSERT INTO ccocac VALUES ('ENS2', 'Établissements d’enseignement à but lucratif');
INSERT INTO ccocac VALUES ('CLI1', 'Cliniques et Établissements hospitaliers');
INSERT INTO ccocac VALUES ('CLI2', 'Centres médico-sociaux, centres de soins, crèches, halte - garderies');
INSERT INTO ccocac VALUES ('CLI3', 'Maisons de repos, maisons de retraite (médicalisées ou non) et locaux assimilables');
INSERT INTO ccocac VALUES ('CLI4', 'Centres de rééducation, de thalassothérapie, établissements thermaux');
INSERT INTO ccocac VALUES ('IND1', 'Établissements industriels nécessitant un outillage important autres que les carrières et assimilés');
INSERT INTO ccocac VALUES ('IND2', 'carrières et Établissements assimilables');
INSERT INTO ccocac VALUES ('EXC1', 'Locaux ne relevant d’aucune des catégories précédentes par leurs caractéristiques sortant de l’ordinaire');
INSERT INTO ccocac VALUES ('MAG', 'Magasins et lieux de vente');
INSERT INTO ccocac VALUES ('BUR', 'Bureaux et locaux divers assimilables');
INSERT INTO ccocac VALUES ('DEP', 'Lieux de dépôt ou stockage et parcs de stationnement');
INSERT INTO ccocac VALUES ('ATE', 'Ateliers et autres locaux assimilables');
INSERT INTO ccocac VALUES ('HOT', 'Hôtels et locaux assimilables');
INSERT INTO ccocac VALUES ('SPE', 'Établissements de spectacles, de sports et de loisirs et autres locaux assimilables');
INSERT INTO ccocac VALUES ('ENS', 'Établissements d''enseignement et locaux assimilables');
INSERT INTO ccocac VALUES ('CLI', 'Cliniques et Établissements du secteur sanitaire et social');
INSERT INTO ccocac VALUES ('IND', 'Établissements industriels n''étant pas évaluées selon la méthode comptable');
INSERT INTO ccocac VALUES ('EXC', 'Autres établissements');

-- nomenclatures Code NAF pour les locaux professionnels (depuis 2011) : cconac
INSERT INTO cconac VALUES ('0111Z','Culture de céréales (à l''exception du riz), de légumineuses et de graines oléagineuses');
INSERT INTO cconac VALUES ('0112Z','Culture du riz');
INSERT INTO cconac VALUES ('0113Z','Culture de légumes, de melons, de racines et de tubercules');
INSERT INTO cconac VALUES ('0114Z','Culture de la canne à sucre');
INSERT INTO cconac VALUES ('0115Z','Culture du tabac');
INSERT INTO cconac VALUES ('0116Z','Culture de plantes à fibres');
INSERT INTO cconac VALUES ('0119Z','Autres cultures non permanentes');
INSERT INTO cconac VALUES ('0121Z','Culture de la vigne');
INSERT INTO cconac VALUES ('0122Z','Culture de fruits tropicaux et subtropicaux');
INSERT INTO cconac VALUES ('0123Z','Culture d''agrumes');
INSERT INTO cconac VALUES ('0124Z','Culture de fruits à pépins et à noyau');
INSERT INTO cconac VALUES ('0125Z','Culture d''autres fruits d''arbres ou d''arbustes et de fruits à coque');
INSERT INTO cconac VALUES ('0126Z','Culture de fruits oléagineux');
INSERT INTO cconac VALUES ('0127Z','Culture de plantes à boissons');
INSERT INTO cconac VALUES ('0128Z','Culture de plantes à épices, aromatiques, médicinales et pharmaceutiques');
INSERT INTO cconac VALUES ('0129Z','Autres cultures permanentes');
INSERT INTO cconac VALUES ('0130Z','Reproduction de plantes');
INSERT INTO cconac VALUES ('0141Z','Élevage de vaches laitières');
INSERT INTO cconac VALUES ('0142Z','Élevage d''autres bovins et de buffles');
INSERT INTO cconac VALUES ('0143Z','Élevage de chevaux et d''autres équidés');
INSERT INTO cconac VALUES ('0144Z','Élevage de chameaux et d''autres camélides');
INSERT INTO cconac VALUES ('0145Z','Élevage d''ovins et de caprins');
INSERT INTO cconac VALUES ('0146Z','Élevage de porcins');
INSERT INTO cconac VALUES ('0147Z','Élevage de volailles');
INSERT INTO cconac VALUES ('0149Z','Élevage d''autres animaux');
INSERT INTO cconac VALUES ('0150Z','Culture et élevage associés');
INSERT INTO cconac VALUES ('0161Z','Activités de soutien aux cultures');
INSERT INTO cconac VALUES ('0162Z','Activités de soutien a la production animale');
INSERT INTO cconac VALUES ('0163Z','Traitement primaire des récoltes');
INSERT INTO cconac VALUES ('0164Z','Traitement des semences');
INSERT INTO cconac VALUES ('0170Z','Chasse, piégeage et services annexes');
INSERT INTO cconac VALUES ('0210Z','Sylviculture et autres activités forestières');
INSERT INTO cconac VALUES ('0220Z','Exploitation forestière');
INSERT INTO cconac VALUES ('0230Z','Récolte de produits forestiers non ligneux poussant à l''état sauvage');
INSERT INTO cconac VALUES ('0240Z','Services de soutien à l''exploitation forestière');
INSERT INTO cconac VALUES ('0311Z','Pêche en mer');
INSERT INTO cconac VALUES ('0312Z','Pêche en eau douce');
INSERT INTO cconac VALUES ('0321Z','Aquaculture en mer');
INSERT INTO cconac VALUES ('0322Z','Aquaculture en eau douce');
INSERT INTO cconac VALUES ('0510Z','Extraction de houille');
INSERT INTO cconac VALUES ('0520Z','Extraction de lignite');
INSERT INTO cconac VALUES ('0610Z','Extraction de pétrole brut');
INSERT INTO cconac VALUES ('0620Z','Extraction de gaz naturel');
INSERT INTO cconac VALUES ('0710Z','Extraction de minerais de fer');
INSERT INTO cconac VALUES ('0721Z','Extraction de minerais d''uranium et de thorium');
INSERT INTO cconac VALUES ('0729Z','Extraction d''autres minerais de métaux non ferreux');
INSERT INTO cconac VALUES ('0811Z','Extraction de pierres ornementales et de construction, de calcaire industriel, de gypse, de craie et d''ardoise');
INSERT INTO cconac VALUES ('0812Z','Exploitation de gravières et sablières, extraction d''argiles et de kaolin');
INSERT INTO cconac VALUES ('0891Z','Extraction des minéraux chimiques et d''engrais minéraux');
INSERT INTO cconac VALUES ('0892Z','Extraction de tourbe');
INSERT INTO cconac VALUES ('0893Z','Production de sel');
INSERT INTO cconac VALUES ('0899Z','Autres activités extractives n.c.a.');
INSERT INTO cconac VALUES ('0910Z','Activités de soutien a l''extraction d''hydrocarbures');
INSERT INTO cconac VALUES ('0990Z','Activités de soutien aux autres industries extractives');
INSERT INTO cconac VALUES ('1011Z','Transformation et conservation de la viande de boucherie');
INSERT INTO cconac VALUES ('1012Z','Transformation et conservation de la viande de volaille');
INSERT INTO cconac VALUES ('1013A','Préparation industrielle de produits à base de viande');
INSERT INTO cconac VALUES ('1013B','Charcuterie');
INSERT INTO cconac VALUES ('1020Z','Transformation et conservation de poisson, de crustacés et de mollusques');
INSERT INTO cconac VALUES ('1031Z','Transformation et conservation de pommes de terre');
INSERT INTO cconac VALUES ('1032Z','Préparation de jus de fruits et légumes');
INSERT INTO cconac VALUES ('1039A','Autre transformation et conservation de légumes');
INSERT INTO cconac VALUES ('1039B','Transformation et conservation de fruits');
INSERT INTO cconac VALUES ('1041A','Fabrication d''huiles et graisses brutes');
INSERT INTO cconac VALUES ('1041B','Fabrication d''huiles et graisses raffinées');
INSERT INTO cconac VALUES ('1042Z','Fabrication de margarine et graisses comestibles similaires');
INSERT INTO cconac VALUES ('1051A','Fabrication de lait liquide et de produits frais');
INSERT INTO cconac VALUES ('1051B','Fabrication de beurre');
INSERT INTO cconac VALUES ('1051C','Fabrication de fromage');
INSERT INTO cconac VALUES ('1051D','Fabrication d''autres produits laitiers');
INSERT INTO cconac VALUES ('1052Z','Fabrication de glaces et sorbets');
INSERT INTO cconac VALUES ('1061A','Meunerie');
INSERT INTO cconac VALUES ('1061B','Autres activités du travail des grains');
INSERT INTO cconac VALUES ('1062Z','Fabrication de produits amylaces');
INSERT INTO cconac VALUES ('1071A','Fabrication industrielle de pain et de patisserie fraîche');
INSERT INTO cconac VALUES ('1071B','Cuisson de produits de boulangerie');
INSERT INTO cconac VALUES ('1071C','Boulangerie et boulangerie-pâtisserie');
INSERT INTO cconac VALUES ('1071D','Pâtisserie');
INSERT INTO cconac VALUES ('1072Z','Fabrication d;e biscuits, biscottes et patisseries de conservation');
INSERT INTO cconac VALUES ('1073Z','Fabrication de pates alimentaires');
INSERT INTO cconac VALUES ('1081Z','Fabrication de sucre');
INSERT INTO cconac VALUES ('1082Z','Fabrication de cacao, chocolat et de produits de confiserie');
INSERT INTO cconac VALUES ('1083Z','Transformation du thé et du café');
INSERT INTO cconac VALUES ('1084Z','Fabrication de condiments et assaisonnements');
INSERT INTO cconac VALUES ('1085Z','Fabrication de plats préparés');
INSERT INTO cconac VALUES ('1086Z','Fabrication d''aliments homogéneisés et diététiques');
INSERT INTO cconac VALUES ('1089Z','Fabrication d''autres produits alimentaires n.c.a.');
INSERT INTO cconac VALUES ('1091Z','Fabrication d''aliments pour animaux de ferme');
INSERT INTO cconac VALUES ('1092Z','Fabrication d''aliments pour animaux de compagnie');
INSERT INTO cconac VALUES ('1101Z','Production de boissons alcooliques distillées');
INSERT INTO cconac VALUES ('1102A','Fabrication de vins effervescents');
INSERT INTO cconac VALUES ('1102B','Vinification');
INSERT INTO cconac VALUES ('1103Z','Fabrication de cidre et de vins de fruits');
INSERT INTO cconac VALUES ('1104Z','Production d autres boissons fermentees non distillees');
INSERT INTO cconac VALUES ('1105Z','Fabrication de bière');
INSERT INTO cconac VALUES ('1106Z','Fabrication de malt');
INSERT INTO cconac VALUES ('1107A','Industrie des eaux de table');
INSERT INTO cconac VALUES ('1107B','Production de boissons rafraîchissantes');
INSERT INTO cconac VALUES ('1200Z','Fabrication de produits à base de tabac');
INSERT INTO cconac VALUES ('1310Z','Préparation de fibres textiles et filature');
INSERT INTO cconac VALUES ('1320Z','Tissage');
INSERT INTO cconac VALUES ('1330Z','Ennoblissement textile');
INSERT INTO cconac VALUES ('1391Z','Fabrication d''étoffes à mailles');
INSERT INTO cconac VALUES ('1392Z','Fabrication d''articles textiles, sauf habillement');
INSERT INTO cconac VALUES ('1393Z','Fabrication de tapis et moquettes');
INSERT INTO cconac VALUES ('1394Z','Fabrication de ficelles, cordes et filets');
INSERT INTO cconac VALUES ('1395Z','Fabrication de non-tissés, sauf habillement');
INSERT INTO cconac VALUES ('1396Z','Fabrication d''autres textiles techniques et industriels');
INSERT INTO cconac VALUES ('1399Z','Fabrication d''autres textiles n.c.a.');
INSERT INTO cconac VALUES ('1411Z','Fabrication de vêtements en cuir');
INSERT INTO cconac VALUES ('1412Z','Fabrication de vêtements de travail');
INSERT INTO cconac VALUES ('1413Z','Fabrication de vêtements de dessus');
INSERT INTO cconac VALUES ('1414Z','Fabrication de vêtements de dessous');
INSERT INTO cconac VALUES ('1419Z','Fabrication d''autres vêtements et accessoires');
INSERT INTO cconac VALUES ('1420Z','Fabrication d''articles en fourrure');
INSERT INTO cconac VALUES ('1431Z','Fabrication d''articles chaussants à mailles');
INSERT INTO cconac VALUES ('1439Z','Fabrication d''autres articles à mailles');
INSERT INTO cconac VALUES ('1511Z','Apprêt et tannage des cuirs ; préparation et teinture des fourrures');
INSERT INTO cconac VALUES ('1512Z','Fabrication d''articles de voyage, de maroquinerie et de sellerie');
INSERT INTO cconac VALUES ('1520Z','Fabrication de chaussures');
INSERT INTO cconac VALUES ('1610A','Sciage et rabotage du bois, hors imprégnation');
INSERT INTO cconac VALUES ('1610B','Imprégnation du bois');
INSERT INTO cconac VALUES ('1621Z','Fabrication de placage et de panneaux de bois');
INSERT INTO cconac VALUES ('1622Z','Fabrication de parquets assemblés');
INSERT INTO cconac VALUES ('1623Z','Fabrication de charpentes et d''autres menuiseries');
INSERT INTO cconac VALUES ('1624Z','Fabrication d''emballages en bois');
INSERT INTO cconac VALUES ('1629Z','Fabrication d''objets divers en bois ; fabrication d objets en liège, vannerie et sparterie');
INSERT INTO cconac VALUES ('1711Z','Fabrication de pate à papier');
INSERT INTO cconac VALUES ('1712Z','Fabrication de papier et de carton');
INSERT INTO cconac VALUES ('1721A','Fabrication de carton ondulé');
INSERT INTO cconac VALUES ('1721B','Fabrication de cartonnages');
INSERT INTO cconac VALUES ('1721C','Fabrication d''emballages en papier');
INSERT INTO cconac VALUES ('1722Z','Fabrication d''articles en papier à usage sanitaire ou domestique');
INSERT INTO cconac VALUES ('1723Z','Fabrication d''articles de papeterie');
INSERT INTO cconac VALUES ('1724Z','Fabrication de papiers peints');
INSERT INTO cconac VALUES ('1729Z','Fabrication d''autres articles en papier ou en carton');
INSERT INTO cconac VALUES ('1811Z','Imprimerie de journaux');
INSERT INTO cconac VALUES ('1812Z','Autre imprimerie (labeur)');
INSERT INTO cconac VALUES ('1813Z','Activités de pré-presse');
INSERT INTO cconac VALUES ('1814Z','Reliure et activités connexes');
INSERT INTO cconac VALUES ('1820Z','Reproduction d''enregistrements');
INSERT INTO cconac VALUES ('1910Z','Cokefaction');
INSERT INTO cconac VALUES ('1920Z','Raffinage du pétrole');
INSERT INTO cconac VALUES ('2011Z','Fabrication de gaz industriels');
INSERT INTO cconac VALUES ('2012Z','Fabrication de colorants et de pigments');
INSERT INTO cconac VALUES ('2013A','Enrichissement et retraitement de matières nucléaires');
INSERT INTO cconac VALUES ('2013B','Fabrication d''autres produits chimiques inorganiques de base n.c.a.');
INSERT INTO cconac VALUES ('2014Z','Fabrication d''autres produits chimiques organiques de base');
INSERT INTO cconac VALUES ('2015Z','Fabrication de produits azotés et d''engrais');
INSERT INTO cconac VALUES ('2016Z','Fabrication de matières plastiques de base');
INSERT INTO cconac VALUES ('2017Z','Fabrication de caoutchouc synthétique');
INSERT INTO cconac VALUES ('2020Z','Fabrication de pesticides et d''autres produits agrochimiques');
INSERT INTO cconac VALUES ('2030Z','Fabrication de peintures, vernis, encres et mastics');
INSERT INTO cconac VALUES ('2041Z','Fabrication de savons, détergents et produits d''entretien');
INSERT INTO cconac VALUES ('2042Z','Fabrication de parfums et de produits pour la toilette');
INSERT INTO cconac VALUES ('2051Z','Fabrication de produits explosifs');
INSERT INTO cconac VALUES ('2052Z','Fabrication de colles');
INSERT INTO cconac VALUES ('2053Z','Fabrication d''huiles essentielles');
INSERT INTO cconac VALUES ('2059Z','Fabrication d''autres produits chimiques n.c.a.');
INSERT INTO cconac VALUES ('2060Z','Fabrication de fibres artificielles ou synthétiques');
INSERT INTO cconac VALUES ('2110Z','Fabrication de produits pharmaceutiques de base');
INSERT INTO cconac VALUES ('2120Z','Fabrication de préparations pharmaceutiques');
INSERT INTO cconac VALUES ('2211Z','Fabrication et rechapage de pneumatiques');
INSERT INTO cconac VALUES ('2219Z','Fabrication d''autres articles en caoutchouc');
INSERT INTO cconac VALUES ('2221Z','Fabrication de plaques, feuilles, tubes et profiles en matières plastiques');
INSERT INTO cconac VALUES ('2222Z','Fabrication d''emballages en matières plastiques');
INSERT INTO cconac VALUES ('2223Z','Fabrication d''élements en matières plastiques pour la construction');
INSERT INTO cconac VALUES ('2229A','Fabrication de pièces techniques à base de matières plastiques');
INSERT INTO cconac VALUES ('2229B','Fabrication de produits de consommation courante en matières plastiques');
INSERT INTO cconac VALUES ('2311Z','Fabrication de verre plat');
INSERT INTO cconac VALUES ('2312Z','Façonnage et transformation du verre plat');
INSERT INTO cconac VALUES ('2313Z','Fabrication de verre creux');
INSERT INTO cconac VALUES ('2314Z','Fabrication de fibres de verre');
INSERT INTO cconac VALUES ('2319Z','Fabrication et façonnage d''autres articles en verre, y compris verre technique');
INSERT INTO cconac VALUES ('2320Z','Fabrication de produits réfractaires');
INSERT INTO cconac VALUES ('2331Z','Fabrication de carreaux en céramique');
INSERT INTO cconac VALUES ('2332Z','Fabrication de briques, tuiles et produits de construction, en terre cuite');
INSERT INTO cconac VALUES ('2341Z','Fabrication d''articles céramiques à usage domestique ou ornemental');
INSERT INTO cconac VALUES ('2342Z','Fabrication d''appareils sanitaires en céramique');
INSERT INTO cconac VALUES ('2343Z','Fabrication d''isolateurs et pièces isolantes en céramique');
INSERT INTO cconac VALUES ('2344Z','Fabrication d''autres produits céramiques à usage technique');
INSERT INTO cconac VALUES ('2349Z','Fabrication d''autres produits céramiques');
INSERT INTO cconac VALUES ('2351Z','Fabrication de ciment');
INSERT INTO cconac VALUES ('2352Z','Fabrication de chaux et platre');
INSERT INTO cconac VALUES ('2361Z','Fabrication d''élements en béton pour la construction');
INSERT INTO cconac VALUES ('2362Z','Fabrication d''élements en platre pour la construction');
INSERT INTO cconac VALUES ('2363Z','Fabrication de béton prêt a l''emploi');
INSERT INTO cconac VALUES ('2364Z','Fabrication de mortiers et bétons secs');
INSERT INTO cconac VALUES ('2365Z','Fabrication d''ouvrages en fibre-ciment');
INSERT INTO cconac VALUES ('2369Z','Fabrication d''autres ouvrages en béton, en ciment ou en platre');
INSERT INTO cconac VALUES ('2370Z','Taille, façonnage et finissage de pierres');
INSERT INTO cconac VALUES ('2391Z','Fabrication de produits abrasifs');
INSERT INTO cconac VALUES ('2399Z','Fabrication d''autres produits minéraux non métalliques n.c.a.');
INSERT INTO cconac VALUES ('2410Z','Sidérurgie');
INSERT INTO cconac VALUES ('2420Z','Fabrication de tubes, tuyaux, profiles creux et accessoires correspondants en acier');
INSERT INTO cconac VALUES ('2431Z','Étirage à froid de barres');
INSERT INTO cconac VALUES ('2432Z','Laminage à froid de feuillards');
INSERT INTO cconac VALUES ('2433Z','Profilage à froid par formage ou pliage');
INSERT INTO cconac VALUES ('2434Z','Tréfilage à froid');
INSERT INTO cconac VALUES ('2441Z','Production de métaux précieux');
INSERT INTO cconac VALUES ('2442Z','Métallurgie de l''aluminium');
INSERT INTO cconac VALUES ('2443Z','Métallurgie du plomb, du zinc ou de l''étain');
INSERT INTO cconac VALUES ('2444Z','Métallurgie du cuivre');
INSERT INTO cconac VALUES ('2445Z','Métallurgie des autres métaux non ferreux');
INSERT INTO cconac VALUES ('2446Z','Élaboration et transformation de matières nucléaires');
INSERT INTO cconac VALUES ('2451Z','Fonderie de fonte');
INSERT INTO cconac VALUES ('2452Z','Fonderie d''acier');
INSERT INTO cconac VALUES ('2453Z','Fonderie de métaux légers');
INSERT INTO cconac VALUES ('2454Z','Fonderie d''autres métaux non ferreux');
INSERT INTO cconac VALUES ('2511Z','Fabrication de structures métalliques et de parties de structures');
INSERT INTO cconac VALUES ('2512Z','Fabrication de portes et fenêtres en métal');
INSERT INTO cconac VALUES ('2521Z','Fabrication de radiateurs et de chaudières pour le chauffage central');
INSERT INTO cconac VALUES ('2529Z','Fabrication d''autres réservoirs, citernes et conteneurs métalliques');
INSERT INTO cconac VALUES ('2530Z','Fabrication de générateurs de vapeur, à l''exception des chaudières pour le chauffage central');
INSERT INTO cconac VALUES ('2540Z','Fabrication d''armes et de munitions');
INSERT INTO cconac VALUES ('2550A','Forge, estampage, matricage ; métallurgie des poudres');
INSERT INTO cconac VALUES ('2550B','Découpage, emboutissage');
INSERT INTO cconac VALUES ('2561Z','Traitement et revêtement des métaux');
INSERT INTO cconac VALUES ('2562A','Décolletage');
INSERT INTO cconac VALUES ('2562B','Mécanique industrielle');
INSERT INTO cconac VALUES ('2571Z','Fabrication de coutellerie');
INSERT INTO cconac VALUES ('2572Z','Fabrication de serrures et de ferrures');
INSERT INTO cconac VALUES ('2573A','Fabrication de moules et modèles');
INSERT INTO cconac VALUES ('2573B','Fabrication d''autres outillages');
INSERT INTO cconac VALUES ('2591Z','Fabrication de fûts et emballages métalliques similaires');
INSERT INTO cconac VALUES ('2592Z','Fabrication d''emballages métalliques légers');
INSERT INTO cconac VALUES ('2593Z','Fabrication d''articles en fils métalliques, de chaînes et de ressorts');
INSERT INTO cconac VALUES ('2594Z','Fabrication de vis et de boulons');
INSERT INTO cconac VALUES ('2599A','Fabrication d''articles métalliques ménagers');
INSERT INTO cconac VALUES ('2599B','Fabrication d''autres articles métalliques');
INSERT INTO cconac VALUES ('2611Z','Fabrication de composants électroniques');
INSERT INTO cconac VALUES ('2612Z','Fabrication de cartes électroniques assemblées');
INSERT INTO cconac VALUES ('2620Z','Fabrication d''ordinateurs et d''équipements périphériques');
INSERT INTO cconac VALUES ('2630Z','Fabrication d''équipements de communication');
INSERT INTO cconac VALUES ('2640Z','Fabrication de produits électroniques grand public');
INSERT INTO cconac VALUES ('2651A','Fabrication d''équipements d''aide à la navigation');
INSERT INTO cconac VALUES ('2651B','Fabrication d''instrumentation scientifique et technique');
INSERT INTO cconac VALUES ('2652Z','Horlogerie');
INSERT INTO cconac VALUES ('2660Z','Fabrication d''équipements d''irradiation médicale, d''équipements électromédicaux et électrothérapeutiques');
INSERT INTO cconac VALUES ('2670Z','Fabrication de matériels optique et photographique');
INSERT INTO cconac VALUES ('2680Z','Fabrication de supports magnétiques et optiques');
INSERT INTO cconac VALUES ('2711Z','Fabrication de moteurs, génératrices et transformateurs électriques');
INSERT INTO cconac VALUES ('2712Z','Fabrication de matériel de distribution et de commande électrique');
INSERT INTO cconac VALUES ('2720Z','Fabrication de piles et d''accumulateurs électriques');
INSERT INTO cconac VALUES ('2731Z','Fabrication de câbles de fibres optiques');
INSERT INTO cconac VALUES ('2732Z','Fabrication d''autres fils et câbles électroniques ou électriques');
INSERT INTO cconac VALUES ('2733Z','Fabrication de matériel d''installation électrique');
INSERT INTO cconac VALUES ('2740Z','Fabrication d''appareils d''éclairage électrique');
INSERT INTO cconac VALUES ('2751Z','Fabrication d''appareils électromenagers');
INSERT INTO cconac VALUES ('2752Z','Fabrication d''appareils ménagers non électriques');
INSERT INTO cconac VALUES ('2790Z','Fabrication d''autres matériels électriques');
INSERT INTO cconac VALUES ('2811Z','Fabrication de moteurs et turbines, à l''exception des moteurs d''avions et de véhicules');
INSERT INTO cconac VALUES ('2812Z','Fabrication d''équipements hydrauliques et pneumatiques');
INSERT INTO cconac VALUES ('2813Z','Fabrication d''autres pompes et compresseurs');
INSERT INTO cconac VALUES ('2814Z','Fabrication d''autres articles de robinetterie');
INSERT INTO cconac VALUES ('2815Z','Fabrication d''engrenages et d''organes mécaniques de transmission');
INSERT INTO cconac VALUES ('2821Z','Fabrication de fours et brûleurs');
INSERT INTO cconac VALUES ('2822Z','Fabrication de matériel de levage et de manutention');
INSERT INTO cconac VALUES ('2823Z','Fabrication de machines et d''équipements de bureau (à l''exception des ordinateurs et équipements périphériques)');
INSERT INTO cconac VALUES ('2824Z','Fabrication d''outillage portatif à moteur incorporé');
INSERT INTO cconac VALUES ('2825Z','Fabrication d''équipements aérauliques et frigorifiques industriels');
INSERT INTO cconac VALUES ('2829A','Fabrication d''équipements d''emballage, de conditionnement et de pesage');
INSERT INTO cconac VALUES ('2829B','Fabrication d''autres machines d''usage général');
INSERT INTO cconac VALUES ('2830Z','Fabrication de machines agricoles et forestières');
INSERT INTO cconac VALUES ('2841Z','Fabrication de machines-outils pour le travail des métaux');
INSERT INTO cconac VALUES ('2849Z','Fabrication d''autres machines-outils');
INSERT INTO cconac VALUES ('2891Z','Fabrication de machines pour la métallurgie');
INSERT INTO cconac VALUES ('2892Z','Fabrication de machines pour l''extraction ou la construction');
INSERT INTO cconac VALUES ('2893Z','Fabrication de machines pour l''industrie agro-alimentaire');
INSERT INTO cconac VALUES ('2894Z','Fabrication de machines pour les industries textiles');
INSERT INTO cconac VALUES ('2895Z','Fabrication de machines pour les industries du papier et du carton');
INSERT INTO cconac VALUES ('2896Z','Fabrication de machines pour le travail du caoutchouc ou des plastiques');
INSERT INTO cconac VALUES ('2899A','Fabrication de machines d''imprimerie');
INSERT INTO cconac VALUES ('2899B','Fabrication d''autres machines spécialisées');
INSERT INTO cconac VALUES ('2910Z','Construction de véhicules automobiles');
INSERT INTO cconac VALUES ('2920Z','Fabrication de carrosseries et remorques');
INSERT INTO cconac VALUES ('2931Z','Fabrication d''équipements électriques et électroniques automobiles');
INSERT INTO cconac VALUES ('2932Z','Fabrication d''autres équipements automobiles');
INSERT INTO cconac VALUES ('3011Z','Construction de navires et de structures flottantes');
INSERT INTO cconac VALUES ('3012Z','Construction de bateaux de plaisance');
INSERT INTO cconac VALUES ('3020Z','Construction de locomotives et d''autre matériel ferroviaire roulant');
INSERT INTO cconac VALUES ('3030Z','Construction aéronautique et spatiale');
INSERT INTO cconac VALUES ('3040Z','Construction de véhicules militaires de combat');
INSERT INTO cconac VALUES ('3091Z','Fabrication de motocycles');
INSERT INTO cconac VALUES ('3092Z','Fabrication de bicyclettes et de véhicules pour invalides');
INSERT INTO cconac VALUES ('3099Z','Fabrication d''autres équipements de transport n.c.a.');
INSERT INTO cconac VALUES ('3101Z','Fabrication de meubles de bureau et de magasin');
INSERT INTO cconac VALUES ('3102Z','Fabrication de meubles de cuisine');
INSERT INTO cconac VALUES ('3103Z','Fabrication de matelas');
INSERT INTO cconac VALUES ('3109A','Fabrication de sièges d''ameublement d''intérieur');
INSERT INTO cconac VALUES ('3109B','Fabrication d''autres meubles et industries connexes de l''ameublement');
INSERT INTO cconac VALUES ('3211Z','Frappe de monnaie');
INSERT INTO cconac VALUES ('3212Z','Fabrication d''articles de joaillerie et bijouterie');
INSERT INTO cconac VALUES ('3213Z','Fabrication d''articles de bijouterie fantaisie et articles similaires');
INSERT INTO cconac VALUES ('3220Z','Fabrication d''instruments de musique');
INSERT INTO cconac VALUES ('3230Z','Fabrication d''articles de sport');
INSERT INTO cconac VALUES ('3240Z','Fabrication de jeux et jouets');
INSERT INTO cconac VALUES ('3250A','Fabrication de matériel médico-chirurgical et dentaire');
INSERT INTO cconac VALUES ('3250B','Fabrication de lunettes');
INSERT INTO cconac VALUES ('3291Z','Fabrication d''articles de brosserie');
INSERT INTO cconac VALUES ('3299Z','Autres activités manufacturieres n.c.a.');
INSERT INTO cconac VALUES ('3311Z','Réparation d''ouvrages en métaux');
INSERT INTO cconac VALUES ('3312Z','Réparation de machines et équipements mécaniques');
INSERT INTO cconac VALUES ('3313Z','Réparation de matériels électroniques et optiques');
INSERT INTO cconac VALUES ('3314Z','Réparation d''équipements électriques');
INSERT INTO cconac VALUES ('3315Z','Réparation et maintenance navale');
INSERT INTO cconac VALUES ('3316Z','Réparation et maintenance d''aéronefs et d''engins spatiaux');
INSERT INTO cconac VALUES ('3317Z','Réparation et maintenance d''autres équipements de transport');
INSERT INTO cconac VALUES ('3319Z','Réparation d''autres équipements');
INSERT INTO cconac VALUES ('3320A','Installation de structures métalliques, chaudronnees et de tuyauterie');
INSERT INTO cconac VALUES ('3320B','Installation de machines et équipements mécaniques');
INSERT INTO cconac VALUES ('3320C','Conception d''ensemble et assemblage sur site industriel d''équipements de contrôle des processus industriels');
INSERT INTO cconac VALUES ('3320D','Installation d''équipements électriques, de matériels électroniques et optiques ou d''autres matériels');
INSERT INTO cconac VALUES ('3511Z','Production d''électricité');
INSERT INTO cconac VALUES ('3512Z','Transport d''électricité');
INSERT INTO cconac VALUES ('3513Z','Distribution d''électricité');
INSERT INTO cconac VALUES ('3514Z','Commerce d''électricité');
INSERT INTO cconac VALUES ('3521Z','Production de combustibles gazeux');
INSERT INTO cconac VALUES ('3522Z','Distribution de combustibles gazeux par conduites');
INSERT INTO cconac VALUES ('3523Z','Commerce de combustibles gazeux par conduites');
INSERT INTO cconac VALUES ('3530Z','Production et distribution de vapeur et d''air conditionné');
INSERT INTO cconac VALUES ('3600Z','Captage, traitement et distribution d''eau');
INSERT INTO cconac VALUES ('3700Z','Collecte et traitement des eaux usées');
INSERT INTO cconac VALUES ('3811Z','Collecte des déchets non dangereux');
INSERT INTO cconac VALUES ('3812Z','Collecte des déchets dangereux');
INSERT INTO cconac VALUES ('3821Z','Traitement et élimination des déchets non dangereux');
INSERT INTO cconac VALUES ('3822Z','Traitement et élimination des déchets dangereux');
INSERT INTO cconac VALUES ('3831Z','Démantelement d''épaves');
INSERT INTO cconac VALUES ('3832Z','Réecuperation de déchets triés');
INSERT INTO cconac VALUES ('3900Z','Dépollution et autres services de gestion des déchets');
INSERT INTO cconac VALUES ('4110A','Promotion immobilière de logements');
INSERT INTO cconac VALUES ('4110B','Promotion immobilière de bureaux');
INSERT INTO cconac VALUES ('4110C','Promotion immobilière d''autres batiments');
INSERT INTO cconac VALUES ('4110D','Supports juridiques de programmes');
INSERT INTO cconac VALUES ('4120A','Construction de maisons individuelles');
INSERT INTO cconac VALUES ('4120B','Construction d''autres batiments');
INSERT INTO cconac VALUES ('4211Z','Construction de routes et autoroutes');
INSERT INTO cconac VALUES ('4212Z','Construction de voies ferrées de surface et souterraines');
INSERT INTO cconac VALUES ('4213A','Construction d''ouvrages d''art');
INSERT INTO cconac VALUES ('4213B','Construction et entretien de tunnels');
INSERT INTO cconac VALUES ('4221Z','Construction de réseaux pour fluides');
INSERT INTO cconac VALUES ('4222Z','Construction de réseaux électriques et de télécommunications');
INSERT INTO cconac VALUES ('4291Z','Construction d''ouvrages maritimes et fluviaux');
INSERT INTO cconac VALUES ('4299Z','Construction d''autres ouvrages de génie civil n.c.a.');
INSERT INTO cconac VALUES ('4311Z','Travaux de démolition');
INSERT INTO cconac VALUES ('4312A','Travaux de terrassement courants et travaux préparatoires');
INSERT INTO cconac VALUES ('4312B','Travaux de terrassement spécialisés ou de grande masse');
INSERT INTO cconac VALUES ('4313Z','Forages et sondages');
INSERT INTO cconac VALUES ('4321A','Travaux d''installation électrique dans tous locaux');
INSERT INTO cconac VALUES ('4321B','Travaux d''installation électrique sur la voie publique');
INSERT INTO cconac VALUES ('4322A','Travaux d''installation d''eau et de gaz en tous locaux');
INSERT INTO cconac VALUES ('4322B','Travaux d''installation d''équipements thermiques et de climatisation');
INSERT INTO cconac VALUES ('4329A','Travaux d''isolation');
INSERT INTO cconac VALUES ('4329B','Autres travaux d''installation n.c.a.');
INSERT INTO cconac VALUES ('4331Z','Travaux de platrerie');
INSERT INTO cconac VALUES ('4332A','Travaux de menuiserie bois et pvc');
INSERT INTO cconac VALUES ('4332B','Travaux de menuiserie métallique et serrurerie');
INSERT INTO cconac VALUES ('4332C','Agencement de lieux de vente');
INSERT INTO cconac VALUES ('4333Z','Travaux de revêtement des sols et des murs');
INSERT INTO cconac VALUES ('4334Z','Travaux de peinture et vitrerie');
INSERT INTO cconac VALUES ('4339Z','Autres travaux de finition');
INSERT INTO cconac VALUES ('4391A','Travaux de charpente');
INSERT INTO cconac VALUES ('4391B','Travaux de couverture par élements');
INSERT INTO cconac VALUES ('4399A','Travaux d''étanchéification');
INSERT INTO cconac VALUES ('4399B','Travaux de montage de structures métalliques');
INSERT INTO cconac VALUES ('4399C','Travaux de maçonnerie générale et gros œuvre de bâtiment');
INSERT INTO cconac VALUES ('4399D','Autres travaux spécialisés de construction');
INSERT INTO cconac VALUES ('4399E','Location avec opérateur de matériel de construction');
INSERT INTO cconac VALUES ('4511Z','Commerce de voitures et de véhicules automobiles légers');
INSERT INTO cconac VALUES ('4519Z','Commerce d''autres véhicules automobiles');
INSERT INTO cconac VALUES ('4520A','Entretien et réparation de véhicules automobiles légers');
INSERT INTO cconac VALUES ('4520B','Entretien et réparation d''autres véhicules automobiles');
INSERT INTO cconac VALUES ('4531Z','Commerce de gros d''équipements automobiles');
INSERT INTO cconac VALUES ('4532Z','Commerce de détail d''équipements automobiles');
INSERT INTO cconac VALUES ('4540Z','Commerce et réparation de motocycles');
INSERT INTO cconac VALUES ('4611Z','Intermédiaires du commerce en matières premières agricoles, animaux vivants, matières premières textiles et produits semi-finis');
INSERT INTO cconac VALUES ('4612A','Centrales d''achat de carburant');
INSERT INTO cconac VALUES ('4612B','Autres intermédiaires du commerce en combustibles, métaux, minéraux et produits chimiques');
INSERT INTO cconac VALUES ('4613Z','Intermédiaires du commerce en bois et matériaux de construction');
INSERT INTO cconac VALUES ('4614Z','Intermédiaires du commerce en machines, equipements industriels, navires et avions');
INSERT INTO cconac VALUES ('4615Z','intermédiaires du commerce en meubles, articles de ménage et quincaillerie');
INSERT INTO cconac VALUES ('4616Z','Intermédiaires du commerce en textiles, habillement, fourrures, chaussures et articles en cuir');
INSERT INTO cconac VALUES ('4617A','Centrales d''achat alimentaires');
INSERT INTO cconac VALUES ('4617B','Autres intermédiaires du commerce en denrées, boissons et tabac');
INSERT INTO cconac VALUES ('4618Z','Intermédiaires spécialisés dans le commerce d''autres produits spécifiques');
INSERT INTO cconac VALUES ('4619A','Centrales d''achat non alimentaires');
INSERT INTO cconac VALUES ('4619B','Autres intermédiaires du commerce en produits divers');
INSERT INTO cconac VALUES ('4621Z','Commerce de gros (commerce interentreprises) de céréales, de tabac non manufacturé, de semences et d''aliments pour le bétail');
INSERT INTO cconac VALUES ('4622Z','Commerce de gros (commerce interentreprises) de fleurs et plantes');
INSERT INTO cconac VALUES ('4623Z','Commerce de gros (commerce interentreprises) d''animaux vivants');
INSERT INTO cconac VALUES ('4624Z','Commerce de gros (commerce interentreprises) de cuirs et peaux');
INSERT INTO cconac VALUES ('4631Z','Commerce de gros (commerce interentreprises) de fruits et légumes');
INSERT INTO cconac VALUES ('4632A','Commerce de gros (commerce interentreprises) de viandes de boucherie');
INSERT INTO cconac VALUES ('4632B','Commerce de gros (commerce interentreprises) de produits à base de viande');
INSERT INTO cconac VALUES ('4632C','Commerce de gros (commerce interentreprises) de volailles et gibier');
INSERT INTO cconac VALUES ('4633Z','Commerce de gros (commerce interentreprises) de produits laitiers, œufs, huiles et matières grasses comestibles');
INSERT INTO cconac VALUES ('4634Z','Commerce de gros (commerce interentreprises) de boissons');
INSERT INTO cconac VALUES ('4635Z','Commerce de gros (commerce interentreprises) de produits à base de tabac');
INSERT INTO cconac VALUES ('4636Z','Commerce de gros (commerce interentreprises) de sucre, chocolat et confiserie');
INSERT INTO cconac VALUES ('4637Z','Commerce de gros (commerce interentreprises) de café, thé, cacao et épices');
INSERT INTO cconac VALUES ('4638A','Commerce de gros (commerce interentreprises) de poissons, crustacés et mollusques');
INSERT INTO cconac VALUES ('4638B','Commerce de gros (commerce interentreprises) alimentaire specialisé divers');
INSERT INTO cconac VALUES ('4639A','Commerce de gros (commerce interentreprises) de produits surgelés');
INSERT INTO cconac VALUES ('4639B','Commerce de gros (commerce interentreprises) alimentaire non specialisé');
INSERT INTO cconac VALUES ('4641Z','Commerce de gros (commerce interentreprises) de textiles');
INSERT INTO cconac VALUES ('4642Z','Commerce de gros (commerce interentreprises) d''habillement et de chaussures');
INSERT INTO cconac VALUES ('4643Z','Commerce de gros (commerce interentreprises) d''appareils électromenagers');
INSERT INTO cconac VALUES ('4644Z','Commerce de gros (commerce interentreprises) de vaisselle, verrerie et produits d''entretien');
INSERT INTO cconac VALUES ('4645Z','Commerce de gros (commerce interentreprises) de parfumerie et de produits de beauté');
INSERT INTO cconac VALUES ('4646Z','Commerce de gros (commerce interentreprises) de produits pharmaceutiques');
INSERT INTO cconac VALUES ('4647Z','Commerce de gros (commerce interentreprises) de meubles, de tapis et d''appareils d''éclairage');
INSERT INTO cconac VALUES ('4648Z','Commerce de gros (commerce interentreprises) d''articles d''horlogerie et de bijouterie');
INSERT INTO cconac VALUES ('5630Z','Débits de boissons');
INSERT INTO cconac VALUES ('4649Z','Commerce de gros (commerce interentreprises) d''autres biens domestiques');
INSERT INTO cconac VALUES ('4651Z','Commerce de gros (commerce interentreprises) d''ordinateurs, d''équipements informatiques péripheriques et de logiciels');
INSERT INTO cconac VALUES ('4652Z','Commerce de gros (commerce interentreprises) de composants et d''équipements électroniques et de télécommunication');
INSERT INTO cconac VALUES ('4661Z','Commerce de gros (commerce interentreprises) de matériel agricole');
INSERT INTO cconac VALUES ('4662Z','Commerce de gros (commerce interentreprises) de machines-outils');
INSERT INTO cconac VALUES ('4663Z','Commerce de gros (commerce interentreprises) de machines pour l''extraction, la construction et le génie civil');
INSERT INTO cconac VALUES ('4664Z','Commerce de gros (commerce interentreprises) de machines pour l''industrie textile et l''habillement');
INSERT INTO cconac VALUES ('4665Z','Commerce de gros (commerce interentreprises) de mobilier de bureau');
INSERT INTO cconac VALUES ('4666Z','Commerce de gros (commerce interentreprises) d''autres machines et équipements de bureau');
INSERT INTO cconac VALUES ('4669A','Commerce de gros (commerce interentreprises) de matériel électrique');
INSERT INTO cconac VALUES ('4669B','Commerce de gros (commerce interentreprises) de fournitures et équipements industriels divers');
INSERT INTO cconac VALUES ('4669C','Commerce de gros (commerce interentreprises) de fournitures et équipements divers pour le commerce et les services');
INSERT INTO cconac VALUES ('4671Z','Commerce de gros (commerce interentreprises) de combustibles et de produits annexes');
INSERT INTO cconac VALUES ('4672Z','Commerce de gros (commerce interentreprises) de minerais et métaux');
INSERT INTO cconac VALUES ('4673A','Commerce de gros (commerce interentreprises) de bois et de matériaux de construction');
INSERT INTO cconac VALUES ('4673B','Commerce de gros (commerce interentreprises) d''appareils sanitaires et de produits de décoration');
INSERT INTO cconac VALUES ('4674A','Commerce de gros (commerce interentreprises) de quincaillerie');
INSERT INTO cconac VALUES ('4674B','Commerce de gros (commerce interentreprises) de fournitures pour la plomberie et le chauffage');
INSERT INTO cconac VALUES ('4675Z','Commerce de gros (commerce interentreprises) de produits chimiques');
INSERT INTO cconac VALUES ('4676Z','Commerce de gros (commerce interentreprises) d''autres produits intermédiaires');
INSERT INTO cconac VALUES ('4677Z','Commerce de gros (commerce interentreprises) de déchets et débris');
INSERT INTO cconac VALUES ('4690Z','Commerce de gros (commerce interentreprises) non spécialisé');
INSERT INTO cconac VALUES ('4711A','Commerce de détail de produits surgelés');
INSERT INTO cconac VALUES ('4711B','Commerce d''alimentation générale');
INSERT INTO cconac VALUES ('4711C','Superettes');
INSERT INTO cconac VALUES ('4711D','Supermarchés');
INSERT INTO cconac VALUES ('4711E','Magasins multi-commerces');
INSERT INTO cconac VALUES ('4711F','Hypermarchés');
INSERT INTO cconac VALUES ('4719A','Grands magasins');
INSERT INTO cconac VALUES ('4719B','Autres commerces de détail en magasin non spécialisé');
INSERT INTO cconac VALUES ('4721Z','Commerce de détail de fruits et légumes en magasin spécialisé');
INSERT INTO cconac VALUES ('4722Z','Commerce de détail de viandes et de produits à base de viande en magasin specialisé');
INSERT INTO cconac VALUES ('4723Z','Commerce de détail de poissons, crustacés et mollusques en magasin specialisé');
INSERT INTO cconac VALUES ('4724Z','Commerce de détail de pain, pâtisserie et confiserie en magasin spécialisé');
INSERT INTO cconac VALUES ('4725Z','Commerce de détail de boissons en magasin spécialisé');
INSERT INTO cconac VALUES ('4726Z','Commerce de détail de produits à base de tabac en magasin spécialisé');
INSERT INTO cconac VALUES ('4729Z','Autres commerces de détail alimentaires en magasin spécialisé');
INSERT INTO cconac VALUES ('4730Z','Commerce de détail de carburants en magasin spécialisé');
INSERT INTO cconac VALUES ('4741Z','Commerce de détail d''ordinateurs, d''unités périphériques et de logiciels en magasin spécialisé');
INSERT INTO cconac VALUES ('4742Z','Commerce de détail de materiels de télécommunication en magasin spécialisé');
INSERT INTO cconac VALUES ('4743Z','Commerce de détail de matériels audio et vidéo en magasin spécialisé');
INSERT INTO cconac VALUES ('4751Z','Commerce de détail de textiles en magasin spécialisé');
INSERT INTO cconac VALUES ('4752A','Commerce de détail de quincaillerie, peintures et verres en petites surfaces (moins de 400 m²)');
INSERT INTO cconac VALUES ('4752B','Commerce de détail de quincaillerie, peintures et verres en grandes surfaces (400 m² et plus)');
INSERT INTO cconac VALUES ('4753Z','Commerce de détail de tapis, moquettes et revêtements de murs et de sols en magasin spécialisé');
INSERT INTO cconac VALUES ('4754Z','Commerce de détail d''appareils électromenagers en magasin spécialisé');
INSERT INTO cconac VALUES ('4759A','Commerce de détail de meubles');
INSERT INTO cconac VALUES ('4759B','Commerce de détail d''autres équipements du foyer');
INSERT INTO cconac VALUES ('4761Z','Commerce de détail de livres en magasin spécialisé');
INSERT INTO cconac VALUES ('4762Z','Commerce de détail de journaux et papeterie en magasin spécialisé');
INSERT INTO cconac VALUES ('4763Z','Commerce de détail d''enregistrements musicaux et vidéo en magasin spécialisé');
INSERT INTO cconac VALUES ('4764Z','Commerce de détail d''articles de sport en magasin spécialisé');
INSERT INTO cconac VALUES ('4765Z','Commerce de détail de jeux et jouets en magasin spécialisé');
INSERT INTO cconac VALUES ('4771Z','Commerce de détail d''habillement en magasin spécialisé');
INSERT INTO cconac VALUES ('4772A','Commerce de détail de la chaussure');
INSERT INTO cconac VALUES ('4772B','Commerce de détail de maroquinerie et d''articles de voyage');
INSERT INTO cconac VALUES ('4773Z','Commerce de détail de produits pharmaceutiques en magasin spécialisé');
INSERT INTO cconac VALUES ('4774Z','Commerce de détail d''articles médicaux et orthopédiques en magasin spécialisé');
INSERT INTO cconac VALUES ('4775Z','Commerce de détail de parfumerie et de produits de beauté en magasin spécialisé');
INSERT INTO cconac VALUES ('4776Z','Commerce de détail de fleurs, plantes, graines, engrais, animaux de compagnie et aliments pour ces animaux en magasin spécialisé');
INSERT INTO cconac VALUES ('4777Z','Commerce de détail d''articles d''horlogerie et de bijouterie en magasin spécialisé');
INSERT INTO cconac VALUES ('4778A','Commerces de détail d''optique');
INSERT INTO cconac VALUES ('4778B','Commerces de détail de charbons et combustibles');
INSERT INTO cconac VALUES ('4778C','Autres commerces de détail spécialisés divers');
INSERT INTO cconac VALUES ('4779Z','Commerce de détail de biens d''occasion en magasin');
INSERT INTO cconac VALUES ('4781Z','Commerce de détail alimentaire sur éventaires et marchés');
INSERT INTO cconac VALUES ('4782Z','Commerce de détail de textiles, d''habillement et de chaussures sur éventaires et marchés');
INSERT INTO cconac VALUES ('4789Z','Autres commerces de détail sur éventaires et marchés');
INSERT INTO cconac VALUES ('4791A','Vente à distance sur catalogue général');
INSERT INTO cconac VALUES ('4791B','Vente à distance sur catalogue spécialisé');
INSERT INTO cconac VALUES ('4799A','Vente à domicile');
INSERT INTO cconac VALUES ('4799B','Vente par automates et autres commerces de détail hors magasin, éventaires ou marchés n.c.a.');
INSERT INTO cconac VALUES ('4910Z','Transport ferroviaire interurbain de voyageurs');
INSERT INTO cconac VALUES ('4920Z','Transports ferroviaires de fret');
INSERT INTO cconac VALUES ('4931Z','Transports urbains et suburbains de voyageurs');
INSERT INTO cconac VALUES ('4932Z','Transports de voyageurs par taxis');
INSERT INTO cconac VALUES ('4939A','Transports routiers réguliers de voyageurs');
INSERT INTO cconac VALUES ('4939B','Autres transports routiers de voyageurs');
INSERT INTO cconac VALUES ('4939C','Téléphériques et rémontées mécaniques');
INSERT INTO cconac VALUES ('4941A','Transports routiers de fret interurbains');
INSERT INTO cconac VALUES ('4941B','Transports routiers de fret de proximité');
INSERT INTO cconac VALUES ('4941C','Location de camions avec chauffeur');
INSERT INTO cconac VALUES ('4942Z','Services de déménagement');
INSERT INTO cconac VALUES ('4950Z','Transports par conduites');
INSERT INTO cconac VALUES ('5010Z','Transports maritimes et côtiers de passagers');
INSERT INTO cconac VALUES ('5020Z','Transports maritimes et côtiers de fret');
INSERT INTO cconac VALUES ('5030Z','Transports fluviaux de passagers');
INSERT INTO cconac VALUES ('5040Z','Transports fluviaux de fret');
INSERT INTO cconac VALUES ('5110Z','Transports aériens de passagers');
INSERT INTO cconac VALUES ('5121Z','Transports aériens de fret');
INSERT INTO cconac VALUES ('5122Z','Transports spatiaux');
INSERT INTO cconac VALUES ('5210A','Entreposage et stockage frigorifique');
INSERT INTO cconac VALUES ('5210B','Entreposage et stockage non frigorifique');
INSERT INTO cconac VALUES ('5221Z','Services auxiliaires des transports terrestres');
INSERT INTO cconac VALUES ('5222Z','Services auxiliaires des transports par eau');
INSERT INTO cconac VALUES ('5223Z','Services auxiliaires des transports aeriens');
INSERT INTO cconac VALUES ('5224A','Manutention portuaire');
INSERT INTO cconac VALUES ('5224B','Manutention non portuaire');
INSERT INTO cconac VALUES ('5229A','Messagerie, fret express');
INSERT INTO cconac VALUES ('5229B','Affrètement et organisation des transports');
INSERT INTO cconac VALUES ('5310Z','Activités de poste dans le cadre d''une obligation de service universel');
INSERT INTO cconac VALUES ('5320Z','Autres activités de poste et de courrier');
INSERT INTO cconac VALUES ('5510Z','Hôtels et hébergement similaire');
INSERT INTO cconac VALUES ('5520Z','Hébergement touristique et autre hébergement de courte durée');
INSERT INTO cconac VALUES ('5530Z','Terrains de camping et parcs pour caravanes ou véhicules de loisirs');
INSERT INTO cconac VALUES ('5590Z','Autres hébergements');
INSERT INTO cconac VALUES ('5610A','Restauration traditionnelle');
INSERT INTO cconac VALUES ('5610B','Cafétérias et autres libres-services');
INSERT INTO cconac VALUES ('5610C','Restauration de type rapide');
INSERT INTO cconac VALUES ('5621Z','Services des traiteurs');
INSERT INTO cconac VALUES ('5629A','Restauration collective sous contrat');
INSERT INTO cconac VALUES ('5629B','Autres services de restauration n.c.a.');
INSERT INTO cconac VALUES ('5811Z','Édition de livres');
INSERT INTO cconac VALUES ('5812Z','Édition de répertoires et de fichiers d''adresses');
INSERT INTO cconac VALUES ('5813Z','Édition de journaux');
INSERT INTO cconac VALUES ('5814Z','Édition de revues et périodiques');
INSERT INTO cconac VALUES ('5819Z','Autres activites d''édition');
INSERT INTO cconac VALUES ('5821Z','Édition de jeux éléctroniques');
INSERT INTO cconac VALUES ('5829A','Édition de logiciels système et de réseau');
INSERT INTO cconac VALUES ('5829B','Édition de logiciels outils de développement et de langages');
INSERT INTO cconac VALUES ('5829C','Édition de logiciels applicatifs');
INSERT INTO cconac VALUES ('5911A','Production de films et de programmes pour la télévision');
INSERT INTO cconac VALUES ('5911B','Production de films institutionnels et publicitaires');
INSERT INTO cconac VALUES ('5911C','Production de films pour le cinéma');
INSERT INTO cconac VALUES ('5912Z','Post-production de films cinématographiques, de vidéo et de programmes de télévision');
INSERT INTO cconac VALUES ('5913A','Distribution de films cinématographiques');
INSERT INTO cconac VALUES ('5913B','Édition et distribution vidéo');
INSERT INTO cconac VALUES ('5914Z','Projection de films cinématographiques');
INSERT INTO cconac VALUES ('5920Z','Enregistrement sonore et édition musicale');
INSERT INTO cconac VALUES ('6010Z','Édition et diffusion de programmes radio');
INSERT INTO cconac VALUES ('6020A','Édition de chaînes généralistes');
INSERT INTO cconac VALUES ('6020B','Édition de chaînes thématiques');
INSERT INTO cconac VALUES ('6110Z','Télécommunications filaires');
INSERT INTO cconac VALUES ('6120Z','Télécommunications sans fil');
INSERT INTO cconac VALUES ('6130Z','Télécommunications par satellite');
INSERT INTO cconac VALUES ('6190Z','Autres activités de telecommunication');
INSERT INTO cconac VALUES ('6201Z','Programmation informatique');
INSERT INTO cconac VALUES ('6202A','Conseil en systèmes et logiciels informatiques');
INSERT INTO cconac VALUES ('6202B','Tierce maintenance de systèmes et d''applications informatiques');
INSERT INTO cconac VALUES ('6203Z','Gestion d''installations informatiques');
INSERT INTO cconac VALUES ('6209Z','Autres activités informatiques');
INSERT INTO cconac VALUES ('6311Z','Traitement de données, hébergement et activités connexes');
INSERT INTO cconac VALUES ('6312Z','Portails internet');
INSERT INTO cconac VALUES ('6391Z','Activités des agences de presse');
INSERT INTO cconac VALUES ('6399Z','Autres services d''information n.c.a.');
INSERT INTO cconac VALUES ('6411Z','Activités de banque centrale');
INSERT INTO cconac VALUES ('6419Z','Autres intermédiations monétaires');
INSERT INTO cconac VALUES ('6420Z','Activités des sociétés holding');
INSERT INTO cconac VALUES ('6430Z','Fonds de placement et entités financières similaires');
INSERT INTO cconac VALUES ('6491Z','Crédit-bail');
INSERT INTO cconac VALUES ('6492Z','Autre distribution de crédit');
INSERT INTO cconac VALUES ('6499Z','Autres activités des services financiers, hors assurance et caisses de retraite, n.c.a.');
INSERT INTO cconac VALUES ('6511Z','Assurance vie');
INSERT INTO cconac VALUES ('6512Z','Autres assurances');
INSERT INTO cconac VALUES ('6520Z','Réassurance');
INSERT INTO cconac VALUES ('6530Z','Caisses de retraite');
INSERT INTO cconac VALUES ('6611Z','Administration de marches financiers');
INSERT INTO cconac VALUES ('6612Z','Courtage de valeurs mobilières et de marchandises');
INSERT INTO cconac VALUES ('6619A','Supports juridiques de gestion de patrimoine mobilier');
INSERT INTO cconac VALUES ('6619B','Autres activités auxiliaires de services financiers, hors assurance et caisses de retraite, n.c.a.');
INSERT INTO cconac VALUES ('6621Z','Évaluation des risques et dommages');
INSERT INTO cconac VALUES ('6622Z','Activités des agents et courtiers d''assurances');
INSERT INTO cconac VALUES ('6629Z','Autres activités auxiliaires d''assurance et de caisses de retraite');
INSERT INTO cconac VALUES ('6630Z','Gestion de fonds');
INSERT INTO cconac VALUES ('6810Z','Activités des marchands de biens immobiliers');
INSERT INTO cconac VALUES ('6820A','Location de logements');
INSERT INTO cconac VALUES ('6820B','Location de terrains et d''autres biens immobiliers');
INSERT INTO cconac VALUES ('6831Z','Agences immobilieres');
INSERT INTO cconac VALUES ('6832A','Administration d''immeubles et autres biens immobiliers');
INSERT INTO cconac VALUES ('6832B','Supports juridiques de gestion de patrimoine immobilier');
INSERT INTO cconac VALUES ('6910Z','Activités juridiques');
INSERT INTO cconac VALUES ('6920Z','Activités comptables');
INSERT INTO cconac VALUES ('7010Z','Activités des sièges sociaux');
INSERT INTO cconac VALUES ('7021Z','Conseil en relations publiques et communication');
INSERT INTO cconac VALUES ('7022Z','Conseil pour les affaires et autres conseils de gestion');
INSERT INTO cconac VALUES ('7111Z','Activités d''architecture');
INSERT INTO cconac VALUES ('7112A','Activité des géomètres');
INSERT INTO cconac VALUES ('7112B','Ingénierie, études techniques');
INSERT INTO cconac VALUES ('7120A','Contrôle technique automobile');
INSERT INTO cconac VALUES ('7120B','Analyses, essais et inspections techniques');
INSERT INTO cconac VALUES ('7211Z','Recherche-développement en biotechnologie');
INSERT INTO cconac VALUES ('7219Z','Recherche-développement en autres sciences physiques et naturelles');
INSERT INTO cconac VALUES ('7220Z','Recherche-développement en sciences humaines et sociales');
INSERT INTO cconac VALUES ('7311Z','Activités des agences de publicité');
INSERT INTO cconac VALUES ('7312Z','Régie publicitaire de médias');
INSERT INTO cconac VALUES ('7320Z','Études de marche et sondages');
INSERT INTO cconac VALUES ('7410Z','Activités spécialisées de design');
INSERT INTO cconac VALUES ('7420Z','Activités photographiques');
INSERT INTO cconac VALUES ('7430Z','Traduction et interprétation');
INSERT INTO cconac VALUES ('7490A','Activité des économistes de la construction');
INSERT INTO cconac VALUES ('7490B','Activités spécialisées, scientifiques et techniques diverses');
INSERT INTO cconac VALUES ('7500Z','Activités vétérinaires');
INSERT INTO cconac VALUES ('7711A','Location de courte durée de voitures et de véhicules automobiles légers');
INSERT INTO cconac VALUES ('7711B','Location de longue durée de voitures et de véhicules automobiles légers');
INSERT INTO cconac VALUES ('7712Z','Location et location-bail de camions');
INSERT INTO cconac VALUES ('7721Z','Location et location-bail d''articles de loisirs et de sport');
INSERT INTO cconac VALUES ('7722Z','Location de vidéocassettes et disques vidéo');
INSERT INTO cconac VALUES ('7729Z','Location et location-bail d''autres biens personnels et domestiques');
INSERT INTO cconac VALUES ('7731Z','Location et location-bail de machines et équipements agricoles');
INSERT INTO cconac VALUES ('7732Z','Location et location-bail de machines et équipements pour la construction');
INSERT INTO cconac VALUES ('7733Z','Location et location-bail de machines de bureau et de matériel informatique');
INSERT INTO cconac VALUES ('7734Z','Location et location-bail de matériels de transport par eau');
INSERT INTO cconac VALUES ('7735Z','Location et location-bail de matériels de transport aérien');
INSERT INTO cconac VALUES ('7739Z','Location et location-bail d''autres machines, équipements et biens matériels n.c.a.');
INSERT INTO cconac VALUES ('7740Z','Location-bail de propriété intellectuelle et de produits similaires, à l''exception des œuvres soumises a copyright');
INSERT INTO cconac VALUES ('7810Z','Activités des agences de placement de main-d œuvre');
INSERT INTO cconac VALUES ('7820Z','Activités des agences de travail temporaire');
INSERT INTO cconac VALUES ('7830Z','Autre mise a disposition de ressources humaines');
INSERT INTO cconac VALUES ('7911Z','Activités des agences de voyage');
INSERT INTO cconac VALUES ('7912Z','Activités des voyagistes');
INSERT INTO cconac VALUES ('7990Z','Autres services de réservation et activités connexes');
INSERT INTO cconac VALUES ('8010Z','Activités de sécurité privée');
INSERT INTO cconac VALUES ('8020Z','Activités liées aux systèmes de sécurité');
INSERT INTO cconac VALUES ('8030Z','Activités d''enquête');
INSERT INTO cconac VALUES ('8110Z','Activités combinées de soutien lié aux bâtiments');
INSERT INTO cconac VALUES ('8121Z','Nettoyage courant des bâtiments');
INSERT INTO cconac VALUES ('8122Z','Autres activités de nettoyage des bâtiments et nettoyage industriel');
INSERT INTO cconac VALUES ('8129A','Désinfection, désinsectisation, dératisation');
INSERT INTO cconac VALUES ('8129B','Autres activités de nettoyage n.c.a.');
INSERT INTO cconac VALUES ('8130Z','Services d''aménagement paysager');
INSERT INTO cconac VALUES ('8211Z','Services administratifs combinés de bureau');
INSERT INTO cconac VALUES ('8219Z','Photocopie, préparation de documents et autres activités spécialisées de soutien de bureau');
INSERT INTO cconac VALUES ('8220Z','Activités de centres d''appels');
INSERT INTO cconac VALUES ('8230Z','Organisation de foires, salons professionnels et congrés');
INSERT INTO cconac VALUES ('8291Z','Activités des agences de recouvrement de factures et des sociétés d''information financière sur la clientèle');
INSERT INTO cconac VALUES ('8292Z','Activités de conditionnement');
INSERT INTO cconac VALUES ('8299Z','Autres activités de soutien aux entreprises n.c.a.');
INSERT INTO cconac VALUES ('8411Z','Administration publique générale');
INSERT INTO cconac VALUES ('8412Z','Administration publique (tutelle) de la santé, de la formation, de la culture et des services sociaux, autre que securité sociale');
INSERT INTO cconac VALUES ('8413Z','Administration publique (tutelle) des activités économiques');
INSERT INTO cconac VALUES ('8421Z','Affaires étrangères');
INSERT INTO cconac VALUES ('8422Z','Défense');
INSERT INTO cconac VALUES ('8423Z','Justice');
INSERT INTO cconac VALUES ('8424Z','Activités d''ordre public et de sécurité');
INSERT INTO cconac VALUES ('8425Z','Services du feu et de secours');
INSERT INTO cconac VALUES ('8430A','Activités générales de sécurité sociale');
INSERT INTO cconac VALUES ('8430B','Gestion des retraites complémentaires');
INSERT INTO cconac VALUES ('8430C','Distribution sociale de revenus');
INSERT INTO cconac VALUES ('8510Z','Enseignement pré-primaire');
INSERT INTO cconac VALUES ('8520Z','Enseignement primaire');
INSERT INTO cconac VALUES ('8531Z','Enseignement secondaire général');
INSERT INTO cconac VALUES ('8532Z','Enseignement secondaire technique ou professionnel');
INSERT INTO cconac VALUES ('8541Z','Enseignement post-secondaire non supérieur');
INSERT INTO cconac VALUES ('8542Z','Enseignement supérieur');
INSERT INTO cconac VALUES ('8551Z','Enseignement de disciplines sportives et d''activités de loisirs');
INSERT INTO cconac VALUES ('8552Z','Enseignement culturel');
INSERT INTO cconac VALUES ('8553Z','Enseignement de la conduite');
INSERT INTO cconac VALUES ('8559A','Formation continue d''adultes');
INSERT INTO cconac VALUES ('8559B','Autres enseignements');
INSERT INTO cconac VALUES ('8560Z','Activités de soutien à l''enseignement');
INSERT INTO cconac VALUES ('8610Z','Activités hospitalières');
INSERT INTO cconac VALUES ('8621Z','Activité des médecins généralistes');
INSERT INTO cconac VALUES ('8622A','Activités de radiodiagnostic et de radiothérapie');
INSERT INTO cconac VALUES ('8622B','Activités chirurgicales');
INSERT INTO cconac VALUES ('8622C','Autres activités des médecins spécialistes');
INSERT INTO cconac VALUES ('8623Z','Pratique dentaire');
INSERT INTO cconac VALUES ('8690A','Ambulances');
INSERT INTO cconac VALUES ('8690B','Laboratoires d''analyses médicales');
INSERT INTO cconac VALUES ('8690C','Centres de collecte et banques d''organes');
INSERT INTO cconac VALUES ('8690D','Activités des infirmiers et des sages-femmes');
INSERT INTO cconac VALUES ('8690E','Activités des professionnels de la rééducation, de l''appareillage et des pédicures-podologues');
INSERT INTO cconac VALUES ('8690F','Activités de santé humaine non classées ailleurs');
INSERT INTO cconac VALUES ('8710A','Hébergement médicalisé pour personnes âgées');
INSERT INTO cconac VALUES ('8710B','Hébergement médicalisé pour enfants handicapés');
INSERT INTO cconac VALUES ('8710C','Hébergement médicalisé pour adultes handicapés et autre hébergement médicalisé');
INSERT INTO cconac VALUES ('8720A','Hébergement social pour handicapés mentaux et malades mentaux');
INSERT INTO cconac VALUES ('8720B','Hébergement social pour toxicomanes');
INSERT INTO cconac VALUES ('8730A','hebergement social pour personnes âgées');
INSERT INTO cconac VALUES ('8730B','Hébergement social pour handicapés physiques');
INSERT INTO cconac VALUES ('8790A','Hébergement social pour enfants en difficultés');
INSERT INTO cconac VALUES ('8790B','Hébergement social pour adultes et familles en difficultés et autre hébergement social');
INSERT INTO cconac VALUES ('8810A','Aide a domicile');
INSERT INTO cconac VALUES ('8810B','Accueil ou accompagnement sans hébergement d''adultes handicapés ou de personnes âgées');
INSERT INTO cconac VALUES ('8810C','Aide par le travail');
INSERT INTO cconac VALUES ('8891A','Accueil de jeunes enfants');
INSERT INTO cconac VALUES ('8891B','Accueil ou accompagnement sans hébergement d''enfants handicapés');
INSERT INTO cconac VALUES ('8899A','Autre accueil ou accompagnement sans hébergement d''enfants et d''adolescents');
INSERT INTO cconac VALUES ('8899B','Action sociale sans hébergement n.c.a.');
INSERT INTO cconac VALUES ('9001Z','Arts du spectacle vivant');
INSERT INTO cconac VALUES ('9002Z','Activités de soutien au spectacle vivant');
INSERT INTO cconac VALUES ('9003A','Création artistique relevant des arts plastiques');
INSERT INTO cconac VALUES ('9003B','Autre création artistique');
INSERT INTO cconac VALUES ('9004Z','Gestion de salles de spectacles');
INSERT INTO cconac VALUES ('9101Z','Gestion des bibliothèques et des archives');
INSERT INTO cconac VALUES ('9102Z','Gestion des musées');
INSERT INTO cconac VALUES ('9103Z','Gestion des sites et monuments historiques et des attractions touristiques similaires');
INSERT INTO cconac VALUES ('9104Z','Gestion des jardins botaniques et zoologiques et des réserves naturelles');
INSERT INTO cconac VALUES ('9200Z','Organisation de jeux de hasard et d''argent');
INSERT INTO cconac VALUES ('9311Z','Gestion d''installations sportives');
INSERT INTO cconac VALUES ('9312Z','Activités de clubs de sports');
INSERT INTO cconac VALUES ('9313Z','Activités des centres de culture physique');
INSERT INTO cconac VALUES ('9319Z','Autres activités liées au sport');
INSERT INTO cconac VALUES ('9321Z','Activités des parcs d attractions et parcs à thèmes');
INSERT INTO cconac VALUES ('9329Z','Autres activités récréatives et de loisirs');
INSERT INTO cconac VALUES ('9411Z','Activités des organisations patronales et consulaires');
INSERT INTO cconac VALUES ('9412Z','Activités des organisations professionnelles');
INSERT INTO cconac VALUES ('9420Z','Activités des syndicats de salariés');
INSERT INTO cconac VALUES ('9491Z','Activités des organisations religieuses');
INSERT INTO cconac VALUES ('9492Z','Activités des organisations politiques');
INSERT INTO cconac VALUES ('9499Z','Autres organisations fonctionnant par adhésion volontaire');
INSERT INTO cconac VALUES ('9511Z','Réparation d''ordinateurs et d''équipements périphériques');
INSERT INTO cconac VALUES ('9512Z','Réparation d ''équipements de communication');
INSERT INTO cconac VALUES ('9521Z','Réparation de produits électroniques grand public');
INSERT INTO cconac VALUES ('9522Z','Réparation d appareils électromenagers et d''équipements pour la maison et le jardin');
INSERT INTO cconac VALUES ('9523Z','Réparation de chaussures et d''articles en cuir');
INSERT INTO cconac VALUES ('9524Z','Réparation de meubles et d''équipements du foyer');
INSERT INTO cconac VALUES ('9525Z','Réparation d''articles d''horlogerie et de bijouterie');
INSERT INTO cconac VALUES ('9529Z','Réparation d''autres biens personnels et domestiques');
INSERT INTO cconac VALUES ('9601A','Blanchisserie-teinturerie de gros');
INSERT INTO cconac VALUES ('9601B','Blanchisserie-teinturerie de détail');
INSERT INTO cconac VALUES ('9602A','Coiffure');
INSERT INTO cconac VALUES ('9602B','Soins de beauté');
INSERT INTO cconac VALUES ('9603Z','Services funéraires');
INSERT INTO cconac VALUES ('9604Z','Entretien corporel');
INSERT INTO cconac VALUES ('9609Z','Autres services personnels n.c.a.');
INSERT INTO cconac VALUES ('9700Z','Activités des ménages en tant qu''employeurs de personnel domestique');
INSERT INTO cconac VALUES ('9810Z','Activités indifferenciées des ménages en tant que producteurs de biens pour usage propre');
INSERT INTO cconac VALUES ('9820Z','Activités indifferenciées des ménages en tant que producteurs de services pour usage propre');
INSERT INTO cconac VALUES ('9900Z','Activités des organisations et organismes extraterritoriaux');


-- nomenclatures Matériaux des gros murs (depuis 2009, pevprincipale et pevdependances) : dmatgm
INSERT INTO dmatgm VALUES ('01','Pierre');
INSERT INTO dmatgm VALUES ('02','Meulière');
INSERT INTO dmatgm VALUES ('03','Béton');
INSERT INTO dmatgm VALUES ('04','Briques');
INSERT INTO dmatgm VALUES ('05','Aggloméré');
INSERT INTO dmatgm VALUES ('06','Bois');
INSERT INTO dmatgm VALUES ('09','Autres');
INSERT INTO dmatgm VALUES ('10','Pierre');
INSERT INTO dmatgm VALUES ('11','Pierre');
INSERT INTO dmatgm VALUES ('12','Meulière - Pierre');
INSERT INTO dmatgm VALUES ('13','Béton - Pierre');
INSERT INTO dmatgm VALUES ('14','Briques - Pierre');
INSERT INTO dmatgm VALUES ('15','Aggloméré - Pierre');
INSERT INTO dmatgm VALUES ('16','Bois - Pierre');
INSERT INTO dmatgm VALUES ('19','Pierre - Autres');
INSERT INTO dmatgm VALUES ('20','Meulière');
INSERT INTO dmatgm VALUES ('21','Meulière - Pierre');
INSERT INTO dmatgm VALUES ('22','Meulière');
INSERT INTO dmatgm VALUES ('23','Béton - Meulière');
INSERT INTO dmatgm VALUES ('24','Briques - Meulière');
INSERT INTO dmatgm VALUES ('25','Aggloméré - Meulière');
INSERT INTO dmatgm VALUES ('26','Bois - Meulière');
INSERT INTO dmatgm VALUES ('29','Meulière - Autres');
INSERT INTO dmatgm VALUES ('30','Béton');
INSERT INTO dmatgm VALUES ('31','Béton - Pierre');
INSERT INTO dmatgm VALUES ('32','Béton - Meulière');
INSERT INTO dmatgm VALUES ('33','Béton');
INSERT INTO dmatgm VALUES ('34','Béton - Briques');
INSERT INTO dmatgm VALUES ('35','Aggloméré - Béton');
INSERT INTO dmatgm VALUES ('36','Béton - Bois');
INSERT INTO dmatgm VALUES ('39','Béton - Autres');
INSERT INTO dmatgm VALUES ('40','Briques');
INSERT INTO dmatgm VALUES ('41','Briques - Pierre');
INSERT INTO dmatgm VALUES ('42','Briques - Meulière');
INSERT INTO dmatgm VALUES ('43','Béton - Briques');
INSERT INTO dmatgm VALUES ('44','Briques');
INSERT INTO dmatgm VALUES ('45','Aggloméré - Briques');
INSERT INTO dmatgm VALUES ('46','Bois - Briques');
INSERT INTO dmatgm VALUES ('49','Briques - Autres');
INSERT INTO dmatgm VALUES ('50','Aggloméré');
INSERT INTO dmatgm VALUES ('51','Aggloméré - Pierre');
INSERT INTO dmatgm VALUES ('52','Aggloméré - Meulière');
INSERT INTO dmatgm VALUES ('53','Aggloméré - Béton');
INSERT INTO dmatgm VALUES ('54','Aggloméré - Briques');
INSERT INTO dmatgm VALUES ('55','Aggloméré');
INSERT INTO dmatgm VALUES ('56','Aggloméré - Bois');
INSERT INTO dmatgm VALUES ('59','Aggloméré - Autres');
INSERT INTO dmatgm VALUES ('60','Bois');
INSERT INTO dmatgm VALUES ('61','Bois - Pierre');
INSERT INTO dmatgm VALUES ('62','Bois - Meulière');
INSERT INTO dmatgm VALUES ('63','Béton - Bois');
INSERT INTO dmatgm VALUES ('64','Bois - Briques');
INSERT INTO dmatgm VALUES ('65','Aggloméré - Bois');
INSERT INTO dmatgm VALUES ('66','Bois');
INSERT INTO dmatgm VALUES ('69','Bois - Autres');
INSERT INTO dmatgm VALUES ('90','Autres');
INSERT INTO dmatgm VALUES ('91','Pierre - Autres');
INSERT INTO dmatgm VALUES ('92','Meulière - Autres');
INSERT INTO dmatgm VALUES ('93','Béton - Autres');
INSERT INTO dmatgm VALUES ('94','Briques - Autres');
INSERT INTO dmatgm VALUES ('95','Aggloméré - Béton');
INSERT INTO dmatgm VALUES ('96','Bois - Autres');
INSERT INTO dmatgm VALUES ('99','Autres');
INSERT INTO dmatgm VALUES ('0','Indéterminé');
INSERT INTO dmatgm VALUES ('1','Pierre');
INSERT INTO dmatgm VALUES ('2','Meulière');
INSERT INTO dmatgm VALUES ('3','Béton');
INSERT INTO dmatgm VALUES ('4','Briques');
INSERT INTO dmatgm VALUES ('5','Aggloméré');
INSERT INTO dmatgm VALUES ('6','Bois');
INSERT INTO dmatgm VALUES ('9','Autres');


-- nomenclatures Matériaux des toitures (depuis 2009, pevprincipale, pevdependances) : dmatto
INSERT INTO dmatto VALUES ('00', 'Indéterminé');
INSERT INTO dmatto VALUES ('01','Tuiles');
INSERT INTO dmatto VALUES ('02','Ardoises');
INSERT INTO dmatto VALUES ('03','Zinc aluminium');
INSERT INTO dmatto VALUES ('04','Béton');
INSERT INTO dmatto VALUES ('09','Autres');
INSERT INTO dmatto VALUES ('10','Tuiles');
INSERT INTO dmatto VALUES ('11','Tuiles');
INSERT INTO dmatto VALUES ('12','Ardoises - Tuiles');
INSERT INTO dmatto VALUES ('13','Tuiles - Zinc aluminium');
INSERT INTO dmatto VALUES ('14','Béton - Tuiles');
INSERT INTO dmatto VALUES ('19','Tuiles - Autres');
INSERT INTO dmatto VALUES ('20','Ardoises');
INSERT INTO dmatto VALUES ('21','Ardoises - Tuiles');
INSERT INTO dmatto VALUES ('22','Ardoises');
INSERT INTO dmatto VALUES ('23','Ardoises - Zinc aluminium');
INSERT INTO dmatto VALUES ('24','Ardoises - Béton');
INSERT INTO dmatto VALUES ('29','Ardoises - Autres');
INSERT INTO dmatto VALUES ('30','Zinc aluminium');
INSERT INTO dmatto VALUES ('31','Tuiles - Zinc aluminium');
INSERT INTO dmatto VALUES ('32','Ardoises - Zinc aluminium');
INSERT INTO dmatto VALUES ('33','Zinc aluminium');
INSERT INTO dmatto VALUES ('34','Béton - Zinc aluminium');
INSERT INTO dmatto VALUES ('39','Zinc aluminium - Autres');
INSERT INTO dmatto VALUES ('40','Béton');
INSERT INTO dmatto VALUES ('41','Béton - Tuiles');
INSERT INTO dmatto VALUES ('42','Ardoises - Béton');
INSERT INTO dmatto VALUES ('43','Béton - Zinc aluminium');
INSERT INTO dmatto VALUES ('44','Béton');
INSERT INTO dmatto VALUES ('49','Béton - Autres');
INSERT INTO dmatto VALUES ('90','Autres');
INSERT INTO dmatto VALUES ('91','Tuiles - Autres');
INSERT INTO dmatto VALUES ('92','Ardoises - Autres');
INSERT INTO dmatto VALUES ('93','Zinc aluminium - Autres');
INSERT INTO dmatto VALUES ('94','Béton - Autres');
INSERT INTO dmatto VALUES ('99','Autres');
INSERT INTO dmatto VALUES ('0','Indéterminé');
INSERT INTO dmatto VALUES ('1','Tuiles');
INSERT INTO dmatto VALUES ('2','Ardoises');
INSERT INTO dmatto VALUES ('3','Zinc aluminium');
INSERT INTO dmatto VALUES ('4','Béton');
INSERT INTO dmatto VALUES ('9','Autres');

-- nomenclatures Top terrain constructible (depuis 2009, suf) : drgpos
INSERT INTO drgpos VALUES ('0', 'La subdivision fiscale n''est pas passible de la majoration TC');
INSERT INTO drgpos VALUES ('1', 'La parcelle est isolée');
INSERT INTO drgpos VALUES ('2', 'Les parcelles sont contigues et forment un groupe unique pour le calcul de la majoration TC');
INSERT INTO drgpos VALUES ('3', 'Les parcelles sont contigues et forment un groupe unique pour le calcul de la majoration TC');
INSERT INTO drgpos VALUES ('4', 'Les parcelles sont contigues et forment un groupe unique pour le calcul de la majoration TC');
INSERT INTO drgpos VALUES ('5', 'Les parcelles sont contigues et forment un groupe unique pour le calcul de la majoration TC');
INSERT INTO drgpos VALUES ('6', 'Les parcelles sont contigues et forment un groupe unique pour le calcul de la majoration TC');
INSERT INTO drgpos VALUES ('7', 'Les parcelles sont contigues et forment un groupe unique pour le calcul de la majoration TC');
INSERT INTO drgpos VALUES ('8', 'Les parcelles sont contigues et forment un groupe unique pour le calcul de la majoration TC');
INSERT INTO drgpos VALUES ('9', 'Les parcelles sont contigues et forment un groupe unique pour le calcul de la majoration TC');


-- nomenclatures Etat d'entretien (depuis 2009, pevprincipale, pevdependances) : detent
INSERT INTO detent VALUES ('1','Bon');
INSERT INTO detent VALUES ('2','Assez bon');
INSERT INTO detent VALUES ('3','Passable');
INSERT INTO detent VALUES ('4','Médiocre');
INSERT INTO detent VALUES ('5','Mauvais');


-- nomenclatures Type de filiation (depuis 2012, parcelle) : type_filiation
INSERT INTO type_filiation VALUES ('D','Division');
INSERT INTO type_filiation VALUES ('R','Réunion');
INSERT INTO type_filiation VALUES ('T','Transfert');

-- nomenclatures Indicateur pour les locaux passibles de la taxe annuelle
-- sur les locaux à usage de bureaux, les locaux commerciaux et les locaux de stockage et les surfaces de
-- stationnement (TSBCS) et/ou de la taxe annuelle sur les surfaces de stationnement (TSS)
INSERT INTO fburx VALUES ('0','Local passible ni de la TSBCS ni de la TSS');
INSERT INTO fburx VALUES ('1','Local passible de la TSBCS uniquement');
INSERT INTO fburx VALUES ('2','Local passible de la TSS uniquement');
INSERT INTO fburx VALUES ('3','Local passible de la TSBCS et de la TSS');
INSERT INTO fburx VALUES ('4','Local passible de la TSBCS et/ou de la TSS mais non saisi dans l’application de gestion de données cadastrales');
