SET search_path TO cadastre_soissons,public;
SELECT
-- identification
l.dnubat AS l_batiment, l.descr AS l_numero_entree,
l.dniv AS l_niveau_etage, l.dpor AS l_numero_local,

-- adresse
ltrim(l.dnvoiri, '0') || l.dindic AS l_numero_voirie,
CASE WHEN v.libvoi IS NOT NULL THEN v.natvoi || v.libvoi ELSE p.cconvo || p.dvoilib END AS l_adresse,

-- proprio et acte
concat(l10.ccodep, l10.ccocom, '-',l10.dnupro) AS l10_compte_proprietaire,
l10.jdatat AS l10_date_acte,

-- autres infos
dteloc_lib AS l10_type_local_lib,
cconlc_lib AS l10_nature_local_lib,
ccoplc_lib AS l10_nature_construction_particuliere,
l10.jannat AS l10_annee_construction,
l10.dnbniv AS l10_nombre_niveaux,
dnatlc_lib AS l10_nature_occupation,

-- pev : informations générales

ccoaff_lib AS pev_affectation,
pev.ccostb AS pev_lettre_serie,
pev.dcapec AS pev_categorie,
pev.dcetlc AS pev_entretien,
pev.dvlpera AS pev_valeur_locative,
pev.gnexpl AS pev_nature_exoneration_permanente,
pev.dnuref AS pev_numero_local_type,
pev.dcsplca AS pev_coefficient_situation_particuliere,
pev.dcsglca AS pev_coefficient_situation_generale,

-- pev : taxation (1 seule par PEV)
Coalesce(Cast(pt.co_vlbaia * px.pexb / 100 AS numeric(10,2)) , 0) as co_vlbaia, pt.co_bipevla as co_bipevla,
Coalesce(Cast(pt.gp_vlbaia * px.pexb / 100 AS numeric(10,2)) , 0) as gp_vlbaia, pt.gp_bipevla as gp_bipevla,
Coalesce(Cast(pt.de_vlbaia * px.pexb / 100 AS numeric(10,2)) , 0) as de_vlbaia, pt.de_bipevla as de_bipevla,
Coalesce(Cast(pt.re_vlbaia * px.pexb / 100 AS numeric(10,2)) , 0) as re_vlbaia,
Coalesce(pt.re_bipevla, 0)  as re_bipevla,

'' AS toto

FROM parcelle p
INNER JOIN local00 l ON l.parcelle = p.parcelle
INNER JOIN local10 l10 ON l10.local00 = l.local00
INNER JOIN pev ON pev.local10 = l10.local10
LEFT OUTER JOIN voie v ON v.voie = l.voie
LEFT JOIN pevtaxation pt ON pt.pev = pev.pev
LEFT JOIN pevexoneration px ON px.pev = pev.pev
LEFT JOIN pevprincipale pp ON pp.pev = pev.pev
LEFT JOIN "dteloc" ON l10.dteloc = dteloc.dteloc
LEFT JOIN "cconlc" ON l10.cconlc = cconlc.cconlc
LEFT JOIN "ccoplc" ON l10.ccoplc = ccoplc.ccoplc
LEFT JOIN "dnatlc" ON l10.dnatlc = dnatlc.dnatlc
LEFT JOIN "ccoaff" ON pev.ccoaff = ccoaff.ccoaff
WHERE 2>1
AND p.parcelle = '2017020722000AE0058'


