# -*- coding: utf-8 -*-

"""
000	2012-08-20
"""

# Import standard libraries
import os

# Import the PyQt and QGIS libraries
from PyQt4.QtCore import *
from PyQt4.QtGui import *

prefix_icons = os.environ['PWD']+'/.qgis/python/plugins/cad4qgisPunti/Icons/'

class polyg4qgisUI(QDialog):	#QtGui.
	"""
		Dialogo per cad4qgis
	"""

	def __init__(self):
		""" Inizializza la maschera per l'editing """
		QDialog.__init__(self)	#QtGui.
		self.setObjectName("Dialog")
		self.resize(220, 660)
		self.setWindowTitle('Cad for qGis')

		lbl = QLabel(self)	#QtGui.
		lbl.setGeometry(QRect(10, 10, 200, 20))	#QtCore.
		lbl.setText('GENERAL')

		self.lay = QLabel(self)	#QtGui.
		self.lay.setGeometry(QRect(10, 30, 100, 20))	#QtCore.
		self.lay.setText('layer:')

		self.lay_edit = QLabel(self)	#QtGui.
		self.lay_edit.setGeometry(QRect(110, 30, 100, 20))	#QtCore.
		self.lay_edit.setText('')

		self.prov = QLabel(self)	#QtGui.
		self.prov.setGeometry(QRect(10, 50, 200, 20))	#QtCore.
		self.prov.setText('provider:')

		self.crs = QLabel(self)	#QtGui.
		self.crs.setGeometry(QRect(10, 70, 200, 20))	#QtCore.
		self.crs.setText('CRS:')

		lbl = QLabel(self)	#QtGui.
		lbl.setGeometry(QRect(10, 90, 200, 20))	#QtCore.
		lbl.setText('# points ')

		self.sbNumPnts = QSpinBox(self)	#QtGui.
		self.sbNumPnts.setMinimum(4)
		self.sbNumPnts.setMaximum(100)
		self.sbNumPnts.setGeometry(QRect(70, 90, 100, 20))	#QtCore.
		self.sbNumPnts.setValue(10)

		lbl = QLabel(self)	#QtGui.
		lbl.setGeometry(QRect(10, 110, 200, 20))	#QtCore.
		lbl.setText('tolerance ')

		self.sbToler = QSpinBox(self)	#QtGui.
		self.sbToler.setMinimum(1)
		self.sbToler.setMaximum(1000000)
		self.sbToler.setGeometry(QRect(70, 110, 80, 20))	#QtCore.

		lbl = QLabel(self)	#QtGui.
		lbl.setGeometry(QRect(10, 130, 200, 20))	#QtCore.
		lbl.setText('INQUIRY	')

		self.pbInqPolyg = QPushButton(self)	#QtGui.
		self.pbInqPolyg.setIcon(QIcon(prefix_icons+"actionPolyInq.png"))	#QtGui.
		self.pbInqPolyg.setGeometry(QRect(10, 150, 20, 20))	#QtCore.
#		self.pbInqPolyg.setText('Polygon inquiring')
		self.pbInqPolyg.setToolTip("Polygon inquiring")

		self.pbPolygValidation = QPushButton(self)	#QtGui.
		self.pbPolygValidation.setIcon(QIcon(prefix_icons+"actionPolyValidation.png"))	#QtGui.
		self.pbPolygValidation.setGeometry(QRect(40, 150, 20, 20))	#QtCore.
#		self.pbPolygValidation.setText('Polygon validation')
		self.pbPolygValidation.setToolTip("Polygon validation")

		self.pbInqEdge = QPushButton(self)	#QtGui.
		self.pbInqEdge.setIcon(QIcon(prefix_icons+"actionEdgeInq.png"))	#QtGui.
		self.pbInqEdge.setGeometry(QRect(70, 150, 20, 20))	#QtCore.
#		self.pbInqEdge.setText('Edge inquiring')
		self.pbInqEdge.setToolTip("Edge inquiring")

		self.pbInqVertex = QPushButton(self)	#QtGui.
		self.pbInqVertex.setIcon(QIcon(prefix_icons+"actionVertexInq.png"))	#QtGui.
		self.pbInqVertex.setGeometry(QRect(100, 150, 20, 20))	#QtCore.
#		self.pbInqVertex.setText('Vertex inquiring')
		self.pbInqVertex.setToolTip("Vertex inquiring")

		self.pb2PntDist = QPushButton(self)	#QtGui.
		self.pb2PntDist.setIcon(QIcon(prefix_icons+"action2PntDist.png"))	#QtGui.
		self.pb2PntDist.setGeometry(QRect(130, 150, 20, 20))	#QtCore.
#		self.pb2PntDist.setText('2 points distance')
		self.pb2PntDist.setToolTip("2 points distance")

		self.pbAngle3Pnt = QPushButton(self)	#QtGui.
		self.pbAngle3Pnt.setIcon(QIcon(prefix_icons+"action3PntAngle.png"))	#QtGui.
		self.pbAngle3Pnt.setGeometry(QRect(160, 150, 20, 20))	#QtCore.
#		self.pbAngle3Pnt.setText('Three points angle')
		self.pbAngle3Pnt.setToolTip("Three points angle")

		self.pbPolyCentroid = QPushButton(self)	#QtGui.
		self.pbPolyCentroid.setIcon(QIcon(prefix_icons+"actionPolyCentroid.png"))	#QtGui.
		self.pbPolyCentroid.setGeometry(QRect(190, 150, 20, 20))	#QtCore.
#		self.pbPolyCentroid.setText('Polygon centroid')
		self.pbPolyCentroid.setToolTip("Polygon centroid")

		self.pbPolyLength = QPushButton(self)	#QtGui.
		self.pbPolyLength.setIcon(QIcon(prefix_icons+"actionPolyLength.png"))	#QtGui.
		self.pbPolyLength.setGeometry(QRect(10, 170, 20, 20))	#QtCore.
#		self.pbPolyLength.setText('Polygon perimeter')
		self.pbPolyLength.setToolTip("Polygon perimeter")

		self.pbPolyArea = QPushButton(self)	#QtGui.
		self.pbPolyArea.setIcon(QIcon(prefix_icons+"actionPolyArea.png"))	#QtGui.
		self.pbPolyArea.setGeometry(QRect(40, 170, 20, 20))	#QtCore.
#		self.pbPolyArea.setText('Polygon area')
		self.pbPolyArea.setToolTip("Polygon area")

		self.pbPntsDiag = QPushButton(self)	#QtGui.
		self.pbPntsDiag.setIcon(QIcon(prefix_icons+"actionpbPntsDiag.png"))	#QtGui.
		self.pbPntsDiag.setGeometry(QRect(190, 170, 20, 20))	#QtCore.
#		self.pbPntsDiag.setText('Points diag')
		self.pbPntsDiag.setToolTip("Points diag")

		lbl = QLabel(self)	#QtGui.
		lbl.setGeometry(QRect(10, 190, 200, 20))	#QtCore.
		lbl.setText('CONSTRUCTION')

		self.pbPolygCopy = QPushButton(self)	#QtGui.
		self.pbPolygCopy.setIcon(QIcon(prefix_icons+"actionPolygCopy.png"))	#QtGui.
		self.pbPolygCopy.setGeometry(QRect(10, 210, 20, 20))	#QtCore.
#		self.pbPolygCopy.setText('Polygon copy')
		self.pbPolygCopy.setToolTip("Polygon copy")

		self.pbPolygRectSeries = QPushButton(self)	#QtGui.
		self.pbPolygRectSeries.setIcon(QIcon(prefix_icons+"actionPntRectSeries.png"))	#QtGui.
		self.pbPolygRectSeries.setGeometry(QRect(40, 210, 20, 20))	#QtCore.
#		self.pbPolygRectSeries.setText('Rectangular series of polygons')
		self.pbPolygRectSeries.setToolTip("Rectangular series of polygons")

		self.pbPolygPolarSeries = QPushButton(self)	#QtGui.
		self.pbPolygPolarSeries.setIcon(QIcon(prefix_icons+"actionPntPolarSeries.png"))	#QtGui.
		self.pbPolygPolarSeries.setGeometry(QRect(70, 210, 20, 20))	#QtCore.
#		self.pbPolygPolarSeries.setText('Polar series of Polygs')
		self.pbPolygPolarSeries.setToolTip("Polar series of polygons")

		self.pbPolygAxialMirror = QPushButton(self)	#QtGui.
		self.pbPolygAxialMirror.setIcon(QIcon(prefix_icons+"actionPntAxialMirror.png"))	#QtGui.
		self.pbPolygAxialMirror.setGeometry(QRect(100, 210, 20, 20))	#QtCore.
#		self.pbPolygAxialMirror.setText('Axial symmetry of Polygs')
		self.pbPolygAxialMirror.setToolTip("Axial symmetry of polygons")

		self.pbPolygRadialMirror = QPushButton(self)	#QtGui.
		self.pbPolygRadialMirror.setIcon(QIcon(prefix_icons+"actionPntRadialMirror.png"))	#QtGui.
		self.pbPolygRadialMirror.setGeometry(QRect(130, 210, 20, 20))	#QtCore.
#		self.pbPolygRadialMirror.setText('Radial symmetry of Polygs')
		self.pbPolygRadialMirror.setToolTip("Radial symmetry of polygons")

		lbl = QLabel(self)	#QtGui.
		lbl.setGeometry(QRect(10, 230, 200, 20))	#QtCore.
		lbl.setText('QUADRATIC INTERPOLATION (CIRCLE)')

		self.pbPolygRegPolyg = QPushButton(self)	#QtGui.
		self.pbPolygRegPolyg.setIcon(QIcon(prefix_icons+"actionPntRegPolyg.png"))	#QtGui.
		self.pbPolygRegPolyg.setGeometry(QRect(10, 250, 20, 20))	#QtCore.
#		self.pbPolygRegPolyg.setText('Regular polygon On/Off')
		self.pbPolygRegPolyg.setToolTip("Regular polygon")

		self.pbPolygCircle2P = QPushButton(self)	#QtGui.
		self.pbPolygCircle2P.setIcon(QIcon(prefix_icons+"actionPntCircle2P.png"))	#QtGui.
		self.pbPolygCircle2P.setGeometry(QRect(40, 250, 20, 20))	#QtCore.
#		self.pbPolygCircle2P.setText('2 points circle On/Off')
		self.pbPolygCircle2P.setToolTip("2 points circle")

		self.pbPolygCircleInCbyP = QPushButton(self)	#QtGui.
		self.pbPolygCircleInCbyP.setIcon(QIcon(prefix_icons+"actionPntCircleInCbyP.png"))	#QtGui.
		self.pbPolygCircleInCbyP.setGeometry(QRect(70, 250, 20, 20))	#QtCore.
#		self.pbPolygCircleInCbyP.setText('Circle in C by P On/Off')
		self.pbPolygCircleInCbyP.setToolTip("Circle in C by P")

		self.pbPolygCircle3P = QPushButton(self)	#QtGui.
		self.pbPolygCircle3P.setIcon(QIcon(prefix_icons+"actionPntCircle3P.png"))	#QtGui.
		self.pbPolygCircle3P.setGeometry(QRect(100, 250, 20, 20))	#QtCore.
#		self.pbPolygCircle3P.setText('Cerchio per 3 punti On/Off')
		self.pbPolygCircle3P.setToolTip("3 points circle")

		self.pbPolygEllisse = QPushButton(self)	#QtGui.
		self.pbPolygEllisse.setIcon(QIcon(prefix_icons+"actionPntEllisse.png"))	#QtGui.
		self.pbPolygEllisse.setGeometry(QRect(10, 270, 20, 20))	#QtCore.
#		self.pbPolygEllisse.setText('Ellipsys')
		self.pbPolygEllisse.setToolTip("Ellipsys")

		self.pbPolygEllisseByP = QPushButton(self)	#QtGui.
		self.pbPolygEllisseByP.setIcon(QIcon(prefix_icons+"actionPntEllisseByP.png"))	#QtGui.
		self.pbPolygEllisseByP.setGeometry(QRect(40, 270, 20, 20))	#QtCore.
#		self.pbPolygEllisseByP.setText('Ellipsys by P')
		self.pbPolygEllisseByP.setToolTip("Ellipsys by P")




		lbl = QLabel(self)	#QtGui.
		lbl.setGeometry(QRect(10, 370, 200, 20))	#QtCore.
		lbl.setText('EDITING')

		self.pbPolygVrtsEditMouse = QPushButton(self)	#QtGui.
		self.pbPolygVrtsEditMouse.setIcon(QIcon(prefix_icons+"actionPolygVrtsEditMouse.png"))	#QtGui.
		self.pbPolygVrtsEditMouse.setGeometry(QRect(10, 390, 20, 20))	#QtCore.
#		self.pbPolygVrtsEditMouse.setText('Analogic editing polygon vertices')
		self.pbPolygVrtsEditMouse.setToolTip("Analogic editing polygon vertice")

		self.pbPolygVrtsEdit = QPushButton(self)	#QtGui.
		self.pbPolygVrtsEdit.setIcon(QIcon(prefix_icons+"actionPolygVrtsEdit.png"))	#QtGui.
		self.pbPolygVrtsEdit.setGeometry(QRect(40, 390, 20, 20))	#QtCore.
#		self.pbPolygVrtsEdit.setText('Polyg vertices editing')
		self.pbPolygVrtsEdit.setToolTip("Polyg vertices editing")

		lbl = QLabel(self)	#QtGui.
		lbl.setGeometry(QRect(10, 410, 200, 20))	#QtCore.
		lbl.setText('FILLET & CHAMFER')

		self.pbPolygFilletSingle = QPushButton(self)	#QtGui.
		self.pbPolygFilletSingle.setIcon(QIcon(prefix_icons+"actionPolygFilletSingle.png"))	#QtGui.
		self.pbPolygFilletSingle.setGeometry(QRect(10, 430, 20, 20))	#QtCore.
#		self.pbPolygFilletSingle.setText('Polygon vertex fillet')
		self.pbPolygFilletSingle.setToolTip("Polygon vertex fillet")

		self.pbPolygChamferSingle = QPushButton(self)	#QtGui.
		self.pbPolygChamferSingle.setIcon(QIcon(prefix_icons+"actionPolygChamfer.png"))	#QtGui.
		self.pbPolygChamferSingle.setGeometry(QRect(40, 430, 20, 20))	#QtCore.
#		self.pbPolygChamferSingle.setText('Polygon vertex chamfer')
		self.pbPolygChamferSingle.setToolTip("Polygon vertex chamfer")




		self.pbPolygChamfer = QPushButton(self)	#QtGui.
		self.pbPolygChamfer.setIcon(QIcon(prefix_icons+"actionPolygChamfer.png"))	#QtGui.
		self.pbPolygChamfer.setGeometry(QRect(130, 430, 20, 20))	#QtCore.
#		self.pbPolygChamfer.setText('Polygon chamfer')
		self.pbPolygChamfer.setToolTip("Polygon chamfer")

		lbl = QLabel(self)	#QtGui.
		lbl.setGeometry(QRect(10, 450, 200, 20))	#QtCore.
		lbl.setText('OFFSET & BUFFER')

		self.pbPolygOffset = QPushButton(self)	#QtGui.
		self.pbPolygOffset.setIcon(QIcon(prefix_icons+"actionPolygOffset.png"))	#QtGui.
		self.pbPolygOffset.setGeometry(QRect(10, 470, 20, 20))	#QtCore.
#		self.pbPolygOffset.setText('Polygon offset')
		self.pbPolygOffset.setToolTip("Polygon offset")

		self.pbPolygBuffer = QPushButton(self)	#QtGui.
		self.pbPolygBuffer.setIcon(QIcon(prefix_icons+"actionPolygBuffer.png"))	#QtGui.
		self.pbPolygBuffer.setGeometry(QRect(40, 470, 20, 20))	#QtCore.
#		self.pbPolygBuffer.setText('Polygon Buffer')
		self.pbPolygBuffer.setToolTip("Polygon Buffer")	

		lbl = QLabel(self)	#QtGui.
		lbl.setGeometry(QRect(10, 490, 200, 20))	#QtCore.
		lbl.setText('TRANSFORMATIONS')

		self.pbLineTranslation = QPushButton(self)	#QtGui.
		self.pbLineTranslation.setIcon(QIcon(prefix_icons+"actionPntTranslation.png"))	#QtGui.
		self.pbLineTranslation.setGeometry(QRect(10, 510, 20, 20))	#QtCore.
#		self.pbLineTranslation.setText('Line translation')
		self.pbLineTranslation.setToolTip("Line translation")

		self.pbLineScaling = QPushButton(self)	#QtGui.
		self.pbLineScaling.setIcon(QIcon(prefix_icons+"actionPntScaling.png"))	#QtGui.
		self.pbLineScaling.setGeometry(QRect(40, 510, 20, 20))	#QtCore.
#		self.pbLineScaling.setText('Line scaling')
		self.pbLineScaling.setToolTip("Line scaling")

		self.pbLineRotation = QPushButton(self)	#QtGui.
		self.pbLineRotation.setIcon(QIcon(prefix_icons+"actionPntRotation.png"))	#QtGui.
		self.pbLineRotation.setGeometry(QRect(70, 510, 20, 20))	#QtCore.
#		self.pbLineRotation.setText('Line rotation')
		self.pbLineRotation.setToolTip("Line rotation")

		lbl = QLabel(self)	#QtGui.
		lbl.setGeometry(QRect(10, 530, 200, 20))	#QtCore.
		lbl.setText('COLLIMATIONS')

		self.pbLineCollimation1P = QPushButton(self)	#QtGui.
		self.pbLineCollimation1P.setIcon(QIcon(prefix_icons+"actionPntCollimation1P.png"))	#QtGui.
		self.pbLineCollimation1P.setGeometry(QRect(10, 550, 20, 20))	#QtCore.
#		self.pbLineCollimation1P.setText('1 pair collimation')
		self.pbLineCollimation1P.setToolTip("1 pair collimation")

		self.pbLineCollimation2P = QPushButton(self)	#QtGui.
		self.pbLineCollimation2P.setIcon(QIcon(prefix_icons+"actionPntCollimation2P.png"))	#QtGui.
		self.pbLineCollimation2P.setGeometry(QRect(40, 550, 20, 20))	#QtCore.
#		self.pbLineCollimation2P.setText('Two pairs collimation')
		self.pbLineCollimation2P.setToolTip("Two pairs collimation")

		self.pbLineCollimationNP = QPushButton(self)	#QtGui.
		self.pbLineCollimationNP.setIcon(QIcon(prefix_icons+"actionPntCollimationNP.png"))	#QtGui.
		self.pbLineCollimationNP.setGeometry(QRect(70, 550, 20, 20))	#QtCore.
#		self.pbLineCollimationNP.setText('Collimation with N pairs')
		self.pbLineCollimationNP.setToolTip("Collimation with N pairs")

		lbl = QLabel(self)	#QtGui.
		lbl.setGeometry(QRect(10, 570, 200, 20))	#QtCore.
		lbl.setText('DELETING')

		self.pbPolygDel = QPushButton(self)	#QtGui.
		self.pbPolygDel.setIcon(QIcon(prefix_icons+"actionPolygDel.png"))	#QtGui.
		self.pbPolygDel.setGeometry(QRect(10, 590, 20, 20))	#QtCore.
#		self.pbPolygDel.setText('Polygon deleting')
		self.pbPolygDel.setToolTip("Polygon deleting")

		lbl = QLabel(self)	#QtGui.
		lbl.setGeometry(QRect(10, 610, 200, 20))	#QtCore.
		lbl.setText('HELP')

		self.buttonAbout = QPushButton(self)	#QtGui.
		self.buttonAbout.setIcon(QIcon(prefix_icons+"buttonAbout.png"))	#QtGui.
		self.buttonAbout.setGeometry(QRect(10, 630, 20, 20))	#QtCore.
#		self.buttonAbout.setText('About')
		self.buttonAbout.setToolTip("About")

		self.buttonInfo = QPushButton(self)	#QtGui.
		self.buttonInfo.setIcon(QIcon(prefix_icons+"buttonInfo.png"))	#QtGui.
		self.buttonInfo.setGeometry(QRect(40, 630, 20, 20))	#QtCore.
#		self.buttonInfo.setText('Info')
		self.buttonInfo.setToolTip("Info")

		self.buttonHelpFlag = QPushButton(self)	#QtGui.
		self.buttonHelpFlag.setIcon(QIcon(prefix_icons+"buttonHelpFlag.png"))	#QtGui.
		self.buttonHelpFlag.setGeometry(QRect(70, 630, 20, 20))	#QtCore.
#		self.buttonHelpFlag.setText('Help flag')
		self.buttonHelpFlag.setToolTip("Help")

		buttonBox = QDialogButtonBox(self)	#QtGui.
		buttonBox.setGeometry(QRect(100, 630, 100, 20))	#QtCore.
		buttonBox.setOrientation(Qt.Horizontal)	#QtCore.
		buttonBox.setStandardButtons(QDialogButtonBox.Cancel)	#QtGui.,QtGui.
		buttonBox.setObjectName("buttonBox")

		QObject.connect(buttonBox, SIGNAL("rejected()"), self.reject)	#QtCore.,QtCore.
		QMetaObject.connectSlotsByName(self)	#QtCore.

	def setLayer(self,layName,layEdit,prName,scrs,eps):
		""" Setta il layer + provider  """
		self.lay.setText('layer:    '+layName)
		self.lay_edit.setText(layEdit)
		self.prov.setText('provider: '+prName)
		self.crs.setText('CRS: '+scrs)
		self.sbToler.setValue(eps)

	def setLayerEdit(self,layEdit):
		""" Setta il layer + provider  """
		self.lay_edit.setText(layEdit)

	def getNumPnts(self):
		""" Restituisce il numero di punti delle nuove primitive  """
		return self.sbNumPnts.value()

	def getToler(self):
		""" Restituisce il raggio di ricerca """
		return self.sbToler.value()

	def clear(self):
		""" Azzera tutto """
		self.lay.setText('layer ')
		self.prov.setText('provider ')
		self.litems.setText("items  ")
